## 2020-10-01: Virtual 2020q3 release

This is a virtual release only for reference that covers everything from
2020-07-01.

No breaking changes.

Features:

- SAMD21 support with GPIO, UART, External Interrupt.
- A rewritten AMNB protocol.
- RaspberryPi support with GPIO (via Linux/WiringPi).
- Better Windows support incl. CI.
- Compliance with CMSIS SystemCoreClock interface.
- TinyUSB integration!

Fixes:

- STM32F3: Fix `Adc::isConversionFinished()`.
- STM32: Add missing BDTR register to TIM14.
- STM32: Fix RCC clock enable for Ethernet.
- STM32L1: Fix CMSIS Header selection for -A variants.
- STM32F0/G0: Add support for remapped pins.
- FreeRTOS: Make malloc thread-safe.

New development boards:

- NUCLEO-F334R8 as `modm:board:nucleo-f334r8`.
- Feather-M0 as `modm:board:feather-m0`.
- SAMD21 Mini as `modm:board:samd21-mini`.
- Raspberry Pi v3 as `modm:board:raspberrypi`.
- DevEBox STM32F4xx as `modm:board:devebox-stm32f4xx`.
- STM32_F32VE as `modm:board:stm32_f32ve`.

New device drivers:

- LSM6DS33 compass and gyroscope as `modm:driver:lsm6ds33`.
- LIS3MDL compass as `modm:driver:lis3mdl`.
- GPIO Sampler (STM32-only) as `modm:driver:gpio-sampler`.
- IS31FL3733 LED matrix driver as `modm:driver:is31fl3733`.
- ILI9341 Parallel/SPI display driver as `modm:driver:ili9341`.

Known bugs:

- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Benjamin Carrick (@nesos)
- Christopher Durand (@chris-durand)
- delphi (@delphi)
- Erik Henriksson (@henrikssn) 🎉
- Lukas Güldenstein (@gueldenstone) 🎉
- Mike Wolfram (@mikewolfram)
- Niklas Hauser (@salkinium)
- Pavel Pletenev (@ASMfreaK)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Vivien Henry (@lukh)

<details>
<summary>Detailed changelog</summary>

#### 2020-09-30: Integrate TinyUSB for STM32 and SAMD

PR #478 -> 3072005.  
Tested in hardware by @salkinium.

#### 2020-09-19: Add ILI9341 Parallel/SPI display driver

PR #437 -> 43f32e6.  
Tested in hardware by @mikewolfram and @delphi.

#### 2020-09-18: Update FreeRTOS and make malloc thread-safe

PR #475 -> cb82eec with low impact in ARM Cortex-M targets.  
Tested in hardware by @strongly-typed and @salkinium.

#### 2020-09-18: Add GPIO remap support for STM32F0/G0

PR #471 -> 48d73dc with low impact on STM32 targets.  
Tested in hardware by @chris-durand and @salkinium.

#### 2020-09-12: Add DevEBox STM32F4xx board and examples

PR #462 -> 8082f69.  
Tested in hardware by @strongly-typed.

#### 2020-09-07: Add RaspberryPi support

Wraps `<wiringPi.h>` for GPIO driver.

PR #444 -> d3496a3.  
Tested in hardware by @henrikssn.

#### 2020-08-30: Add FreeRTOS+TCP module

PR #448 -> 821677b.  
Tested in hardware by @mikewolfram.

#### 2020-08-15: Add IS31FL3733 LED matrix driver

PR #445 -> 9b6aeee.  
Tested in hardware by @salkinium.

#### 2020-07-31: Add GPIO Sampler driver for STM32

PR #96 -> 9d8bbfa.  
Tested in hardware by @salkinium.

#### 2020-07-20: Add rewrite of AMNB protocol

PR #395 -> 8820d6b.  
Tested in hardware by @salkinium.

#### 2020-07-20: Add SAMD21 External Interrupt driver

PR #436 -> cbce428.  
Tested in hardware by @henrikssn.

#### 2020-07-08: Add SAMD21 basic UART driver

PR #430 -> 04688bc.  
Tested in hardware by @henrikssn.

#### 2020-07-07: Add LIS3MDL compass driver

PR #428 -> 0994a55.  
Tested in hardware by @nesos.

#### 2020-07-05: Add SAMD21 modm port

Also adds Feather-M0 and SAMD21 Mini BSPs.

PR #194 -> d2d38a0.  
Tested in hardware by @salkinium and @henrikssn.

#### 2020-07-02: Add LSM6DS33 compass and gyroscope driver

PR #426 -> e233708.  
Tested in hardware by @nesos.

</details>
