## 2020-07-01: Virtual 2020q2 release

This is a virtual release only for reference that covers everything from
2020-04-01.

Breaking changes:

- Move FCPU option to `modm:platform:core:f_cpu` lbuild option.
- `modm::Clock` reimplemented using `std::chrono`.
- ZeroMQ support removed as ZeroMQ is unmaintained.
- STM32 DMA driver rewritten for only STM32L4.

Features:

- `modm::delay()` is now `std::chrono` compatible.
- `modm::PreciseClock` with microsecond resolution.
- Containers derive from `std::iterator` to work with STL algorithms.
- Simple (stateless) CRC8, CRC16, CRC32 implementations.
- `.ramcode` linker section for Cortex-M.
- Use linkerscript via lbuild option.
- Simple Flash driver for STM32G0/F4.
- Basic DAC driver for STM32F4.

Fixes:

- Fix `<cmath>` in AVR libstdc++.
- Cortex-M: Explicitly set the stack pointer on startup, since some bootloaders
  forget to load the stackpointer from the image.
- TLSF `free()` ignores null pointers.
- STM32F0/F3: Correct Pll Source selection.

New development boards:

- NUCLEO-F303RE as `modm:board:nucleo-f303re`.
- Mega 2560 PRO as `modm:board:mega-2560-pro`.

New device drivers:

- LP503x LED driver as `modm:driver:lp503x`.
- Sx1276 LoRa Modem as `modm:driver:sx1276`.
- Bit-bang encoder output as `modm:driver:encoder.output`.

Known bugs:

- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Benjamin Carrick (@nesos) 🎉
- Christopher Durand (@chris-durand)
- Felix Petriconi (@FelixPetriconi) 🎉
- Jeff McBride (@mcbridejc) 🎉
- Kaelin Laundry (@WasabiFan)
- Mike Wolfram (@mikewolfram)
- Niklas Hauser (@salkinium)
- Pavel Pletenev (@ASMfreaK)
- Philipp Graf (@luxarf) 🎉
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Vivien Henry (@lukh) 🎉

<details>
<summary>Detailed changelog</summary>

#### 2020-06-19: Add basic DAC driver for STM32F4

PR #420 -> 78d18f6.  
Tested in hardware by @mcbridejc.

#### 2020-06-14: Add bit-banged encoder output

PR #153 -> 21af57b.  
Tested in hardware by @rleh.

#### 2020-06-13: Add Sx1276 LoRa Modem driver

PR #418 -> 7d1f7cc.  
Tested in hardware by @nesos.

#### 2020-06-11: Add Flash driver for STM32G0/F4

PR #417 -> 9e285db.  
Tested in hardware by @salkinium.

#### 2020-05-12: Add LP503x LED driver

PR #366 -> 6e5ebf4.  
Tested in hardware by @chris-durand.

#### 2020-05-12: Add NUCLEO-F746ZG board and example

PR #396 -> c38550a.  
Tested in hardware by @FelixPetriconi.

#### 2020-05-12: Add NUCLEO-F746ZG board and example

PR #396 -> c38550a.  
Tested in hardware by @FelixPetriconi.

#### 2020-05-08: Add DMA-capable SPI driver

PR #400 -> 80a9c66 with low impact on STM32 targets.  
Tested in hardware by @mikewolfram.

#### 2020-05-06: Rewrite DMA implementation for STM32L4

The previous DMA implementation is replaced by a new STM32L4-only one.

PR #371 -> 0217a19 with **high impact** on STM32 targets.  
Tested in hardware by @mikewolfram.

#### 2020-04-25: Add Mega 2560 PRO board and example

PR #382 -> 11ffe92.  
Tested in hardware by @chris-durand.

#### 2020-04-16: Add NUCLEO-F303RE board and example

PR #376 -> 141aa71.  
Tested in hardware by @luxarf.

#### 2020-04-09: Rewrite modm::Clock and add modm::PreciseClock

Highly efficient implementation via SysTick on Cortex-M and TC0 on AVR.
Breaking changes:

- `modm::Clock` now using `std::chrono` compatible interface.

PR #217 -> c63a536 with **high impact** on AVR and STM32 targets.  
Tested in hardware by @salkinium.

#### 2020-04-06: std::chrono compatible modm::delay

PR #374 -> b010775 with low impact on all targets.  
Tested in hardware by @salkinium.

</details>
