## 2020-04-01: Virtual 2020q1 release

This is a virtual release only for reference that covers everything from
2020-01-01.

Breaking changes:

- `modm_assert()` arguments, behavior and assertion handler arguments.
- STM32: `Rcc::enablePll(PllFactors&)` arguments.

Features:

- Doxypress support for API docs generation.
- Support for C11/C++11 atomics on ARMv6-M.
- Make heap module optional with linker failure when accidentally calling malloc.

Fixes:

- I2C NACK handling on STM32.
- Static initialization guard for C++.

No new development boards.

New device drivers:

- CAT24AAxx I2C EEPROM as `modm:driver:cat24aa`.

Known bugs:

- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.

Many thanks to all our contributors:

- Christopher Durand (@chris-durand)
- David Hebbeker (@dhebbeker)
- Mike Wolfram (@mikewolfram)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)

<details>
<summary>Detailed changelog</summary>

#### 2020-03-30: Add HX711 scale driver

PR #372 -> d21e991.  
Tested in hardware by @strongly-typed.

#### 2020-03-19: Move heap into own module

`modm:platform:heap` is optional and will cause the linker to fail if malloc is
called without this module.

PR #364 -> b8648be with **medium impact** on Cortex-M targets.  
Tested in hardware by @salkinium.

#### 2020-03-19: Pass PLL configuration as struct

Breaking changes:

- Single arguments of `Rcc::enable()` now passed as struct.

PR #361 -> e3ba913 with **high impact** on STM32 targets.  
Tested in hardware by @rleh.

#### 2020-03-19: Refactor modm_assert interface and implementation

Breaking changes:

- `modm_assert` signature.
- Additional `modm_assert_*` functions with new behaviors.
- Assertion handler signature and arguments.

PR #351 -> 23ec952 with **high impact** on all targets.  
Tested in hardware by @salkinium.

#### 2020-03-13: Implement C11 atomics on ARMv6-M

PR #346 -> 5332765.  
Tested in hardware by @salkinium.

#### 2020-03-12: Add C++ RTTI and Exception support

As lbuild options in the `modm:stdc++` module.

PR #343 -> 4ff604f.  
Tested in hardware by @salkinium.

#### 2020-01-20: Add CAT24AAxx I2C EEPROM driver

PR #321 -> b721551.  
Tested in hardware by @mikewolfram.

</details>
