## 2019-10-01: Virtual 2019q3 release

This is a virtual release only for reference that covers everything from
2019-07-01.

Breaking changes:

- Modularized CMSIS-DSP integration.
- Refactored CMake build script generator.
- Refactored NRF24 radio driver.
- Removal of deprecated TIPC XPCC backend.
- Removal of deprecated SDL display driver.

Features:

- Remove hardcoded OpenOCD programmer for some boards.
- AVR: size reporting.
- CMake: Support multi-repository builds.
- `HARDWARE_INIT` helper macro for linker section.

Fixes:

- STM32: Acknowledge external interrupt flags.
- STM32: Shared ADC interrupt.

New device drivers:

- BNO055 IMU driver as `modm:driver:bno055`.
- TLC594x PWM driver as `modm:driver:tlc594x`.
- APA102 RGB LED driver as `modm:driver:apa102`.
- SK6812 RGB LED driver as `modm:driver:sk6812`.

Known bugs:

- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Benjamin Weps (@nesos)
- Carl Treudler (@cajt)
- Jörg Hoffmann (@19joho66) 🎉
- Kaelin Laundry (@WasabiFan) 🎉
- Linas Nikiperavicius (@linasnikis) 🎉
- Niklas Hauser (@salkinium)
- Pavel Pletenev (@ASMfreaK)
- Sascha Schade (@strongly-typed)

<details>
<summary>Detailed changelog</summary>


#### 2019-08-07: Add APA102 and SK6812 LED drivers

PR #267 -> 72d5ae9.  
Tested in hardware by @salkinium.

#### 2019-07-24: Refactor NRF24 radio driver

PR #253 -> 22867e0.  
Tested in hardware by @danielk.

#### 2019-07-15: Refactor CMake build script generator

PR #254 -> 00471ca.  
Tested in hardware by @salkinium.

#### 2019-07-15: Add TLC594x PWM driver

PR #242 -> b570d07.  
Tested in hardware by @linasnikis.

#### 2019-07-11: Add BNO055 IMU driver

PR #191 -> a8edbe8.  
Tested in hardware by @salkinium.

#### 2019-07-11: Modularize CMSIS-DSP

Breaking changes: You need to choose the required submodules.

PR #241 -> 022a60a.  
Tested in hardware by @salkinium.

#### 2019-07-11: Remove hardcoding of OpenOCD programmer

PR #240 -> afbd533.  
Tested in hardware by @salkinium.

</details>
