## 2020-04-01: Virtual 2019q1 release

This is a virtual release only for reference that covers everything from
2019-01-01.

Breaking changes:

- All inheritable lbuild board configs are moved from `modm:board:*` to `modm:*`.
- Split `modm:platform:core` module into `modm:platform:cortex-m` module.
- Refactor SysTick and RCC module.

Features:

- Black Magic Probe upload support.
- STM32: RCC driver with enable()/disable() functions for clocks.
- Cortex-M: Add option to link with flash offset for bootloaders.
- STM32G0 support!

Fixes:

- HD44780: 4-bit initialization.
- NUCLEO-F303K8: Fix SystemClock for CAN.

New device drivers:

- PAT9125EL motion sensor driver as `modm:driver:pat9125el`.
- MAX7219 LED matrix driver as `modm:driver:max7219`.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Fabian Greif (@dergraaf)
- Niklas Hauser (@salkinium)
- Patrick Servello (@patrick--) 🎉
- Pavel Pletenev (@ASMfreaK) 🎉
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Sebastian Birke (@se-bi)
- Thomas Figueroa (@OperativeF) 🎉
- Zawadniak Pedro (@PDR5) 🎉

<details>
<summary>Detailed changelog</summary>


#### 2019-02-06: Add MAX7219 LED matrix driver

PR #187 -> 5dd598c.  
Tested in hardware by @dergraaf.

#### 2019-03-26: Add MAX7219 LED matrix driver

PR #187 -> 5dd598c.  
Tested in hardware by @dergraaf.

#### 2019-03-06: Add STM32G0 support

PR #167 -> 399a533.  
Tested in hardware by @salkinium.

#### 2019-03-06: Refactor SysTick and RCC module

Breaking changes:

- `modm:platform:clock.cortex` -> `modm:platform:systick`.
- `Rcc::setFlashLatency(Frequency);` -> `Rcc::setFlashLatency<Frequency>();`.

PR #180 -> c7b35ca with **high impact** on STM32 targets.  
Tested in hardware by @salkinium.

#### 2019-02-28: Add RCC driver

PR #177 -> 4a82a94 with low impact on STM32 targets.  
Tested in hardware by @salkinium.

#### 2019-02-28: Move common Cortex-M code into own module

Breaking changes: Some options move to `modm:platform:cortex-m` module.

PR #176 -> dee5ea2 with **high impact** on STM32 targets.  
Tested in hardware by @salkinium.

#### 2019-02-20: Move lbuild board configs to repo namespace

Breaking changes: Config inheritance renamed from `modm:board:*` to `modm:*` .

PR #171 -> 564effa with **high impact** on all targets.  
Tested by @salkinium.

#### 2019-01-04: Add PAT9125EL motion sensor driver

PR #136 -> 4f25cdf.  
Tested in hardware by @chris-durand.

</details>
