/*
 *  Copyright (C) 2021 mod.io Pty Ltd. <https://mod.io>
 *
 *  This file is part of the mod.io SDK.
 *
 *  Distributed under the MIT License. (See accompanying file LICENSE or
 *   view online at <https://github.com/modio/modio-sdk/blob/main/LICENSE>)
 *
 */

#pragma once

#pragma push_macro("JSON_HAS_CPP_14")

#define JSON_HAS_CPP_14

#pragma push_macro("JSON_NOEXCEPTION")

#define JSON_NOEXCEPTION 

#pragma push_macro("JSON_HAS_FILESYSTEM")

#define JSON_HAS_FILESYSTEM 0


#include "modio/detail/ModioCompilerMacros.h"
#ifdef MODIO_PLATFORM_UNREAL

	#include MODIO_UNREAL_PLATFORM_PREAMBLE

	MODIO_DISABLE_WARNING_PUSH
	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COVERED_SWITCH_DEFAULT
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_DEPRECATED_LITERAL_OPERATOR
	MODIO_DISABLE_WARNING_FLOAT_EQUAL
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	#include "nlohmann/json.hpp"
	MODIO_DISABLE_WARNING_POP

	#include MODIO_UNREAL_PLATFORM_EPILOGUE
#else
	MODIO_DISABLE_WARNING_PUSH
	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COVERED_SWITCH_DEFAULT
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_DEPRECATED_LITERAL_OPERATOR
	MODIO_DISABLE_WARNING_FLOAT_EQUAL
	MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	#include "nlohmann/json.hpp"
	MODIO_DISABLE_WARNING_POP
#endif

#pragma pop_macro("JSON_HAS_FILESYSTEM")

#pragma pop_macro("JSON_NOEXCEPTION")

#pragma pop_macro("JSON_HAS_CPP_14")