/*
 *  Copyright (C) 2021 mod.io Pty Ltd. <https://mod.io>
 *
 *  This file is part of the mod.io SDK.
 *
 *  Distributed under the MIT License. (See accompanying file LICENSE or
 *   view online at <https://github.com/modio/modio-sdk/blob/main/LICENSE>)
 *
 */

#pragma once

#ifdef MODIO_PLATFORM_NO_LSTAT
	#include <sys/stat.h>
extern "C" inline int lstat(const char* path, struct stat* outStat)
{
	return ::stat(path, outStat);
}

#endif

#ifdef MODIO_PLATFORM_UNREAL

	#include MODIO_UNREAL_PLATFORM_PREAMBLE
	#include "modio/detail/ModioCompilerMacros.h"

	#if defined(MODIO_PLATFORM_CUSTOM_FS)
		#pragma push_macro("GHC_OS_CUSTOM")
		#define GHC_OS_CUSTOM
		#pragma push_macro("_LIBCPP_VERSION")
		#undef _LIBCPP_VERSION

		#include "modio/detail/ModioCompilerMacros.h"
		MODIO_DISABLE_WARNING_PUSH

		MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPE_STRICT
		MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPES
		MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_CPP98_COMPAT
		MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
		MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_NESTED_ANON_TYPES
		MODIO_DISABLE_WARNING_OLD_STYLE_CAST
		MODIO_DISABLE_WARNING_RESERVED_IDENTIFIER
		MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
		MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
		MODIO_DISABLE_WARNING_STRUCTURE_PADDING
		MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
		MODIO_DISABLE_WARNING_UNUSED_FUNCTION
		MODIO_DISABLE_WARNING_ZERO_AS_NULL_POINTER_CONSTANT

		// Backport of std::filesystem to support C++14/C++11
		#include "ghc/filesystem.hpp"

		MODIO_DISABLE_WARNING_POP

		#include "file/FileSystemStubs.h"
		#pragma pop_macro("_LIBCPP_VERSION")
		#pragma pop_macro("GHC_OS_CUSTOM")
namespace Modio
{
	namespace filesystem = ghc::filesystem;
} // namespace Modio

	#elif defined(MODIO_USE_STD_FILESYSTEM)

		#include <filesystem>

		namespace Modio
		{
			namespace filesystem = std::filesystem;
		} // namespace Modio
	#else

		#include "modio/detail/ModioCompilerMacros.h"
		MODIO_DISABLE_WARNING_PUSH

		MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPE_STRICT
		MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPES
		MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_CPP98_COMPAT
		MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
		MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
		MODIO_DISABLE_WARNING_NESTED_ANON_TYPES
		MODIO_DISABLE_WARNING_OLD_STYLE_CAST
		MODIO_DISABLE_WARNING_RESERVED_IDENTIFIER
		MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
		MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
		MODIO_DISABLE_WARNING_STRUCTURE_PADDING
		MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
		MODIO_DISABLE_WARNING_UNUSED_FUNCTION
		MODIO_DISABLE_WARNING_ZERO_AS_NULL_POINTER_CONSTANT

		// Backport of std::filesystem to support C++14/C++11
		#include "ghc/filesystem.hpp"

		MODIO_DISABLE_WARNING_POP

		namespace Modio
		{
			namespace filesystem = ghc::filesystem;
		} // namespace Modio
	#endif

	#include MODIO_UNREAL_PLATFORM_EPILOGUE

#elif defined(MODIO_PLATFORM_CUSTOM_FS)

	// Backport of std::filesystem to support C++14/C++11, with special defines for providing platform stubs in a
	// separate file
	#pragma push_macro("GHC_OS_CUSTOM")
	#define GHC_OS_CUSTOM
	#pragma push_macro("_LIBCPP_VERSION")
	#undef _LIBCPP_VERSION

	#include "ghc/filesystem.hpp"

	#include "file/FileSystemStubs.h"
	#pragma pop_macro("_LIBCPP_VERSION")
	#pragma pop_macro("GHC_OS_CUSTOM")
namespace Modio
{
	namespace filesystem = ghc::filesystem;
} // namespace Modio

#elif defined(MODIO_USE_STD_FILESYSTEM)

	#include <filesystem>

	namespace Modio
	{
		namespace filesystem = std::filesystem;
	} // namespace Modio
#else

	#include "modio/detail/ModioCompilerMacros.h"
	MODIO_DISABLE_WARNING_PUSH

	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPE_STRICT
	MODIO_DISABLE_WARNING_CAST_FUNCTION_TYPES
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
	MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_NESTED_ANON_TYPES
	MODIO_DISABLE_WARNING_OLD_STYLE_CAST
	MODIO_DISABLE_WARNING_RESERVED_IDENTIFIER
	MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
	MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	MODIO_DISABLE_WARNING_ZERO_AS_NULL_POINTER_CONSTANT

	// Backport of std::filesystem to support C++14/C++11
	#include "ghc/filesystem.hpp"

	MODIO_DISABLE_WARNING_POP

	namespace Modio
	{
		namespace filesystem = ghc::filesystem;
	} // namespace Modio
#endif
