/*
 *  Copyright (C) 2021-2024 mod.io Pty Ltd. <https://mod.io>
 *
 *  This file is part of the mod.io SDK.
 *
 *  Distributed under the MIT License. (See accompanying file LICENSE or
 *   view online at <https://github.com/modio/modio-sdk/blob/main/LICENSE>)
 *
 */

#pragma once
/// @brief Wrapper header that enforces both the inclusion of our defines as well as SDKDDKVer.h to ensure asio gets the
/// correct windows version
#include "modio/detail/HedleyWrapper.h"
#include "modio/detail/ModioDefines.h"

#ifdef MODIO_PLATFORM_UNREAL
	#define MODIO_WRAPPING_ASIO
	#include MODIO_UNREAL_PLATFORM_PREAMBLE

namespace asio
{
	namespace detail
	{
		template<typename Exception>
		void throw_exception(const Exception& e)
		{
			checkf(false, TEXT("Asio threw a exception with the message %hs"), e.what());
		}

	} // namespace detail
} // namespace asio

	#pragma push_macro("ASIO_NO_TYPEID")
#ifndef ASIO_NO_TYPEID
	#define ASIO_NO_TYPEID 1
#endif

	#pragma push_macro("ASIO_NO_EXCEPTIONS")
#ifndef ASIO_NO_EXCEPTIONS
	#define ASIO_NO_EXCEPTIONS 1
#endif

	#pragma push_macro("ASIO_DONT_USE_PAUSE")
#ifndef ASIO_DONT_USE_PAUSE
	#define ASIO_DONT_USE_PAUSE
#endif

	#include "modio/detail/ModioCompilerMacros.h"
	MODIO_DISABLE_WARNING_PUSH
	MODIO_DISABLE_WARNING_64BIT_TO_32BIT_CONVERSION
	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_SUGGEST_DESTRUCTOR_OVERRIDE
	MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
	MODIO_DISABLE_WARNING_EXPRESSION_BEFORE_COMMA
	MODIO_DISABLE_WARNING_GLOBAL_CONSTRUCTORS
	MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_NO_NEWLINE_AT_EOF
	MODIO_DISABLE_WARNING_NONPORTABLE_INCLUDE_PATH
	MODIO_DISABLE_WARNING_OLD_STYLE_CAST
	MODIO_DISABLE_WARNING_PRAGMA_POP_MISMATCH
	MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
	MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_SUGGEST_OVERRIDE
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	MODIO_DISABLE_WARNING_UNUSED_PRIVATE_FIELD

	#include <asio.hpp>
	MODIO_DISABLE_WARNING_POP
	#pragma pop_macro("ASIO_DONT_USE_PAUSE")
	#pragma pop_macro("ASIO_NO_EXCEPTIONS")
	#pragma pop_macro("ASIO_NO_TYPEID")

	#include MODIO_UNREAL_PLATFORM_EPILOGUE
	#undef MODIO_WRAPPING_ASIO
#elif defined(_WIN32)
	// Set the proper SDK version before including asio
	#include <sdkddkver.h>
namespace asio
{
	namespace detail
	{
		template<typename Exception>
		void throw_exception(const Exception& MODIO_UNUSED_ARGUMENT(e))
		{}

	} // namespace detail
} // namespace asio

	#pragma push_macro("ASIO_NO_TYPEID")
#ifndef ASIO_NO_TYPEID
	#define ASIO_NO_TYPEID 1
#endif

	#include "modio/detail/ModioCompilerMacros.h"
	MODIO_DISABLE_WARNING_PUSH
	MODIO_DISABLE_WARNING_64BIT_TO_32BIT_CONVERSION
	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED 
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_SUGGEST_DESTRUCTOR_OVERRIDE
	MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
	MODIO_DISABLE_WARNING_EXPRESSION_BEFORE_COMMA
	MODIO_DISABLE_WARNING_GLOBAL_CONSTRUCTORS
	MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_NO_NEWLINE_AT_EOF
	MODIO_DISABLE_WARNING_NONPORTABLE_INCLUDE_PATH
	MODIO_DISABLE_WARNING_OLD_STYLE_CAST
	MODIO_DISABLE_WARNING_PRAGMA_POP_MISMATCH
	MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
	MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_SUGGEST_OVERRIDE
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	MODIO_DISABLE_WARNING_UNUSED_PRIVATE_FIELD

	// Note asio includes Windows.h.
	#include <asio.hpp>
	MODIO_DISABLE_WARNING_POP
	#pragma pop_macro("ASIO_NO_TYPEID")

	// Ensure that we are linking against Winhttp that we require on Windows
	#pragma comment(lib, "Winhttp.lib")
#else // _WIN32
	#ifdef ASIO_NO_EXCEPTIONS

namespace asio
{
	namespace detail
	{
		template<typename Exception>
		void throw_exception(const Exception& e)
		{}
	} // namespace detail
} // namespace asio

	#endif
	#pragma push_macro("ASIO_DONT_USE_PAUSE")
#ifndef ASIO_DONT_USE_PAUSE
	#define ASIO_DONT_USE_PAUSE
#endif

  //#pragma push_macro("ASIO_DISABLE_SOCKETS")
  //#define ASIO_DISABLE_SOCKETS 1
  //#pragma push_macro("ASIO_DISABLE_FD_SET")

//#define ASIO_DISABLE_FD_SET 1
MODIO_DIAGNOSTIC_PUSH

// Disable spurious warning about deprecated allocator<void> specialisation
MODIO_ALLOW_DEPRECATED_SYMBOLS

	#include "modio/detail/ModioCompilerMacros.h"
	MODIO_DISABLE_WARNING_PUSH
	MODIO_DISABLE_WARNING_64BIT_TO_32BIT_CONVERSION
	MODIO_DISABLE_WARNING_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_COPY_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_CPP98_COMPAT
	MODIO_DISABLE_WARNING_SUGGEST_DESTRUCTOR_OVERRIDE
	MODIO_DISABLE_WARNING_EXIT_TIME_DESTRUCTORS
	MODIO_DISABLE_WARNING_EXPRESSION_BEFORE_COMMA
	MODIO_DISABLE_WARNING_GLOBAL_CONSTRUCTORS
	MODIO_DISABLE_WARNING_MOVE_ASSIGNMENT_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_MOVE_CONSTRUCTOR_IMPLICITLY_DELETED
	MODIO_DISABLE_WARNING_NO_NEWLINE_AT_EOF
	MODIO_DISABLE_WARNING_NONPORTABLE_INCLUDE_PATH
	MODIO_DISABLE_WARNING_OLD_STYLE_CAST
	MODIO_DISABLE_WARNING_PRAGMA_POP_MISMATCH
	MODIO_DISABLE_WARNING_SIGNED_UNSIGNED_INTEGER_CONVERSION
	MODIO_DISABLE_WARNING_SPECTRE_MITIGATION
	MODIO_DISABLE_WARNING_STRUCTURE_PADDING
	MODIO_DISABLE_WARNING_SUGGEST_OVERRIDE
	MODIO_DISABLE_WARNING_UNSAFE_BUFFER_USAGE
	MODIO_DISABLE_WARNING_UNUSED_FUNCTION
	MODIO_DISABLE_WARNING_UNUSED_PRIVATE_FIELD
	#include <asio.hpp>
	MODIO_DISABLE_WARNING_POP

MODIO_DIAGNOSTIC_POP
	//#pragma pop_macro("ASIO_DISABLE_FD_SET")
	//#pragma pop_macro("ASIO_DISABLE_SOCKETS")
	#pragma pop_macro("ASIO_DONT_USE_PAUSE")
#endif //_WIN32
