"use strict";(self.webpackChunkmodio_docs=self.webpackChunkmodio_docs||[]).push([[6837],{9136:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>d,contentTitle:()=>r,default:()=>h,frontMatter:()=>s,metadata:()=>a,toc:()=>l});var i=t(4848),o=t(8453);const s={id:"getting-started",title:"Getting Started",slug:"/cppsdk/getting-started/",sidebar_position:2,custom_edit_url:"https://github.com/modio/modio-sdk-internal/blob/develop/doc/getting-started.mdx"},r=void 0,a={id:"game-integration/cppsdk/getting-started",title:"Getting Started",description:"SDK structure and concepts",source:"@site/public/en-us/game-integration/cppsdk/getting-started.mdx",sourceDirName:"game-integration/cppsdk",slug:"/cppsdk/getting-started/",permalink:"/cppsdk/getting-started/",draft:!1,unlisted:!1,editUrl:"https://github.com/modio/modio-sdk-internal/blob/develop/doc/getting-started.mdx",tags:[],version:"current",sidebarPosition:2,frontMatter:{id:"getting-started",title:"Getting Started",slug:"/cppsdk/getting-started/",sidebar_position:2,custom_edit_url:"https://github.com/modio/modio-sdk-internal/blob/develop/doc/getting-started.mdx"},sidebar:"sidebar",previous:{title:"Installation & Setup",permalink:"/cppsdk/setup/"},next:{title:"Marketplace",permalink:"/cppsdk/marketplace/"}},d={},l=[{value:"SDK structure and concepts",id:"sdk-structure-and-concepts",level:2},{value:"Value objects",id:"value-objects",level:3},{value:"UTF-8 guarantees",id:"utf-8-guarantees",level:3},{value:"Non-blocking, asynchronous interface",id:"non-blocking-asynchronous-interface",level:3},{value:"Callback conventions",id:"callback-conventions",level:4},{value:"Maintaining the SDK event loop",id:"maintaining-the-sdk-event-loop",level:4},{value:"Thread Safety",id:"thread-safety",level:3},{value:"Users and Local Profiles",id:"users-and-local-profiles",level:3},{value:"Error handling",id:"error-handling",level:3},{value:"Mod Data Directories",id:"mod-data-directories",level:3},{value:"SDK quick-start",id:"sdk-quick-start",level:2},{value:"Initialization and Teardown",id:"initialization-and-teardown",level:3},{value:"SDK Configuration and Initialization",id:"sdk-configuration-and-initialization",level:4},{value:"Extended Initialization Parameters",id:"extended-initialization-parameters",level:4},{value:"Shutting Down",id:"shutting-down",level:4},{value:"Event Loop (RunPendingHandlers)",id:"event-loop-runpendinghandlers",level:4},{value:"Browsing available mods",id:"browsing-available-mods",level:3},{value:"User Authentication",id:"user-authentication",level:3},{value:"Email authentication",id:"email-authentication",level:4},{value:"SSO/External authentication",id:"ssoexternal-authentication",level:4},{value:"Epic Games Authentication Example",id:"epic-games-authentication-example",level:4},{value:"Steam Authentication Example",id:"steam-authentication-example",level:5},{value:"GOG Authentication Example",id:"gog-authentication-example",level:5},{value:"Mod management and subscriptions",id:"mod-management-and-subscriptions",level:3},{value:"Installation management and mod filepaths",id:"installation-management-and-mod-filepaths",level:4},{value:"Mod subscriptions",id:"mod-subscriptions",level:4},{value:"External subscription changes",id:"external-subscription-changes",level:5},{value:"Checking the user subscription list",id:"checking-the-user-subscription-list",level:5},{value:"Retrieving mod directory filepaths for loading",id:"retrieving-mod-directory-filepaths-for-loading",level:5},{value:"In-game mod submission",id:"in-game-mod-submission",level:3},{value:"Submitting a new mod",id:"submitting-a-new-mod",level:4},{value:"Submitting a file for a mod",id:"submitting-a-file-for-a-mod",level:4},{value:"Edit an existing mod",id:"edit-an-existing-mod",level:3},{value:"Content reporting",id:"content-reporting",level:3},{value:"User mute and unmute functions",id:"user-mute-and-unmute-functions",level:3},{value:"Mute a user",id:"mute-a-user",level:4},{value:"Unmute a user",id:"unmute-a-user",level:4},{value:"List muted users",id:"list-muted-users",level:4},{value:"Temporary Mod Sets",id:"temporary-mod-sets",level:3},{value:"Installing Temporary Mods",id:"installing-temporary-mods",level:4},{value:"Multithreading",id:"multithreading",level:3},{value:"Using an existing secondary thread",id:"using-an-existing-secondary-thread",level:4},{value:"Using a dedicated background thread",id:"using-a-dedicated-background-thread",level:4},{value:"Monetization",id:"monetization",level:3},{value:"Initialization",id:"initialization",level:4},{value:"Getting the user&#39;s wallet",id:"getting-the-users-wallet",level:4},{value:"Syncing Entitlements",id:"syncing-entitlements",level:4},{value:"Querying &amp; Purchasing Mods",id:"querying--purchasing-mods",level:3},{value:"Purchasing Mods",id:"purchasing-mods",level:4},{value:"Showing user purchases",id:"showing-user-purchases",level:4},{value:"Getting a User Delegation Token",id:"getting-a-user-delegation-token",level:4},{value:"Metrics Play Sessions",id:"metrics-play-sessions",level:3},{value:"Initialization",id:"initialization-1",level:4},{value:"Starting a Metrics Session",id:"starting-a-metrics-session",level:4},{value:"Metrics heartbeat",id:"metrics-heartbeat",level:4},{value:"Ending a Metrics Session",id:"ending-a-metrics-session",level:4},{value:"Error Handling",id:"error-handling-1",level:3},{value:"Checking for errors",id:"checking-for-errors",level:4},{value:"Handling Failures",id:"handling-failures",level:5},{value:"Inspecting ErrorCodes more deeply",id:"inspecting-errorcodes-more-deeply",level:4},{value:"Direct Queries",id:"direct-queries",level:5},{value:"Semantic Queries",id:"semantic-queries",level:5},{value:"Putting it all together",id:"putting-it-all-together",level:4},{value:"Parameter Validation Errors",id:"parameter-validation-errors",level:4}];function c(e){const n={a:"a",admonition:"admonition",code:"code",em:"em",h2:"h2",h3:"h3",h4:"h4",h5:"h5",hr:"hr",li:"li",mdxAdmonitionTitle:"mdxAdmonitionTitle",ol:"ol",p:"p",pre:"pre",strong:"strong",table:"table",tbody:"tbody",td:"td",th:"th",thead:"thead",tr:"tr",ul:"ul",...(0,o.R)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(n.h2,{id:"sdk-structure-and-concepts",children:"SDK structure and concepts"}),"\n",(0,i.jsxs)(n.p,{children:["The mod.io SDK has a simple structure that primarily consists of a flat interface, with all public methods declared within ",(0,i.jsx)(n.code,{children:"ModioSDK.h"}),"."]}),"\n",(0,i.jsx)(n.h3,{id:"value-objects",children:"Value objects"}),"\n",(0,i.jsx)(n.p,{children:"All data returned by the SDK uses a small set of classes, containing information such as:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Details for mods available for installation"}),"\n",(0,i.jsx)(n.li,{children:"Status information about in-progress mod management operations"}),"\n",(0,i.jsx)(n.li,{children:"Details and load paths for installed mods."}),"\n"]}),"\n",(0,i.jsxs)(n.p,{children:["These objects return as ",(0,i.jsx)(n.code,{children:"pass-by-value"}),". In other words, if you want to hold onto them once you've shut down the SDK you can do so. In contrast to interfaces that return values via interface pointers, no mod.io SDK objects require you to call ",(0,i.jsx)(n.code,{children:"dispose"}),", ",(0,i.jsx)(n.code,{children:"release"}),", or some other memory manager when their scope finishes."]}),"\n",(0,i.jsx)(n.p,{children:"This flexibility allows you to initialize the SDK, query the installed mods, and keep that list. Then shut down the SDK and stop running the SDK's event loop."}),"\n",(0,i.jsx)(n.h3,{id:"utf-8-guarantees",children:"UTF-8 guarantees"}),"\n",(0,i.jsxs)(n.p,{children:["The SDK uses UTF8 for all strings, stored in ",(0,i.jsx)(n.code,{children:"std::string"}),", as does the mod.io REST API."]}),"\n",(0,i.jsx)(n.h3,{id:"non-blocking-asynchronous-interface",children:"Non-blocking, asynchronous interface"}),"\n",(0,i.jsx)(n.p,{children:"The SDK communicates with the mod.io servers, the filesystem on the device it is running on, and platform-specific authentication services. All of these may not return results immediately; therefore, a large number of the SDK's public methods are non-blocking and asynchronous."}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["All asynchronous methods in the public API have the suffix ",(0,i.jsx)(n.code,{children:"Async"}),"."]})}),"\n",(0,i.jsx)(n.h4,{id:"callback-conventions",children:"Callback conventions"}),"\n",(0,i.jsxs)(n.p,{children:["These asynchronous methods take a ",(0,i.jsx)(n.code,{children:"std::function"}),"-derived callback, which will be invoked exactly once with the results of the requested operation."]}),"\n",(0,i.jsxs)(n.p,{children:["Every async callback takes an ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ErrorCode",children:"ErrorCode"})," as its first parameter, with any results wrapped in ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#Optional",children:"Optional"})," to check if a result is valid or empty."]}),"\n",(0,i.jsxs)(n.p,{children:["Return values provided to your callback are passed ",(0,i.jsx)(n.code,{children:"by-value"}),". The SDK does not expect you to have to call ",(0,i.jsx)(n.code,{children:"release"})," or free up resources given to you."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["Even if the SDK shuts down while asynchronous operations are pending, the remaining callbacks will still execute ",(0,i.jsx)(n.strong,{children:"exactly once"}),". In this case, the callback receives an ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ErrorCode",children:"ErrorCode"})," to indicate a canceled state. Your project should handle gracefully this behavior as part of your error handling."]})}),"\n",(0,i.jsx)(n.h4,{id:"maintaining-the-sdk-event-loop",children:"Maintaining the SDK event loop"}),"\n",(0,i.jsxs)(n.p,{children:["In order to provide a non-blocking implementation, the SDK operates an internal event loop. This event loop only runs on the thread which calls ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["The event loop, all internal event handlers and callbacks provided to the mod.io SDK execute on the thread invoking ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),". ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," must only be called on one thread, otherwise, its behavior is undefined."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["If you stop calling ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),", any pending asynchronous API methods will not complete and their associated callbacks will not be invoked. It also includes the internal data allocated for those operations, as well as the release of any allocated objects."]})}),"\n",(0,i.jsx)(n.h3,{id:"thread-safety",children:"Thread Safety"}),"\n",(0,i.jsxs)(n.p,{children:["Given that ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," performs all the work of the SDK and executes the callbacks that you provide as handlers for the completion of async functions, your application needs to be calling it at regular intervals. However, you may not wish to do so on the main thread of your application, given that the function has to execute for long enough to actually 'get some work done'."]}),"\n",(0,i.jsxs)(n.p,{children:["The mod.io SDK supports the execution of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," on a background thread while your application invokes other SDK functions on the main thread, for example in response to user input in your application's user interface."]}),"\n",(0,i.jsxs)(n.p,{children:["Whilst it is safe to call all other SDK functions from a different thread to the one executing ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),", it is important to note that our existing guarantees are maintained, namely, you'll still receive exactly one callback invocation per asynchronous function you run, and ",(0,i.jsx)(n.em,{children:(0,i.jsxs)(n.strong,{children:["callbacks you provide to those methods will be executed on the thread running ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})]})}),"."]}),"\n",(0,i.jsxs)(n.admonition,{type:"note",children:[(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," should still only be called on a single thread - it is not safe to call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," from multiple threads, either simultaneously or sequentially."]}),(0,i.jsxs)(n.p,{children:["By using a background thread for ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),", you can decouple the frequency with which you perform SDK 'work' from the frequency of your application's main loop for greater performance."]}),(0,i.jsxs)(n.p,{children:["See * ",(0,i.jsx)(n.a,{href:"#multithreading",children:"Multithreading"})," for more information."]})]}),"\n",(0,i.jsx)(n.h3,{id:"users-and-local-profiles",children:"Users and Local Profiles"}),"\n",(0,i.jsx)(n.p,{children:"The mod.io SDK uses a \"Local Profile\" throughout its lifetime. The Local Profile may optionally contain an authenticated user, once you have successfully authenticated using the appropriate SDK function.\nThese local profiles essentially create a 'scope' for the current user to live in, so that a single system can support multiple authenticated users side-by-side without requiring deauthentication of the previous user.\nOn console platforms, we suggest that this be a string representation of the platform-provided UserID, as this gives the best experience when it comes to things like user switching."}),"\n",(0,i.jsx)(n.p,{children:"Internally, the SessionID is used to create a folder containing the authentication information and cached profile of the authenticated user (if any). For example, a game using the GDK on Xbox, using a sanitized string representation of the Xbox live ID as the SessionID, would have a folder structure in the persistent storage like the following:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"<Persistent Storage>/mod.io/<Game ID>/<Xbox Live ID #1>/<Cached Auth>/<Profile data for Xbox Live User #1>\n<Persistent Storage>/mod.io/<Game ID>/<Xbox Live ID #2>/<Cached Auth>/<Profile data for Xbox Live User #2>\n"})}),"\n",(0,i.jsx)(n.p,{children:"When your game starts, you can detect the user associated with the current controller and pass in the stable string representation of their Xbox Live ID as the SessionID. If the user has previously authenticated with mod.io for this game on this device, their authentication status would be maintained."}),"\n",(0,i.jsx)(n.p,{children:"In the case of a PC title with user-provided profile names, the folder structure would be more like the following:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"%USERDATA%/mod.io/<Game ID>/MyProfile1/<Cached Auth>/<Profile data for mod.io account #1>\n%USERDATA%/mod.io/<Game ID>/SomeOtherProfile/<Cached Auth>/<Profile data for mod.io account #2>\n%USERDATA%/mod.io/<Game ID>/ThirdUserSpecifiedProfileName/<Cached Auth>/<Profile data for mod.io account #3>\n"})}),"\n",(0,i.jsx)(n.p,{children:"This allows multiple players, such as siblings, to each have their own session that lives in the same Windows account."}),"\n",(0,i.jsxs)(n.p,{children:["An authenticated user is required to install mods and perform other operations. Check the ",(0,i.jsx)(n.code,{children:"requires"})," section on any SDK function to see what operations need an authenticated user. However, anyone can freely browse and search your game's available mods and only prompt the user to authenticate/create an account when they wish to perform any restricted operations (such as rating or subscribing to a mod)."]}),"\n",(0,i.jsxs)(n.p,{children:["To change a Local Profile's authenticated user, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#clearuserdataasync",children:"ClearUserDataAsync"})," to remove the authenticated user, and then re-authenticate as normal."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["A call to ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#clearuserdataasync",children:"ClearUserDataAsync"})," removes the authenticated user from the local device, and disables mod management. Any installed content is marked for uninstallation from local storage if no other Local Profiles contain authenticated users with active subscriptions to it."]})}),"\n",(0,i.jsxs)(n.p,{children:["To add a newly authenticated user or switch to one already-authenticated without removing the current one, swap to another Local Profile by calling ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"}),", then re-initialize via ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#initializeasync",children:"InitializeAsync"})," specifying a different Local Profile name in the initialization parameters you supply."]}),"\n",(0,i.jsx)(n.h3,{id:"error-handling",children:"Error handling"}),"\n",(0,i.jsxs)(n.p,{children:["Callback functions in the SDK either return a value or provide an ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ErrorCode",children:"ErrorCode"})," value. It is a numeric error code with a category and an associated string message."]}),"\n",(0,i.jsxs)(n.p,{children:["The SDK doesn't attempt to predict what your error-handling logic or requirements are. For example, if you call a function and receive an error code ",(0,i.jsx)(n.code,{children:"ec == Modio::HttpError::CannotOpenConnection"}),", your application could potentially handle this by shutting down the SDK. Another application, however, might wish to retry after an interval determined by its own internal logic. As a result, the SDK defers to your application to decide how to handle errors for the functions you call."]}),"\n",(0,i.jsxs)(n.p,{children:["For more details on the error codes and how to inspect their values, please see ",(0,i.jsx)(n.a,{href:"#error-handling",children:"Error Handling"})," and ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ErrorCode",children:"ErrorCode"}),"."]}),"\n",(0,i.jsx)(n.h3,{id:"mod-data-directories",children:"Mod Data Directories"}),"\n",(0,i.jsx)(n.p,{children:"The plugin stores mods in a game-specific directory in the following path by default:"}),"\n",(0,i.jsxs)(n.table,{children:[(0,i.jsx)(n.thead,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.th,{children:"Windows"}),(0,i.jsx)(n.th,{children:"Linux"}),(0,i.jsx)(n.th,{children:"OSX"})]})}),(0,i.jsx)(n.tbody,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"${FolderID_Public}/mod.io"})}),(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"${USER_HOME}/mod.io"})}),(0,i.jsx)(n.td,{children:(0,i.jsx)(n.code,{children:"${USER_HOME}/Library/Application Support/mod.io"})})]})})]}),"\n",(0,i.jsx)(n.admonition,{type:"info",children:(0,i.jsx)(n.p,{children:"In Linux and macOS, mods and data binds to a single user. Every other client would have their own instance in their home directory."})}),"\n",(0,i.jsx)(n.p,{children:"However, this value can be overridden in one of two ways:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Globally for a system account"}),"\n",(0,i.jsxs)(n.p,{children:["On the first run of a game using the plugin, ",(0,i.jsx)(n.code,{children:"${FolderID_LocalAppData}/mod.io/globalsettings.json"})," will be created."]}),"\n",(0,i.jsxs)(n.p,{children:["This JSON object contains a ",(0,i.jsx)(n.code,{children:"RootLocalStoragePath"})," element. A change to this string to a valid path on disk will globally redirect the mod installation directory for ",(0,i.jsx)(n.strong,{children:"ALL"})," games using the mod.io SDK for the current system account (it also includes the Unreal Engine 4 plugin). To ignore this override and enforce use of the default directory, set the extended parameter key ",(0,i.jsx)(n.code,{children:"IgnoreModInstallationDirectoryOverride"})," to any string value when initializing the SDK."]}),"\n",(0,i.jsx)(n.admonition,{type:"warning",children:(0,i.jsx)(n.p,{children:"Changing this value while the SDK is initialized is not supported and behavior is undefined."})}),"\n",(0,i.jsx)(n.admonition,{type:"info",children:(0,i.jsx)(n.p,{children:"Consider that the mod.io SDK configuration folder is different from that where mod metadata and files stored."})}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Per-Local Profile override"}),"\n",(0,i.jsxs)(n.p,{children:["Per-game, Local Profile-specific settings are stored in ",(0,i.jsx)(n.code,{children:"${FolderID_LocalAppData}/mod.io/${Game_ID}/${Local_Profile_Name}/user.json"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.strong,{children:"Adding"})," a ",(0,i.jsx)(n.code,{children:"RootLocalStoragePath"})," element to this file will redirect the mod installation directory for this specific game only, for the current Local Profile. Removing this value will cause the game to revert back to the global value in ",(0,i.jsx)(n.code,{children:"globalsettings.json"}),"."]}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"sdk-quick-start",children:"SDK quick-start"}),"\n",(0,i.jsxs)(n.p,{children:["The following guides are provided to help you through the basic functions of the SDK as described in ",(0,i.jsx)(n.a,{href:"#sdk-structure-and-concepts",children:"SDK structure and concepts"}),"."]}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#initialization-and-teardown",children:"Initialization and Teardown"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#browsing-available-mods",children:"Browsing available mods"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#user-authentication",children:"User Authentication"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#mod-management-and-subscriptions",children:"Mod management and subscriptions"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#in-game-mod-submission",children:"In-game mod submission"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#edit-an-existing-mod",children:"Edit an existing mod"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#content-reporting",children:"Content reporting"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#user-mute-and-unmute-functions",children:"User mute and unmute functions"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#temporary-mod-sets",children:"Temporary Mod Sets"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#multithreading",children:"Multithreading"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#monetization",children:"Monetization"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#metrics-play-sessions",children:"Metrics Play Sessions"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"#error-handling",children:"Error Handling"})}),"\n"]}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"initialization-and-teardown",children:"Initialization and Teardown"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 01_Initialization"})}),"\n",(0,i.jsx)(n.h4,{id:"sdk-configuration-and-initialization",children:"SDK Configuration and Initialization"}),"\n",(0,i.jsxs)(n.p,{children:["When you are ready to initialize the SDK for the current session, you'll need to call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#initializeasync",children:"InitializeAsync"}),", passing in your product's mod.io ID, your API key, the Local Profile Name, and a callback/handler so you know when the SDK is initialized correctly. Note that ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#initializeasync",children:"InitializeAsync"}),"'s callback will be invoked after calling ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," from your project's main loop."]}),"\n",(0,i.jsx)(n.p,{children:"You should also ensure that you are targeting an appropriate Portal for mod.io to understand what storefront or app the request is originating from. This enabled additional storefront-based functionality, such as returning display name mappings for that portal."}),"\n",(0,i.jsx)(n.p,{children:"[source,cpp]"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:'// represents some external state so we know that the SDK is good to go\nModio::Optional<bool> SDKInitialized;\n\nModio::InitializeOptions Options;\nOptions.APIKey = Modio::ApiKey(YOUR_API_KEY);\nOptions.GameID = Modio::GameID(YOUR_GAME_ID);\nOptions.User = "LocalProfileName";\nOptions.GameEnvironment = Modio::Environment::Live;\nOptions.PortalInUse = Modio::Portal::Steam;\n\nModio::InitializeAsync(Options, [&SDKInitialized](Modio::ErrorCode ec) {\n    if (ec)\n    {\n        // SDK initialization failure\n    }\n    else\n    {\n        // SDK init OK - can now make other calls to the SDK, show mod browser UI, etc\n    }\n});\n'})}),"\n",(0,i.jsxs)(n.p,{children:['It is worth considering that the "LocalProfileName" is used by the mod.io SDK to associate a local session to a user, as mentioned in ',(0,i.jsx)(n.a,{href:"#users-and-local-profiles",children:"Users and Local Profiles"}),". It is possible to forward a user nickname as the LocalProfileName, then initialize the mod.io SDK. Any data related to a user session will be stored in its corresponding ",(0,i.jsx)(n.a,{href:"#mod-data-directories",children:"Mod Data Directory"}),"."]}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Notes"})}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["By convention you'll see these code examples pass in lambda functions as callback handlers, but you can use anything convertible to ",(0,i.jsx)(n.code,{children:"std::function"})," with the appropriate signature."]}),"\n",(0,i.jsxs)(n.li,{children:["The error-handling in this sample is deliberately kept brief. See ",(0,i.jsx)(n.a,{href:"#error-handling",children:"Error Handling"})," for more information on error handling."]}),"\n",(0,i.jsxs)(n.li,{children:["You can perform calls to other functions, such as something that shows your mod browser UI implementation, directly in the callback. The primary caveat to doing much processing here is that you'll be running in the context of, and therefore blocking, the thread running the callback, which is the thread running ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),"."]}),"\n"]}),"\n",(0,i.jsx)(n.h4,{id:"extended-initialization-parameters",children:"Extended Initialization Parameters"}),"\n",(0,i.jsxs)(n.p,{children:["The ",(0,i.jsx)(n.code,{children:"ExtendedParameters"})," field on ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#InitializeOptions",children:"InitializeOptions"})," is a set of key-value pairs intended for platform-specific or special-case parameters that need to be passed to the SDK.\nSimply set the value before passing your initialization parameters in to ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#initializeasync",children:"InitializeAsync"}),"."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Options.ExtendedParameters["SomeParameterName"] = "SomeParameterValue";\n\n'})}),"\n",(0,i.jsx)(n.h4,{id:"shutting-down",children:"Shutting Down"}),"\n",(0,i.jsx)(n.p,{children:"To finalize and shut down the mod.io SDK is equally simple:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"// State variable, stored in some valid scope\nbool SDKShutdownComplete = false;\n\n// Capture reference to the state variable in the lambda - could use shared_ptr for more safety instead\nModio::ShutdownAsync([&SDKShutdownComplete](Modio::ErrorCode ec)\n{\n    SDKShutdownComplete = true;\n});\n\nwhile(!SDKShutdownComplete)\n{\n    Modio::RunPendingHandlers();\n}\n\n"})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," uses a lock to ensure that global SDK state is not mutated out from underneath an invocation of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),". It is not safe to call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," in any callback you provide to the SDK. Callbacks are executed during ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," execution, your application will deadlock while waiting for the enclosing ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," to complete. The lock is deliberately not implemented to support recursive locking, again because ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," mutates data structures that ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," expects to remain unchanged for the duration of its scope."]})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["You will need to continue to call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," while the async shutdown is in progress to allow for intermediate handlers to finish running."]})}),"\n",(0,i.jsx)(n.h4,{id:"event-loop-runpendinghandlers",children:"Event Loop (RunPendingHandlers)"}),"\n",(0,i.jsxs)(n.p,{children:["As mentioned in ",(0,i.jsx)(n.a,{href:"#maintaining-the-sdk-event-loop",children:"Maintaining the SDK event loop"}),", the SDK's internal event loop requires care and attention in the form of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["ALL SDK work is performed during executions of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),", therefore calling it as often as possible will improve performance of the SDK's I/O operations."]}),"\n",(0,i.jsxs)(n.p,{children:["You can either call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," on the main thread, or on a ",(0,i.jsx)(n.a,{href:"#using-a-dedicated-background-thread",children:"dedicated background thread or existing thread of your choice"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["For optimal execution, ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," should be called at least once per frame."]}),"\n",(0,i.jsxs)(n.p,{children:["For example, if you wish to call RunPendingHandlers on the main thread, it could be located into your project's main loop or into a ",(0,i.jsx)(n.code,{children:"tick"}),"-style function on an appropriate controller/manager object."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"while(bGameIsRunning == true)\n{\n    // other stuff\n   Modio::RunPendingHandlers();\n    // other stuff\n}\n"})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["RunPendingHandlers is not reentrant-safe. Do not call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," inside a callback you give to the SDK, or your application will deadlock. Callbacks are run inside ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"}),", and your inner ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," call will block infinitely waiting for the enclosing scope to exit."]})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"browsing-available-mods",children:"Browsing available mods"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 02_ModQueries"})}),"\n",(0,i.jsxs)(n.p,{children:["Now that you've followed the instructions in ",(0,i.jsx)(n.a,{href:"#initialization-and-teardown",children:"Initialization and Teardown"})," you can begin to query the available mods for information you can display to your end users. The primary way this is done is through ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#listallmodsasync",children:"ListAllModsAsync"}),". Note that authentication is not required to browse mods."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"\nModio::ListAllModsAsync(Modio::FilterParams(), [](Modio::ErrorCode ec, Modio::Optional<Modio::ModInfoList> Results)\n{\n    if (ec)\n    {\n        // Error handling\n    }\n    else\n    {\n        for (Modio::ModInfo& CurrentModProfile : *Results)\n        {\n            std::cout << CurrentModProfile.ProfileName;\n        }\n    }\n});\n"})}),"\n",(0,i.jsxs)(n.p,{children:["You'll notice that ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#listallmodsasync",children:"ListAllModsAsync"})," takes a ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#FilterParams",children:"FilterParams"})," object as its first parameter. The default state of this object is set to ask for the first 100 results (the maximum number returnable in a query), sorting by mod ID."]}),"\n",(0,i.jsx)(n.p,{children:"To search for a specific query string, sort in a different order, or combine different filters, you can pass in a FilterParams object like this:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'// Search queries\nModio::ListAllModsAsync(Modio::FilterParams().NameContains("SomeString"), ...)\n// Sorting\nModio::ListAllModsAsync(Modio::FilterParams().SortBy(Modio::FilterParams::SortFieldType::DownloadsToday, Modio::SortDirection::Ascending), ...)\n\n// Ranged results - starting at index 20, return 10 results\nModio::ListAllModsAsync(Modio::FilterParams.NameContains("Your Query").IndexedResults(20, 10), ...)\n\n// Ranged results - return the 20th page of 10 results\nModio::ListAllModsAsync(Modio::FilterParams.NameContains("Your Query").PagedResults(20, 10), ...)\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"user-authentication",children:"User Authentication"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 03_Authentication"})}),"\n",(0,i.jsx)(n.p,{children:"When you want players to subscribe to and use content, you must authenticate them. mod.io provides two ways for users to create an account to use the service: email authentication and single sign on (SSO) through an external authentication partner. The flow for these is slightly different."}),"\n",(0,i.jsx)(n.h4,{id:"email-authentication",children:"Email authentication"}),"\n",(0,i.jsx)(n.p,{children:"mod.io allows users to create an account on the mod.io website using an email address. Once the user has accepted the mod.io Terms of Use and created an account, they can use that email address to log in and access mod.io services in your game."}),"\n",(0,i.jsx)(n.p,{children:"Email authentication involves:"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsx)(n.li,{children:"Submitting the user's email address"}),"\n",(0,i.jsx)(n.li,{children:"The user retrieving the one-time code mod.io sends to that address (externally to your application)"}),"\n",(0,i.jsx)(n.li,{children:"Submitting the code provided by the user"}),"\n"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::RequestEmailAuthCodeAsync(Modio::EmailAddress(UserProvidedEmailAddress), [](Modio::ErrorCode ec)\n{\n    // Handle errors if ec is truthy\n});\n\n// some time later, after the user inputs their authentication code\n\nModio::AuthenticateUserEmailAsync(Modio::EmailAuthCode(UserProvidedAuthCode), [](Modio::ErrorCode ec) {\n\t\tif (ec)\n\t\t{\n            // Authentication failure, inspect ec to determine what information to provide to the end user\n\t\t}\n\t\telse\n\t\t{\n            // User is now authenticated and able to manage their subscriptions via SDK calls\n\t\t}\n\t});\n\n"})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"Email authentication is not recommended for production releases. We strongly recommend the use of platform SSO to provide a seamless authentication experience for your players. Additional platform functionality such as platform display names, avatars and console certification requirements are supported via SSO flows."})}),"\n",(0,i.jsx)(n.h4,{id:"ssoexternal-authentication",children:"SSO/External authentication"}),"\n",(0,i.jsx)(n.p,{children:"mod.io features single sign on authentication from a number of external providers. This currently includes:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Apple"}),"\n",(0,i.jsx)(n.li,{children:"Discord"}),"\n",(0,i.jsx)(n.li,{children:"Epic Games Store"}),"\n",(0,i.jsx)(n.li,{children:"GoG"}),"\n",(0,i.jsx)(n.li,{children:"Google"}),"\n",(0,i.jsx)(n.li,{children:"itch.io"}),"\n",(0,i.jsx)(n.li,{children:"Nintendo Switch"}),"\n",(0,i.jsx)(n.li,{children:"PlayStation\u2122Network"}),"\n",(0,i.jsx)(n.li,{children:"Steam"}),"\n",(0,i.jsx)(n.li,{children:"Xbox Live"}),"\n",(0,i.jsx)(n.li,{children:"Oculus"}),"\n",(0,i.jsx)(n.li,{children:"OpenID"}),"\n"]}),"\n",(0,i.jsxs)(n.p,{children:["Please note that the ability to authenticate players using OpenID is a premium feature. If you are interested in mod.io premium features, please contact ",(0,i.jsx)(n.a,{href:"mailto:developers@mod.io",children:"developers@mod.io"}),"."]}),"\n",(0,i.jsx)(n.p,{children:"To use SSO with mod.io, a user must have accepted the mod.io Terms of Use in order to create an account."}),"\n",(0,i.jsx)(n.p,{children:"This means the external authentication flow is the following:"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["Call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#authenticateuserexternalasync",children:"AuthenticateUserExternalAsync"})," , passing in any provider-specific parameters, setting ",(0,i.jsx)(n.code,{children:"AuthenticationParams::bUserHasAcceptedTerms"})," to false, and indicating which authentication provider you wish to use"]}),"\n",(0,i.jsxs)(n.li,{children:["Check the error code in the callback - if it indicates the user has not yet created an account or accepted the terms, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#gettermsofuseasync",children:"GetTermsOfUseAsync"})," and display the provided information to your user"]}),"\n",(0,i.jsxs)(n.li,{children:["If the user clicks the OK/affirmative button on your screen displaying the terms of use, repeat the call in step 1 but setting ",(0,i.jsx)(n.code,{children:"AuthenticationParams::bUserHasAcceptedTerms"})," to ",(0,i.jsx)(n.strong,{children:"true"})]}),"\n",(0,i.jsx)(n.li,{children:"Check the error code in the callback - a false-y error code indicates that authentication was successful, and users can now install and manage mods and subscriptions."}),"\n"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::AuthenticationParams UserParams;\nUserParams.AuthToken = "AuthenticationToken";\nUserParams.UserEmail = "UserEmail";\nUserParams.bUserHasAcceptedTerms = false;\n\nModio::AuthenticateUserExternalAsync(UserParams,Provider,[Provider](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        if (ec == Modio::ApiError::UserNoAcceptTermsOfUse)\n        {\n            // We need to display the terms of use to the user\n            Modio::GetTermsOfUseAsync([](Modio::ErrorCode ec, Modio::Optional<Modio::Terms> Terms)\n            {\n                if (ec)\n                {\n                    // something went wrong fetching the terms, inspect ec to decide what to do\n                }\n                else\n                {\n                    // Display the terms of use to the user, remember not to block in the callback here!\n                    NonBlockingFunctionThatDisplaysTheTermsOfUse(Terms);\n                }\n            });\n        }\n    }\n});\n\n// Later sometime, when your user clicks accept on the terms of use\nUserParams.bUserHasAcceptedTerms = true;\nModio::AuthenticateUserExternalAsync(UserParams,Provider,[](Modio::ErrorCode ec){/* ... */});\n\n'})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"Changing users via AuthenticateUserExternalAsync (ie performing an authentication for a different user) will disable mod management."})}),"\n",(0,i.jsx)(n.h4,{id:"epic-games-authentication-example",children:"Epic Games Authentication Example"}),"\n",(0,i.jsxs)(n.p,{children:["In order to use Epic Games Authentication, you must ensure that you have ",(0,i.jsx)(n.a,{href:"/platforms/epic/authentication",children:"configured Epic Account Services for your title"}),". Once you have done this, you can request an ID Token for a user that has been logged into Epic. You must ensure that the scopes you are authentication with match the scopes for the application you are configuring in EAS."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["If your title is not yet live, you can use Epic's DevAuthTool and the ",(0,i.jsx)(n.code,{children:"EOS_LCT_Developer"})," credential type for testing."]})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'static void EOS_CALL LoginCompleteCallbackFn(const EOS_Auth_LoginCallbackInfo* Data)\n{\n\tEOS_Auth_CopyIdTokenOptions IdTokenOptions;\n\tIdTokenOptions.AccountId = Data->LocalUserId;\n\tIdTokenOptions.ApiVersion = EOS_AUTH_COPYIDTOKEN_API_LATEST;\n\n\tEOS_Auth_IdToken* IdToken;\n\tEOS_EResult Result = EOS_Auth_CopyIdToken(ModioTest::EpicAuthHelper::instance().AuthHandle, &IdTokenOptions, &IdToken);\n\n\tif (Result == EOS_EResult::EOS_Success)\n\t{\n\t\tstd::string Token = IdToken->JsonWebToken;\n\n\t\tModio::AuthenticationParams User;\n\t\tUser.AuthToken = Token;\n\t\tUser.bURLEncodeAuthToken = true;\n\t\tUser.bUserHasAcceptedTerms = true;\n\n\t\tModio::AuthenticateUserExternalAsync(User, Modio::AuthenticationProvider::Epic, [](Modio::ErrorCode ec) {\n\t\t\tif (ec)\n\t\t\t{\n\t\t\t\tstd::cout << "Failed to authenticate to mod.io: " << ec.message() << std::endl;\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tstd::cout << "Authentication complete" << std::endl;\n\t\t\t}\n\t\t});\n\t}\n\telse\n\t{\n\t\tstd::cout << "Failed to get Epic ID Token";\n\t}\n}\n'})}),"\n",(0,i.jsx)(n.h5,{id:"steam-authentication-example",children:"Steam Authentication Example"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in advanced example 01_SteamAuthAndEntitlements"})}),"\n",(0,i.jsxs)(n.p,{children:["In order to use the Steam authentication functionality, you must ",(0,i.jsx)(n.a,{href:"/platforms/steam/authentication",children:"configure your game's Encrypted App Ticket Key from Steamworks"}),". Once you have done that, you can request an Encrypted App Ticket for an authenticated user as follows, replacing your class references to your own Steam Subsystem as appropriate."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"uint32 k_unSecretData = 0x5444;\nSteamAPICall_t hSteamAPICall = SteamUser()->RequestEncryptedAppTicket(&k_unSecretData, sizeof(k_unSecretData));\nSteamAuthHelperInstance->m_SteamCallResultEncryptedAppTicket.Set(hSteamAPICall, SteamAuthHelperInstance, &SteamAuthHelper::OnEncryptedAppTicketResponse);\n"})}),"\n",(0,i.jsxs)(n.p,{children:["Ensure that you have defined a Steam CCallResult to listen for a callback, such as ",(0,i.jsx)(n.code,{children:"CCallResult<SteamAuthHelper, EncryptedAppTicketResponse_t> m_SteamCallResultEncryptedAppTicket;"}),"."]}),"\n",(0,i.jsx)(n.p,{children:"Once you successfully receive that callback, you can get the Encrypted App Ticket as follows, ensuring you Base64 encode it."}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'std::string EncodedSteamAuthTicket;\n\nunsigned char rgubTicket[1024];\nuint32 cubTicket;\nif (SteamUser()->GetEncryptedAppTicket(rgubTicket, sizeof(rgubTicket), &cubTicket))\n{\n\t\t\t\tEncodedSteamAuthTicket = base64_encode(rgubTicket, cubTicket);\n\t\t\t\tstd::cout << "Steam App Ticket received" << std::endl;\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:"Finally, once you have your Base64 encoded app ticket, you can SSO to mod.io as follows:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::AuthenticationParams AuthParams;\nAuthParams.AuthToken = EncodedSteamAuthTicket;\nAuthParams.bURLEncodeAuthToken = true;\nAuthParams.bUserHasAcceptedTerms = true;\nModio::AuthenticateUserExternalAsync(\n\tAuthParams, Modio::AuthenticationProvider::Steam, [&](Modio::ErrorCode ec) {\n\t\tif (ec)\n\t\t{\n\t\t\tstd::cout << "Failed to authenticate to mod.io: " << ec.message() << std::endl;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tstd::cout << "Authentication complete" << std::endl;\n\t\t}\n\t});\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h5,{id:"gog-authentication-example",children:"GOG Authentication Example"}),"\n",(0,i.jsxs)(n.p,{children:["In order to use the GOG authentication functionality, you must ",(0,i.jsx)(n.a,{href:"/platforms/gog/authentication",children:"configure your game's Encrypted App Ticket Key from GOG"}),". Ensure that you are signing into GOG using ",(0,i.jsx)(n.code,{children:"galaxy::api::User()->SignInGalaxy"}),". Once you have done that, you can request an Encrypted App Ticket for an authenticated user as follows, replacing your class references to your own GOG as appropriate."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"galaxy::api::User()->RequestEncryptedAppTicket(nullptr, 0, &GOGAuthHelperInstance);\n"})}),"\n",(0,i.jsxs)(n.p,{children:["In your authentication helper, ensure that you are inheriting from ",(0,i.jsx)(n.code,{children:"galaxy::api::GlobalEncryptedAppTicketListener"})," to get the result of the the app ticket request, via the ",(0,i.jsx)(n.code,{children:"OnEncryptedAppTicketRetrieveSuccess()"})," method."]}),"\n",(0,i.jsx)(n.p,{children:"Once you receive that callback, you can get the value of the encrypted app ticket as follows:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"unsigned char ticket[1024];\nuint32_t ticketLength;\n\ngalaxy::api::User()->GetEncryptedAppTicket(ticket, sizeof(ticket), ticketLength);\n\nstd::string AuthTicket;\nAuthTicket.assign(ticket, std::find(ticket, ticket + ticketLength, '\\0'));\n"})}),"\n",(0,i.jsx)(n.p,{children:"Finally, you can SSO to mod.io as follows:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::AuthenticationParams AuthParams;\nAuthParams.AuthToken = AuthTicket;\nAuthParams.bURLEncodeAuthToken = true;\nAuthParams.bUserHasAcceptedTerms = true;\nModio::AuthenticateUserExternalAsync(\n\tAuthParams, Modio::AuthenticationProvider::GoG, [&](Modio::ErrorCode ec) {\n\t\tif (ec)\n\t\t{\n\t\t\tstd::cout << "Failed to authenticate to mod.io: " << ec.message() << std::endl;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tstd::cout << "Authentication complete" << std::endl;\n\t\t}\n\t});\n'})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["Note that you do not need to base64 encode the app ticket that you receive from GOG; you only need to ensure it is URL encoded, either by setting ",(0,i.jsx)(n.code,{children:"bURLEncodeAuthToken=true"})," or doing it yourself before passing it to ",(0,i.jsx)(n.code,{children:"AuthenticateUserExternalAsync"}),"."]})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"mod-management-and-subscriptions",children:"Mod management and subscriptions"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 04_SubscriptionManagement"})}),"\n",(0,i.jsx)(n.p,{children:"Now you've shown the user some mods based on a query they've submitted through your UI. The user has picked one that they'd like to install. This section explains how to trigger an installation process and the files downloaded to the filesystem."}),"\n",(0,i.jsx)(n.h4,{id:"installation-management-and-mod-filepaths",children:"Installation management and mod filepaths"}),"\n",(0,i.jsxs)(n.p,{children:["A subscription marks a mod as requiring installation, whereas an unsubscription indicates uninstallation. But, how do you actually control when the SDK ",(0,i.jsx)(n.strong,{children:"does"})," those things? After all, you don't want a mod to be uninstalled after your main program has loaded those files into memory, locking them from deletion. Likewise, you probably don't want to be using networking or processor resources during gameplay for downloading mods. In order to give you control over when these processes occur, without forcing you to shut down the SDK entirely, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#enablemodmanagement",children:"EnableModManagement"})," and ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#disablemodmanagement",children:"DisableModManagement"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["In order to display a notification to your users when a mod is finished installing or updating, ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#enablemodmanagement",children:"EnableModManagement"})," asks you to provide a callback. Because ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#enablemodmanagement",children:"EnableModManagement"})," is ",(0,i.jsx)(n.strong,{children:"not an async"})," function (ie it doesn't end with *Async), the function handler operates differently compared to other asynchronous results callbacks you use elsewhere in the SDK. A handler given to this function will be held by the SDK until a corresponding call to ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#disablemodmanagement",children:"DisableModManagement"})," or ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," takes place. The handler will be invoked every time a mod is automatically installed, updated, or uninstalled by the SDK's internal event loop."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::EnableModManagement([](Modio::ModManagementEvent ModEvent)\n{\n    if (ModEvent.Status && ModEvent.Event == Modio::ModManagementEvent::EventType::Installed)\n    {\n        std::cout << "Mod with ID: " << ModEvent.ID << " is installed" << std::endl;\n    }\n    else \n    {\n        std::cout << "Mod with ID: " << ModEvent.ID << " failed to install: " << ModEvent.Status.message() << std::endl;\n    }\n});\n\n// Some time later: check if there\'s a mod being installed, or more mods that require installation pending\nif (!Modio::IsModManagementBusy())\n{\n    // This will reset any in-progress installations to pending, so we\'re only calling it if nothing\'s being processed\n    Modio::DisableModManagement();\n}\n\n'})}),"\n",(0,i.jsx)(n.h4,{id:"mod-subscriptions",children:"Mod subscriptions"}),"\n",(0,i.jsx)(n.p,{children:"A user indicates they want to have a mod installed by 'subscribing' to it. The mod.io servers stores subscriptions and associates them with a particular user's mod.io account.\nWhen a user 'unsubscribes' to a mod, they indicate that mod should be uninstalled from any device they're logged in on."}),"\n",(0,i.jsxs)(n.p,{children:["The API for managing subscriptions is simple and consists of a call to either ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#subscribetomodasync",children:"SubscribeToModAsync"})," or ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#unsubscribefrommodasync",children:"UnsubscribeFromModAsync"})," with the ID of the mod in question and a callback to receive the status of the request:"]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["To subscribe to a mod, ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#enablemodmanagement",children:"EnableModManagement"})," must be called beforehand."]})}),"\n",(0,i.jsx)(n.p,{children:"When subscribing to a mod, you can also pass in a bool to indicate if you want to subscribe to all dependencies for the given mod. If dependencies are also subscribed, the mod.io servers will also associate them with the current user."}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["Currently when dependencies are included during subscription, they will not automatically be downloaded. To ensure the latest content is downloaded, ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#fetchexternalupdatesasync",children:"FetchExternalUpdatesAsync"})," must be called after subscribing."]})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"// Subscription\nModio::SubscribeToModAsync(ModID, IncludeDependencies, [](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // Didn't subscribe, show a message to the user\n    }\n    else\n    {\n        // Successfully subscribed on the server\n    }\n});\n\n// Unsubscription\nModio::UnsubscribeFromModAsync(ModID, [](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // Couldn't unsubscribe, show error\n    }\n    else\n    {\n        // Server records unsubscription to remove the user's association to this mod\n    }\n});\n\n"})}),"\n",(0,i.jsx)(n.h5,{id:"external-subscription-changes",children:"External subscription changes"}),"\n",(0,i.jsxs)(n.p,{children:["Remember that the mod.io service is available as a website besides the integration within your application. Users can manage their subscriptions (and therefore installations) outside of your game. Consequently, you must query the server for any external subscription changes. To do this, use ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#fetchexternalupdatesasync",children:"FetchExternalUpdatesAsync"})," to synchronise the server state with the SDK's local subscriptions:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::FetchExternalUpdatesAsync([](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // Couldn't fetch external subscription data, handle error\n    }\n    else\n    {\n        // The SDK's internal state synchronised. This is an acknowledgment of success\n    }\n});\n"})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["You should call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#fetchexternalupdatesasync",children:"FetchExternalUpdatesAsync"})," at particular times in your application when you want to ensure that the state is up-to-date. The mod.io SDK will apply rate-limiting internally if you try to call it too often."]})}),"\n",(0,i.jsxs)(n.p,{children:["In case you need to prepare for changes happening beforehand, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#previewexternalupdatesasync",children:"PreviewExternalUpdatesAsync"}),". This function retrieves a list of updates between the users local mod state, and the server-side state. It allows you to identify which mods will be modified when you call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#fetchexternalupdatesasync",children:"FetchExternalUpdatesAsync"})," next in order to perform any content management (such as unloading files) that might be required. Its use is very similar:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::PreviewExternalUpdatesAsync([](Modio::ErrorCode ec, std::map<Modio::ModID, Modio::UserSubscriptionList::ChangeType> ListOfChanges)\n{\n    if (ec)\n    {\n        // Couldn\'t preview external subscription data, handle error\n    }\n    else\n    {\n        // Take notice of the changes brought inside variable "ListOfChanges". It serves as acknowledgment of success\n    }\n});\n'})}),"\n",(0,i.jsx)(n.h5,{id:"checking-the-user-subscription-list",children:"Checking the user subscription list"}),"\n",(0,i.jsxs)(n.p,{children:["In order to see which mods the user has subscribed to, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryusersubscriptions",children:"QueryUserSubscriptions"})," to retrieve a collection of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ModCollectionEntry",children:"ModCollectionEntry"})," objects, one for each subscribed mod.\nEach of these objects contains the mod's state, profile information, ID, and other data suitable for showing users a list of their subscriptions."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["This collection includes mods that are still in the process of being installed. Make sure to check the result of ",(0,i.jsx)(n.code,{children:"ModCollectionEntry::GetModState"})," before trying to load files from the mods in this collection. Alternatively, use ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryuserinstallations",children:"QueryUserInstallations"})," as described in ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#retrieving-mod-directory-filepaths-for-loading",children:"Retrieving mod directory paths for loading"}),"."]})}),"\n",(0,i.jsxs)(n.p,{children:["A distinction exists between functions ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryuserinstallations",children:"QueryUserInstallations"})," and ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#querysysteminstallations",children:"QuerySystemInstallations"}),". The first fetches the subset of the user's subscribed mods that are installed and therefore ready for loading. ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryuserinstallations",children:"QueryUserInstallations"})," is more relevant for most cases to personalize the content shown to the user. On the other hand, a call to ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#querysysteminstallations",children:"QuerySystemInstallations"})," returns all mods installed on the system (including those the current user is subscribed to). This provides insight into mods installed by other users."]}),"\n",(0,i.jsx)(n.p,{children:"If local space is a concern, here are some options to manage storage:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["Execute ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#querysysteminstallations",children:"QuerySystemInstallations"}),", let the user know space is limited and provide the chance to select mods to uninstall. Then call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ForceUninstallModAsync",children:"ForceUninstallModAsync"})," to remove mods selected by the user."]}),"\n",(0,i.jsxs)(n.li,{children:["Execute ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryuserinstallations",children:"QueryUserInstallations"})," and prompt the user to unsubscribe from large mods."]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"The first option focuses on the removal of mods the user has not interacted with, whereas the second option would actively uninstall mods the user has previously considered and subscribed to. Consider other alternatives when designing your game to support mods."}),"\n",(0,i.jsx)(n.h5,{id:"retrieving-mod-directory-filepaths-for-loading",children:"Retrieving mod directory filepaths for loading"}),"\n",(0,i.jsx)(n.p,{children:"Once the user can pick mods and subscribe to them (i.e. mark them for installation), mod.io SDK management can alter the filesystem and retrieve mods. We need to know where they are on the filesystem to load them into your gameplay."}),"\n",(0,i.jsxs)(n.p,{children:["The easiest way to do this is by using ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#queryuserinstallations",children:"QueryUserInstallations"}),". This function allows you to specify if you want to include outdated mods or not. It returns a collection of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ModCollectionEntry",children:"ModCollectionEntry"})," objects that you can query for folder paths you can use to load files into your title."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'std::vector<Modio::filesystem::path> ModPaths;\n\n// It iterates over all the installed mods that are up-to-date\nbool bIncludeOutdatedMods = false;\nfor (std::pair<Modio::ModID, Modio::ModCollectionEntry>& Entry : Modio::QueryUserInstallations(bIncludeOutdatedMods))\n{\n    ModPaths.push_back(Entry.second().GetPath());\n}\n\n// You can now append whatever filenames you expect in a mod to the paths and load those in\nfor (Modio::filesystem::path& Path : ModPaths)\n{\n    YourGame::FileHandle ModManifest = YourGame::OpenFile(Path / "mod_manifest.txt");\n}\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"in-game-mod-submission",children:"In-game mod submission"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 08_SubmitMod"})}),"\n",(0,i.jsx)(n.p,{children:"Submitting a mod from inside your game and making it visible to other players involves two steps:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Submission of the mod"}),"\n",(0,i.jsx)(n.li,{children:"Submission of the mod's data (aka 'the mod file')"}),"\n"]}),"\n",(0,i.jsxs)(n.p,{children:["These steps are outlined below. Mods can also be edited after submission, as detailed in ",(0,i.jsx)(n.a,{href:"#edit-an-existing-mod",children:"Edit an existing mod"})]}),"\n",(0,i.jsx)(n.h4,{id:"submitting-a-new-mod",children:"Submitting a new mod"}),"\n",(0,i.jsxs)(n.p,{children:["To submit a mod, first create a mod handle using ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#getmodcreationhandle",children:"GetModCreationHandle"})," and use that handle when calling ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#submitnewmodasync",children:"SubmitNewModAsync"}),". Note that the newly created mod will remain hidden until a mod file is added in the next step."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'\nModio::ModCreationHandle Handle = GetModCreationHandle();\n\nModio::CreateModParams Params;\n\nParams.PathToLogoFile = "C:/temp/image.png";\nParams.Name = "My Awesome Mod";\nParams.Summary = "This is an amazing mod";\n// add any additional optional parameters\n\nModio::SubmitNewModAsync(Handle, Params, [](Modio::ErrorCode ec, Modio::Optional<Modio::ModID> NewModID)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // capture NewModID as needed for subsequent use\n    }\n});\n\n'})}),"\n",(0,i.jsx)(n.h4,{id:"submitting-a-file-for-a-mod",children:"Submitting a file for a mod"}),"\n",(0,i.jsxs)(n.p,{children:["Once you have successfully submitted a mod, you can submit a file for that mod using ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#submitnewmodfileformod",children:"SubmitNewModFileForMod"}),". When you submit a file, pass a ",(0,i.jsx)(n.code,{children:"Modio::CreateModFileParams"})," containing the directory of the files that you want to submit. The SDK will compress this folder into a zip file and upload it as the active version of the mod. Note that there is no callback for this method; you'll be notified of the completed upload by the Mod Management callback."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'\nModio::CreateModFileParams Params;\n\nParams.RootDirectory = "C:/temp/mod_folder";\n// add any additional optional parameters\n\n// Use NewModID returned in SubmitNewModAsync() callback\nModio::SubmitNewModFileForMod(NewModID, Params);\n\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"edit-an-existing-mod",children:"Edit an existing mod"}),"\n",(0,i.jsxs)(n.p,{children:["Mod details can be edited in-game using ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#submitmodchangesasync",children:"SubmitModChangesAsync"}),".  This function allows you to edit multiple parameters with a single call.  It takes a ",(0,i.jsx)(n.code,{children:"Modio::ModID"})," of the mod to edit, a ",(0,i.jsx)(n.code,{children:"Modio::EditModParams"})," containing one or more parameters to be altered, and a callback that will contain an optional updated ",(0,i.jsx)(n.code,{children:"Modio::ModInfo"})," object on success."]}),"\n",(0,i.jsxs)(n.p,{children:["Note that updating the mod file itself is done via ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#submitnewmodfileformod",children:"SubmitNewModFileForMod"}),", as detailed in ",(0,i.jsx)(n.a,{href:"#submitting-a-file-for-a-mod",children:"Submitting a file for a mod"}),"."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'\nModio::EditModParams EditParams;\n\n// Add one or more parameters to edit\nEditParams.Name = "My Edited Mod Name";\nEditParams.Summary = "My edited summary";\n\nModio::SubmitModChangesAsync(ModID, EditParams, [](Modio::ErrorCode ec, Modio::Optional<Modio::ModInfo> UpdatedModInfo)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // capture or display UpdatedModInfo as needed\n    }\n});\n\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"content-reporting",children:"Content reporting"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 06_ReportMod"})}),"\n",(0,i.jsx)(n.p,{children:"The SDK has full support for reporting content that breaches guidelines - this can be entire games, users, or mods themselves. When reporting a mod, users can provide a report type, a reason and their contact details. These reports will appear on your game's moderation dashboard to be actioned. Shipping your title on consoles generally requires moderation and reporting capability being provided in your game."}),"\n",(0,i.jsxs)(n.p,{children:["To report a piece of content, call ",(0,i.jsx)(n.a,{href:"cppsdk/refdocs#reportcontentasync",children:"ReportContentAsync"}),", providing a ",(0,i.jsx)(n.code,{children:"Modio::ReportParams"})," containing the paramters for the report."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'\nModio::ReportParams Params = Modio::ReportParams(Modio::ModID(ModID), Modio::ReportType::DMCA, "This mod contains copyrighted content",\n\t\t\t\t\t\t"ReporterName", "Reporter@Email.com");\n\nModio::ReportContentAsync(Params, [](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // content successfully reported\n    }\n});\n\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"user-mute-and-unmute-functions",children:"User mute and unmute functions"}),"\n",(0,i.jsx)(n.p,{children:"Users have the ability to disable updates from other user's mods. This will prevent mod.io from returning mods authored by the muted user. There are three functions to perform these actions:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Mute a user"}),"\n",(0,i.jsx)(n.li,{children:"Unmute a user"}),"\n",(0,i.jsx)(n.li,{children:"List muted users"}),"\n"]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"To perform any of these actions, the muting user must be authenticated."})}),"\n",(0,i.jsx)(n.h4,{id:"mute-a-user",children:"Mute a user"}),"\n",(0,i.jsxs)(n.p,{children:["To mute a user, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#muteuserasync",children:"MuteUserAsync"})," with the corresponding ",(0,i.jsx)(n.code,{children:"Modio::UserID"})," and a callback, given the asynchronous nature of the function"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"\nModio::MuteUserAsync(UserID, [](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // user successfully muted\n    }\n});\n\n"})}),"\n",(0,i.jsx)(n.h4,{id:"unmute-a-user",children:"Unmute a user"}),"\n",(0,i.jsxs)(n.p,{children:["To perform the inverse operation, unmute a user, call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#unmuteuserasync",children:"UnmuteUserAsync"})," with the corresponding ",(0,i.jsx)(n.code,{children:"Modio::UserID"})," and a callback, given the asynchronous nature of the function"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"\nModio::UnmuteUserAsync(UserID, [](Modio::ErrorCode ec)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // user successfully unmuted\n    }\n});\n\n"})}),"\n",(0,i.jsx)(n.h4,{id:"list-muted-users",children:"List muted users"}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#getmutedusersasync",children:"GetMutedUsersAsync"})," returns a ",(0,i.jsx)(n.code,{children:"Modio::UserList"})," on success, containing information on users previously muted by the authenticated user."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"\nModio::GetMutedUsersAsync([](Modio::ErrorCode ec, Modio::Optional<Modio::UserList> UserList)\n{\n    if (ec)\n    {\n        // error handling\n    }\n    else\n    {\n        // capture or display UserList as needed\n    }\n});\n\n"})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h3,{id:"temporary-mod-sets",children:"Temporary Mod Sets"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 11_TempModSets"})}),"\n",(0,i.jsx)(n.p,{children:"In some situations, you may want mods to only exist on a temporary basis - for instance, in Multiplayer environments where you don't want to subscribe a user to a piece of content. Temporary Mod Sets allow management of these more transient pieces of content separately from subscriptions. Temp Mod Sets do not require authentication to be used, however Mod Management must still be enabled to use Temp Mods."}),"\n",(0,i.jsxs)(n.p,{children:["Temp Mods are downloaded in a folder separately from subscriptions, and are not updated or handled when you call ",(0,i.jsx)(n.code,{children:"FetchExternalUpdatesAsync"}),". That means you can prioritize download and installation of Temp Mods outside of the regular subscription flow."]}),"\n",(0,i.jsxs)(n.p,{children:["To use Temp Mods, you can start a TempModSet by calling ",(0,i.jsx)(n.code,{children:"InitTempModSet"})," and passing a list of Mod IDs to be downloaded and extracted. At anytime while a TempModSet is open, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#addtotempmodset",children:"AddToTempModSet"})," to add mods to the set (which will be instantly downloaded and extracted). If you no longer need a mod, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#removefromtempmodset",children:"RemoveFromTempModSet"})," which will remove the file. Once you have finished with a TempModSet, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#closetempmodset",children:"CloseTempModSet"})," which will delete all temporary mods. Temporary mods are also deleted the next time you re-initialize the SDK."]}),"\n",(0,i.jsxs)(n.p,{children:["Like regular mods, Temp Mods can be queried using ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#querytempmodset",children:"QueryTempModSet"})," to get a ModCollectionEntry with an installation path."]}),"\n",(0,i.jsx)(n.h4,{id:"installing-temporary-mods",children:"Installing Temporary Mods"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::EnableModManagement([](Modio::ModManagementEvent ModEvent)\n{\n    if (ModEvent.Status && ModEvent.Event == Modio::ModManagementEvent::EventType::Installed)\n    {\n        std::cout << "Mod with ID: " << ModEvent.ID << " is installed" << std::endl;\n    }\n    else \n    {\n        std::cout << "Mod with ID: " << ModEvent.ID << " failed to install: " << ModEvent.Status.message() << std::endl;\n    }\n});\n\nstd::vector<Modio::ModID> ModIds = {8, 4, 5};\n\nModio::InitTempModSet(ModIds);\n\nwhile(Modio::IsModManagementBusy())\n{\n    Modio::RunPendingHandlers();\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:"This call will start a TempModSet and install Mods with IDs 8, 4 and 5."}),"\n",(0,i.jsxs)(n.admonition,{type:"note",children:[(0,i.jsx)(n.mdxAdmonitionTitle,{}),(0,i.jsx)(n.p,{children:"If you add an already subscribed mod to TempModSet, it will not download be downloaded as the player will already have that content. If you try to unsubscribe from it while it's in TempModSet, the SDK it will wait for it to be removed from TempModSet before processing the unsubscribe."})]}),"\n",(0,i.jsx)(n.h3,{id:"multithreading",children:"Multithreading"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 07_Threading"})}),"\n",(0,i.jsxs)(n.p,{children:["As mentioned in ",(0,i.jsx)(n.a,{href:"#initialization-and-teardown",children:"the quick-start section on initialization"}),", the SDK supports ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," being run on a secondary thread that already exists or a dedicated background thread you create specifically to peform SDK work."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["Callbacks you provide to the SDK will run ",(0,i.jsx)(n.em,{children:(0,i.jsxs)(n.strong,{children:["on the thread running ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})]})})," - if you host ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," on a different thread, it is your responsibility to synchronize with the main thread if you wish to pass results back to it, through callbacks you provide to the SDK."]})}),"\n",(0,i.jsx)(n.p,{children:"This allows the SDK to avoid blocking the main thread of your application while performing IO."}),"\n",(0,i.jsx)(n.h4,{id:"using-an-existing-secondary-thread",children:"Using an existing secondary thread"}),"\n",(0,i.jsxs)(n.p,{children:["If you have an existing secondary thread which is not heavily utilized, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," on that thread:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"while(bRunBackgroundThread == true)\n{\n    // other stuff\n   Modio::RunPendingHandlers();\n    // other stuff\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"Just remember, that performance of the SDK is proportional to the amount of CPU cycles you give it, so if you use an existing secondary thread you'll need to ensure that that thread's loop runs at a high enough frequency."}),"\n",(0,i.jsx)(n.h4,{id:"using-a-dedicated-background-thread",children:"Using a dedicated background thread"}),"\n",(0,i.jsxs)(n.p,{children:["Using a dedicated background thread for ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," will ensure the best performance for the SDK's I/O operations by allowing SDK functionality to execute at a rate not limited by your application's main loop frequency or existing background loop frequencies."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"//Assumption: bHaltBackgroundThread is a threadsafe flag or atomic boolean whose lifetime is guaranteed to be longer than that of the handler thread\nHandlerThread = std::thread([&bHaltBackgroundThread]() {\n\twhile (!bHaltBackgroundThread)\n\t{\n\t\tModio::RunPendingHandlers();\n        //Use one of the following if you intend to call ShutdownAsync in your program:\n        std::this_thread::yield();\n        //Change the sleep duration here as appropriate\n        std::this_thread::sleep_for(std::chrono::milliseconds(1));\n\t}\n});\n"})}),"\n",(0,i.jsxs)(n.admonition,{type:"note",children:[(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," takes a lock on the SDK's internal state in order to finalize the pending task queue and shut down internal services."]}),(0,i.jsxs)(n.p,{children:["If you call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#runpendinghandlers",children:"RunPendingHandlers"})," in a background thread, especially a dedicated background thread, and invoke ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," to close the SDK while your application continues to run, on certain platforms you may find the mutex/lock to be unfair to the point that the main thread cannot take the lock, because the background thread does not get suspended by the OS' scheduler often enough."]}),(0,i.jsxs)(n.p,{children:["If this occurs, we recommend you use either a ",(0,i.jsx)(n.code,{children:"yield"})," or high-resolution ",(0,i.jsx)(n.code,{children:"sleep"})," after each invocation of RunPendingHandlers to allow the main thread to take the shutdown lock. Alternatively, you can use some kind of signaling mechanism to pause the background thread calling RunPendingHandlers, call ShutdownAsync, and then allow that background thread to resume looping."]}),(0,i.jsxs)(n.p,{children:["If the SDK runs for the lifetime of your application and you do not call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#shutdownasync",children:"ShutdownAsync"})," this is not necessary."]})]}),"\n",(0,i.jsx)(n.h3,{id:"monetization",children:"Monetization"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 09_MonetizationWalletManagement (for initialization and wallet management) and 10_MonetizationPurchase (for purchase functionality)."})}),"\n",(0,i.jsxs)(n.p,{children:["The mod.io SDK supports all of the mod.io monetization features, allowing you sell a per-game virtual currency to your players that they can use to purchase mods, with a share of the revenue split between creators and your studio. Visit ",(0,i.jsx)(n.a,{href:"https://docs.mod.io/monetization/",children:"https://docs.mod.io/monetization/"})," for an overview of the mod.io monetization system."]}),"\n",(0,i.jsx)(n.p,{children:"Every platform requires specific setup for monetization features to work, with regards to the virtual currency configuration and API calls, however the following documentation is generically applicable, with only small differences per-platform that are documented within the platform-specific monetization documentation."}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["You can use our sandbox test environment at test.mod.io for testing monetization functionality, which allows for simulating real-world payments using dummy credit cards and credentials. When you initialize the SDK, use ",(0,i.jsx)(n.code,{children:"Modio::Environment::Test"})," as the environment parameter, along with your test.mod.io title's GameID and APIKey."]})}),"\n",(0,i.jsx)(n.h4,{id:"initialization",children:"Initialization"}),"\n",(0,i.jsx)(n.p,{children:"The mod.io monetization features are enabled as part of the onboarding process on your game profile. Once that is setup, there is nothing further you need to do for initialization in the SDK."}),"\n",(0,i.jsx)(n.p,{children:"Ensure that you have set the appropriate Portal when initializing the SDK for the portal you are using for purchasing - for instance, on Steam, you must initialize with Modio::Portal::Steam in order to redeem entitlements for Steam."}),"\n",(0,i.jsx)(n.h4,{id:"getting-the-users-wallet",children:"Getting the user's wallet"}),"\n",(0,i.jsxs)(n.p,{children:["On startup, you can make a call to ",(0,i.jsx)(n.code,{children:"<<GetUserWalletBalanceAsync>>"})," to get the balance of the current user's wallet. If no wallet exists for the user, one will be created for them automatically. This call returns the users wallet balance for the current game. On startup is the only time you need to make this call."]}),"\n",(0,i.jsxs)(n.p,{children:["We recommend that you cache the value of this result in your game code rather than making consistent calls to ",(0,i.jsx)(n.code,{children:"<<GetUserWalletBalanceAsync>>"})," and update your local state from the return values of other calls that affect wallet balance."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"\t\tModio::GetUserWalletBalanceAsync([](Modio::ErrorCode ec, Modio::Optional<uint64_t> WalletBalance) {\n\t\t\tif (!ec && WalletBalance.has_value())\n\t\t\t{\n\t\t\t\tGlobalState.WalletAmount = WalletBalance.value();\n\t\t\t}\n            else \n            {\n                // Error handling\n            }\n\t\t});\n"})}),"\n",(0,i.jsx)(n.h4,{id:"syncing-entitlements",children:"Syncing Entitlements"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 12_RefreshEntitlements.\nFor Steam, this functionality is demonstrated in advanced example 01_SteamAuthAndEntitlements.\nFor consoles, check the examples folder in the platform module."})}),"\n",(0,i.jsx)(n.p,{children:"If you are supporting the purchase of virtual currency packs on platform storefronts, entitlement refreshing is the method by which those virtual currency packs are consumed and converted into mod.io virtual currency credits for users to purchase UGC with."}),"\n",(0,i.jsx)(n.p,{children:"Each platform has a specific way of setting up entitlements for consumption, but generally speaking the way you consume those entitlements is the same. Read each platform's Marketplace documentation for how to configure entitlements and any platform-specific information for entitlement consumption."}),"\n",(0,i.jsxs)(n.p,{children:["You should always start by calling ",(0,i.jsx)(n.code,{children:"GetUserWalletBalanceAsync"})," to ensure that a user has a wallet created, or entitlements cannot be consumed. To consume entitlements, call ",(0,i.jsx)(n.code,{children:"RefreshUserEntitlementsAsync"})," as follows:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'const Modio::EntitlementParams EntitlementParams;\nModio::RefreshUserEntitlementsAsync(\n\tEntitlementParams,\n\t[&](Modio::ErrorCode ec, Modio::Optional<Modio::EntitlementConsumptionStatusList> Entitlements) {\n\t\tif (ec)\n\t\t{\n\t\t\tstd::cout << "Failed to refresh user entitlements: " << ec.message() << std::endl;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tif (Entitlements.has_value() && Entitlements->Size() > 0)\n\t\t\t{\n\t\t\t\tif (Entitlements->WalletBalance.has_value())\n\t\t\t\t{\n\t\t\t\t\tUserWalletBalance = Entitlements->WalletBalance->Balance;\n\n\t\t\t\t\tstd::cout << "Entitlements consumed: " << Entitlements->Size() << std::endl;\n\t\t\t\t\tstd::cout << "Updated UserWalletBalance is " << UserWalletBalance;\n\t\t\t\t}\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tstd::cout << "No entitlements synced; nothing further to do." << std::endl;\n\t\t\t}\n\t\t}\n\t});\n'})}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["The ",(0,i.jsx)(n.code,{children:"WalletBalance"})," returned in ",(0,i.jsx)(n.code,{children:"Modio::EntitlementConsumptionStatusList"})," will be 0 if no entitlements have been consumed. You should conditionally update your local state based on whether any entitlements have actually been consumed."]})}),"\n",(0,i.jsxs)(n.p,{children:["Generally speaking, you should do this on startup in case the user has made a purchase outside of the game, and after a user has made a purchase on a platform - most platforms will have some callback or indicator that this has occurred. Check that the ",(0,i.jsx)(n.code,{children:"Modio::Optional<Modio::EntitlementConsumptionStatusList>"})," is valid and its size is greater than 0."]}),"\n",(0,i.jsx)(n.h3,{id:"querying--purchasing-mods",children:"Querying & Purchasing Mods"}),"\n",(0,i.jsxs)(n.p,{children:["As part ",(0,i.jsx)(n.code,{children:"<<ListAllModsAsync>>"}),", you can include an additional filter for whether you list paid mods. By default, only free mods are shown, but you can set ",(0,i.jsx)(n.code,{children:"RevenueType"})," on the ",(0,i.jsx)(n.code,{children:"<<FilterParams>>"})," object passed to ",(0,i.jsx)(n.code,{children:"<<ListAllModsAsync>>"})," to include free and paid content, or just paid content. All mods returned will have a ",(0,i.jsx)(n.code,{children:"Price"})," property, indicating the virtual currency price that must be paid in order to purchase."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::ListAllModsAsync(Modio::FilterParams().RevenueType(Modio::FilterParams::RevenueFilterType::FreeAndPaid), [](Modio::ErrorCode ec, Modio::Optional<Modio::ModInfoList> Results)\n{\n    if (ec)\n    {\n        // Error handling\n    }\n    else\n    {\n        for (Modio::ModInfo& CurrentModProfile : *Results)\n        {\n            std::cout << CurrentModProfile.Price;\n        }\n    }\n});\n"})}),"\n",(0,i.jsx)(n.h4,{id:"purchasing-mods",children:"Purchasing Mods"}),"\n",(0,i.jsxs)(n.p,{children:["You can call ",(0,i.jsx)(n.code,{children:"<<PurchaseModAsync>>"})," to purchase a given mod. PurchaseModAsync takes two parameters = the ModID of the mod to purchase, and the ExpectedPrice, which is the price displayed to the user from ",(0,i.jsx)(n.code,{children:"<<ListAllModsAsync>>"}),". You must include this parameter for safety, so the user is not charged more or less than the price displayed to them in case the price of the mod has changed between the call to ListAllModsAsync and purchase time.\nOnce a mod is purchased, it is automatically subscribed to for the user."]}),"\n",(0,i.jsxs)(n.p,{children:["You should validate that the user has enough virtual currency to make the purchase by comparing it to the balance you received from ",(0,i.jsx)(n.code,{children:"GetUserWalletBalanceAsync"}),". Note this is purely for user experience (ie for graying out the purchase button in the UI, or upselling the user a virtual currenct pack), and ",(0,i.jsx)(n.code,{children:"PurchaseModAsync"})," will return an error if the user does not have enough in their wallet."]}),"\n",(0,i.jsxs)(n.p,{children:["The updated wallet balance after the purchase amount is subtracted is returned in the callback of ",(0,i.jsx)(n.code,{children:"<<PurchaseModAsync>>"}),"."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::PurchaseModAsync(ModId, ModPrice, [](Modio::ErrorCode ec, Modio::Optional<Modio::TransactionRecord> Transaction) {\n    if (ec)\n    {\n        // Error handling\n    }\n    else\n    {\n        if (Transaction.has_value())\n        {\n            GlobalState.WalletAmount =\n                Transaction.value().UpdatedUserWalletBalance;\n        }\n    }\n});\n"})}),"\n",(0,i.jsx)(n.h4,{id:"showing-user-purchases",children:"Showing user purchases"}),"\n",(0,i.jsxs)(n.p,{children:["Even though all purchased mods are automatically subscribed, the user can still unsubscribe from them and uninstall them; however, they still remain owned and purchased by the user. They must re-subscribe to the mod in order to have it installed. This is facilitated by ",(0,i.jsx)(n.code,{children:"<<FetchUserPurchasesAsync>>"}),", which will fetch a list of a users purchased mods. After a successful call, you can then display them with ",(0,i.jsx)(n.code,{children:"<<QueryUserPurchases>>"}),", allowing re-subscription if necessary."]}),"\n",(0,i.jsx)(n.h4,{id:"getting-a-user-delegation-token",children:"Getting a User Delegation Token"}),"\n",(0,i.jsxs)(n.p,{children:["User Delegation Tokens can be used by a backend server for S2S (Server to Server) transactions/functionality. You can get one for the current user by calling ",(0,i.jsx)(n.code,{children:"<<GetUserDelegationToken>>"}),", the callback for which contains the Token as a ",(0,i.jsx)(n.code,{children:"std::string"}),"."]}),"\n",(0,i.jsx)(n.h3,{id:"metrics-play-sessions",children:"Metrics Play Sessions"}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"This functionality is demonstrated in example 13_MetricsSession."})}),"\n",(0,i.jsxs)(n.p,{children:["The mod.io SDK supports all of the mod.io metrics features, allowing you to start a metrics play sesion, keeping that session alive via a heartbeat (automatically called, or manually handled) and then ending that session. Metric sessions allow you to track which mods your players interact with most frequently. Visit ",(0,i.jsx)(n.a,{href:"https://docs.mod.io/metrics/",children:"https://docs.mod.io/metrics/"})," for an overview of the mod.io metrics system."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsxs)(n.p,{children:["Running metrics play sessions is a premium feature. If you are interested in mod.io premium features, please contact ",(0,i.jsx)(n.a,{href:"mailto:developers@mod.io",children:"developers@mod.io"}),"."]})}),"\n",(0,i.jsx)(n.p,{children:"Metrics based on the platform and portal, are transparently taken care of with no additional consideration needed when using the SDK."}),"\n",(0,i.jsx)(n.h4,{id:"initialization-1",children:"Initialization"}),"\n",(0,i.jsxs)(n.p,{children:["The mod.io metrics features are enabled as part of generating a Metrics Secret Key your API settings in your game dashboard, e.g. ",(0,i.jsx)(n.a,{href:"https://mod.io/g/game-name/admin/api-key",children:"https://mod.io/g/game-name/admin/api-key"}),". Once this key has been generated, you need to pass it in as an ExtendedParameters field in your InitializeOptions when Initializing the mod.io SDK, e.g.:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:'Modio::InitializeOptions initializeOptions;\ninitializeOptions.ExtendedParameters["MetricsSecretKey"] = "00000000-1111-2222-3333-444444444444";\n'})}),"\n",(0,i.jsx)(n.p,{children:"Failing to set up the Metrics Secret Key will result in a `Modio::MetricsError::SessionNotInitialized`` error being returned when using the metrics functionality."}),"\n",(0,i.jsx)(n.h4,{id:"starting-a-metrics-session",children:"Starting a Metrics Session"}),"\n",(0,i.jsxs)(n.p,{children:["You can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#metricssessionstartasync",children:"MetricsSessionStartAsync"})," to start a new session tracking the usage of mods in the context of your game. You'll notice that ",(0,i.jsx)(n.code,{children:"MetricsSessionStartAsync"})," takes a ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#metricssessionparams",children:"MetricsSessionParams"})," object as its parameter. This contains an optional Session Id, as well as a required vector of mods to track."]}),"\n",(0,i.jsx)(n.admonition,{type:"note",children:(0,i.jsx)(n.p,{children:"If a Session Id is not provided, a random one will be created for you."})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::MetricsSessionParams Params = Modio::MetricsSessionParams {{}, ModIds};\n\nModio::MetricsSessionStartAsync(Params, [](Modio::ErrorCode ec) {\n{\n\tif (ec)\n\t{\n\t\t// Error has occurred while attempting to start a session\n\t}\n\telse\n\t{\n\t\t// Session started successfully\n\t}\n});\n"})}),"\n",(0,i.jsxs)(n.p,{children:["The Metrics Session Params accepts an optional Session Id in the form of a ",(0,i.jsx)(n.code,{children:"Modio::Guid"})," which you may want to use to associate the new session with any supplementary telemetry you are gathering in your game."]}),"\n",(0,i.jsx)(n.h4,{id:"metrics-heartbeat",children:"Metrics heartbeat"}),"\n",(0,i.jsx)(n.p,{children:"To ensure that the session is kept alive, a heartbeat is required to be submitted at most every 5 minutes. We recommend doing this a bit earlier than the threshold to ensure you do not miss the window."}),"\n",(0,i.jsxs)(n.p,{children:["There are two methods provided to control the behaviour of the heart beat, ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#metricssessionsendheartbeatonceasync",children:"MetricsSessionSendHeartbeatOnceAsync"})," which you can call at your desired precision, as well as a single call and forget ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#metricssessionsendheartbeatintervalasync",children:"MetricsSessionSendHeartbeatAtIntervalAsync"})," with a desired interval."]}),"\n",(0,i.jsxs)(n.p,{children:["Calling ",(0,i.jsx)(n.code,{children:"MetricsSessionSendHeartbeatOnceAsync"})," will submit a single heartbeat, and return an error code if something went wrong. If no error has occured, the heartbeat has been successfully sent."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::MetricsSessionSendHeartbeatOnceAsync([](Modio::ErrorCode ec) \n{\n\tif (ec)\n\t{\n\t\t// Error has occurred while submitting a heartbeat\n\t}\n\telse\n\t{\n\t\t// Heartbeat successfully sent\n\t}\n});\n"})}),"\n",(0,i.jsxs)(n.p,{children:["Calling ",(0,i.jsx)(n.code,{children:"MetricsSessionSendHeartbeatAtIntervalAsync"})," requires a parameter with the desired interval frequency in seconds. An error code will be returned if something went wrong, otherwise you will receive a false-y error if the interval loop has been shut down successfully (such as ending a session)."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"uint32_t IntervalSeconds = 150;\nModio::MetricsSessionSendHeartbeatAtIntervalAsync(IntervalSeconds, [](Modio::ErrorCode ec) \n{\n\tif (ec)\n\t{\n\t\t// Error has occurred while submitting a heartbeat\n\t}\n\telse\n\t{\n\t\t// Heartbeat interval loop has been shut down successfully\n\t}\n});\n"})}),"\n",(0,i.jsx)(n.h4,{id:"ending-a-metrics-session",children:"Ending a Metrics Session"}),"\n",(0,i.jsxs)(n.p,{children:["To complete a session, for example when finishing a match, or quitting out of your game, you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#metricssessionendasync",children:"MetricsSessionEndAsync"}),".\nAs with the other calls, you will receive an error if anything has gone wrong, otherwise the operation successfully completed."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::MetricsSessionEndAsync([](Modio::ErrorCode ec) \n{\n\tif (ec)\n\t{\n\t\t// Error has occurred while attempting to end a session\n\t}\n\telse\n\t{\n\t\t// Metrics session successfully completed\n\t}\n});\n"})}),"\n",(0,i.jsx)(n.h3,{id:"error-handling-1",children:"Error Handling"}),"\n",(0,i.jsxs)(n.p,{children:["The majority of mod.io SDK functions return a ",(0,i.jsx)(n.code,{children:"Modio::ErrorCode"}),". In particular, asynchronous callbacks execute with a ",(0,i.jsx)(n.code,{children:"Modio::ErrorCode"})," as the first parameter."]}),"\n",(0,i.jsx)(n.h4,{id:"checking-for-errors",children:"Checking for errors"}),"\n",(0,i.jsxs)(n.p,{children:["You can check if a ",(0,i.jsx)(n.code,{children:"Modio::ErrorCode"})," represents a success or failure by checking its 'truthyness'. If an ErrorCode evaluates to true, the function failed."]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::ErrorCode ec;\nif (ec)\n{\n    // Error code was truthy, therefore an error occurred.\n}\nelse\n{\n    // Error code was false-y, therefore the operation succeeded\n}\n"})}),"\n",(0,i.jsx)(n.h5,{id:"handling-failures",children:"Handling Failures"}),"\n",(0,i.jsxs)(n.p,{children:["Sometimes an entitlement may fail to be consumed. To verify this, you should check if ",(0,i.jsx)(n.code,{children:"Modio::Optional<Modio::EntitlementConsumptionStatusList>::EntitlementsThatRequireRetry()"})," has a value. If so, you can retry the call to RefreshUserEntitlementsAsync. If the failure persists, you should show an error, indicating that the customer contact mod.io support."]}),"\n",(0,i.jsx)(n.h4,{id:"inspecting-errorcodes-more-deeply",children:"Inspecting ErrorCodes more deeply"}),"\n",(0,i.jsx)(n.p,{children:"Sometimes, this information will be all that is required, just a simple 'success/fail' that you can handle."}),"\n",(0,i.jsx)(n.p,{children:"In many cases, however, you will want to perform some degree of inspection on an ErrorCode to determine specific information about that error. If nothing else you can display a reason for the failure to the end user."}),"\n",(0,i.jsx)(n.h5,{id:"direct-queries",children:"Direct Queries"}),"\n",(0,i.jsx)(n.p,{children:"It's possible to query the raw value of an ErrorCode by comparing it against a particular enum value. For example, to check if a particular ErrorCode represents a filesystem error of 'Not enough space', you could do the following:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"if (ec == Modio::FilesystemError::InsufficientSpace)\n{\n    // Handle insufficient space by possibly deleting some files.\n}\nelse\n{\n    // Other error handling here\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"Of course, this means you can chain such checks together:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"if (ec == Modio::FilesystemError::InsufficientSpace)\n{\n    // Handle insufficient space by possibly deleting some files.\n}\nelse if (ec == Modio::FilesystemError::NoPermission)\n{\n    // Handle permissions error by asking the user to re-run as admin, or prompt for priviledge elevation.\n}\nelse\n{\n    // Other error handling here\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"This isn't ideal though, for several reasons:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"It's considerably verbose"}),"\n",(0,i.jsx)(n.li,{children:"It doesn't check for semantic equivalency, only literal equivalency. In other words, some other error that derives from similar issues would return false because the codes don't match"}),"\n",(0,i.jsx)(n.li,{children:"It requires you to handle each case regardless of whether you need to or not"}),"\n",(0,i.jsx)(n.li,{children:"It scales poorly if there are several error codes with equivalent semantics in this context."}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"We can address these by using 'semantic queries' against the error code rather than directly comparing numerical values."}),"\n",(0,i.jsx)(n.h5,{id:"semantic-queries",children:"Semantic Queries"}),"\n",(0,i.jsx)(n.p,{children:"The SDK provides a function with several overloads that you can use to query for the semantic meaning of an ErrorCode."}),"\n",(0,i.jsx)(n.p,{children:"Firstly, you can query if an ErrorCode is equivalent to a specific raw enum value:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::ErrorCode ec;\nif (Modio::ErrorCodeMatches(ec, Modio::HttpError::CannotOpenConnection))\n{\n    // We couldn't connect to the mod.io server\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"This can be chained together like the literal value comparison mentioned earlier:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::ErrorCode ec;\nif (Modio::ErrorCodeMatches(ec, Modio::HttpError::CannotOpenConnection))\n{\n    // We couldn't connect to the mod.io server\n}\nelse if (Modio::ErrorCodeMatches(ec, Modio::HttpError::ServerClosedConnection))\n{\n    // Server unexpectedly closed the connection\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"However, this still requires knowledge of the different types of HTTP errors. In your application you probably don't need to handle them differently. The semantics of networking errors are largely 'try the function again later'."}),"\n",(0,i.jsxs)(n.p,{children:["This is where the second overload of ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#ErrorCodeMatches",children:"ErrorCodeMatches"})," comes in. It allows you to query if the error satisfies a particular condition, such as 'does this code represent some kind of networking error':"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::ErrorCode ec;\nif (Modio::ErrorCodeMatches(ec, Modio::ErrorConditionTypes::NetworkError))\n{\n    // Error code represents some kind of network error\n}\nelse\n{\n    // Error code is not a network error\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"By querying if the error meets a specific condition, you can focus on handling a family of errors (in this case, network transmission errors) without needing to deal with individual errors within that group. No more manually checking against individual HttpError values, just a single query."}),"\n",(0,i.jsx)(n.p,{children:"As a second example, when you ask the SDK to retrieve information about a specific mod, that ModID might be invalid or deleted. Both of these result in an error, which you could handle like the following:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"// Inside a Modio::GetModInfoAsync callback\nif (Modio::ErrorCodeMatches(ec, Modio::ApiError::RequestedModNotFound))\n{\n    // The ModID wasn't valid, we couldn't find it\n}\nelse if (Modio::ErrorCodeMatches(ec, Modio::ApiError::RequestedModDeleted))\n{\n    // The ModID used to be valid, but the mod was deleted\n}\nelse\n{\n    // Some other error...\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"However, you may not care about the reasons the mod couldn't be retrieved, just that the mod information did not return a valid object."}),"\n",(0,i.jsxs)(n.p,{children:["In this case, you can query if the error code matches the ",(0,i.jsx)(n.code,{children:"EntityNotFoundError"})," condition:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"// In Modio::GetModInfoAsync callback\nif (Modio::ErrorCodeMatches(ec, Modio::ErrorConditionTypes::EntityNotFoundError))\n{\n    // The mod couldn't be found. Handle appropriately.\n}\n"})}),"\n",(0,i.jsx)(n.p,{children:"By grouping these codes into semantic checks, it helps you to potentially consolidate your error handling into a more limited set of generic error handlers rather than needing to deal with each potential outcome individually."}),"\n",(0,i.jsx)(n.h4,{id:"putting-it-all-together",children:"Putting it all together"}),"\n",(0,i.jsx)(n.p,{children:"By combining queries of categories with queries of specific values, you can handle general families of errors at a single location with special-case clauses for a particular error as necessary:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-cpp",children:"Modio::GetModInfoAsync(ModID, [](Modio::ErrorCode ec, Modio::Optional<Modio::ModInfo> Info)\n{\n    if (ec)\n    {\n        if (Modio::ErrorCodeMatches(ec, Modio::ErrorConditionTypes::NetworkError)) // NetworkError group\n        {\n            // Error code represents some network error kind. Possibly ask the user to try again later.\n        }\n        else if (Modio::ErrorCodeMatches(ec, Modio::ErrorConditionTypes::EntityNotFoundError)) // Entity Not Found group\n        {\n            // An mod entity is not located with this configuration. Therefore, the list you're fetching the ModID from is probably stale. A remedy could be to fetch an updated version of the list from the server.\n        }\n        else if (Modio::ErrorCodeMatches(ec, Modio::GenericError::SDKNotInitialized)) // SDK not initialized group\n        {\n            // Your application is trying to call SDK functions without initializing the SDK first\n        }\n    }\n});\n\n"})}),"\n",(0,i.jsx)(n.h4,{id:"parameter-validation-errors",children:"Parameter Validation Errors"}),"\n",(0,i.jsxs)(n.p,{children:["Some of the SDK functions may return errors that indicate a parameter or data validation failure. For these cases, the SDK parses the error response from the mod.io API and stores the information about which parameters failed validation until the next network request executes. If an SDK function returns an error which matches ",(0,i.jsx)(n.code,{children:"Modio::ErrorConditionTypes::InvalidArgsError"}),", you can call ",(0,i.jsx)(n.a,{href:"/cppsdk/refdocs#getlastvalidationerror",children:"GetLastValidationError"})," in your callback to retrieve those errors and display appropriate feedback to the end-user."]}),"\n",(0,i.jsx)(n.hr,{})]})}function h(e={}){const{wrapper:n}={...(0,o.R)(),...e.components};return n?(0,i.jsx)(n,{...e,children:(0,i.jsx)(c,{...e})}):c(e)}},8453:(e,n,t)=>{t.d(n,{R:()=>r,x:()=>a});var i=t(6540);const o={},s=i.createContext(o);function r(e){const n=i.useContext(s);return i.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function a(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:r(e.components),i.createElement(s.Provider,{value:n},e.children)}}}]);