"use strict";(self.webpackChunkmodio_docs=self.webpackChunkmodio_docs||[]).push([[5936],{6492:(e,n,i)=>{i.r(n),i.d(n,{assets:()=>a,contentTitle:()=>d,default:()=>h,frontMatter:()=>r,metadata:()=>s,toc:()=>c});var t=i(4848),o=i(8453);const r={id:"android-getting-started",title:"Getting Started",slug:"/cppsdk/android/getting-started",sidebar_position:1,custom_edit_url:"https://github.com/modio/modio-sdk-internal/blob/develop/platform/android/doc/getting-started.mdx"},d=void 0,s={id:"game-integration/cppsdk/android/android-getting-started",title:"Getting Started",description:"Android SDK/NDK Versions",source:"@site/public/en-us/game-integration/cppsdk/android/getting-started.mdx",sourceDirName:"game-integration/cppsdk/android",slug:"/cppsdk/android/getting-started",permalink:"/cppsdk/android/getting-started",draft:!1,unlisted:!1,editUrl:"https://github.com/modio/modio-sdk-internal/blob/develop/platform/android/doc/getting-started.mdx",tags:[],version:"current",sidebarPosition:1,frontMatter:{id:"android-getting-started",title:"Getting Started",slug:"/cppsdk/android/getting-started",sidebar_position:1,custom_edit_url:"https://github.com/modio/modio-sdk-internal/blob/develop/platform/android/doc/getting-started.mdx"},sidebar:"sidebar",previous:{title:"CMake Integration",permalink:"/cppsdk/ios/cmake-integration"},next:{title:"CMake Integration",permalink:"/cppsdk/android/cmake-integration/"}},a={},c=[{value:"Android SDK/NDK Versions",id:"android-sdkndk-versions",level:2},{value:"Compiling for Android",id:"compiling-for-android",level:2},{value:"Initializing the Android SDK",id:"initializing-the-android-sdk",level:2},{value:"Authentication",id:"authentication",level:3},{value:"Sever Auth Code",id:"sever-auth-code",level:4},{value:"ID Token",id:"id-token",level:4}];function l(e){const n={a:"a",code:"code",h2:"h2",h3:"h3",h4:"h4",li:"li",ol:"ol",p:"p",pre:"pre",...(0,o.R)(),...e.components};return(0,t.jsxs)(t.Fragment,{children:[(0,t.jsx)(n.h2,{id:"android-sdkndk-versions",children:"Android SDK/NDK Versions"}),"\n",(0,t.jsx)(n.p,{children:"The mod.io Android SDK is built against NDK version NDK r23c, shipped with Visual Studio 2022's Android workload and supports the arm64-v8a ABI."}),"\n",(0,t.jsx)(n.h2,{id:"compiling-for-android",children:"Compiling for Android"}),"\n",(0,t.jsx)(n.p,{children:"Currently, the mod.io SDK can only be used from native Android applications being built with CMake on Windows. There is no support for the AGDE for Visual Studio. mod.io SDK method calls are not available from Java.  You can follow the CMake Integration documentation for how to configure your native CMake project to use the SDK."}),"\n",(0,t.jsx)(n.h2,{id:"initializing-the-android-sdk",children:"Initializing the Android SDK"}),"\n",(0,t.jsxs)(n.p,{children:["Prior to initializing the mod.io SDK via ",(0,t.jsx)(n.code,{children:"Modio::InitializeAsync"}),", you have to pass a few initialization parameters to the SDK for Android specific support."]}),"\n",(0,t.jsxs)(n.ol,{children:["\n",(0,t.jsxs)(n.li,{children:["\n",(0,t.jsxs)(n.p,{children:["Pass mod.io the JNI VM and an optional reference to the global ClassLoader using ",(0,t.jsx)(n.code,{children:"Modio::InitializeAndroidJNI(vm, nullptr);"}),". Generally you should do this in your ",(0,t.jsx)(n.code,{children:"JNI_OnLoad"})," method. If you don't provide a reference to the native classloader, the SDK will attempt to discover and create one itself."]}),"\n"]}),"\n",(0,t.jsxs)(n.li,{children:["\n",(0,t.jsxs)(n.p,{children:["Pass mod.io a reference to your native main Activity using ",(0,t.jsx)(n.code,{children:"Modio::SetGlobalActivity(JavaObject);"}),". You can do this either in a native event from Java, or anytime in your startup process if you have a reference to the native activity cached."]}),"\n"]}),"\n",(0,t.jsxs)(n.li,{children:["\n",(0,t.jsxs)(n.p,{children:["Call ",(0,t.jsx)(n.code,{children:"Modio::InitializeAndroid();"})," for mod.io to initialize and setup its JNI bindings."]}),"\n"]}),"\n"]}),"\n",(0,t.jsx)(n.h3,{id:"authentication",children:"Authentication"}),"\n",(0,t.jsx)(n.p,{children:"There are two ways that you can perform Google SSO, either via a server-side auth code which the mod.io service will exchange for an ID Token, or directly using an ID token."}),"\n",(0,t.jsx)(n.h4,{id:"sever-auth-code",children:"Sever Auth Code"}),"\n",(0,t.jsx)(n.p,{children:"Obtain a Server Auth Code from Google Play Games Services (v1 only) or the Google Sign-In Client library, ensuring you request Email access and the Profile scope."}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-java",children:"GoogleSignInOptions signInOptions = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN)\n                .requestScopes(new Scope(Scopes.PROFILE))\n                .requestEmail()\n                .requestServerAuthCode(OAUTH_CLIENT_ID)\n                .build();\n"})}),"\n",(0,t.jsx)(n.p,{children:"You can then show the Google Sign-In Intent to prompt users to consent to the OAuth scopes you are requesting, and obtain the server auth code in the callback."}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-java",children:"    SignInClient = GoogleSignIn.getClient(this, signInOptions);\n    startActivityForResult(SignInClient.getSignInIntent(), RC_SIGN_IN);\n\n    @Override\n    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {\n        if (requestCode == RC_SIGN_IN) {\n            Task<GoogleSignInAccount> task = GoogleSignIn.getSignedInAccountFromIntent(intent);\n\n            try {\n                GoogleSignInAccount account = task.getResult(ApiException.class);\n                serverSideAuthCode = account.getServerAuthCode();\n            }\n        }\n    }\n"})}),"\n",(0,t.jsxs)(n.p,{children:["Once you receive the Server Auth Code, you can authenticate using ",(0,t.jsx)(n.code,{children:"Modio::AuthenticateUserExternalAsync"}),", passing ",(0,t.jsx)(n.code,{children:"Modio::AuthenticationProvider::GoogleServerSideToken"})," as the authentication provider. This indicates to mod.io that this is a server side token that should be exchanged for an ID Token by the backend."]}),"\n",(0,t.jsx)(n.p,{children:"Ensure that you have configured your OAuth client ID and secret on your games authentication providers page."}),"\n",(0,t.jsxs)(n.p,{children:["You can read more about Google Play Services sign-in at ",(0,t.jsx)(n.a,{href:"https://developers.google.com/games/services/common/concepts/v1/sign-in",children:"https://developers.google.com/games/services/common/concepts/v1/sign-in"})]}),"\n",(0,t.jsx)(n.h4,{id:"id-token",children:"ID Token"}),"\n",(0,t.jsx)(n.p,{children:"You can also directly request an ID Token using Google Credential Manager, and use this to authenticate."}),"\n",(0,t.jsxs)(n.p,{children:["Once you receive the ID Token, you can authenticate using ",(0,t.jsx)(n.code,{children:"Modio::AuthenticateUserExternalAsync"}),", passing ",(0,t.jsx)(n.code,{children:"Modio::AuthenticationProvider::GoogleIDToken"})," as the authentication provider. This indicates to mod.io that this is is an ID token that can be directly used."]})]})}function h(e={}){const{wrapper:n}={...(0,o.R)(),...e.components};return n?(0,t.jsx)(n,{...e,children:(0,t.jsx)(l,{...e})}):l(e)}},8453:(e,n,i)=>{i.d(n,{R:()=>d,x:()=>s});var t=i(6540);const o={},r=t.createContext(o);function d(e){const n=t.useContext(r);return t.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function s(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:d(e.components),t.createElement(r.Provider,{value:n},e.children)}}}]);