# JotBot - AI-powered code documentation

[![Go Reference](https://pkg.go.dev/badge/github.com/modernice/jotbot.svg)](https://pkg.go.dev/github.com/modernice/jotbot)
[![Test](https://github.com/modernice/jotbot/actions/workflows/test.yml/badge.svg)](https://github.com/modernice/jotbot/actions/workflows/test.yml)
[![jotbot-ts](https://github.com/modernice/jotbot/actions/workflows/jotbot-ts.yml/badge.svg)](https://github.com/modernice/jotbot/actions/workflows/jotbot-ts.yml)

`JotBot` seamlessly auto-generates code documentation for your Go and TypeScript
projects, bridging the gap between comprehensive code and insightful documentation.

~~The documentation of this repository was entirely generated by JotBot using
`gpt-4` but currently (2023/07/18) I get the best results using `gpt-3.5-turbo`.~~

~~OpenAI's `gpt-3.5` and `gpt-4` models demonstrate fluctuations in quality over time.
Determining which model excels at any given instance can be challenging, but `gpt-4` often yields more consistent results.~~

~~For general applications, I recommend using `gpt-3.5-turbo-16k` as a default,
and temporarliy switching to `gpt-4` in scenarios where `gpt-3.5` might fall
short.~~

`gpt-4-1106-preview` is the best model for generating documentation so far.
The default model of JotBot is `gpt-3.5-turbo` which is gives the best value
for money.

You can find generated TypeScript documentation in [packages/jotbot](./packages/jotbot).

## Quick Start

### Install

```
go install github.com/modernice/jotbot/cmd/jotbot@latest
```

#### Add TypeScript Support

```
npm i -g jotbot-ts@latest
pnpm i -g jotbot-ts@latest
```

### Use

Within your Go and/or TypeScript codebase, run:

```
jotbot generate --key OPENAI_API_KEY
```

---

## Features

- Generate documentation for Go and TypeScript codebases
- Customize glob patterns for included and excluded files
- Filter code symbols by matching regular expressions
- Limit the number of files to generate documentation for
- Run in dry mode to preview changes without applying them
- Control the AI model and token limits used for generating documentation
- Optionally commit changes to a Git branch

## Models

JotBot utilizes OpenAI's GPT models to generate documentation. By default,
JotBot uses the `gpt-3.5-turbo` model which provides good results at
a cost-effective rate. ~~However, the best results are produced by `gpt-4` and
`text-davinci-003`, which are 10-30x more expensive than `gpt-3.5-turbo`.~~

You are free to choose any model from the [OpenAI Docs](https://platform.openai.com/docs/models)
and pass it via the `--model|-m` flag:

```
jotbot generate -m text-davinci-003
```

## Installation

### Via `go install`

If you have Go installed, you can simply install JotBot using `go install`:

```
go install github.com/modernice/jotbot/cmd/jotbot@latest
```

### Standalone Binary

You can download the latest binary from the
[Releases](https://github.com/modernice/jotbot/releases/latest) page.

### TypeScript Support

To enable TypeScript (and JavaScript) support, you also need to install the
`jotbot-ts` npm package.

```
npm install -g jotbot-ts
pnpm install -g jotbot-ts
```

## Usage

To generate missing documentation for your codebase, run the following command:

```
jotbot generate [options]
```

By default, this command will find all Go and TypeScript (and JavaScript) files
in the current and nested directories and generate documentation for them.
Excluded from the search are by default:

- `**/.*/**`
- `**/dist/**`
- `**/node_modules/**`
- `**/vendor/**`
- `**/testdata/**`
- `**/test/**`
- `**/tests/**`
- `**/*.pb.go`


### To-Do

- [ ] Configurable OpenAI settings (temperature, top_p etc.)
- [ ] _Any ideas?_ [open an issue](//github.com/modernice/jotbot/issues) or [start a discussion](//github.com/modernice/jotbot/discussions)

## CLI options

```
jotbot --help
```

| Option                 | Description                                                             | Default        |
|------------------------|-------------------------------------------------------------------------|----------------|
| `--root`               | Root directory of the repository                                        | `"."`          |
| `--include, -i`       | Glob pattern(s) to include files                                        |                |
| `--include-tests, -T` | Include TestXXX() functions (Go-specific)                               |                |
| `--exclude, -e`       | Glob pattern(s) to exclude files                                        |                |
| `--exclude-internal, -E` | Exclude 'internal' directories (Go-specific)                          | `true`         |
| `--match`             | Regular expression(s) to match identifiers                              |                |
| `--symbol, -s`        | Symbol(s) to search for in code (TS/JS-specific)                        |                |
| `--clear, -c`         | Force-clear comments in generation prompt (Go-specific)                 |                |
| `--branch`             | Branch name to commit changes to (leave empty to not commit)            |                |
| `--limit`              | Limit the number of files to generate documentation for                 | `0`            |
| `--dry`                | Print the changes without applying them                                 | `false`        |
| `--model, -m`          | OpenAI model used to generate documentation                             | `"gpt-3.5-turbo"` |
| `--maxTokens`          | Maximum number of tokens to generate for a single documentation         | `512`          |
| `--parallel, -p`      | Number of files to handle concurrently                                  | `4`            |
| `--workers`            | Number of workers to use per file                                       | `2`            |
| `--override, -o`      | Override existing documentation (Go-specific)                            |                |
| `--key`                | OpenAI API key                                                          |                |
| `--verbose, -v`       | Enable verbose logging                                                  | `false`        |

## Screenshots

![JotBot](./.github/screenshot-go.png)
![JotBot](./.github/screenshot-ts.png)

## License

[MIT](./LICENSE)
