﻿# Moca.NET Template Extension for Visual Studio

![Visual Studio Marketplace Version](https://img.shields.io/visual-studio-marketplace/v/MiYABiS.MocaNETTemplate30.svg)
[![license](https://img.shields.io/badge/License-MS--PL-blue.svg)](https://opensource.org/licenses/MS-PL)

## Overview

Moca.NET framework Templates.

### Project Templates (Only supports VB.NET code)

* Moca.NET Windows Forms application 
* Moca.NET Web application 

### Item Template (supports VB.NET and C# code)

**for Moca.NET**

* Dao class template 
* Entity Wizard 
* Web User Control template 
* Web Form template 
* Web Master Page template 
* Web Session interface template 
* Web Cookie interface template 
* Web API Controller template 
* IMethodInterceptor implements class template 
* SQL statements Interceptor implements class template 

**for Selenium**

* Selenium Test Class
* Selenium Test Page Class
* Selenium Test PageObject Class Wizard


## How to get

vs2012 or later : [Moca.NET Template 3.0](https://marketplace.visualstudio.com/items?itemName=MiYABiS.MocaNETTemplate30)  
vs2010 : [Moca.NET Templates 2010](https://marketplace.visualstudio.com/items?itemName=MiYABiS.MocaNETTemplates2010)


## Entity Wizard 

It's the wizard into which a used entity class is formed from a SQL statement to use Moca.NET.

![EntityCodeWizard-00](Images/EntityCodeWizard-00.png)  
![EntityCodeWizard-01](Images/EntityCodeWizard-01.png)

```vb
'------------------------------------------------------------------------------
' <auto-generated>
'     このコードはツールによって生成されました。
'     ランタイム バージョン:4.0.30319.42000
'
'     このファイルへの変更は、以下の状況下で不正な動作の原因になったり、
'     コードが再生成されるときに損失したりします。
' </auto-generated>
'------------------------------------------------------------------------------

Option Strict Off
Option Explicit On

Imports Moca.Db
Imports Moca.Db.Attr
Imports Moca.Win
Imports System.ComponentModel
Imports System.Runtime.CompilerServices

Namespace Models
    
    ''' <summary> 
    ''' EntityClass1 Entity 
    ''' </summary> 
    ''' <remarks></remarks> 
    ''' <history> 
    ''' </history> 
    Public Class EntityClass1
        Implements System.ComponentModel.INotifyPropertyChanged
        
        #Region " Declare "
        Shared _def As IEntityClass1Definition
        
        Private _id As Integer
        
        Private _name As String
        
        Private _note As String
        #End Region
        
        #Region " Property "
        ''' <summary> 
        ''' Id (Id) Property. 
        ''' </summary> 
        <Column("Id"),  _
         PropertyOrder(1)>  _
        Public Property Id() As Integer
            Get
                Return Me._id
            End Get
            Set
                Me._id = value
                OnPropertyChanged()
            End Set
        End Property
        
        ''' <summary> 
        ''' Name (Name) Property. 
        ''' </summary> 
        <Column("Name"),  _
         PropertyOrder(2)>  _
        Public Property Name() As String
            Get
                Return Me._name
            End Get
            Set
                Me._name = value
                OnPropertyChanged()
            End Set
        End Property
        
        ''' <summary> 
        ''' Note (Note) Property. 
        ''' </summary> 
        <Column("Note"),  _
         PropertyOrder(3)>  _
        Public Property Note() As String
            Get
                Return Me._note
            End Get
            Set
                Me._note = value
                OnPropertyChanged()
            End Set
        End Property
        #End Region
        
        #Region " PropertyChanged "
        Public Event PropertyChanged As System.ComponentModel.PropertyChangedEventHandler Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged
        
        Protected Overridable Sub OnPropertyChanged(<CallerMemberName()> ByVal optional name As String = Nothing)
            RaiseEvent PropertyChanged(Me, New System.ComponentModel.PropertyChangedEventArgs(name))
        End Sub
        #End Region
    End Class
    
    #Region " Definition "
    ''' <summary> 
    ''' EntityClass1 Entity definition 
    ''' </summary> 
    ''' <remarks></remarks> 
    ''' <history> 
    ''' </history> 
    <Table(Sys.ConnectionStringName, "trnTable")>  _
    Public Interface IEntityClass1Definition
        
        ''' <summary> 
        ''' Table (Table) Property. 
        ''' </summary> 
        Property Table() As Moca.Db.DbInfoTable
        
        ''' <summary> 
        ''' Id (Id) Property. 
        ''' </summary> 
        <Column("Id")>  _
        Property Id() As Moca.Db.DbInfoColumn
        
        ''' <summary> 
        ''' Name (Name) Property. 
        ''' </summary> 
        <Column("Name")>  _
        Property Name() As Moca.Db.DbInfoColumn
        
        ''' <summary> 
        ''' Note (Note) Property. 
        ''' </summary> 
        <Column("Note")>  _
        Property Note() As Moca.Db.DbInfoColumn
    End Interface
    #End Region
End Namespace
```


## Selenium Test PageObject Class Wizard

Wizards which makes a PageObject class of selenium from a Web page.

![PageObjectWizard](Images/SeleniumPageObjectWizard.png)

```vb
'------------------------------------------------------------------------------
' <auto-generated>
'     このコードはツールによって生成されました。
'     ランタイム バージョン:4.0.30319.42000
'
'     このファイルへの変更は、以下の状況下で不正な動作の原因になったり、
'     コードが再生成されるときに損失したりします。
' </auto-generated>
'------------------------------------------------------------------------------

Option Strict Off
Option Explicit On

Imports MiYABiS.SeleniumTestAssist
Imports OpenQA.Selenium
Imports OpenQA.Selenium.Support.PageObjects


''' <summary> 
''' PageObject1 PageObjects  
''' </summary> 
''' <remarks></remarks> 
''' <history> 
''' </history> 
Public Class PageObject1
    Inherits SeleniumAction

#Region " Declare "
    <FindsBy([Using]:="service-alert")>
    Private _serviceAlert As IWebElement

    <FindsBy([Using]:="outer-wrapper")>
    Private _outerWrapper As IWebElement

    <FindsBy([Using]:="content-wrapper")>
    Private _contentWrapper As IWebElement

    <FindsBy([Using]:="layout-footer")>
    Private _layoutFooter As IWebElement

    <FindsBy([Using]:="body")>
    Private _body As IWebElement

    <FindsBy([Using]:="logo")>
    Private _logo As IWebElement

    <FindsBy([Using]:="header-sidebox")>
    Private _headerSidebox As IWebElement

    <FindsBy([Using]:="searchBox")>
    Private _searchBox As IWebElement

    <FindsBy([Using]:="searchBoxInput")>
    Private _searchBoxInput As IWebElement

    <FindsBy([Using]:="searchBoxSubmit")>
    Private _searchBoxSubmit As IWebElement

    <FindsBy([Using]:="menu")>
    Private _menu As IWebElement

    <FindsBy([Using]:="UniquePackages")>
    Private _uniquePackages As IWebElement

    <FindsBy([Using]:="Downloads")>
    Private _downloads As IWebElement

    <FindsBy([Using]:="TotalPackages")>
    Private _totalPackages As IWebElement

    <FindsBy([Using]:="footer")>
    Private _footer As IWebElement

    <FindsBy([Using]:="releaseTag")>
    Private _releaseTag As IWebElement
#End Region

    Public Sub New(ByVal driver As IWebDriver)
        MyBase.New(driver)
    End Sub
End Class
```


## Moca.NET Libraries

[Moca.NET Organization](https://github.com/mocanet)

## Visual Studio Extensions

* [Moca.NET Template Extension](https://marketplace.visualstudio.com/items?itemName=MiYABiS.MocaNETTemplate30)
* [Moca.NET Snippets Extension](https://marketplace.visualstudio.com/items?itemName=MiYABiS.MocaNETCodeSnippet)

## Sample

* Web Form Application  
  * http://miyabis.github.io/Moca.NET-WebAppDemo/  
  * https://code.msdn.microsoft.com/vstudio/MocaNET-Framework-Web-0e8d6dd7

* Windows Form Application  
  * http://miyabis.github.io/Moca.NET-WinAppDemo/  
  * https://code.msdn.microsoft.com/vstudio/MocaNET-Framework-Windows-7174d250

## For Development

* Visual Studio 2019

## License

Microsoft Public License (MS-PL)

http://opensource.org/licenses/MS-PL
