enum ColorGroup {
  White,
  Red,
  Brown,
  Yellow,
  Green,
  Blue,
  Purple,
}

export interface Color {
  label: string;
  value: string;
  R: number;
  G: number;
  B: number;
  group: ColorGroup;
}

const colorArray:Array<Color> = [
  {
    label: "素雪白",
    value: "snow-white",
    R: 228,
    G: 223,
    B: 208,
    group: ColorGroup.White,
  },
  {
    label: "苍白灰",
    value: "ash-grey",
    R: 172,
    G: 168,
    B: 162,
    group: ColorGroup.White,
  },
  {
    label: "古菩灰",
    value: "goobbue-grey",
    R: 137,
    G: 135,
    B: 132,
    group: ColorGroup.White,
  },
  {
    label: "石板灰",
    value: "slate-grey",
    R: 101,
    G: 101,
    B: 101,
    group: ColorGroup.White,
  },
  {
    label: "木炭灰",
    value: "charcoal-grey",
    R: 72,
    G: 71,
    B: 66,
    group: ColorGroup.White,
  },
  {
    label: "煤烟黑",
    value: "soot-black",
    R: 43,
    G: 41,
    B: 35,
    group: ColorGroup.White,
  },

  {
    label: "玫瑰粉",
    value: "rose-pink",
    R: 230,
    G: 159,
    B: 150,
    group: ColorGroup.Red,
  },
  {
    label: "丁香紫",
    value: "lilac-purple",
    R: 131,
    G: 105,
    B: 105,
    group: ColorGroup.Red,
  },
  {
    label: "罗兰莓",
    value: "rolanberry-red",
    R: 91,
    G: 23,
    B: 41,
    group: ColorGroup.Red,
  },
  {
    label: "卫月红",
    value: "dalamud-red",
    R: 120,
    G: 26,
    B: 26,
    group: ColorGroup.Red,
  },
  {
    label: "铁锈红",
    value: "rust-red",
    R: 98,
    G: 34,
    B: 7,
    group: ColorGroup.Red,
  },
  {
    label: "果酒红",
    value: "wine-red",
    R: 69,
    G: 21,
    B: 17,
    group: ColorGroup.Red,
  },
  {
    label: "珊瑚粉",
    value: "coral-pink",
    R: 204,
    G: 108,
    B: 94,
    group: ColorGroup.Red,
  },
  {
    label: "鲜血红",
    value: "blood-red",
    R: 145,
    G: 59,
    B: 48,
    group: ColorGroup.Red,
  },
  {
    label: "鲑鱼粉",
    value: "salmon-pink",
    R: 228,
    G: 170,
    B: 138,
    group: ColorGroup.Red,
  },

  {
    label: "日落橙",
    value: "sunset-orange",
    R: 183,
    G: 92,
    B: 45,
    group: ColorGroup.Brown,
  },
  {
    label: "台地红",
    value: "mesa-red",
    R: 125,
    G: 57,
    B: 6,
    group: ColorGroup.Brown,
  },
  {
    label: "树皮棕",
    value: "bark-brown",
    R: 106,
    G: 75,
    B: 55,
    group: ColorGroup.Brown,
  },
  {
    label: "巧克力",
    value: "chocolate-brown",
    R: 110,
    G: 61,
    B: 36,
    group: ColorGroup.Brown,
  },
  {
    label: "铁锈棕",
    value: "russet-brown",
    R: 79,
    G: 45,
    B: 31,
    group: ColorGroup.Brown,
  },
  {
    label: "钴铁棕",
    value: "kobold-brown",
    R: 48,
    G: 33,
    B: 27,
    group: ColorGroup.Brown,
  },
  {
    label: "软木棕",
    value: "cork-brown",
    R: 201,
    G: 145,
    B: 86,
    group: ColorGroup.Brown,
  },
  {
    label: "卢恩棕",
    value: "qiqirn-brown",
    R: 153,
    G: 110,
    B: 63,
    group: ColorGroup.Brown,
  },
  {
    label: "奥猴棕",
    value: "opo-opo-brown",
    R: 123,
    G: 92,
    B: 45,
    group: ColorGroup.Brown,
  },
  {
    label: "山羊棕",
    value: "aldgoat-brown",
    R: 162,
    G: 135,
    B: 92,
    group: ColorGroup.Brown,
  },
  {
    label: "南瓜橙",
    value: "pumpkin-orange",
    R: 197,
    G: 116,
    B: 36,
    group: ColorGroup.Brown,
  },
  {
    label: "橡果棕",
    value: "acorn-brown",
    R: 142,
    G: 88,
    B: 27,
    group: ColorGroup.Brown,
  },
  {
    label: "果园棕",
    value: "orchard-brown",
    R: 100,
    G: 66,
    B: 22,
    group: ColorGroup.Brown,
  },
  {
    label: "山栗棕",
    value: "chestnut-brown",
    R: 61,
    G: 41,
    B: 13,
    group: ColorGroup.Brown,
  },
  {
    label: "哥布林",
    value: "gobbiebag-brown",
    R: 185,
    G: 164,
    B: 137,
    group: ColorGroup.Brown,
  },
  {
    label: "页岩棕",
    value: "shale-brown",
    R: 146,
    G: 129,
    B: 108,
    group: ColorGroup.Brown,
  },
  {
    label: "鼹鼠棕",
    value: "mole-brown",
    R: 97,
    G: 82,
    B: 69,
    group: ColorGroup.Brown,
  },
  {
    label: "沃土棕",
    value: "loam-brown",
    R: 63,
    G: 51,
    B: 41,
    group: ColorGroup.Brown,
  },

  {
    label: "骸骨白",
    value: "bone-white",
    R: 235,
    G: 211,
    B: 160,
    group: ColorGroup.Yellow,
  },
  {
    label: "黄沙棕",
    value: "ul-brown",
    R: 183,
    G: 163,
    B: 112,
    group: ColorGroup.Yellow,
  },
  {
    label: "沙漠黄",
    value: "desert-yellow",
    R: 219,
    G: 180,
    B: 87,
    group: ColorGroup.Yellow,
  },
  {
    label: "蜂蜜黄",
    value: "honey-yellow",
    R: 250,
    G: 198,
    B: 43,
    group: ColorGroup.Yellow,
  },
  {
    label: "玉米黄",
    value: "millioncorn-yellow",
    R: 228,
    G: 158,
    B: 52,
    group: ColorGroup.Yellow,
  },
  {
    label: "猛豹黄",
    value: "coeurl-yellow",
    R: 188,
    G: 136,
    B: 4,
    group: ColorGroup.Yellow,
  },
  {
    label: "奶油黄",
    value: "cream-yellow",
    R: 242,
    G: 215,
    B: 112,
    group: ColorGroup.Yellow,
  },
  {
    label: "日影黄",
    value: "halatali-yellow",
    R: 165,
    G: 132,
    B: 48,
    group: ColorGroup.Yellow,
  },
  {
    label: "萄干棕",
    value: "raisin-brown",
    R: 64,
    G: 51,
    B: 17,
    group: ColorGroup.Yellow,
  },

  {
    label: "泥沼绿",
    value: "mud-green",
    R: 88,
    G: 82,
    B: 48,
    group: ColorGroup.Green,
  },
  {
    label: "妖精绿",
    value: "sylph-green",
    R: 187,
    G: 187,
    B: 138,
    group: ColorGroup.Green,
  },
  {
    label: "青柠绿",
    value: "lime-green",
    R: 171,
    G: 176,
    B: 84,
    group: ColorGroup.Green,
  },
  {
    label: "苔藓绿",
    value: "moss-green",
    R: 112,
    G: 115,
    B: 38,
    group: ColorGroup.Green,
  },
  {
    label: "牧草绿",
    value: "meadow-green",
    R: 139,
    G: 156,
    B: 99,
    group: ColorGroup.Green,
  },
  {
    label: "橄榄绿",
    value: "olive-green",
    R: 75,
    G: 82,
    B: 50,
    group: ColorGroup.Green,
  },
  {
    label: "沼泽绿",
    value: "marsh-green",
    R: 50,
    G: 54,
    B: 33,
    group: ColorGroup.Green,
  },
  {
    label: "苹果绿",
    value: "apple-green",
    R: 149,
    G: 174,
    B: 92,
    group: ColorGroup.Green,
  },
  {
    label: "仙人掌",
    value: "cactuar-green",
    R: 101,
    G: 130,
    B: 65,
    group: ColorGroup.Green,
  },
  {
    label: "猎人绿",
    value: "hunter-green",
    R: 40,
    G: 75,
    B: 38,
    group: ColorGroup.Green,
  },
  {
    label: "口花绿",
    value: "ochu-green",
    R: 64,
    G: 99,
    B: 57,
    group: ColorGroup.Green,
  },
  {
    label: "金龟绿",
    value: "adamantoise-green",
    R: 95,
    G: 117,
    B: 88,
    group: ColorGroup.Green,
  },
  {
    label: "地神绿",
    value: "nophica-green",
    R: 59,
    G: 77,
    B: 60,
    group: ColorGroup.Green,
  },
  {
    label: "深林绿",
    value: "deepwood-green",
    R: 30,
    G: 42,
    B: 33,
    group: ColorGroup.Green,
  },
  {
    label: "天上蓝",
    value: "celeste-green",
    R: 150,
    G: 189,
    B: 185,
    group: ColorGroup.Green,
  },
  {
    label: "绿松蓝",
    value: "turquoise-green",
    R: 67,
    G: 114,
    B: 144,
    group: ColorGroup.Green,
  },
  {
    label: "魔花绿",
    value: "morbol-green",
    R: 31,
    G: 70,
    B: 70,
    group: ColorGroup.Green,
  },

  {
    label: "寒冰蓝",
    value: "ice-blue",
    R: 178,
    G: 196,
    B: 206,
    group: ColorGroup.Blue,
  },
  {
    label: "天空蓝",
    value: "sky-blue",
    R: 131,
    G: 176,
    B: 210,
    group: ColorGroup.Blue,
  },
  {
    label: "海雾蓝",
    value: "seafog-blue",
    R: 100,
    G: 129,
    B: 160,
    group: ColorGroup.Blue,
  },
  {
    label: "孔雀蓝",
    value: "peacock-blue",
    R: 59,
    G: 104,
    B: 134,
    group: ColorGroup.Blue,
  },
  {
    label: "罗海蓝",
    value: "rhotano-blue",
    R: 28,
    G: 61,
    B: 84,
    group: ColorGroup.Blue,
  },
  {
    label: "腐尸蓝",
    value: "corpse-blue",
    R: 142,
    G: 155,
    B: 172,
    group: ColorGroup.Blue,
  },
  {
    label: "青磷蓝",
    value: "ceruleam-blue",
    R: 79,
    G: 87,
    B: 102,
    group: ColorGroup.Blue,
  },
  {
    label: "靛青蓝",
    value: "woad-blue",
    R: 47,
    G: 56,
    B: 81,
    group: ColorGroup.Blue,
  },
  {
    label: "油墨蓝",
    value: "ink-blue",
    R: 26,
    G: 31,
    B: 39,
    group: ColorGroup.Blue,
  },
  {
    label: "盗龙蓝",
    value: "raptor-blue",
    R: 91,
    G: 127,
    B: 192,
    group: ColorGroup.Blue,
  },
  {
    label: "东洲蓝",
    value: "othard-blue",
    R: 47,
    G: 88,
    B: 137,
    group: ColorGroup.Blue,
  },
  {
    label: "风暴蓝",
    value: "storm-blue",
    R: 35,
    G: 65,
    B: 114,
    group: ColorGroup.Blue,
  },
  {
    label: "虚空蓝",
    value: "void-blue",
    R: 17,
    G: 41,
    B: 68,
    group: ColorGroup.Blue,
  },
  {
    label: "皇室蓝",
    value: "royal-blue",
    R: 39,
    G: 48,
    B: 103,
    group: ColorGroup.Blue,
  },
  {
    label: "午夜蓝",
    value: "midnight-blue",
    R: 24,
    G: 25,
    B: 55,
    group: ColorGroup.Blue,
  },
  {
    label: "阴影蓝",
    value: "shadow-blue",
    R: 55,
    G: 55,
    B: 71,
    group: ColorGroup.Blue,
  },
  {
    label: "深渊蓝",
    value: "abyssal-blue",
    R: 49,
    G: 45,
    B: 87,
    group: ColorGroup.Blue,
  },
  {
    label: "薰衣草",
    value: "lavender-purple",
    R: 135,
    G: 127,
    B: 174,
    group: ColorGroup.Purple,
  },
  {
    label: "忧郁紫",
    value: "gloom-purple",
    R: 81,
    G: 69,
    B: 96,
    group: ColorGroup.Purple,
  },
  {
    label: "醋栗紫",
    value: "currant-purple",
    R: 50,
    G: 44,
    B: 59,
    group: ColorGroup.Purple,
  },
  {
    label: "虹膜紫",
    value: "iris-purple",
    R: 183,
    G: 158,
    B: 188,
    group: ColorGroup.Purple,
  },
  {
    label: "葡萄紫",
    value: "grape-purple",
    R: 59,
    G: 42,
    B: 61,
    group: ColorGroup.Purple,
  },
  {
    label: "莲花粉",
    value: "lotus-pink",
    R: 254,
    G: 206,
    B: 245,
    group: ColorGroup.Purple,
  },
  {
    label: "蜂鸟粉",
    value: "colibri-pink",
    R: 220,
    G: 155,
    B: 202,
    group: ColorGroup.Purple,
  },
  {
    label: "仙子梅",
    value: "plum-purple",
    R: 121,
    G: 82,
    B: 108,
    group: ColorGroup.Purple,
  },
  {
    label: "帝王紫",
    value: "regal-purple",
    R: 102,
    G: 48,
    B: 78,
    group: ColorGroup.Purple,
  },
];

const categories:Map<ColorGroup, {cn: string; value: string}> = new Map([
  [ColorGroup.White, {
    cn: '白',
    value: 'bg-white'
  }],
  [ColorGroup.Red, {
    cn: '红',
    value: 'bg-red-700'
  }],
  [ColorGroup.Brown, {
    cn: '棕',
    value: 'bg-yellow-800'
  }],
  [ColorGroup.Yellow, {
    cn: '黄',
    value: 'bg-yellow-300'
  }],
  [ColorGroup.Green, {
    cn: '绿',
    value: 'bg-green-400'
  }],
  [ColorGroup.Blue, {
    cn: '蓝',
    value: 'bg-blue-500'
  }],
  [ColorGroup.Purple, {
    cn: '紫',
    value: 'bg-purple-700'
  }]
])

const colours:Map<string, Color> = new Map();

colorArray.forEach(config => {
  colours.set(config.value, config);
})

export { ColorGroup, colours, categories };
