#!/bin/bash
# Sort Domains into a plain text file with domain names only
# Created by: Mitchell Krog (mitchellkrog@gmail.com)
# Copyright: Mitchell Krog - https://github.com/mitchellkrogza
# Repo Url: https://github.com/mitchellkrogza/The-Big-List-of-Hacked-Malware-Web-Sites

# ******************************
# Specify Input and Output Files
# ******************************

_input=$TRAVIS_BUILD_DIR/.input_sources/hacked-malware-websites.txt
_input2=$TRAVIS_BUILD_DIR/.dev-tools/domains-tmp.txt
_output=$TRAVIS_BUILD_DIR/.dev-tools/_strip_domains/domains.txt
_output2=$TRAVIS_BUILD_DIR/.dev-tools/_strip_domains/domains.tmp

# *****************
# Truncate our file
# *****************

sudo truncate -s 0 $_output

# ***************************************************
# Use cut to strip the domains out of the url strings
# ***************************************************

cut -d'/' -f3 $_input > $_output

# **************************************************************************
# Sort lists alphabetically and remove duplicates before cleaning Dead Hosts
# **************************************************************************

sort -u $_output -o $_output

# ******************************************
# Trim Empty Line at Beginning of Input File
# ******************************************

grep '[^[:blank:]]' < $_output > $_input2
sudo cp $_output $_output2
sudo mv $_input2 $_output

# ********************************************************
# Clean the list of any lines not containing a . character
# ********************************************************

cat $_output | sed '/\./!d' > $_input2 && mv $_input2 $_output

# ************************************************
# Activate Dos2Unix 
# ************************************************

dos2unix $_output

exit 0

