# Goal / Issue

Describe a short description of of this PR, e.g. _The user can click the
"Share" button an post a link to her Twitter timeline._

### Quality

* [ ] Submitted a ticket for my issue if one did not already exist
  * [ ] Ticket number is in the subject of the commit message
  * [ ] Used [Github auto-closing keywords](https://help.github.com/articles/closing-issues-via-commit-messages/) in the commit message
* [ ] If you've changed APIs, update the documentation
* [ ] Tested, all tests are passing
  * [ ] Includes new tests for new functionality
* [ ] Style - code passes all linting & validation checks 
  * [ ] Code follows the contributing guidelines
  * [ ] Code follows the style guide
* [ ] Single commit - recently `git rebase -i` off of `master`
* [ ] If you've removed any code, make sure there isn't dangling orphan code

_If there’s a checkbox you can’t complete for any reason, that's okay, just
explain in detail why you weren’t able to do so._


### Expected Use

Describe how to use the feature if it's complex.


### Commit Msg

If your pull request fixes an issue specify it (by number e.g. `#1`) in the
commit message subject.
