//https://core.telegram.org/bots/payments/currencies.json
export default {
    "AED": {
        "code": "AED",
        "title": "United Arab Emirates Dirham",
        "symbol": "AED",
        "native": "د.إ.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "367",
        "max_amount": "3673075"
    },
    "AFN": {
        "code": "AFN",
        "title": "Afghan Afghani",
        "symbol": "AFN",
        "native": "؋",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "7546",
        "max_amount": "75466344"
    },
    "ALL": {
        "code": "ALL",
        "title": "Albanian Lek",
        "symbol": "ALL",
        "native": "Lek",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": false,
        "exp": 2,
        "min_amount": "9979",
        "max_amount": "99791903"
    },
    "AMD": {
        "code": "AMD",
        "title": "Armenian Dram",
        "symbol": "AMD",
        "native": "դր.",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "40843",
        "max_amount": "408437382"
    },
    "ARS": {
        "code": "ARS",
        "title": "Argentine Peso",
        "symbol": "ARS",
        "native": "$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "35000",
        "max_amount": "350008503"
    },
    "AUD": {
        "code": "AUD",
        "title": "Australian Dollar",
        "symbol": "AU$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "156",
        "max_amount": "1562915"
    },
    "AZN": {
        "code": "AZN",
        "title": "Azerbaijani Manat",
        "symbol": "AZN",
        "native": "ман.",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "170",
        "max_amount": "1702763"
    },
    "BAM": {
        "code": "BAM",
        "title": "Bosnia & Herzegovina Convertible Mark",
        "symbol": "BAM",
        "native": "KM",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "184",
        "max_amount": "1849981"
    },
    "BDT": {
        "code": "BDT",
        "title": "Bangladeshi Taka",
        "symbol": "BDT",
        "native": "৳",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "10979",
        "max_amount": "109790011"
    },
    "BGN": {
        "code": "BGN",
        "title": "Bulgarian Lev",
        "symbol": "BGN",
        "native": "лв.",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "184",
        "max_amount": "1849903"
    },
    "BND": {
        "code": "BND",
        "title": "Brunei Dollar",
        "symbol": "BND",
        "native": "$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "136",
        "max_amount": "1363099"
    },
    "BOB": {
        "code": "BOB",
        "title": "Bolivian Boliviano",
        "symbol": "BOB",
        "native": "Bs",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "688",
        "max_amount": "6881352"
    },
    "BRL": {
        "code": "BRL",
        "title": "Brazilian Real",
        "symbol": "R$",
        "native": "R$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "513",
        "max_amount": "5136802"
    },
    "BYN": {
        "code": "BYN",
        "title": "Belarusian ruble",
        "symbol": "BYN",
        "native": "BYN",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "327",
        "max_amount": "3279417"
    },
    "CAD": {
        "code": "CAD",
        "title": "Canadian Dollar",
        "symbol": "CA$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "136",
        "max_amount": "1360565"
    },
    "CHF": {
        "code": "CHF",
        "title": "Swiss Franc",
        "symbol": "CHF",
        "native": "CHF",
        "thousands_sep": "'",
        "decimal_sep": ".",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "90",
        "max_amount": "905735"
    },
    "CLP": {
        "code": "CLP",
        "title": "Chilean Peso",
        "symbol": "CLP",
        "native": "$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 0,
        "min_amount": "921",
        "max_amount": "9210498"
    },
    "CNY": {
        "code": "CNY",
        "title": "Chinese Renminbi Yuan",
        "symbol": "CN¥",
        "native": "CN¥",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "717",
        "max_amount": "7174399"
    },
    "COP": {
        "code": "COP",
        "title": "Colombian Peso",
        "symbol": "COP",
        "native": "$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "431700",
        "max_amount": "4317000000"
    },
    "CRC": {
        "code": "CRC",
        "title": "Costa Rican Colón",
        "symbol": "CRC",
        "native": "₡",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "53284",
        "max_amount": "532847751"
    },
    "CZK": {
        "code": "CZK",
        "title": "Czech Koruna",
        "symbol": "CZK",
        "native": "Kč",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "2323",
        "max_amount": "23234973"
    },
    "DKK": {
        "code": "DKK",
        "title": "Danish Krone",
        "symbol": "DKK",
        "native": "kr",
        "thousands_sep": "",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "705",
        "max_amount": "7052302"
    },
    "DOP": {
        "code": "DOP",
        "title": "Dominican Peso",
        "symbol": "DOP",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "5655",
        "max_amount": "56557726"
    },
    "DZD": {
        "code": "DZD",
        "title": "Algerian Dinar",
        "symbol": "DZD",
        "native": "د.ج.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "13757",
        "max_amount": "137578678"
    },
    "EGP": {
        "code": "EGP",
        "title": "Egyptian Pound",
        "symbol": "EGP",
        "native": "ج.م.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "3090",
        "max_amount": "30900598"
    },
    "ETB": {
        "code": "ETB",
        "title": "Ethiopian Birr",
        "symbol": "ETB",
        "native": "ብር",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "5552",
        "max_amount": "55527829"
    },
    "EUR": {
        "code": "EUR",
        "title": "Euro",
        "symbol": "€",
        "native": "€",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "94",
        "max_amount": "945725"
    },
    "GBP": {
        "code": "GBP",
        "title": "British Pound",
        "symbol": "£",
        "native": "£",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "81",
        "max_amount": "817630"
    },
    "GEL": {
        "code": "GEL",
        "title": "Georgian Lari",
        "symbol": "GEL",
        "native": "GEL",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "267",
        "max_amount": "2674970"
    },
    "GTQ": {
        "code": "GTQ",
        "title": "Guatemalan Quetzal",
        "symbol": "GTQ",
        "native": "Q",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "781",
        "max_amount": "7814037"
    },
    "HKD": {
        "code": "HKD",
        "title": "Hong Kong Dollar",
        "symbol": "HK$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "782",
        "max_amount": "7820480"
    },
    "HNL": {
        "code": "HNL",
        "title": "Honduran Lempira",
        "symbol": "HNL",
        "native": "L",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "2456",
        "max_amount": "24560142"
    },
    "HRK": {
        "code": "HRK",
        "title": "Croatian Kuna",
        "symbol": "HRK",
        "native": "kn",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "701",
        "max_amount": "7014709"
    },
    "HUF": {
        "code": "HUF",
        "title": "Hungarian Forint",
        "symbol": "HUF",
        "native": "Ft",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "36704",
        "max_amount": "367046504"
    },
    "IDR": {
        "code": "IDR",
        "title": "Indonesian Rupiah",
        "symbol": "IDR",
        "native": "Rp",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "1575255",
        "max_amount": "15752550000"
    },
    "ILS": {
        "code": "ILS",
        "title": "Israeli New Sheqel",
        "symbol": "₪",
        "native": "₪",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "395",
        "max_amount": "3950730"
    },
    "INR": {
        "code": "INR",
        "title": "Indian Rupee",
        "symbol": "₹",
        "native": "₹",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "8325",
        "max_amount": "83255203"
    },
    "ISK": {
        "code": "ISK",
        "title": "Icelandic Króna",
        "symbol": "ISK",
        "native": "kr",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 0,
        "min_amount": "137",
        "max_amount": "1377905"
    },
    "JMD": {
        "code": "JMD",
        "title": "Jamaican Dollar",
        "symbol": "JMD",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "15409",
        "max_amount": "154093553"
    },
    "JPY": {
        "code": "JPY",
        "title": "Japanese Yen",
        "symbol": "¥",
        "native": "￥",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 0,
        "min_amount": "148",
        "max_amount": "1489589"
    },
    "KES": {
        "code": "KES",
        "title": "Kenyan Shilling",
        "symbol": "KES",
        "native": "Ksh",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "14889",
        "max_amount": "148893121"
    },
    "KGS": {
        "code": "KGS",
        "title": "Kyrgyzstani Som",
        "symbol": "KGS",
        "native": "KGS",
        "thousands_sep": " ",
        "decimal_sep": "-",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "8892",
        "max_amount": "88920198"
    },
    "KRW": {
        "code": "KRW",
        "title": "South Korean Won",
        "symbol": "₩",
        "native": "₩",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 0,
        "min_amount": "1349",
        "max_amount": "13493116"
    },
    "KZT": {
        "code": "KZT",
        "title": "Kazakhstani Tenge",
        "symbol": "KZT",
        "native": "₸",
        "thousands_sep": " ",
        "decimal_sep": "-",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "47618",
        "max_amount": "476182369"
    },
    "LBP": {
        "code": "LBP",
        "title": "Lebanese Pound",
        "symbol": "LBP",
        "native": "ل.ل.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "1496746",
        "max_amount": "14967461218"
    },
    "LKR": {
        "code": "LKR",
        "title": "Sri Lankan Rupee",
        "symbol": "LKR",
        "native": "රු.",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "32241",
        "max_amount": "322417707"
    },
    "MAD": {
        "code": "MAD",
        "title": "Moroccan Dirham",
        "symbol": "MAD",
        "native": "د.م.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "1032",
        "max_amount": "10326663"
    },
    "MDL": {
        "code": "MDL",
        "title": "Moldovan Leu",
        "symbol": "MDL",
        "native": "MDL",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "1815",
        "max_amount": "18159289"
    },
    "MNT": {
        "code": "MNT",
        "title": "Mongolian Tögrög",
        "symbol": "MNT",
        "native": "MNT",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "346613",
        "max_amount": "3466138128"
    },
    "MUR": {
        "code": "MUR",
        "title": "Mauritian Rupee",
        "symbol": "MUR",
        "native": "MUR",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "4419",
        "max_amount": "44196439"
    },
    "MVR": {
        "code": "MVR",
        "title": "Maldivian Rufiyaa",
        "symbol": "MVR",
        "native": "MVR",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "1540",
        "max_amount": "15405864"
    },
    "MXN": {
        "code": "MXN",
        "title": "Mexican Peso",
        "symbol": "MX$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "1826",
        "max_amount": "18268460"
    },
    "MYR": {
        "code": "MYR",
        "title": "Malaysian Ringgit",
        "symbol": "MYR",
        "native": "RM",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "473",
        "max_amount": "4735500"
    },
    "MZN": {
        "code": "MZN",
        "title": "Mozambican Metical",
        "symbol": "MZN",
        "native": "MTn",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "6324",
        "max_amount": "63249950"
    },
    "NGN": {
        "code": "NGN",
        "title": "Nigerian Naira",
        "symbol": "NGN",
        "native": "₦",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "76882",
        "max_amount": "768820241"
    },
    "NIO": {
        "code": "NIO",
        "title": "Nicaraguan Córdoba",
        "symbol": "NIO",
        "native": "C$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "3643",
        "max_amount": "36437764"
    },
    "NOK": {
        "code": "NOK",
        "title": "Norwegian Krone",
        "symbol": "NOK",
        "native": "kr",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "1086",
        "max_amount": "10861050"
    },
    "NPR": {
        "code": "NPR",
        "title": "Nepalese Rupee",
        "symbol": "NPR",
        "native": "नेरू",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "13268",
        "max_amount": "132688524"
    },
    "NZD": {
        "code": "NZD",
        "title": "New Zealand Dollar",
        "symbol": "NZ$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "166",
        "max_amount": "1665695"
    },
    "PAB": {
        "code": "PAB",
        "title": "Panamanian Balboa",
        "symbol": "PAB",
        "native": "B/.",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "99",
        "max_amount": "995833"
    },
    "PEN": {
        "code": "PEN",
        "title": "Peruvian Nuevo Sol",
        "symbol": "PEN",
        "native": "S/.",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "381",
        "max_amount": "3811938"
    },
    "PHP": {
        "code": "PHP",
        "title": "Philippine Peso",
        "symbol": "PHP",
        "native": "₱",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "5686",
        "max_amount": "56863497"
    },
    "PKR": {
        "code": "PKR",
        "title": "Pakistani Rupee",
        "symbol": "PKR",
        "native": "₨",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "28032",
        "max_amount": "280328415"
    },
    "PLN": {
        "code": "PLN",
        "title": "Polish Złoty",
        "symbol": "PLN",
        "native": "zł",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "431",
        "max_amount": "4311835"
    },
    "PYG": {
        "code": "PYG",
        "title": "Paraguayan Guaraní",
        "symbol": "PYG",
        "native": "₲",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 0,
        "min_amount": "7280",
        "max_amount": "72805524"
    },
    "QAR": {
        "code": "QAR",
        "title": "Qatari Riyal",
        "symbol": "QAR",
        "native": "ر.ق.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "364",
        "max_amount": "3641027"
    },
    "RON": {
        "code": "RON",
        "title": "Romanian Leu",
        "symbol": "RON",
        "native": "RON",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "469",
        "max_amount": "4695402"
    },
    "RSD": {
        "code": "RSD",
        "title": "Serbian Dinar",
        "symbol": "RSD",
        "native": "дин.",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "11086",
        "max_amount": "110867977"
    },
    "RUB": {
        "code": "RUB",
        "title": "Russian Ruble",
        "symbol": "RUB",
        "native": "₽",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "10527",
        "max_amount": "105278286"
    },
    "SAR": {
        "code": "SAR",
        "title": "Saudi Riyal",
        "symbol": "SAR",
        "native": "ر.س.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "375",
        "max_amount": "3751017"
    },
    "SEK": {
        "code": "SEK",
        "title": "Swedish Krona",
        "symbol": "SEK",
        "native": "kr",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "1095",
        "max_amount": "10952880"
    },
    "SGD": {
        "code": "SGD",
        "title": "Singapore Dollar",
        "symbol": "SGD",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "136",
        "max_amount": "1366380"
    },
    "THB": {
        "code": "THB",
        "title": "Thai Baht",
        "symbol": "฿",
        "native": "฿",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "3689",
        "max_amount": "36891498"
    },
    "TJS": {
        "code": "TJS",
        "title": "Tajikistani Somoni",
        "symbol": "TJS",
        "native": "TJS",
        "thousands_sep": " ",
        "decimal_sep": ";",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "1093",
        "max_amount": "10939274"
    },
    "TRY": {
        "code": "TRY",
        "title": "Turkish Lira",
        "symbol": "TRY",
        "native": "TL",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "2772",
        "max_amount": "27726803"
    },
    "TTD": {
        "code": "TTD",
        "title": "Trinidad and Tobago Dollar",
        "symbol": "TTD",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "676",
        "max_amount": "6760310"
    },
    "TWD": {
        "code": "TWD",
        "title": "New Taiwan Dollar",
        "symbol": "NT$",
        "native": "NT$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "3214",
        "max_amount": "32149800"
    },
    "TZS": {
        "code": "TZS",
        "title": "Tanzanian Shilling",
        "symbol": "TZS",
        "native": "TSh",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "250500",
        "max_amount": "2505000060"
    },
    "UAH": {
        "code": "UAH",
        "title": "Ukrainian Hryvnia",
        "symbol": "UAH",
        "native": "₴",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": false,
        "exp": 2,
        "min_amount": "3638",
        "max_amount": "36386657"
    },
    "UGX": {
        "code": "UGX",
        "title": "Ugandan Shilling",
        "symbol": "UGX",
        "native": "USh",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 0,
        "min_amount": "3729",
        "max_amount": "37296985"
    },
    "USD": {
        "code": "USD",
        "title": "United States Dollar",
        "symbol": "$",
        "native": "$",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": false,
        "exp": 2,
        "min_amount": "100",
        "max_amount": 1000000
    },
    "UYU": {
        "code": "UYU",
        "title": "Uruguayan Peso",
        "symbol": "UYU",
        "native": "$",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "3898",
        "max_amount": "38980566"
    },
    "UZS": {
        "code": "UZS",
        "title": "Uzbekistani Som",
        "symbol": "UZS",
        "native": "UZS",
        "thousands_sep": " ",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 2,
        "min_amount": "1212920",
        "max_amount": "12129209232"
    },
    "VND": {
        "code": "VND",
        "title": "Vietnamese Đồng",
        "symbol": "₫",
        "native": "₫",
        "thousands_sep": ".",
        "decimal_sep": ",",
        "symbol_left": false,
        "space_between": true,
        "exp": 0,
        "min_amount": "24415",
        "max_amount": "244150000"
    },
    "YER": {
        "code": "YER",
        "title": "Yemeni Rial",
        "symbol": "YER",
        "native": "ر.ي.‏",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "25040",
        "max_amount": "250402577"
    },
    "ZAR": {
        "code": "ZAR",
        "title": "South African Rand",
        "symbol": "ZAR",
        "native": "R",
        "thousands_sep": ",",
        "decimal_sep": ".",
        "symbol_left": true,
        "space_between": true,
        "exp": 2,
        "min_amount": "1922",
        "max_amount": "19226494"
    }
}