-- Purpose: awesomewm wibar config

local awful = require("awful")
local gears = require("gears")
local wibox = require("wibox")
local dpi = require('beautiful').xresources.apply_dpi

mylauncher = awful.widget.launcher({ image = beautiful.awesome_icon,
                                     menu = mymainmenu })

-- {{{ Wibar
-- Create a textclock widget
mytextclock = wibox.widget.textclock()

-- Create a wibox for each screen and add it
local taglist_buttons = gears.table.join(
                    awful.button({ }, 1, function(t) t:view_only() end),
                    awful.button({ modkey }, 1, function(t)
                                              if client.focus then
                                                  client.focus:move_to_tag(t)
                                              end
                                          end),
                    awful.button({ }, 3, awful.tag.viewtoggle),
                    awful.button({ modkey }, 3, function(t)
                                              if client.focus then
                                                  client.focus:toggle_tag(t)
                                              end
                                          end),
                    awful.button({ }, 4, function(t) awful.tag.viewnext(t.screen) end),
                    awful.button({ }, 5, function(t) awful.tag.viewprev(t.screen) end)
                )

local tasklist_buttons = gears.table.join(
                     awful.button({ }, 1, function (c)
                                              if c == client.focus then
                                                  c.minimized = true
                                              else
                                                  c:emit_signal(
                                                      "request::activate",
                                                      "tasklist",
                                                      {raise = true}
                                                  )
                                              end
                                          end),
                     awful.button({ }, 3, function()
                                              awful.menu.client_list({ theme = { width = 250 } })
                                          end),
                     awful.button({ }, 4, function ()
                                              awful.client.focus.byidx(1)
                                          end),
                     awful.button({ }, 5, function ()
                                              awful.client.focus.byidx(-1)
                                          end))

awful.screen.connect_for_each_screen(function(s)
    -- Wallpaper
    require("UIDesktop.wallpaper").run(s)

    local function rounded_rect(cr, width, height)
        return gears.shape.rounded_rect(cr, width, height, 5)
    end

    -- Each screen has its own tag table.
    awful.tag({"", "", "", "", "", "", ""}, s, awful.layout.layouts[1])

    -- Create a promptbox for each screen
    s.mypromptbox = awful.widget.prompt()
    -- Create an imagebox widget which will contain an icon indicating which layout we're using.
    -- We need one layoutbox per screen.
    s.mylayoutbox = awful.widget.layoutbox(s)
    s.mylayoutbox:buttons(gears.table.join(
                           awful.button({ }, 1, function () awful.layout.inc( 1) end),
                           awful.button({ }, 3, function () awful.layout.inc(-1) end),
                           awful.button({ }, 4, function () awful.layout.inc( 1) end),
                           awful.button({ }, 5, function () awful.layout.inc(-1) end)))
    -- Create a taglist widget
    s.mytaglist = awful.widget.taglist {
        screen  = s,
        filter  = awful.widget.taglist.filter.all,
        buttons = taglist_buttons,
        style = {shape = rounded_rect},
        layout = wibox.layout.fixed.horizontal
    }
    -- Create a tasklist widget
    s.mytasklist = awful.widget.tasklist {
        screen  = s,
        filter  = awful.widget.tasklist.filter.currenttags,
        buttons = tasklist_buttons,
        style    = {
            shape_border_width = 1,
            shape = rounded_rect
        },
        layout   = {
            spacing = 10,
            layout  = wibox.layout.flex.horizontal
        },
        -- Notice that there is *NO* wibox.wibox prefix, it is a template,
        -- not a widget instance.
        widget_template = {
            {
                {
                    {
                        {
                            id     = 'icon_role',
                            widget = wibox.widget.imagebox,
                        },
                        margins = 2,
                        widget  = wibox.container.margin,
                    },
                    {
                        id     = 'text_role',
                        widget = wibox.widget.textbox,
                    },
                    layout = wibox.layout.fixed.horizontal,
                },
                left  = 10,
                right = 10,
                widget = wibox.container.margin
            },
            id     = 'background_role',
            widget = wibox.container.background,
        },
    }

    -- [[[ Top Bar
    s.topbar = awful.wibar{
        screen = s,
        width = 1900,
        height = 23,
        position = "top",
        bg = gears.color.transparent
    }

    s.topbar.x = s.geometry.x + 10

    s.topbar:setup {
        layout = wibox.layout.align.horizontal,
        expand = "none",
        {
            layout = wibox.layout.fixed.horizontal,
            wibox.container.margin(
                wibox.widget {
                    shape = rounded_rect,
                    wibox.container.margin(s.mylayoutbox, dpi(4), dpi(4), dpi(4), dpi(4)),
                    bg = "#1c3740",
                    widget = wibox.container.background
                },
                dpi(6), dpi(6)
            ),
            wibox.container.margin (
                wibox.widget {
                    shape = rounded_rect,
                    wibox.container.margin(s.mytaglist, dpi(4), dpi(4), dpi(4), dpi(4)),
                    bg = "#1c3740",
                    widget = wibox.container.background
                },
                dpi(6), dpi(6)
            )
        },
        {
            layout = wibox.layout.fixed.horizontal,
            s.mytasklist
        },
        {
            layout = wibox.layout.fixed.horizontal,
            wibox.container.margin (
                wibox.widget {
                    shape = rounded_rect,
                    wibox.container.margin(mytextclock, dpi(4), dpi(4), dpi(4), dpi(4)),
                    bg = "#012355",
                    fg = "#ffffff",
                    widget = wibox.container.background,
                },
                dpi(6), dpi(6)
            )
        }
    }
    require("wibox.statusCenterAttach"):new():attach(mytextclock, s)
    -- ]]]
end)
