# Mimogear

> **Mimogear** is a complete web development boilerplate for developing static sites. Packed inside Mimogear you'll find [Gulp](https://gulpjs.com/), [Sass](https://sass-lang.com/), and [Pug](https://pugjs.org/api/getting-started.html) boilerplates to get you started. Newcomers and professionals alike will feel right at home with a solid start for any static site! Just run `gulp` and get building!

## Highlights

<table>
  <tr>
    <th>Feature</th>
    <th>Summary</th>
  </tr>
  <tr>
    <td>Gulp Boilerplate</td>
    <td><a href="http://gulpjs.com/">Gulp</a> intelligently handles compilation and optimization tasks based on the environment for speedier Sass, Pug, and js development.</td>
  </tr>
  <tr>
    <td>Responsive Sass Boilerplate</td>
    <td>A flexible <a href="http://sass-lang.com/">Sass</a> boilerplate with various <a href="https://github.com/mimoduo/mimogear/tree/master/src/sass/utilities">mixins</a>, a simpler form of BEM, and a platform-agnostic approach.</td>
  </tr>
  <tr>
    <td>Base <a href="https://pugjs.org/api/getting-started.html">Pug</a> Template Boilerplate</td>
    <td>Generate HTML files faster with Pug's condensed syntax, a highly structured HTML template setup, markdown support, and starter partials.</td>
  </tr>
  <tr>
    <td>Optional Javascript Modules</td>
    <td>Completely optional javascript modules to create slideshows, lightboxes, triggers, and elements on the fly.</td>
  </tr>
  <tr>
    <td>Performance Optimizations</td>
    <td>Gulp will minify CSS, concatenate & uglify javascript, and optimize images to produce performant static pages.</td>
  </tr>
  <tr>
    <td>Live Reloading</td>
    <td>Reloads the browser whenever you make a change to a file.</td>
  </tr>
  <tr>
    <td>Cross-device Synchronization</td>
    <td>BrowserSync synchronizes actions across devices for quicker testing.</td>
  </tr>
  <tr>
    <td><a href="http://mimoduo.github.io/mimogear/style-guide.html">Style Guide Generator</a></td>
    <td>A page for core HTML elements is created by default for easier site styling and future reference.</td>
  </tr>
  <tr>
    <td>Deployments Starter Kit</td>
    <td>Deploy your site to <a href="https://pages.github.com/">GitHub pages</a> and <a href="https://surge.sh/">surge</a> with a <a href="https://travis-ci.org/">Travis CI</a> starter kit.</td>
  </tr>
</table>

## Getting Started

Once you're ready and set up with [npm](https://docs.npmjs.com/getting-started/installing-node), whip out your terminal and enter in the following goodies:

```sh
git clone https://github.com/mimoduo/mimogear.git
cd mimogear
npm install gulp-cli -g
npm install
gulp
```

Your site will open up in a browser window automatically, gulp will begin watching your files, and Browsersync will automatically reload your changes. Check out /src/ to see your shiny new web development boilerplate!

**Once you're all set, there's documentation ready for you:**

* [Quickstart Guide](https://github.com/mimoduo/mimogear/tree/master/docs)
* [Deployment](https://github.com/mimoduo/mimogear/tree/master/docs/deployment)
* [Gulp](https://github.com/mimoduo/mimogear/tree/master/docs/gulp)
* [Javascript](https://github.com/mimoduo/mimogear/tree/master/docs/javascript)
* [CSS:Sass](https://github.com/mimoduo/mimogear/tree/master/docs/sass)
* [HTML:Pug](https://github.com/mimoduo/mimogear/tree/master/docs/pug)

## Share Your Sites Using Mimogear

*If you have built a site with Mimogear and you want to show the world your sweet site, feel free to create a pull request and add it to the list below*:

* [mimogear](http://mimoduo.github.io/mimogear/)
* [Your Site!](#)

# Thank You, Everyone!

**I hope you enjoy developing with Mimogear as much as I have enjoyed building it!** *Please share it if you love it!* This static site generator wouldn't be possible without all the help of my friends. They've contributed to every single aspect of this without knowing it ^w^ Most notably [Nick Hall](https://github.com/nhall) for being the best mentor in the world!
