/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  '/aliases': {
    get: {
      parameters: {
        query: {
          /** Only list aliases that are associated with the specified deployment. */
          deploymentId: string;
          /** Beginning index from where to get the aliases. */
          startAt?: string;
        };
      };
      responses: {
        /** Successful response. */
        200: {
          content: {
            'application/json': {
              metadata: components['schemas']['Pagination'];
              items: components['schemas']['Alias'][];
            };
          };
        };
        400: components['responses']['InvalidParamsError'];
        404: components['responses']['NotFound'];
      };
    };
    post: {
      responses: {
        /** Successful response. */
        201: {
          content: {
            'application/json': components['schemas']['Alias'];
          };
        };
        400: components['responses']['InvalidParamsError'];
      };
      /** Request payload. */
      requestBody: {
        content: {
          'application/json': {
            alias: string;
            target: string;
            override?: boolean;
          };
        };
      };
    };
  };
  '/aliases/{hostname}/{basePath}': {
    delete: {
      parameters: {
        path: {
          /** The hostname of the alias that should be deleted. */
          hostname: string;
          /** The basePath of the alias that should be deleted. If not present, defaults to `/`. */
          basePath?: string;
        };
      };
      responses: {
        /** Successful response. */
        204: never;
        400: components['responses']['InvalidParamsError'];
        404: components['responses']['NotFound'];
      };
    };
  };
  '/deployments': {
    get: {
      parameters: {
        query: {
          /** Beginning index from where to get the deployments. */
          startAt?: string;
        };
      };
      responses: {
        /** Successful response. */
        200: {
          content: {
            'application/json': {
              metadata: components['schemas']['Pagination'];
              items: components['schemas']['Deployment'][];
            };
          };
        };
      };
    };
    post: {
      responses: {
        /** Successful response. */
        201: {
          content: {
            'application/json': components['schemas']['DeploymentInitialized'];
          };
        };
      };
    };
  };
  '/deployments/{deploymentId}': {
    get: {
      parameters: {
        path: {
          /** The id of the deployment to get. */
          deploymentId: string;
        };
      };
      responses: {
        /** Successful response. */
        200: {
          content: {
            'application/json': components['schemas']['Deployment'];
          };
        };
        404: components['responses']['NotFound'];
      };
    };
    delete: {
      parameters: {
        path: {
          /** The id of the deployment to delete. */
          deploymentId: string;
        };
      };
      responses: {
        /** Deletion successfully requested. */
        200: {
          content: {
            'application/json': components['schemas']['Deployment'];
          };
        };
        /** Successful deletion. */
        204: never;
        400: components['responses']['InvalidParamsError'];
      };
    };
  };
}

export interface components {
  schemas: {
    Error: {
      status: number;
      code: string;
      message?: string;
    };
    Pagination: {
      next: string | null;
    };
    Alias: {
      id: string;
      deployment: string;
      createDate: string;
    };
    /** @enum {string} */
    DeploymentStatus:
      | 'INITIALIZED'
      | 'CREATE_IN_PROGRESS'
      | 'CREATE_COMPLETE'
      | 'CREATE_FAILED'
      | 'FINISHED'
      | 'DESTROY_IN_PROGRESS'
      | 'DESTROY_FAILED'
      | 'DESTROY_REQUESTED';
    DeploymentInitialized: {
      id: string;
      status: components['schemas']['DeploymentStatus'];
      uploadUrl: string;
      uploadAttributes: { [key: string]: unknown };
    };
    Deployment: {
      id: string;
      status: components['schemas']['DeploymentStatus'];
      /** Format: date-time */
      createDate: string;
      deploymentAlias?: string;
    };
  };
  responses: {
    /** The specified resource was not found. */
    NotFound: {
      content: {
        'application/json': components['schemas']['Error'];
      };
    };
    /** The validation of the parameters failed. */
    InvalidParamsError: {
      content: {
        'application/json': components['schemas']['Error'];
      };
    };
  };
}

export interface operations {}

export interface external {}
