# Contributing

Contributions are welcome!

As a general advice it is always a good idea to raise an [issue](https://github.com/milliHQ/terraform-aws-next-js/issues) before creating a new pull request.
This ensures that we don't have to reject pull requests that are not aligning with our roadmap and not wasting your valuable time.

## Contribution Prerequisites

The project is a monorepo which contains both the Terraform module and the CLI (`tf-next`) that is used to prepare the Next.js to be served by AWS Lambda written in Node.js.
It also contains components (`proxy` and `deploy-trigger`) that are directly published to AWS Lambda. They are also written in Node.js.

For the Terraform part you should have installed:

- [Terraform CLI](https://www.terraform.io/downloads.html) at 0.13+

For the CLI and the components you should have installed:

- [Node.js](https://nodejs.org/) at v14.0.0+
- [Yarn 1](https://classic.yarnpkg.com/) at v1.2.0+

## Development Workflow

### Terraform module

> **Note:** You should not make changes to the documentation of the **Requirements**, **Providers**, **Inputs** and **Outputs** sections in the `README.md` when contributing.
> The values there are auto generated by a GitHub action task once a PR is merged.

#### Codestyle

We use a [GitHub Action](https://github.com/milliHQ/terraform-aws-next-js/actions/workflows/lint.yml) to make sure that the committed code is properly formatted.
Before submitting a PR, you should make sure that the code is properly formatted.

You can do this by running the Terraform [`fmt` command](https://www.terraform.io/docs/cli/commands/fmt.html) in the root of the repository:

```sh
terraform fmt -recursive
```

### CLI and components

After cloning the repository, run `yarn` to fetch and install its dependencies.

## Testing

Automatic testing is only done for the worker component written in Node.js.
The Terraform module is **not** covered by automatic tests.

### Testing Terraform module

Since the Terraform module itself is not covered by automatic tests, testing has to be done manually.
The repository contains some examples in the [`examples/*`](https://github.com/milliHQ/terraform-aws-next-js/tree/main/examples) folder, that can be used to run a quick acceptance test against your own AWS account.

You may need to change a few settings in the `main.tf` file in the root of the example:

#### Use local development version of the module

To use the local development version instead of downloading it from the Terraform registry you have to change the source to the local path of the module.
When working with one of the examples zou can simply use the relative path to the root of the cloned repository:

```diff
module "tf_next" {
- source = "milliHQ/next-js/aws"
+ source = "../.."
  ...
}
```

#### Use local build of the components

Instead of downloading the components from npm you can also specify the `debug_use_local_packages` to use the local version.
To do so, make sure that the components are built by running the following commands:

```sh
yarn --cwd packages/proxy build
yarn --cwd packages/deploy-trigger build
```

After that you should have a `dist.zip` file in the root of each package.

To deploy the local built components, you also need to set `debug_use_local_packages = true`:

```diff
module "tf_next" {
  source = "../.."
  ...
+ debug_use_local_packages = true
}
```

### End-to-end (e2e) testing (CLI + components)

The end-to-end testing is only used for testing the the CLI (`tf-next`) and components (`proxy` and `deploy-trigger`).
A local environment of AWS Lambda is created for this to simulate a execution under the same conditions as it would run in a AWS data center.

#### 0. Prerequisites

- [Docker Desktop + Docker Compose](https://www.docker.com/products/docker-desktop)  
  (Docker Compose comes bundled with Docker Desktop on MacOS and Windows)
- [AWS SAM CLI](https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/serverless-sam-cli-install.html)

You should check after install if they are available from your command-line:

```sh
docker --version
# > Docker version 20.10.2, build 2291f61

docker-compose --version
# > docker-compose version 1.27.4, build 40524192

sam --version
# > SAM CLI, version 1.17.0
```

#### 1. Build the CLI & components

Before running a e2e-test make sure that the CLI and the components are built:

```sh
# CLI (Order is important here!)
yarn --cwd packages/runtime build
yarn --cwd packages/tf-next build

# Components
yarn --cwd packages/proxy build
yarn --cwd packages/deploy-trigger build
```

#### 2. Build the fixtures

The fixtures are real Next.js apps that need to be built with `tf-next build` before passing them to the e2e-test.
You can build all fixtures by running:

```sh
yarn test:e2e:prepare
```

#### 3. Local S3 instance

Before running the e2e-tests, make sure that the local S3 emulator from docker-compose is running.
From the root of the project run:

```sh
docker-compose up -d
```

#### 4. Run tests

After that you should be able to execute the e2e-tests locally by running the `test:e2e` task:

```sh
yarn test:e2e
```

The e2e-tests are executed from the `test/routes.test.ts` file.
Each fixture in `test/fixtures/*` contains a `probes.json` file that contains the actual test cases.
