<p align="center">
  <a href="https://github.com/MilanAryal/web-development-resources">
    <img width="64" height="64" alt="web development resources" src="https://user-images.githubusercontent.com/9361180/86557412-c37c3f00-bf75-11ea-8503-b42bd67646b2.png" />
  </a>
</p>
<h1 align="center">Web development resources</h1>
<p align="center"><i>A list of open source front-end tools and resources for web designers and developers.</i></p>
<p align="center"><br /></p>

## Table of contents

* [Wiki](#wiki)
* [Frameworks](#frameworks)
* [Mobile Web apps frameworks](#mobile-web-apps-frameworks)
* [Front-end components](#front-end-components)
* [HTML5 themes](#html5-themes)
* [HTML preprocessor](#html-preprocessor)
* [CSS preprocessor](#css-preprocessor)
* [JavaScript preprocessor](#javascript-preprocessor)
* [Sass framework](#sass-frameworks)
* [Node.js feature module and bundler](#nodejs-feature-module-and-bundler)
* [JavaScript library](#javascript-library)
* [Vanilla JavaScript plugins](#vanilla-javascript-plugins)
* [jQuery plugins](#jquery-plugins)
* [JavaScript compressor toolkit](#javascript-compressor-toolkit)
* [CSS library](#css-library)
* [SVG, PNG, and Font icons library](#svg-png-and-font-icons-library)
* [PNG, JPEG , GIF compressor toolkit](#PNG-JPEG-compressor-toolkit)
* [HTML forms](#html-forms)
* [Web tools](#web-tools)
* [CDN library](#cdn-library)
* [Browser compatibility wiki](#browser-compatibility-wiki)
* [Responsiveness testing tools](#responsiveness-testing-tools)
* [Performance testing tools](#performance-testing-tools)
* [Placeholder](#placeholder)
* [Mockup placeholder](#mockup-placeholder)
* [Website icons for browsers](#website-icons-for-browsers)
* [Free inspirational snippets and tutorials](#free-inspirational-snippets-and-tutorials)
* [CSS reference](#css-reference)
* [CSS tutorials](#css-tutorials)
* [Infographics](#infographics)
* [Design inspiration](#design-inspiration)
* [The type system](#the-type-system)
* [Webmaster tools](#webmaster-tools)
* [Package manager](#package-manager)
* [Jamstack](#jamstack)
* [List of lists of lists](#list-of-lists-of-lists)

---

## Wiki

| Name | Description |
|---|---|
| [W3C standards](https://www.w3.org/standards/) | W3C standards define an Open Web Platform for application development that has the unprecedented potential to enable developers to build rich interactive experiences, powered by vast data stores, that are available on any device. |
| [cssdb](https://cssdb.org/) | A comprehensive list of CSS features and their positions in the process of becoming implemented web standards. |
| [MDN Web Docs](https://developer.mozilla.org/en-US/) | Resources for developers, by developers. |
| [Google Web Developers](https://developers.google.com/web) | Build the next generation of web experiences. |
| [W3Schools](https://www.w3schools.com/) | Online web tutorials. |
| [CSS-Tricks](https://css-tricks.com/) | Daily articles about CSS, HTML, JavaScript, and all things related to web design and development. |
| [Smashing Magazine](https://www.smashingmagazine.com/) | For web designers and developers. |
| [WebGlossary.info](https://webglossary.info/) | Extensive glossary of web development and design terms. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Frameworks

| Name | Description |
|---|---|
| [HTML5 Boilerplate](https://html5boilerplate.com/) | The web's most popular front-end template. |
| [Bootstrap](http://getbootstrap.com/) | Bootstrap is the most popular HTML, CSS, and JS framework for developing responsive, mobile first projects on the web. |
| [Foundation](http://foundation.zurb.com/) | The most advanced responsive front-end framework in the world. |
| - | - |
| [Base](http://getbase.org/) | A Rock Solid, Responsive HTML/CSS Framework. |
| [Basscss](http://www.basscss.com/) | Low-level CSS toolkit. |
| [Bulma](http://bulma.io/) | A modern CSS framework based on Flexbox. |
| [Concise Framework](http://concisecss.com/) | A lightweight front-end framework that provides a number of great features without the bloat. |
| [Cardinal](http://cardinalcss.com/) | Cardinal is a modular, "mobile-first" CSS framework built with performance and scalability in mind. |
| [Furtive CSS](http://furtive.co/) | A forward-thinking, CSS micro-framework. |
| [Juiced](http://juicedcss.com/) | a Flexbox CSS Framework. |
| [Material Design Lite](http://www.getmdl.io/) | An implementation of Material Design components in vanilla CSS, JS, and HTML |
| [Materialize](http://materializecss.com/) | A modern responsive front-end framework based on Material Design. |
| [Photon](http://photonkit.com/) | The fastest way to build beautiful Electron apps using simple HTML and CSS. |
| [Primer CSS](https://primer.style/css/) | The GitHub Design Systems team builds and maintains Primer. |
| [Pure](http://purecss.io/)| A set of small, responsive CSS modules that you can use in every web project. |
| [Responsive](http://responsivebp.com/) | A powerful, accessible, developer friendly framework for building responsive websites. |
| [Semantic UI](http://semantic-ui.com/) | A development framework that helps create beautiful, responsive layouts using human-friendly HTML. |
| [Skel](https://github.com/n33/skel) | A lightweight responsive framework for the www. |
| [Skeleton](http://getskeleton.com/) | A dead simple, responsive boilerplate. |
| [Tailwind CSS](https://tailwindcss.com/) | A utility-first CSS framework for rapidly building custom designs. |
| [UIkit](http://getuikit.com/) | A lightweight and modular front-end framework for developing fast and powerful web interfaces. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Mobile Web apps frameworks

| Name | Description |
|---|---|
| [Onsen UI](https://onsen.io/) | The most beautiful and efficient way to develop HTML5 hybrid and mobile web apps. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Front-end components

| Name | Description |
|---|---|
| [Formstone](https://formstone.it/) | Formstone is a collection of front end components. |
| [Le Wagon UI components](https://lewagon.github.io/ui-components/) | - |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## HTML5 themes

| Name | Description |
|---|---|
| [Bootstrap Starter](https://bootstrapstarter.com/) | Free Bootstrap starter themes & templates to kickstart your project. |
| [HTML5 Blank WordPress Theme](http://html5blank.com/) | The best HTML5 WordPress boilerplate theme, noted by Adobe, Smashing Mag, .NET mag. |
| [HTML5 UP!](http://html5up.net/) | Responsive HTML5 and CSS3 site templates. |
| [Start Bootstrap](http://startbootstrap.com/) | A library of free to download Bootstrap themes and templates. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## HTML preprocessor

| Name | Description |
|---|---|
| [Haml](http://haml.info/) | HTML abstraction markup language |
| [Markdown](https://daringfireball.net/projects/markdown/) | A text-to-HTML conversion tool for web writers. |
| [Slim](http://slim-lang.com/) | A lightweight templating engine. |
| [Jade](http://jade-lang.com/) | Node template engine. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CSS preprocessor

| Name | Description |
|---|---|
| [LESS](http://lesscss.org/) | Node CSS pre-processor |
| [SCSS / Sass](http://sass-lang.com/) | The most mature, stable, and powerful professional grade CSS extension language in the world. |
| [Stylus](http://stylus-lang.com/) | Expressive, dynamic, robust, feature-rich CSS preprocessor. |
| [PostCSS](http://postcss.org/) | A tool for transforming CSS with JavaScript. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## JavaScript preprocessor

| Name | Description |
|---|---|
| [CoffeeScript](http://coffeescript.org/) | A little language that compiles into JavaScript. |
| [LiveScript](http://livescript.net/) | A language which compiles to JavaScript. |
| [TypeScript](https://www.typescriptlang.org/) | JavaScript that scales. |
| [Babel](https://babeljs.io/) | The compiler for writing next generation JavaScript. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Sass frameworks

| Name | Description |
|---|---|
| [Bourbon](http://bourbon.io/) | A simple and lightweight mixin library for Sass. |
| [Compass](http://compass-style.org/) | An open-source CSS Authoring Framework. |
| [Susy](http://susy.oddbird.net/) | Custom layout engine for Sass. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## [Node.js](http://nodejs.org/) feature module and bundler

| Name | Description |
|---|---|
| [npm](https://www.npmjs.com/) | The package manager for JavaScript. |
| - | - |
| [Browserify](http://browserify.org/) | browser-side `require()` the node way |
| [Grunt](http://gruntjs.com/) | The JavaScript task runner |
| [Gulp](http://gulpjs.com/) | The streaming build system |
| [Parcel](https://parceljs.org/) | Blazing fast, zero configuration web application bundler. |
| [Rollup](https://rollupjs.org/guide/en/) | Next-generation ES module bundler. |
| [Webpack](https://webpack.js.org/) | A bundler for javascript and friends. |
| - | - |
| [ESLint](https://eslint.org/) | Find and fix problems in your JavaScript code. |
| [Prettier](https://prettier.io/) | Prettier is an opinionated code formatter. |
| [stylelint](https://stylelint.io/) | A mighty, modern linter that helps you avoid errors and enforce conventions in your styles. |
| [commitlint](https://commitlint.js.org/) | 📓 Lint commit messages |
| [linkinator](https://github.com/JustinBeckwith/linkinator) | A super simple site crawler and broken link checker. |
| - | - |
| [Browsersync](https://github.com/Browsersync/browser-sync) | Keep multiple browsers & devices in sync when building websites. |
| [http-server](https://github.com/http-party/http-server) | A simple, zero-configuration command-line http server. |
| [serve](https://github.com/zeit/serve) | Static file serving and directory listing. |
| [server.js](https://github.com/franciscop/server) | Simple and powerful server for Node.js |
| - | - |
| [Chokidar ](https://github.com/paulmillr/chokidar) | An efficient wrapper around node.js fs.watch / fs.watchFile / FSEvents. |
| [nodemon](https://github.com/remy/nodemon) | Monitor for any changes in your node.js application and automatically restart the server - perfect for development. |
| [onchange](https://github.com/Qard/onchange) | Use glob patterns to watch file sets and run a command when anything is added, changed or deleted. |
| - | - |
| [Concurrently](https://github.com/kimmobrunfeldt/concurrently) | Run commands concurrently. Like `npm run watch-js & npm run watch-less` but better. |
| [npm-run-all](https://github.com/mysticatea/npm-run-all) | A CLI tool to run multiple npm-scripts in parallel or sequential. |
| [Parallel Shell](https://github.com/darkguy2008/parallelshell) | A super simple npm module to run shell commands in parallel. |
| - | - |
| [Concat](https://github.com/gko/concat) | Concatenate multiple files. |
| [cpy-cli](https://github.com/sindresorhus/cpy-cli) | Copy files for node. |
| [del](https://github.com/sindresorhus/del) | Delete files and directories using globs. |
| [express](https://github.com/expressjs/express) | Fast, unopinionated, minimalist web framework for node. |
| [node-sass](https://github.com/sass/node-sass) | It allows you to natively compile .scss files to css at incredible speed and automatically via a connect middleware. |
| [npm-check-updates](https://github.com/raineorshine/npm-check-updates) | Upgrades your package.json dependencies to the latest versions, ignoring specified versions. |
| [PurgeCSS](https://purgecss.com/) | PurgeCSS is a tool to remove unused CSS. |
| [rimraf](https://github.com/isaacs/rimraf) | The UNIX command `rm -rf` for node. |
| - | - |
| [Bower](https://bower.io/) [*Depreciated*] | A package manager for the web. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## JavaScript library

| Name | Description |
|---|---|
| [jQuery](http://jquery.com/) | The write less, do more, JavaScript library. |
| [Modernizr](https://modernizr.com/) | Modernizr tells you what HTML, CSS and JavaScript features the user’s browser has to offer. |
| - | - |
| [Bliss.js](https://blissfuljs.com/) | Want to use Vanilla JS but find native APIs a bit unwieldy? Bliss is for you. |
| [Umbrella JS](https://umbrellajs.com/) | ☔ Lightweight javascript library for DOM manipulation and events. |
| [Zepto JS](https://zeptojs.com/) | Zepto is a minimalist JavaScript library for modern browsers with a largely jQuery-compatible API. |
| [Cash JS](https://github.com/fabiospampinato/cash) | An absurdly small jQuery alternative for modern browsers. |
| [Chibi JS](https://github.com/kylebarrow/chibi) | A tiny JavaScript micro-library |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## [Vanilla JavaScript](https://plainjs.com/) plugins

| Name | Description |
|---|---|
| [Anchor.js](http://bryanbraun.github.io/anchorjs/) | Add deep anchor links to your docs. |
| [Anime.js](https://animejs.com/) | Anime.js (/ˈæn.ə.meɪ/) is a lightweight JavaScript animation library with a simple, yet powerful API. It works with CSS properties, SVG, DOM attributes and JavaScript Objects. |
| [Chart.js](http://www.chartjs.org/) | Simple, clean and engaging charts for designers and developers. |
| [Chartist.js](http://gionkunz.github.io/chartist-js/) | Simple responsive charts.|
| (a) [Darkmode.js](https://github.com/sandoche/Darkmode.js) <br> (b) [Dark Mode Switch](https://github.com/coliff/dark-mode-switch) | 🌓 Add a dark-mode / night-mode to your website in a few seconds |
| [Velocity.js](http://julian.com/research/velocity/) | Accelerated JavaScript animation. |
| [Favico.js](http://lab.ejci.net/favico.js/) | Make use of your favicon with badges, images or videos. |
| [FluidVids.js](https://github.com/toddmotto/fluidvids) | Fluid width (responsive) videos module, 1KB, custom players, dynamic elements/XHR support. |
| [Highlight.js](https://github.com/highlightjs/highlight.js) | Highlight.js is a syntax highlighter written in JavaScript. |
| [Headroom.js](http://wicky.nillia.ms/headroom.js/) | Hide your header until you need it. |
| [Holder.js](http://holderjs.com/) | Client side image placeholders. |
| [lazysizes.js](https://github.com/aFarkas/lazysizes) | High performance and SEO friendly lazy loader for images (responsive and normal), iframes and more. |
| [littlefoot.js](https://github.com/goblindegook/littlefoot) | Littlefoot is a lightweight JavaScript library that creates exceptional footnotes. |
| [lunr.js](http://lunrjs.com/) | Simple full-text search in your browser. |
| [NProgress.js](http://ricostacruz.com/nprogress/) | A nanoscopic progress bar. |
| [Pace.js](https://github.com/HubSpot/pace) | An automatic web page progress bar. |
| [Prism.js](https://github.com/PrismJS/prism/) | Prism is a lightweight, robust, elegant syntax highlighting library. |
| [react-burger-menu](https://github.com/negomi/react-burger-menu) | An off-canvas sidebar React component with a collection of effects and styles using CSS transitions and SVG path animations. |
| [Responsive nav](http://responsive-nav.com/) | Responsive navigation plugin without library dependencies and with fast touch screen support. |
| [Slideout.js](https://slideout.js.org/) | A touch slideout navigation menu for your mobile web apps. |
| [Smartcrop.js](https://github.com/jwagner/smartcrop.js/) | Content aware image cropping. |
| [Tabella.js](http://iliketomatoes.github.io/tabellajs/) | Responsive table. |
| [Tether](http://github.hubspot.com/tether/) | A JavaScript library for efficiently making an absolutely positioned element stay next to another element on the page. |
| [Tippy.js](https://atomiks.github.io/tippyjs/) | A lightweight, vanilla JavaScript tooltip library. |
| [Tooltip.js](https://github.com/HubSpot/tooltip) | Tooltip.js is a Javascript and CSS library for creating styleable tooltips. |
| [Turbolinks](https://github.com/turbolinks/turbolinks) | Turbolinks® makes navigating your web application faster. |
| [Typeset](https://blot.im/typeset/) | A ty­po­graphic pre-proces­sor for your HTML which uses zero client-side JavaScript. |
| [ZeroClipboard.js](http://zeroclipboard.org/) | An easy way to copy text to the clipboard. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## [jQuery](http://jquery.com/) plugins

| Name | Description |
|---|---|
| [Formstone - Background](https://formstone.it/components/background/) | A jQuery plugin for full-frame image and video backgrounds.|
| [Bigfoot.js](http://www.bigfootjs.com/) | A jQuery plugin for empowering footnotes. |
| [bigSlide.js](https://ascott1.github.io/bigSlide.js/) | A tiny slide panel navigation jQuery plugin with big dreams. |
| [FitVids.js](http://fitvidsjs.com/) | A lightweight, easy-to-use jQuery plugin for fluid width video embeds. |
| [fullPage.js](http://alvarotrigo.com/fullPage/) | One page scroll sections site plugin. |
| [Lazy Load](http://www.appelsiini.net/projects/lazyload) | Lazy Load is delays loading of images in long web pages. |
| [Lity](http://sorgalla.com/lity/) | A ultra-lightweight, accessible and responsive lightbox plugin which supports images, iframes and inline content out of the box. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## JavaScript compressor toolkit

| Name | Description |
|---|---|
| [Terser](https://github.com/terser/terser) | 🗜 JavaScript parser, mangler and compressor toolkit for ES6+ |
| [UglifyJS](https://github.com/mishoo/UglifyJS2) | UglifyJS is a JavaScript parser, minifier, compressor and beautifier toolkit. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CSS library

| Name | Description |
|---|---|
| [Animate.css](http://daneden.github.io/animate.css/) | A cross-browser library of CSS animations. |
| [CSSgram](https://una.im/CSSgram/) | A tiny `(<1kb gzipped!)` library for recreating Instagram filters with CSS filters and blend modes. |
| [CSS Filters Playground](http://bennettfeely.com/filters/) | Play with the new CSS3 Filter Effects. |
| [EQCSS](http://elementqueries.com/) | A spec for a container-style element query syntax in CSS. |
| [Flex Grid](http://flexboxgrid.com/) | A grid system based on the flex display property. |
| [Mastering the `:nth-child`](http://nthmaster.com/) | CSS3 pseudo classes and :nth-child ranges. |
| [Eric Meyer CSS reset](http://meyerweb.com/eric/tools/css/reset/) | Eric Meyer CSS reset |
| [Graaf](http://graaf.space/) | Pure CSS grid overlays for designing. |
| [Hamburgers](https://jonsuh.com/hamburgers/) | Tasty CSS-animated Hamburgers. |
| [Mueller Grid System](http://muellergridsystem.com/) | A modular grid system for responsive/adaptive and non–responsive layouts, based on Compass. |
| [Normalize.css](http://necolas.github.io/normalize.css/) | A modern, HTML5-ready alternative to CSS resets. |
| [RTLCSS](http://rtlcss.com/) | Framework for converting Left-To-Right (LTR) Cascading Style Sheets(CSS) to Right-To-Left (RTL). |
| [Toast](http://daneden.github.io/Toast/) | Insane, no-nonsense CSS grid. |
| [CSSWand](https://www.csswand.dev/)|It’s really just a handful of simple, pure CSS-based animation library|
| [Water.css](https://watercss.netlify.app/)|collection of styles to make simple websites|
| [Raisin CSS](https://github.com/tretapey/raisincss)|An Utility CSS only library.|
| [Spectrum CSS](https://github.com/adobe/spectrum-css)|standard CSS implementation of the Spectrum design language for internal and 3rd party|
| [Box-shadows.css](https://madeas.github.io/box-shadows/)|Mianly based on box shadows|

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## SVG, PNG, and Font icons library

| Name | Description |
|---|---|
| [How to work with SVG icons](https://fvsch.com/code/svg-icons/how-to/) | - |
| [Align SVG Icons to Text and Say Goodbye to Font Icons](https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4) | - |
| - | - |
| [Bootstrap Icons](https://icons.getbootstrap.com/) | Bootstrap Icons are SVGs, so they scale quickly and easily and can be styled with CSS. While they're built for Bootstrap, they'll work in any project. |
| [Creative Commons license icons](https://creativecommons.org/about/downloads/) | Download SVG, EPS, and PNG Creative Commons license icons to use in your site. |
| [Flaticon](http://www.flaticon.com/) | The largest database of free icons available in PNG, SVG, EPS, PSD and BASE 64 formats. |
| [Feather](https://feathericons.com/) | Feather is a collection of simply beautiful open source icons. |
| [Font Awesome](http://fontawesome.io/) | The iconic font and CSS toolkit. |
| [Font-Awesome-SVG-PNG](https://github.com/encharm/Font-Awesome-SVG-PNG) | Font Awesome split to individual SVG and PNG files of different sizes along with Node.JS based generator. |
| [FontForge](https://fontforge.github.io/en-US/) | A free and open source font editor brought to you by a community of fellow type lovers. |
| [Fontello](http://fontello.com/) | An easy way to create a custom icon font for your site. Select images from our large collection, and make a webfont pack with one click. |
| [IcoMoon](https://icomoon.io/) | IcoMoon provides a package of vector icons, along with a free HTML5 app for making custom icon fonts or SVG sprites. Browse among thousands of pixel perfect icons or import your own vectors. |
| [Ionicons](http://ionicons.com/) | The premium icon font for [Ionic Framework](http://ionicframework.com/). |
| [Material Design Icons](https://materialdesignicons.com/) | View all the Material Design icons and more from the community. |
| [The Big List of Flat Icons & Icon Fonts](https://css-tricks.com/flat-icons-icon-fonts/) by CSS-Triks | There are many such roundups. This one is mine. |
| [Noun Project - Icons for everything](https://thenounproject.com/) | Nearly a million curated icons, created by a global community. |
| [Octicons](https://octicons.github.com/) | A scalable icon font handcrafted with &lt;3 by GitHub. |
| [Perfect Icons](http://perfecticons.com/) | The easiest way to create resolution independent social icons. |
| [Simple Icons](https://simpleicons.org/) | Free SVG icons for popular brands. |
| [svg-icon](https://leungwensen.github.io/svg-icon/) | An ultimate SVG icons collection DONE RIGHT. |
| [SVG Icons](http://svgicons.sparkk.fr/) | Ready to use SVG icons for the web. |
| [Vector Icons Roundup](https://tagliala.github.io/vectoriconsroundup/) | A side-by-side comparison between popular icon fonts. |
| [We Love Icon Fonts](http://weloveiconfonts.com/) | A free & open source icon fonts hosting service for testing purposes. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## PNG, JPEG, GIF compressor toolkit

| Name | Description |
|---|---|
| [TinyJPG](https://tinyjpg.com/) | Smart WebP, JPEG and PNG compression |
| [Compress PNG](https://compresspng.com/) | - |
| [Compress JPEG](https://compressjpeg.com/) | - |
| [Compress GIF](https://compressgif.com/) | - |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## HTML forms

| Name | Description |
|---|---|
| [Chartspree](http://chartspree.io/) | Make charts in seconds. |
| [Formspree](https://formspree.io/) | Functional HTML forms for static sites. |
| [Gridspree](http://gridspree.io/) | Display your spreadsheet data however you like right on your static site with Google Spreadsheet. |
| [JotForm](http://www.jotform.com/) | Form builder |
| [WTF, forms?](http://wtfforms.com/) | Friendlier HTML form controls with a little CSS magic. Designed for IE9+, as well as the latest Chrome, Safari, and Firefox. |
| [Wufoo](http://www.wufoo.com/) | Online form builder with cloud storage database. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Web tools

| Name | Description |
|---|---|
| [Abstract API's](https://www.abstractapi.com/) | A suite of simple yet powerful utility API's for developers, such as email validation, user avatar generator, image compression, and more. All API's have a free version. |
| [AutoDraw](https://www.autodraw.com/) | Fast drawing for everyone. AutoDraw pairs machine learning with drawings from talented artists to help you draw stuff fast. |
| [Binary Translator](http://binarytranslator.com/) | Free binary code translator, translate binary code to text. |
| [Base16](https://github.com/chriskempson/base16) | An architecture for building themes based on carefully chosen syntax highlighting using a base of sixteen colors. |
| [Bootstrap 5 Cheat Sheet](https://bootstrap-cheatsheet.themeselection.com/) | An interactive list of Bootstrap 5 classes, variables, and mixins. |
| [Colors.css](https://github.com/mrmrs/colors) | Better default colors for the web. A collection of skin classes for faster prototyping and nicer looking sites. |
| [Color Hex Color Codes](https://www.color-hex.com/) | Color-hex gives information about colors including color models (RGB,HSL,HSV and CMYK), Triadic colors, monochromatic colors and analogous colors calculated in color page. |
| [Color Hunt](http://www.colorhunt.co/) | Curated collection of beautiful colors, updated daily. |
| [CSS3 Generator](http://css3generator.com/) | CSS3 classics |
| [CSSmatic](http://www.cssmatic.com/) | The ultimate CSS tools for web designers. |
| [Draw.io](http://draw.io/ ) | [Draw.io](http://diagrams.net/) is free online diagram software for making flowcharts, process diagrams, org charts, UML, ER and network diagrams. |
| [Flat Colors](http://flatcolors.net/) | Browse over 11,000 flat colors in over 2,300 flat color palettes. Copy them or download the `.ACO` file for use in Photoshop. |
| [Frontend Dogma frontend development tools](https://frontenddogma.com/tools/) | Curated web-based tools for website developers and owners, for analysis and exploration. |
| [Gradient Backgrounds](https://cssgradient.io/gradient-backgrounds/) | As a curated list of the best gradient websites across the internet, Gradient Backgrounds allows you to explore, try and choose from hundreds of beautiful blended color palettes. |
| [Styling Wizard: Google Maps APIs](https://mapstyle.withgoogle.com/) | Customize colors, roads, labels, and more. Then use your custom style in your Google Maps Platform project.|
| [Snazzy Maps](https://snazzymaps.com/) | A repository of different styles for Google Maps aimed towards web designers and developers. |
| [Solarized - Precision colors for machines and people](https://github.com/altercation/solarized) | Solarized is a sixteen color palette (eight monotones, eight accent colors) designed for use with terminal and gui applications. |
| [SRI Hash Generator](https://www.srihash.org/) | Use of SRI is recommended as a best-practice, whenever libraries are loaded from a third-party source. |
| [Superdomain](http://superdomain.io) | Check domain availability. |
| [Create LaTeX tables online](http://www.tablesgenerator.com/) | Quickly create even complex LaTeX tables with online generator - cells merging is supported together with borders editing. |
| [uiGradients](http://uigradients.com/) | A handpicked collection of beautiful colour gradients for designers and developers. |
| [Unminify](http://unminify.com/) | Free online tool to unminify (unpack, deobfuscate) JavaScript, CSS and HTML code, making it readable and pretty. |
| [Web Code Tools](http://webcodetools.com/) | CSS3, HTML5, Microdata, Open Graph and Twitter Card Generators |
| [What's My Screen Resolution](http://whatsmyscreenresolution.com/) | An Online tool to check screen resolution of any display device. |
| [WebGradients](https://webgradients.com/) | Free collection of background gradients that you can use as content backdrops in any part of your website. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CDN library

| Name | Description |
|---|---|
| [BootstrapCDN](http://www.bootstrapcdn.com/) | The recommended CDN for Bootstrap, Font Awesome and Bootswatch. |
| [cdnjs](https://cdnjs.com/) | The free and open source CDN for web related libraries to speed up your website!
| [CoralCDN](http://www.coralcdn.org/) | A free and open content distribution network based around peer-to-peer technologies, comprised of a world-wide network of web proxies and nameservers. |
| [FontCDN](http://fontcdn.org/) | A search tool for Google web fonts. |
| [Google Fonts](https://www.google.com/fonts) | Hundreds of free, open-source fonts optimized for the web. |
| [Google Hosted Libraries](https://developers.google.com/speed/libraries/) | A stable, reliable, high-speed, globally available content distribution network for the most popular, open-source JavaScript libraries. |
| [jsDelivr](http://www.jsdelivr.com/) | A free super-fast CDN for developers and webmasters. |
| [Microsoft Ajax CDN](http://www.asp.net/ajax/cdn) | Popular third party JavaScript libraries such as jQuery and enables you to easily add them to your Web applications. |
| [Open Source Software CDN](http://osscdn.com/) | Open source software CDN by MaxCDN. |
| [Yandex CDN](https://tech.yandex.ru/jslibs/) | Service hosts JavaScript libraries that provides site developers with access to the Yandex content delivery (CDN) and can handle a variety of open source JavaScript-frameworks and libraries from Yandex servers. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Browser compatibility wiki

| Name | Description |
|---|---|
| [Can I Use](http://caniuse.com/) | Check the browser compatibility of CSS3 and HTML5 properties. |
| [Should I Prefix](http://shouldiprefix.com/) | Simply show what prefixes are needed for a newer CSS property. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Responsiveness testing tools

| Name | Description |
|---|---|
| [Am I Responsive?](http://ami.responsivedesign.is/) | See how your site looks on desktop, laptop, ipad & iphone. |
| [BrowserStack](https://www.browserstack.com/) | Use the browser device tester and download Internet Explorer images for your VM. |
| [Deviceponsive](http://deviceponsive.com/) | Show a quick preview of your website's responsive to different device resolutions like Macbook, iPad, or iPhone. share this preview with your client. |
| [Responsively App](https://github.com/responsively-org/responsively-app) | A must-have devtool for web developers for quicker responsive web development. 🚀 |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Performance testing tools

| Name | Description |
|---|---|
| [Google PageSpeed Tools](https://developers.google.com/speed/pagespeed/) | The PageSpeed tools analyze and optimize your site following web best practices. |
| [WebPagetest](http://www.webpagetest.org/) | Run a free website speed test from multiple locations around the globe using real browsers and at real consumer connection speeds. |
| [Website speed test](http://tools.pingdom.com/) | Use this free Website Speed Test to analyze the load speed of your websites, and learn how to make them faster. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Placeholder

| Name | Description |
|---|---|
| [JSONPlaceholder](https://jsonplaceholder.typicode.com/) | Fake Online REST API for Testing and Prototyping |
| [Lorem Ipsum](https://lipsum.com/) | Lorem Ipsum is simply dummy text of the printing and typesetting industry. |
| [lorempixel](http://lorempixel.com/) | Placeholder images for every case. |
| [Placehold.it](https://placehold.it/) | A quick and simple image placeholder service. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Mockup placeholder

| Name | Description |
|---|---|
| [Placeit](https://placeit.net/) | The best one to drop your project in any device context. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Website icons for browsers

| Name | Description |
|---|---|
| [Favicon Generator](https://realfavicongenerator.net/) | Online Favicon Generator. For real.|
| [Build My Pinned Site](http://www.buildmypinnedsite.com/) | Online tool to create a custom Windows Start Screen tile for your site in less than a minute. |
| [Pinned site enhancements on Windows](https://msdn.microsoft.com/en-us/library/bg183312(v=vs.85).aspx) / [Creating custom tiles for IE11 websites](https://msdn.microsoft.com/en-us/library/dn455106(v=vs.85).aspx) | Setting up live tiles and notifications for Windows |
| [Configuring Web Applications for Apple](https://developer.apple.com/library/ios/documentation/AppleApplications/Reference/SafariWebContent/ConfiguringWebApplications/ConfiguringWebApplications.html) | Conceptual information and techniques on creating effective web content for Safari and WebKit using HTML and CSS. |
| [Installable Web Apps with the Web App Manifest in Chrome for Android](https://developers.google.com/web/updates/2014/11/Support-for-installable-web-apps-with-webapp-manifest-in-chrome-38-for-Android?hl=en) / [Manifest File Format](https://developer.chrome.com/extensions/manifest) | Use the web app manifest to control how your web app launches. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Free inspirational snippets and tutorials

| Name | Description |
|---|---|
| [CodeMyUI](http://codemyui.com/) | Handpicked code snippets you can use in your web projects. Find web design inspiration with code samples. |
| [CodyHouse](https://codyhouse.co/) | A free library of HTML, CSS, JS nuggets. |
| [Codrops](http://tympanus.net/codrops/) | Codrops is a web design and development blog that publishes articles and tutorials about the latest web trends, techniques and new possibilities. |
| [Moving to HTTPS](https://movingtohttps.com/) | Migrate from HTTP to HTTPS with ease. |
| [NavNav](http://navnav.co/) | A ton of CSS, jQuery, and JavaScript responsive navigation examples, demos, and tutorials from all over the web. |
| [Papersizes.io - The best resource for Paper Sizes](http://papersizes.io/) | A simple, free resource for finding the international standards for paper sizes in metric and imperial. |
| [PDF Candy](https://pdfcandy.com/) | Edit PDF files with PDF Candy - a free online PDF editor. Convert PDF to Word, PDF to JPG, merge PDF, split PDF, compress PDF, etc. |
| [Scotch](https://scotch.io/) | A web development blog discussing all things programming, development, web and life. |
| [Smashing Magazine](http://www.smashingmagazine.com/) | An online magazine for professional Web designers and developers, with a focus on useful techniques, best practices and valuable resources. |
| [W3Schools Online Web Tutorials](https://www.w3schools.com/) | The world's largest web developer site. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CSS reference

| Name |
|---|
| [Mozilla Web Docs](https://developer.mozilla.org/en-US/docs/Web/CSS) |
| [CSS Dev Docs](https://devdocs.io/css/) |
| [CSS properties index](https://meiert.com/en/indices/css-properties/) |
| [CSS Reference](https://cssreference.io/) |
| [CSS Reference - Codrops](https://tympanus.net/codrops/css_reference/) |
| **Layout**: |
| [Flexbox - CSS Tricks](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) |
| [CSS Grid - CSS Tricks](https://css-tricks.com/snippets/css/complete-guide-grid/) |
| [CSS Flexbox Playground by Gabi](https://codepen.io/enxaneta/pen/adLPwv) |
| [Flexbox Froggy](https://flexboxfroggy.com/) |
| [CSS Grid Garden](https://cssgridgarden.com/) |
| **CSS animations**: |
| [Using CSS Animation - MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Animations/Using_CSS_animations) |
| [Animation - CSS Tricks](https://css-tricks.com/almanac/properties/a/animation/) |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CSS tutorials

| Name | Description |
|---|---|
| [Browser safe fonts](http://www.ampsoft.net/webdesign-l/WindowsMacFonts.html) | Common fonts to all versions of Windows & Mac equivalents. |
| [CSS Font Stack](http://www.cssfontstack.com/) | A complete collection of web safe CSS font stacks. |
| [CSS outline property - outline: none and outline: 0](http://outlinenone.com/) | The CSS outline property is an accessibility requirement, yet often abused by many web designers, why do they do it? |
| [CSS Selector Reference](https://www.w3schools.com/cssref/css_selectors.asp) | In CSS, selectors are patterns used to select the element(s) you want to style. |
| [CSS Specificity](http://cssspecificity.com) | CSS Specificity. CSS specificity assigns a numerical representation of a selector in order to compare in case there are style conflicts. Web poster displays CSS specificity with icons from Stanley Kubrick's 'The Shining' film. |
| [Grid by Example](https://gridbyexample.com/) | Everything you need to learn CSS Grid Layout. |
| [Grid Garden](https://cssgridgarden.com/) | A game for learning CSS grid. |
| [Griddy](http://griddy.io/) | Learn the CSS Grid! |
| [Hash tag links that don't headbutt the browser window](https://css-tricks.com/hash-tag-links-padding/) | CSS-Tricks post by Chris Coyier. |
| [Learn CSS Grid](http://learncssgrid.com/) | A guide to learning CSS grid. |
| [Learn CSS Grid](http://jensimmons.com/post/feb-27-2017/learn-css-grid) | A lot of fantastic resources out there by Jen Simmons. |
| [Learn CSS Layout](http://learnlayout.com/) | This site teaches the CSS fundamentals that are used in any website's layout. |
| [Overriding the default text selection color with CSS](https://css-tricks.com/overriding-the-default-text-selection-color-with-css/) | CSS-Tricks post by Chris Coyier. |
| [Smarter link underlines for every website](https://eager.io/blog/smarter-link-underlines/) | Post by Adam Schwartz. |
| [What is the browser-default background color when selecting text?](https://stackoverflow.com/questions/16094837/what-is-the-browser-default-background-color-when-selecting-text) | Answer on Stack Overflow |
| [Why I switched from LESS to Sass?](http://hugogiraudel.com/2012/11/13/less-to-sass/) | Post by Hugo Giraudel. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Infographics

| Name | Description |
|---|---|
| [Home Office Posters](https://github.com/UKHomeOffice/posters) | Home Office repository of posters covering different topics - research, access needs, accessibility, design. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Design inspiration

| Name |
|---|
| [Admire The Web](http://www.admiretheweb.com/) |
| [Awwwards](http://www.awwwards.com/) |
| [Behance](https://www.behance.net/) |
| [Best Website Gallery](http://bestwebsite.gallery/) |
| [CodePen](http://codepen.io/) |
| [CSS Gallery](http://www.cssdsgn.com/) |
| [CSS Winner](http://www.csswinner.com/) |
| [Design Fridge](http://www.designfridge.co.uk/) |
| [DeviantArt](http://www.deviantart.com/) |
| [Dribble](https://dribbble.com/) |
| [Favourite Website Awards (FWA)](http://www.thefwa.com/) |
| [GoodUI](http://www.goodui.org/) | |
| [Google Design](https://design.google.com/) |
| [html inspiration](http://htmlinspiration.com/) |
| [Inspiration for Search UI Effects](https://tympanus.net/Development/SearchUIEffects/) |
| [One Page Love](https://onepagelove.com/) |
| [Nice One I Like](http://www.niceoneilike.com/) |
| [Siiimple](http://www.siiimple.com/) |
| [The Best Designs](https://www.thebestdesigns.com/) |
| [Very nice sites](http://www.verynicesites.com/) |
| [Web Design Inspirations](http://www.webdesign-inspiration.com/) |
| [webdesign - Tumblr Search](https://www.tumblr.com/search/webdesign) |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## The type system

| Name | Description |
|---|---|
| [Exploring Responsive Type Scales](https://medium.com/sketch-app-sources/exploring-responsive-type-scales-cf1da541be54) | Finding your (Appropriate, Multi-Device and Vertical) Rhythm |
| [Font Pair](https://fontpair.co/) | Font Pair helps designers pair Google Fonts together. Beautiful Google Font combinations and pairs. |
| [Generate Type Scales With Stackswell](https://medium.com/sketch-app-sources/generate-type-scales-with-stackswell-8cdc27a5fed9) | Save time with Stackswell’s latest release and create type systems in seconds! |
| [Material design type system](https://material.io/design/typography/the-type-system.html) | Use typography to present your design and content as clearly and efficiently as possible. |
| [Modular Scale](https://www.modularscale.com/) | Calculate, visualize, and learn about modular scales. |
| [Type Connection](http://www.typeconnection.com/) | Type Connection is a game that helps you learn how to pair typefaces. |
| [Typography for Developers](https://css-tricks.com/typography-for-developers/) | This is intended as a practical guide for developers to learn web typography. |
| [Typewolf](https://www.typewolf.com/) | What’s Trending in Type |
| [Type Scale - A Visual Calculator](https://type-scale.com/) | Preview and choose the right type scale for your project. Experiment with font size, scale and different webfonts. |
| [WhatFont - Chrome Extension](https://chrome.google.com/webstore/detail/whatfont/jabopobgcpjmedljpbcaablpmlmfcogm?hl=en) | The easiest way to identify fonts on web pages. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Webmaster tools

| Name | Description |
|---|---|
| [Schema.org](https://schema.org/) | A collaborative, community activity with a mission to create, maintain, and promote schemas for structured data on the Internet, on web pages, in email messages, and beyond. |
| [Microformats](http://microformats.org/wiki/Main_Page) | The simplest way to markup structured information in HTML. |
| [Understand how structured data works](https://developers.google.com/search/docs/guides/intro-structured-data) | This documentation describes which properties are required, recommended, or optional for structured data with special meaning to Google Search. |
| [Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool) by Google | Google structured data testing tool. |
| [PageSpeed Insights ](https://developers.google.com/speed/pagespeed/insights/) by Google | Make your web pages fast on all devices. |
| [JSON for Linking Data](https://json-ld.org/) | Data is messy and disconnected. JSON-LD organizes and connects it, creating a better Web. |
| [JSON-LD](https://en.wikipedia.org/wiki/JSON-LD) | Wiki |
| [Latitude and Longitude Finder](https://www.latlong.net/) | Latitude and Longitude are the units that represent the coordinates at geographic coordinate system. To make a search, use the name of a place, city, state, or address, or click the location on the map to find lat long coordinates. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Package manager

| Name | Description |
|---|---|
| [List of software package management systems](https://en.wikipedia.org/wiki/List_of_software_package_management_systems) | This is a list of software package management systems, categorized first by package format (binary, source code, hybrid) and then by operating system family. |
| [APT](https://en.wikipedia.org/wiki/APT_(software)) | Debian based Linux OS package manager. |
| [Yum](https://en.wikipedia.org/wiki/Yum_(software)) | Fedora based Linux OS package manager. |
| [Homebrew](https://en.wikipedia.org/wiki/Homebrew_(package_manager)) | [Homebrew](https://brew.sh/) is a package management system that simplifies the installation of software on Apple's macOS operating system and Linux. |
| [winget](https://en.wikipedia.org/wiki/Windows_Package_Manager) | The [Windows Package Manager](https://docs.microsoft.com/en-us/windows/package-manager/) (aka winget) is a free and open-source package manager designed for Microsoft Windows 10. |
| [Chocolatey](https://en.wikipedia.org/wiki/NuGet#Chocolatey) | [Chocolatey](https://chocolatey.org/) is a machine-level package manager and installer for software packages, built for the Windows platform. |
| goenv | [goenv](https://github.com/syndbg/goenv) aims to be as simple as possible and follow the already established successful version management model of pyenv and rbenv. |
| [npm](https://en.wikipedia.org/wiki/Npm_(software)) | [npm](https://www.npmjs.com/) (originally short for Node Package Manager) is a package manager for the JavaScript programming language. |
| nodenv | Use [nodenv](https://github.com/nodenv/nodenv) to pick a Node version for your application and guarantee that your development environment matches production. |
| pyenv | [pyenv](https://github.com/pyenv/pyenv) lets you easily switch between multiple versions of Python. |
| [yarn](https://en.wikipedia.org/wiki/Npm_(software)#Alternatives) | [yarn](https://yarnpkg.com/) is a alternative to npm. |
| [rvm](https://en.wikipedia.org/wiki/Ruby_Version_Manager) | [RVM](https://rvm.io/) is a command-line tool which allows you to easily install, manage, and work with multiple ruby environments from interpreters to sets of gems. |
| rbenv | Use [rbenv](https://github.com/rbenv/rbenv) to pick a Ruby version for your application and guarantee that your development environment matches production. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## Jamstack

| Name | Description |
|---|---|
| [Netlify ](https://www.netlify.com/) | Deploy modern static websites with Netlify. Get CDN, Continuous deployment, 1-click HTTPS, and all the services you need. Get started for free. |
| [StaticGen](https://www.staticgen.com/) | Top open-source static site generators list. |
| [Staticman](https://staticman.net/) | Staticman is a Node.js application that receives user-generated content and uploads it as data files to a GitHub and/or GitLab repository. |
| [Gitalk](https://gitalk.github.io/) | A modern comment component based on Github Issue and Preact. |
| [utterances ](https://utteranc.es/) | A lightweight comments widget built on GitHub issues. Use GitHub issues for blog comments, wiki pages and more! |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## CheatSheet😎

| Name |
|---|
| [tldr pages](https://tldr.sh/) |
| [tldr InBrowser.App](https://tldr.inbrowser.app/) |
| [tldr-book.pdf](https://tldr.sh/assets/tldr-book.pdf) |
| [Brew basic commands](https://devsheet.com/code-snippet/brew-basic-commands/) - Devsheet |
| [cheat.sh](https://cheat.sh/) |
| [Devhints](https://devhints.io/) |
| [Homebrew cheatsheet](https://devhints.io/homebrew) |
| [Manual GitHub CLi](https://cli.github.com/manual/) |
| [Markdown Cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet) |
| [github-cheat-sheet](https://github.com/tiimgreen/github-cheat-sheet) |
| [cheatsheet.md](https://cheatsheet.md/) |
| [Octonator on Twitter: "Add .pibb to the end of any Gist URL in order to get the HTML only version suitable for embedding in any other site. http://t.co/HYtfQBM2DO" / Twitter](https://twitter.com/octonator/status/459370937344086016) |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>

## List of lists of lists

| Name | Description |
|---|---|
| [56 Unique Lorem Ipsum Generators](https://mashable.com/2013/07/11/lorem-ipsum/) | Spice up your filler text and design projects with these hilarious lorem ipsum generators. |
| [Abstract Guide to HTTP Status Codes](https://www.abstractapi.com/http-status-codes) | A list and explanation of HTTP Status Codes |
| [Awesome](https://github.com/sindresorhus/awesome) | A curated list of awesome lists. |
| [Awesome Awesomeness](https://github.com/bayandin/awesome-awesomeness) | A curated list of amazingly awesome awesomeness. |
| [Awesome Awesome](https://github.com/emijrp/awesome-awesome) | A curated list of awesome curated lists of many topics. |
| [Bootstrap Resources](http://startbootstrap.com/bootstrap-resources/) by Start Bootstrap | A comprehensive list of Bootstrap and related resources. |
| [Bootstrap Snippets](https://startbootstrap.com/snippets/) by Start Bootstrap | A curated library of Bootstrap 4 code snippets, perfect for dropping into your project without downloading an entire theme! |
| [Design essentials, GitHub collections](https://github.com/collections/design-essentials) | This collection of design libraries are the best on the web, and will complete your toolset for designing stunning products. |
| [Design Resources For Developers](https://github.com/bradtraversy/design-resources-for-developers) | A curated list of FREE design & UI resources for developers including stock photos, templates, frameworks, UI Kits, online tools and much much more. |
| [GitHub - Open source showcases](https://github.com/showcases) | Browse popular repositories based on the topic that interests you most. |
| [Gradient Backgrounds](https://cssgradient.io/gradient-backgrounds/) | As a curated list of the best gradient websites across the internet, Gradient Backgrounds allows you to explore, try and choose from hundreds of beautiful blended color palettes. |
| [JavaScript Plugins Repository](https://plainjs.com/javascript/plugins/) | Vanilla JS tools for writing powerful web applications without jQuery. |
| [Javascript Territory](http://jster.net/) | JSter Javascript catalog. |
| [JavaScripting](http://www.javascripting.com/) | The database of JavaScript libraries, frameworks, and plugins. |
| [Libraries.io](https://libraries.io/) | The Open Source Discovery Service. |
| [List of HTTP status codes](https://en.wikipedia.org/wiki/List_of_HTTP_status_codes) | A list of Hypertext Transfer Protocol (HTTP) response status codes. |
| [Social Share URLs](https://github.com/bradvin/social-share-urls#readme) | This project is intended to help you integrate sharing on social media within your code. |
| [Stock photos that don't suck](https://medium.com/@dustin/stock-photos-that-dont-suck-62ae4bcbe01b) | A list of places to find the best free stock photos. |
| [Text editors, GitHub collections](https://github.com/collections/text-editors) | A showcase of some amazingly awesome open source editors. |
| [Unheap](http://www.unheap.com/) | A tidy repository of jQuery plugins classified in categories. |

<p align="right"><a href="#table-of-contents"><b>↥ Back to top</b></a></p>
