/*
 * fiwix/lib/ctype.c
 *
 * Copyright 2018, Jordi Sanfeliu. All rights reserved.
 * Distributed under the terms of the Fiwix License.
 */

#include <fiwix/ctype.h>

unsigned char _ctype[] = {
	0,
	_C,		/* ^@   0x00 (NUL '\0') */
	_C,		/* ^A   0x01 (SOH) */
	_C,		/* ^B   0x02 (STX) */
	_C,		/* ^C   0x03 (ETX) */
	_C,		/* ^D   0x04 (EOT) */
	_C,		/* ^E   0x05 (ENQ) */
	_C,		/* ^F   0x06 (ACK) */
	_C,		/* ^G   0x07 (BEL '\a') */
	_C,		/* ^H   0x08 (BS  '\b') */
	_C | _S,	/* ^I   0x09 (HT  '\t') */
	_C | _S,	/* ^J   0x0A (LF  '\n') */
	_C | _S,	/* ^K   0x0B (VT  '\v') */
	_C | _S,	/* ^L   0x0C (FF  '\f') */
	_C | _S,	/* ^M   0x0D (CR  '\r') */
	_C,		/* ^N   0x0E (SO) */
	_C,		/* ^O   0x0F (SI) */
	_C,		/* ^P   0x10 (DLE) */
	_C,		/* ^Q   0x11 (DC1) */
	_C,		/* ^R   0x12 (DC2) */
	_C,		/* ^S   0x13 (DC3) */
	_C,		/* ^T   0x14 (DC4) */
	_C,		/* ^U   0x15 (NAK) */
	_C,		/* ^V   0x16 (SYN) */
	_C,		/* ^W   0x17 (ETB) */
	_C,		/* ^X   0x18 (CAN) */
	_C,		/* ^Y   0x19 (EM) */
	_C,		/* ^Z   0x1A (SUB) */
	_C,		/* ^[   0x1B (ESC) */
	_C,		/* ^\   0x1C (FS) */
	_C,		/* ^]   0x1D (GS) */
	_C,		/* ^^   0x1E (RS) */
	_C,		/* ^_   0x1F (US) */
	_S,		/* ' '  0x20 */
	_P,		/* '!'  0x21 */
	_P,		/* '"'  0x22 */
	_P,		/* '#'  0x23 */
	_P,		/* '$'  0x24 */
	_P,		/* '%'  0x25 */
	_P,		/* '&'  0x26 */
	_P,		/* '''  0x27 */
	_P,		/* '('  0x28 */
	_P,		/* ')'  0x29 */
	_P,		/* '*'  0x2A */
	_P,		/* '+'  0x2B */
	_P,		/* ','  0x2C */
	_P,		/* '-'  0x2D */
	_P,		/* '.'  0x2E */
	_P,		/* '/'  0x2F */
	_N,		/* '0'  0x30 */
	_N,		/* '1'  0x31 */
	_N,		/* '2'  0x32 */
	_N,		/* '3'  0x33 */
	_N,		/* '4'  0x34 */
	_N,		/* '5'  0x35 */
	_N,		/* '6'  0x36 */
	_N,		/* '7'  0x37 */
	_N,		/* '8'  0x38 */
	_N,		/* '9'  0x39 */
	_P,		/* ':'  0x3A */
	_P,		/* ';'  0x3B */
	_P,		/* '<'  0x3C */
	_P,		/* '='  0x3D */
	_P,		/* '>'  0x3E */
	_P,		/* '?'  0x3F */
	_P,		/* '@'  0x40 */
	_U | _X,	/* 'A'  0x41 */
	_U | _X,	/* 'B'  0x42 */
	_U | _X,	/* 'C'  0x43 */
	_U | _X,	/* 'D'  0x44 */
	_U | _X,	/* 'E'  0x45 */
	_U | _X,	/* 'F'  0x46 */
	_U,		/* 'G'  0x47 */
	_U,		/* 'H'  0x48 */
	_U,		/* 'I'  0x49 */
	_U,		/* 'J'  0x4A */
	_U,		/* 'K'  0x4B */
	_U,		/* 'L'  0x4C */
	_U,		/* 'M'  0x4D */
	_U,		/* 'N'  0x4E */
	_U,		/* 'O'  0x4F */
	_U,		/* 'P'  0x50 */
	_U,		/* 'Q'  0x51 */
	_U,		/* 'R'  0x52 */
	_U,		/* 'S'  0x53 */
	_U,		/* 'T'  0x54 */
	_U,		/* 'U'  0x55 */
	_U,		/* 'V'  0x56 */
	_U,		/* 'W'  0x57 */
	_U,		/* 'X'  0x58 */
	_U,		/* 'Y'  0x59 */
	_U,		/* 'Z'  0x5A */
	_P,		/* '['  0x5B */
	_P,		/* '\'  0x5C */
	_P,		/* ']'  0x5D */
	_P,		/* '^'  0x5E */
	_P,		/* '_'  0x5F */
	_P,		/* '`'  0x60 */
	_L | _X,	/* 'a'  0x61 */
	_L | _X,	/* 'b'  0x62 */
	_L | _X,	/* 'c'  0x63 */
	_L | _X,	/* 'd'  0x64 */
	_L | _X,	/* 'e'  0x65 */
	_L | _X,	/* 'f'  0x66 */
	_L,		/* 'g'  0x67 */
	_L,		/* 'h'  0x68 */
	_L,		/* 'i'  0x69 */
	_L,		/* 'j'  0x6A */
	_L,		/* 'k'  0x6B */
	_L,		/* 'l'  0x6C */
	_L,		/* 'm'  0x6D */
	_L,		/* 'n'  0x6E */
	_L,		/* 'o'  0x6F */
	_L,		/* 'p'  0x70 */
	_L,		/* 'q'  0x71 */
	_L,		/* 'r'  0x72 */
	_L,		/* 's'  0x73 */
	_L,		/* 't'  0x74 */
	_L,		/* 'u'  0x75 */
	_L,		/* 'v'  0x76 */
	_L,		/* 'w'  0x77 */
	_L,		/* 'x'  0x78 */
	_L,		/* 'y'  0x79 */
	_L,		/* 'z'  0x7A */
	_P,		/* '{'  0x7B */
	_P,		/* '|'  0x7C */
	_P,		/* '}'  0x7D */
	_P,		/* '~'  0x7E */
	_C,		/* DEL  0x7F */
};
