# -*- coding: utf-8 -*-
"""sid_vis.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1ev0UyYnCMoEK1802HPmekUOJA2KDCEju
"""

import pandas as pd
import numpy as np
import datetime
import plotly.express as px

data = pd.read_csv('MockData.csv')
data

def create_perc(data):
    perc = {'0-10':0,'10-20':0,'20-30':0,'30-40':0,'40-50':0,'50-60':0,'60-70':0,'70-80':0,'80-90':0,'90-100':0}
    score = data['overall_score']
    for i in score:
        if ((i >= np.percentile(score,0))&(i < np.percentile(score,10))):
            perc['0-10'] += 1
        elif ((i >= np.percentile(score,10))&(i < np.percentile(score,20))):
            perc['10-20'] += 1
        elif ((i >= np.percentile(score,20))&(i < np.percentile(score,30))):
            perc['20-30'] += 1
        elif ((i >= np.percentile(score,30))&(i < np.percentile(score,40))):
            perc['30-40'] += 1
        elif ((i >= np.percentile(score,40))&(i < np.percentile(score,50))):
            perc['40-50'] += 1
        elif ((i >= np.percentile(score,50))&(i < np.percentile(score,60))):
            perc['50-60'] += 1
        elif ((i >= np.percentile(score,60))&(i < np.percentile(score,70))):
            perc['60-70'] += 1
        elif ((i >= np.percentile(score,70))&(i < np.percentile(score,80))):
            perc['70-80'] += 1
        elif ((i >= np.percentile(score,80))&(i < np.percentile(score,90))):
            perc['80-90'] += 1
        elif ((i >= np.percentile(score,90))&(i < np.percentile(score,100))):
            perc['90-100'] += 1
    
    df_perc = pd.DataFrame.from_dict(perc,orient='index',columns=['count'])
    return df_perc

df_perc = create_perc(data)

df_perc

px.bar(df_perc,x=df_perc.index,y=df_perc['count'])

date_time_str = data['Date_Of_Joining'][0]
date_time_str = '2020-09-19 00:02:59.017733'

date_time_obj = datetime.datetime.strptime(date_time_str, '%Y-%m-%d %H:%M:%S.%f')
today_str = '2020-07-01 00:02:59.017733'
today_obj = datetime.datetime.strptime(today_str, '%Y-%m-%d %H:%M:%S.%f')

date_time_obj = date_time_obj.date()

today = datetime.datetime.now().date()
print(today.month)
print(today.day)
print(today.year)

date_time_obj - today

today.month == date_time_obj.month

doj = {'this_week':0,'next_week':0,'this_month':0,'next_month':0,'afterwards':0}

def create_doj(data):
    dates = data['Date_Of_Joining']
    for d in dates:
        d_obj = datetime.datetime.strptime(d,'%Y-%m-%d %H:%M:%S.%f').date()
        today_str = '2020-07-01 00:02:59.017733'
        today_obj = datetime.datetime.strptime(today_str, '%Y-%m-%d %H:%M:%S.%f').date()
        #today = datetime.datetime.now().date()
        diff = (d_obj - today_obj).days
        
        if ((diff>=0) & (diff<7)):
            print("appending to this week--->",diff)
            doj['this_week'] += 1
        elif ((diff>=7) & (diff<14)):
            print("appending to next week--->",diff)
            doj['next_week'] += 1
        elif ((today_obj.month == d_obj.month) & (diff>=14)):
            print("appending to this month--->",diff)
            doj['this_month'] += 1
        elif ((today_obj.month != d_obj.month) & (diff>=14)):
            print("appending to next month--->",diff)
            doj['next_month'] += 1
        else:
            print(d)
            doj['afterwards'] += 1

    df_doj = pd.DataFrame.from_dict(doj,orient='index',columns=['num_days'])

    return df_doj

data_doj = create_doj(data)

data_doj

px.bar(data_doj,x=data_doj.index,y=data_doj['num_days'])

