# -*- coding: utf-8 -*-
"""plots.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1bONLuloeNkIrLATxPG7hMCx2QsxHRJos
"""

import numpy as np
import pandas as pd
import plotly.express as px

df = pd.read_csv("MockData.csv")
df2 = df.drop(columns={"Unnamed: 0"})
df2 = df2.sort_values("Year_of_Experience",ascending=True)
df2 = df2.groupby(["Year_of_Experience"]).mean()
df2 = df2.reset_index()
fig = px.line(df2, x = "Year_of_Experience", y = "overall_score",title = 'Year Of Experience', labels = {'Year_of_Experience':'Year Of Experience','overall_score':'Average Score'},width=796,height=479)
fig.update_traces(line_color='#51cf66',line_width=4)
fig.show()

df = pd.read_csv("MockData.csv")
def func(raw_tags):
    raw_split = raw_tags[1:-1].split(',')
    num_tags = len(raw_split)
    tags_clean = []
    tags_clean.append(raw_split[0][1:-1])
    for i in range(1, num_tags):
       tags_clean.append(raw_split[i][2:-1])
    return tags_clean

df['Skill'] = df['Skill'].apply(lambda x: func(x))
from sklearn.preprocessing import MultiLabelBinarizer
mlb = MultiLabelBinarizer()
mlb.fit_transform(df['Skill'])
mlb.classes_
ski = pd.DataFrame(mlb.fit_transform(df['Skill']), columns=list(mlb.classes_))
num_skills = []
for col in list(ski.columns):
    num_skills.append(ski[col].value_counts().values[1])

f = px.bar( x=num_skills,y=ski.columns, orientation='h',title='Skills',width=748,height=560)
f.update_traces(marker_color='#51cf66', marker_line_color='#51cf66', marker_line_width=1.5)
f.show()

