<?php
must_have_access();
?>


<?php
$defined_taxes = mw()->tax_manager->get();
//d($defined_taxes);
?>

<?php if (!empty($defined_taxes)) : ?>


    <h3 class="font-weight-bold"><?php _e("Taxes list"); ?></h3>

    <div class="table-responsive">
        <table cellspacing="0" cellpadding="0" class="table">
            <thead>
            <tr>
                <th><?php _e('Tax name'); ?></th>
                <th><?php _e('Tax rate'); ?></th>
                <th><?php _e('Tax type'); ?></th>
                <th class="text-center" style="width: 200px;"><?php _e('Actions'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($defined_taxes as $item) : ?>
                <tr class="small">
                    <td><?php print $item['name']; ?></td>
                    <td>
                        <?php if ($item['type'] == 'percent'): ?>
                            <?php print $item['rate']; ?>%
                        <?php endif; ?>

                        <?php if ($item['type'] == 'fixed'): ?>
                            <?php print mw()->shop_manager->currency_format($item['rate']); ?>
                        <?php endif; ?>
                    </td>

                    <td><?php print $item['type']; ?></td>

                    <td class="text-center" style="padding-left: 0; padding-right: 0;">
                        <button onclick="mw_admin_edit_tax_item_popup('<?php print $item['id']; ?>')" class="btn btn-outline-primary btn-sm" title="Edit"><?php _e('Edit'); ?></button>
                        &nbsp;
                        <button onclick="mw_admin_delete_tax_item_confirm('<?php print $item['id']; ?>')" class="btn btn-outline-danger btn-sm" title="Delete"><?php _e('Delete'); ?></button>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php else: ?>

    <div class="text-center you-dont-have-any">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="350" height="350" version="1.1" x="0px" y="0px" viewBox="0 0 3710 3319.8" style="enable-background:new 0 0 3710 3319.8;" xml:space="preserve">
<style type="text/css">
    .st0{opacity:0.5;clip-path:url(#SVGID_00000110446909608776089630000013608320795668472983_);}
    .st1{fill:#FFFFFF;}
    .st2{opacity:0.5;clip-path:url(#SVGID_00000048486405898396656240000012541566550202127802_);}
    .st3{fill:#BFC8D6;}
    .st4{fill:#D8DEE8;}
    .st5{opacity:0.48;fill:#FFFFFF;}
    .st6{fill:url(#SVGID_00000028324489324529501240000005841886284661413776_);}
    .st7{fill:#97A6B7;}
    .st8{fill:url(#SVGID_00000008141411790739262250000008503908415074485424_);}
    .st9{fill:url(#SVGID_00000108303519703813552950000010301812927908594083_);}
    .st10{fill:url(#SVGID_00000139264496480186651280000000738618892168485822_);}
    .st11{fill:url(#SVGID_00000021801439355390045640000011253712349171914919_);}
    .st12{fill:url(#SVGID_00000163768395909280784810000012097050710450117791_);}
    .st13{opacity:0.3;fill:url(#SVGID_00000000202391178002816120000012615540732052857994_);}
    .st14{fill:url(#SVGID_00000033330458234664874710000017818762587729795480_);}
    .st15{fill:url(#SVGID_00000021081795818037695450000015676502271537042835_);}
    .st16{fill:url(#SVGID_00000121979544992209639120000013813856545253025706_);}
    .st17{fill:url(#SVGID_00000027595630361977401200000000664498479939294343_);}
    .st18{fill:url(#SVGID_00000023972698457902763990000002087363436929194389_);}
    .st19{opacity:0.3;fill:url(#SVGID_00000073694617833791638350000013299172807976025728_);}
    .st20{fill:url(#SVGID_00000178892213044992132220000005015834432530283698_);}
    .st21{fill:url(#SVGID_00000042699254649842075420000005605206360959552189_);}
    .st22{fill:url(#SVGID_00000140011520061130990260000005638404110192550297_);}
    .st23{fill:url(#SVGID_00000155138649321488278160000012740312859492561036_);}
    .st24{fill:url(#SVGID_00000159470195130063472030000010546911463304868759_);}
    .st25{opacity:0.3;fill:url(#SVGID_00000054256864219750987010000016691046486224929694_);}
    .st26{fill:url(#SVGID_00000037655310285573672210000007387934306851547786_);}
    .st27{fill:url(#SVGID_00000005946919717727485650000001262660596978278843_);}
    .st28{fill:url(#SVGID_00000024682136775601822350000016636717733415870908_);}
    .st29{fill:url(#SVGID_00000155848516290055420680000007314129032024263085_);}
    .st30{fill:url(#SVGID_00000070115300889181521540000009559820036006422436_);}
    .st31{opacity:0.3;fill:url(#SVGID_00000168811073951049293390000004331461170514805392_);}
    .st32{fill:url(#SVGID_00000018919381179236964180000001656294784327474360_);}
    .st33{fill:url(#SVGID_00000106870197111106408310000011522618547026317207_);}
    .st34{fill:url(#SVGID_00000038411007172086979990000013485470490118626235_);}
</style>
            <g id="Background">
            </g>
            <g id="Illustration">
                <g>
                    <g>
                        <g>
                            <g>
                                <defs>
                                    <path id="SVGID_1_" d="M2171.6,2518c-120.6-113.2-279.8-297.1-351.9-557.1c-94.5-341,44-513.3,28.4-1090.6        c-9.9-365-20.4-619.6-204.5-755.8C1499.4,7.8,1266-13.5,1124.3,85.5c-117.8,82.3-186,257.2-206.8,382.1        c-16.9,101.8-3.3,175.7-62,229.3c-60,54.8-124.7,23.8-180.7,64.4c-113.7,82.3-47.9,354.9-37.2,399        c118.4,490.1,570,820.7,768.7,962.5C1570.6,2239.9,1824.7,2396.2,2171.6,2518z"/>
                                </defs>

                                <linearGradient id="SVGID_00000114047919578633908790000016677568545869409956_" gradientUnits="userSpaceOnUse" x1="608.9744" y1="1269.8464" x2="2171.6272" y2="1269.8464">
                                    <stop offset="0" style="stop-color:#FF9085"/>
                                    <stop offset="1" style="stop-color:#FB6FBB"/>
                                </linearGradient>

                                <use xlink:href="#SVGID_1_" style="overflow:visible;fill:url(#SVGID_00000114047919578633908790000016677568545869409956_);"/>
                                <clipPath id="SVGID_00000010297087449509619500000015199412948477029533_">
                                    <use xlink:href="#SVGID_1_" style="overflow:visible;"/>
                                </clipPath>
                                <g style="opacity:0.5;clip-path:url(#SVGID_00000010297087449509619500000015199412948477029533_);">
                                    <g>
                                        <path class="st1" d="M2309.6,2608.2c-210.3-79.9-391.4-175.3-538.1-283.4c-217.2-160-352.4-343.9-402-546.4         c-38.8-158.4-24.4-330.1-6.2-547.4c15.1-180.2,42-306.4,65.8-417.8c30.8-144.3,55.1-258.3,38.2-423.2         c-17.2-167.5-72.4-334-164.2-495l8.1-4.6c92.5,162.1,148.1,329.9,165.4,498.7c17,166.3-7.4,281-38.4,426.1         c-23.7,111.1-50.6,237-65.6,416.6c-18.9,225-32.5,387.5,6,544.4c104.5,426.7,565.8,683.2,934.3,823.3L2309.6,2608.2z"/>
                                    </g>
                                    <g>
                                        <path class="st1" d="M1379.4,1104.6l-1.5-5.1c-97.1-326-271.5-530-400.7-643.7C837.3,332.8,719.1,286.2,717.9,285.7l3.4-8.7         c1.2,0.5,120.9,47.7,262,171.8c129.4,113.9,303.9,317.7,401.9,642.8c23.3-11.1,127.9-64.5,232.5-172.3         C1726.7,807.2,1858,611.4,1865,315.7l9.3,0.2c-7.1,298.9-139.9,496.9-250.1,610.3c-119.4,122.9-238.8,175.8-240,176.3         L1379.4,1104.6z"/>
                                    </g>
                                    <g>
                                        <path class="st1" d="M1352,1590.9l-3.3-1c-158.5-46.5-338.5-229-534.8-542.4c-146-233-246.8-455.2-247.8-457.4l8.5-3.8         c1,2.2,101.6,223.9,247.3,456.4c191,304.8,372.9,490.5,526.3,537.3c16-23,128.6-182.3,270.8-321.8         c153.7-150.8,511.4-202.9,515-203.4l1.3,9.2c-3.6,0.5-358.3,52.2-509.7,200.8c-152.2,149.4-270.4,321.5-271.6,323.2         L1352,1590.9z"/>
                                    </g>
                                    <g>
                                        <path class="st1" d="M1712.6,2280.5l-9.2-1.1c-1.8-0.2-180-22-412.9-103.2c-215-75-521.8-217.3-763.1-469.7L61.6,1219.2         l6.7-6.5l465.8,487.3c239.9,251,545.2,392.6,759.2,467.2c202,70.4,362.6,96,401.9,101.6c-49.9-90.3-68-184.6-53.6-280.4         c11.8-78.8,45.4-158.7,99.9-237.5c92.6-133.8,215.3-219.3,216.6-220.2l5.3,7.7c-1.2,0.8-122.7,85.5-214.3,218         c-122.4,177-136.3,350.6-41.1,515.9L1712.6,2280.5z"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                        <g>
                            <g>
                                <defs>
                                    <path id="SVGID_00000079477495628226253000000004826258639267536264_" d="M1622,2318.9c-259.6,28.7-594.5,28.3-926.6-82.3        c-84.8-28.2-608.4-202.5-573-436.5c12.5-82.4,83.8-102.6,102.4-212.5c22.1-130.2-63.9-185.2-135.4-337.2        c-42.6-90.7-167.4-356.1-18.2-525.7c89.1-101.4,272.1-163.9,418.2-145.4c214.3,27.1,307.3,223.3,459.1,558        c134.5,296.7,116,374.9,216.5,586.8C1239.6,1881.4,1371.6,2094.9,1622,2318.9z"/>
                                </defs>

                                <linearGradient id="SVGID_00000097486312553523023670000011038483943414903951_" gradientUnits="userSpaceOnUse" x1="1114.194" y1="777.5396" x2="678.9137" y2="1945.925">
                                    <stop offset="3.597120e-03" style="stop-color:#E38DDD"/>
                                    <stop offset="1" style="stop-color:#9571F6"/>
                                </linearGradient>

                                <use xlink:href="#SVGID_00000079477495628226253000000004826258639267536264_" style="overflow:visible;fill:url(#SVGID_00000097486312553523023670000011038483943414903951_);"/>
                                <clipPath id="SVGID_00000165936453669876925890000014270554785609727134_">
                                    <use xlink:href="#SVGID_00000079477495628226253000000004826258639267536264_" style="overflow:visible;"/>
                                </clipPath>
                                <g style="opacity:0.5;clip-path:url(#SVGID_00000165936453669876925890000014270554785609727134_);">
                                    <g>
                                        <path class="st1" d="M2123.9,2400.1c-69.3,0-138.1-4.6-206.4-13.7c-359.4-48.2-685.2-226.5-968.3-530.1         c-294.3-315.5-468.9-687.4-563.5-943.8c-65.9-178.6-78-382.5-35.9-606.1l9.2,1.7c-41.8,221.9-29.9,424.1,35.5,601.1         c115,311.8,565,1339.1,1524.3,1467.8c268.1,36,544.4,0.8,821.1-104.5l3.3,8.7C2535.4,2360.4,2327.9,2400.1,2123.9,2400.1z"/>
                                    </g>
                                    <g>
                                        <path class="st1" d="M625.4,1412.9l-3.7-1.9C24,1107-13.5,689.8-10.8,569.2c0.1-2.4,0.1-3.9,0.1-4.6l9.3-1         c0.1,0.9,0.1,2.2,0,5.8c-2.7,119,34.4,529.9,623.5,831.4c11.6-18.8,65.9-110.2,105.3-238.4c40.6-132.2,73.2-331.8-2.3-531.7         l8.7-3.3c76.5,202.4,43.5,404.3,2.4,538c-44.5,144.7-107.9,243.1-108.6,244L625.4,1412.9z"/>
                                    </g>
                                    <g>
                                        <path class="st1" d="M615.3,1896.9c-161.4,0-283.4-34.8-367.7-72.1C101.1,1760,33.1,1673.4,32.4,1672.6l7.4-5.7         c0.7,0.9,67.6,85.8,212.1,149.6c133.1,58.8,361.2,111.2,692.2,27.4c10.1-30.5,111.4-351.7,37.8-760.1l-78.2-433.6l9.2-1.7         l78.2,433.6c77.5,429.9-37.8,763.9-39,767.2l-0.8,2.4l-2.4,0.6C823.2,1884.4,712.1,1896.9,615.3,1896.9z"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                    <g>
                        <g>
                            <g>
                                <path class="st3" d="M3710,2993.1l-3580.5-30.9v91.6c0,24.9,15.6,46,36.8,49.8l1012.5,180.3c12,2.1,24.2,2.7,36.3,1.7       l2456-205.6c21.9-1.8,38.9-23,38.9-48.6V2993.1z"/>
                                <g>
                                    <path class="st3" d="M2392.4,2846.3L116.7,3013.8c-40.7,3-73.8-28.9-73.8-71.2V1248c0-42.3,33.1-76.6,73.8-76.6h2275.7        c33.5,0,60.7,31,60.7,69.2v1531.9C2453,2810.9,2425.9,2843.9,2392.4,2846.3z"/>
                                    <path class="st1" d="M2428.7,2846.3L153,3013.8c-40.7,3-73.8-28.9-73.8-71.2V1248c0-42.3,33.1-76.6,73.8-76.6h2275.7        c33.5,0,60.7,31,60.7,69.2v1531.9C2489.3,2810.9,2462.2,2843.9,2428.7,2846.3z"/>
                                    <path class="st4" d="M2357.8,2738.3L238.2,2883.8c-33.1,2.3-60.1-23.9-60.1-58.4V1341.8c0-34.5,26.9-62.6,60.1-62.8        l2119.6-9.1c27.7-0.1,50.1,25.3,50.1,56.7v1351.4C2407.8,2709.4,2385.4,2736.4,2357.8,2738.3z"/>
                                    <path class="st1" d="M1371.2,1217.8c0,15.7-11.7,28.5-26.2,28.6c-14.5,0-26.2-12.7-26.2-28.5s11.8-28.6,26.2-28.6        C1359.5,1189.3,1371.2,1202.1,1371.2,1217.8z"/>
                                    <path class="st5" d="M152.9,3013.9l2264.2-166.7l11.5-0.8c15.4-1.1,29.4-8.7,40.1-20.3c-162.9-8.9-264.1-66.7-329.4-126.5        c-131.1-120-108.4-238.3-249.7-317.2c-176.3-98.4-315,26.3-448.8-96.7c-81.1-74.6-41.3-130.2-141.1-241.6        c-110.6-123.4-182.5-81.9-293.6-193c-140.5-140.5-70.2-249.8-191.2-350.6c-146.8-122.4-305.1-9.1-444.9-126.4        c-60.3-50.6-93.4-124.2-110.6-202.4H153c-40.7,0-73.8,34.3-73.8,76.6v1694.7C79.1,2985,112.2,3016.8,152.9,3013.9z"/>
                                </g>

                                <linearGradient id="SVGID_00000113347184198367617600000005159573802592311707_" gradientUnits="userSpaceOnUse" x1="129.4897" y1="3019.4829" x2="3710" y2="3019.4829">
                                    <stop offset="0.494" style="stop-color:#EBEFF2"/>
                                    <stop offset="1" style="stop-color:#FFFFFF"/>
                                </linearGradient>
                                <path style="fill:url(#SVGID_00000113347184198367617600000005159573802592311707_);" d="M2535.9,2837L129.5,3013.4       l1049.2,186.9c12,2.1,24.2,2.7,36.3,1.7l2495-208.9l-1135.8-154.8C2561.5,2836.5,2548.6,2836.1,2535.9,2837z"/>
                                <polygon class="st4" points="480.6,3014.9 2484,2865.9 3104,2949.7 1117.9,3109      "/>
                            </g>
                        </g>
                        <g>
                            <polygon class="st4" points="959.6,2523.8 959.6,2523.8 959.6,2523.8     "/>
                            <path class="st3" d="M1139.5,1309.6v1039.2c0,90.3-75.8,172-175.9,178.3l943.3-63.4c85-5.4,153.5-77.2,153.5-160.5v-958.3      L1139.5,1309.6z"/>
                        </g>
                        <g>
                            <g>
                                <path class="st1" d="M2068.3,2306.4c0,83.3-68,155.2-153,160.5l-946.8,60.1h0c100.1-6.4,180.1-84.7,180.1-175V1312.9       l919.7,35.2V2306.4z"/>
                                <g>
                                    <g>
                                        <path class="st4" d="M1290.7,1553.8l-30.3-0.6v-109.5l-39-1.2v-23.5l107.8,3.5v23.3l-38.5-1.2V1553.8z"/>
                                        <path class="st4" d="M1441.3,1556.9l-10-31.4l-50.8-1.2l-10.2,31.1l-32.2-0.7l49.6-130.9l36.1,1.2l49,132.5L1441.3,1556.9z          M1424.3,1502.1c-9.3-28.5-14.6-44.7-15.7-48.4c-1.2-3.7-2-6.7-2.5-8.9c-2.1,7.6-8.1,26.4-18,56.3L1424.3,1502.1z"/>
                                        <path class="st4" d="M1604.6,1560.3l-32.6-0.7l-31.5-49.6l-31.7,48.3l-31.1-0.6l45.4-66l-42.5-64.2l32.1,1.1l29.4,47.6         l28.6-45.7l30.8,1l-42.3,62.7L1604.6,1560.3z"/>
                                    </g>
                                    <polygon class="st4" points="1896.8,1468.8 1647.6,1461.3 1647.6,1432.7 1896.8,1440.9       "/>
                                    <polygon class="st4" points="2001.2,1520.7 1647.6,1511.8 1647.6,1481.5 2001.2,1491.4       "/>
                                    <polygon class="st4" points="2001.2,1567.9 1647.6,1560.5 1647.6,1531.9 2001.2,1540.2       "/>
                                    <g>
                                        <polygon class="st4" points="1484,1692.1 1222,1690 1222,1660.2 1484,1663.1        "/>
                                        <g>
                                            <g>
                                                <path class="st4" d="M1365.8,1851.9l-123.2,0.9v-115.3l123.2,0.4V1851.9z M1257,1836.9l90.4-0.5v-83.1l-90.4-0.2V1836.9z"/>
                                            </g>
                                            <polygon class="st4" points="2001.2,1769.4 1416.9,1769 1416.9,1738 2001.2,1740.2         "/>
                                            <polygon class="st4" points="2001.2,1816.6 1416.9,1818.9 1416.9,1789.6 2001.2,1789         "/>
                                        </g>
                                        <g>
                                            <g>
                                                <path class="st4" d="M1365.8,2021.2l-123.2,2.8v-115.3l123.2-1.5V2021.2z M1257,2008l90.4-1.9V1923l-90.4,1.2V2008z"/>
                                            </g>
                                            <polygon class="st4" points="2001.2,1928.8 1416.9,1937.5 1416.9,1906.6 2001.2,1899.5         "/>
                                            <polygon class="st4" points="2001.2,1975.9 1416.9,1987.4 1416.9,1958.2 2001.2,1948.3         "/>
                                        </g>
                                        <g>
                                            <g>
                                                <path class="st4" d="M1365.8,2190.6l-123.2,4.7v-115.3l123.2-3.4V2190.6z M1257,2180.8l90.4-3.4v-84.8l-90.4,2.7V2180.8z"/>
                                            </g>
                                            <polygon class="st4" points="2001.2,2088.1 1416.9,2106 1416.9,2075.1 2001.2,2058.8         "/>
                                            <polygon class="st4" points="2001.2,2135.2 1416.9,2155.9 1416.9,2126.7 2001.2,2107.6         "/>
                                        </g>
                                        <g>
                                            <g>
                                                <path class="st4" d="M1365.8,2359.9l-123.2,6.7v-115.3l123.2-5.4V2359.9z M1257,2351.8l90.4-4.8v-84.8l-90.4,4.1V2351.8z"/>
                                            </g>
                                            <polygon class="st4" points="2001.2,2247.4 1416.9,2274.6 1416.9,2243.6 2001.2,2218.1         "/>
                                            <polygon class="st4" points="2001.2,2294.6 1416.9,2324.5 1416.9,2295.2 2001.2,2266.9         "/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                        <g>
                            <path class="st7" d="M1294.5,1832.2c-2.2,0-4.3-0.8-5.9-2.3l-23.1-21.8c-3.3-3.1-3.3-8.1,0-11.2c3.2-3.1,8.5-3.1,11.8,0l16,15.2      l37-50.9c2.6-3.6,7.7-4.4,11.4-2c3.7,2.5,4.6,7.4,2.1,10.9l-42.5,58.6c-1.4,1.9-3.6,3.2-6.1,3.4      C1295,1832.2,1294.8,1832.2,1294.5,1832.2z"/>
                        </g>
                    </g>
                    <g>

                        <linearGradient id="SVGID_00000031900326349219404920000015018956386280130705_" gradientUnits="userSpaceOnUse" x1="2494.2881" y1="794.6156" x2="2116.6389" y2="915.8146">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000031900326349219404920000015018956386280130705_);" d="M2929,780.9     c0,175.2-137,313-312.1,307.6c-182.2-5.6-335.5-163-335.5-351.3c0-188.3,153.3-325,335.5-306.1C2792,449.4,2929,605.7,2929,780.9     z"/>

                        <linearGradient id="SVGID_00000106117967109333602480000015574461491838622340_" gradientUnits="userSpaceOnUse" x1="2799.7842" y1="418.7039" x2="2462.6423" y2="1162.5017">
                            <stop offset="0" style="stop-color:#FFDB44"/>
                            <stop offset="1" style="stop-color:#FEEF06"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000106117967109333602480000015574461491838622340_);" d="M2976.4,765.8     c0,175.2-137,313-312.1,307.6c-182.2-5.6-335.5-163-335.5-351.3c0-188.3,153.3-325,335.5-306.1     C2839.4,434.3,2976.4,590.6,2976.4,765.8z"/>

                        <linearGradient id="SVGID_00000091731996562299565880000017315044306682210192_" gradientUnits="userSpaceOnUse" x1="2737.7668" y1="1204.0724" x2="2672.7146" y2="848.6946">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000091731996562299565880000017315044306682210192_);" d="M2962.6,764.9     c0,167.5-131.1,299-298.3,293.6c-173.8-5.6-319.6-155.8-319.6-335.3c0-179.4,145.9-310,319.6-292.2     C2831.5,448.2,2962.6,597.4,2962.6,764.9z"/>

                        <linearGradient id="SVGID_00000039132549245144624830000001907393403885307802_" gradientUnits="userSpaceOnUse" x1="2599.8435" y1="628.8543" x2="2867.9324" y2="1197.9556">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000039132549245144624830000001907393403885307802_);" d="M2952.8,764.2     c0,162-126.8,289-288.5,283.6c-167.7-5.6-308.4-150.7-308.4-323.8s140.6-299.2,308.4-282.2     C2825.9,458.1,2952.8,602.3,2952.8,764.2z"/>
                        <g>

                            <linearGradient id="SVGID_00000129192848236724846170000011995219828601552775_" gradientUnits="userSpaceOnUse" x1="2589.1628" y1="506.391" x2="2723.967" y2="1011.6138">
                                <stop offset="0" style="stop-color:#FFDB44"/>
                                <stop offset="1" style="stop-color:#FEEF06"/>
                            </linearGradient>
                            <path style="fill:url(#SVGID_00000129192848236724846170000011995219828601552775_);" d="M2662.6,496.9L2662.6,496.9      c8.6,0.8,15.6,8.6,15.6,17.3V544c17.2,1.9,34.4,4.9,51.7,9c12.7,3,25.4,6.5,37.9,10.7c7.5,2.5,12.6,10.1,11.9,17.9l-3.7,37.4      c-1,9.9-10.8,15.7-20,11.6c-8.3-3.7-16.7-6.8-25.4-9.5c-15.2-4.6-31.1-7.6-48-9l-4.4-0.4v85.4c44.9,12.6,77.8,29.4,99.1,50.7      c21.2,21.1,31.8,47.5,31.8,79.1c0,34.2-11.7,61.6-35.1,82.3c-23.6,20.8-56.6,32.5-99.3,35v32.9c0,8.7-7,15.5-15.6,15.2l-0.3,0      c-8.6-0.3-15.6-7.7-15.6-16.5v-32.5l-6.9-0.3c-20-0.9-39.2-2.9-57.6-6.1c-13.6-2.4-26.8-5.4-39.8-9.1      c-7.8-2.3-13.2-9.7-12.5-17.7l4.3-48.1c0.9-10.4,11.4-16.4,21.2-12.5c11.5,4.5,23.2,8.4,35,11.5c18.4,4.9,37,8,55.9,9.3l0.3-95      c-43.1-10.7-75.3-26.4-96.5-47.4c-21.3-21-32-47.9-32-80.6c0-33.8,11.6-59.9,34.7-78.3c23-18.2,55.6-27.3,97.7-27.3v-30.5      C2647,502.5,2654,496,2662.6,496.9z M2647,610.8c-13.3,1-23.7,4.6-31.1,11c-7.4,6.4-11.2,14.9-11.2,25.6      c0,10.2,3.4,18.7,10.3,25.5c6.9,6.8,17.5,12.2,32,16.3V610.8z M2674.6,782.9V870c14.5,0,25.6-3.4,33.3-10.4      c7.7-6.9,11.6-16.7,11.6-29.3c0-11.5-3.6-21.1-10.8-28.7C2701.5,794,2690.2,787.8,2674.6,782.9z"/>
                        </g>

                        <linearGradient id="SVGID_00000137101388356928115330000006454741669645577398_" gradientUnits="userSpaceOnUse" x1="2520.9727" y1="665.6838" x2="2788.5208" y2="1233.6373">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="opacity:0.3;fill:url(#SVGID_00000137101388356928115330000006454741669645577398_);" d="M2612.1,803.9     c9.7-96.3,98.2-137,86.7-225.6c-7.1-54.6-48.5-100.6-94.6-136.5c-140,14.7-248.2,130.6-248.2,282.2     c0,173.1,140.6,318.2,308.4,323.8c16.3,0.5,32.2-0.3,47.7-2.3C2645.3,979.2,2603.7,886.6,2612.1,803.9z"/>
                    </g>
                    <g>

                        <linearGradient id="SVGID_00000161630520730149520020000015589525522374034310_" gradientUnits="userSpaceOnUse" x1="2870.9944" y1="1476.9258" x2="2568.5488" y2="1573.9896">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000161630520730149520020000015589525522374034310_);" d="M3219.2,1466     c0,140.3-109.7,250.7-249.9,246.4c-145.9-4.5-268.7-130.5-268.7-281.3s122.7-260.3,268.7-245.1     C3109.5,1200.5,3219.2,1325.6,3219.2,1466z"/>

                        <linearGradient id="SVGID_00000044881873446139677340000003166775562886624934_" gradientUnits="userSpaceOnUse" x1="3115.6555" y1="1175.8715" x2="2845.6506" y2="1771.5526">
                            <stop offset="0" style="stop-color:#FFDB44"/>
                            <stop offset="1" style="stop-color:#FEEF06"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000044881873446139677340000003166775562886624934_);" d="M3257.1,1453.9     c0,140.3-109.7,250.7-249.9,246.4c-145.9-4.5-268.7-130.5-268.7-281.3c0-150.8,122.7-260.3,268.7-245.1     C3147.4,1188.4,3257.1,1313.5,3257.1,1453.9z"/>

                        <linearGradient id="SVGID_00000072247570669944242320000014383987281194832809_" gradientUnits="userSpaceOnUse" x1="3065.988" y1="1804.8452" x2="3013.8899" y2="1520.2357">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000072247570669944242320000014383987281194832809_);" d="M3246.1,1453.1     c0,134.1-105,239.5-238.9,235.1c-139.2-4.5-256-124.8-256-268.5c0-143.7,116.8-248.2,256-234     C3141.1,1199.5,3246.1,1319,3246.1,1453.1z"/>

                        <linearGradient id="SVGID_00000119115875467289627570000018322053835327397255_" gradientUnits="userSpaceOnUse" x1="2955.53" y1="1344.1735" x2="3170.2329" y2="1799.9463">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000119115875467289627570000018322053835327397255_);" d="M3238.2,1452.6     c0,129.7-101.6,231.4-231,227.1c-134.3-4.5-247-120.7-247-259.3s112.6-239.6,247-226C3136.6,1207.4,3238.2,1322.9,3238.2,1452.6z     "/>
                        <g>

                            <linearGradient id="SVGID_00000121246077186405601890000009114211461707887525_" gradientUnits="userSpaceOnUse" x1="2946.9763" y1="1246.097" x2="3054.9363" y2="1650.7119">
                                <stop offset="0" style="stop-color:#FFDB44"/>
                                <stop offset="1" style="stop-color:#FEEF06"/>
                            </linearGradient>
                            <path style="fill:url(#SVGID_00000121246077186405601890000009114211461707887525_);" d="M3005.8,1238.5L3005.8,1238.5      c6.9,0.7,12.5,6.9,12.5,13.9v23.9c13.8,1.5,27.6,3.9,41.4,7.2c10.2,2.4,20.3,5.2,30.4,8.5c6,2,10.1,8.1,9.5,14.3l-2.9,29.9      c-0.8,7.9-8.6,12.6-16,9.3c-6.6-3-13.4-5.5-20.4-7.6c-12.1-3.7-24.9-6.1-38.4-7.2l-3.5-0.3v68.4c35.9,10.1,62.3,23.6,79.4,40.6      c17,16.9,25.4,38,25.4,63.4c0,27.4-9.4,49.3-28.1,65.9c-18.9,16.6-45.3,26-79.6,28v26.4c0,7-5.6,12.5-12.5,12.2l-0.2,0      c-6.9-0.3-12.5-6.2-12.5-13.2v-26l-5.6-0.3c-16-0.7-31.4-2.4-46.1-4.9c-10.9-1.9-21.5-4.3-31.9-7.3c-6.3-1.8-10.6-7.8-10-14.2      l3.5-38.5c0.7-8.3,9.1-13.2,17-10c9.2,3.6,18.6,6.7,28,9.2c14.7,3.9,29.7,6.4,44.8,7.5l0.2-76.1c-34.5-8.5-60.3-21.2-77.3-37.9      c-17-16.8-25.6-38.4-25.6-64.5c0-27.1,9.3-48,27.8-62.7c18.4-14.6,44.5-21.9,78.3-21.9V1250      C2993.3,1243,2998.9,1237.8,3005.8,1238.5z M2993.3,1329.8c-10.7,0.8-19,3.7-24.9,8.8c-6,5.1-8.9,11.9-8.9,20.5      c0,8.1,2.8,14.9,8.3,20.4c5.5,5.5,14,9.8,25.6,13.1V1329.8z M3015.4,1467.5v69.8c11.6,0,20.5-2.7,26.7-8.3      c6.2-5.5,9.3-13.4,9.3-23.5c0-9.2-2.9-16.9-8.6-23C3037,1476.4,3027.9,1471.4,3015.4,1467.5z"/>
                        </g>

                        <linearGradient id="SVGID_00000148627095200784337380000013125359713707578756_" gradientUnits="userSpaceOnUse" x1="2892.3652" y1="1373.6688" x2="3106.635" y2="1828.5226">
                            <stop offset="0" style="stop-color:#FCB148"/>
                            <stop offset="5.207239e-02" style="stop-color:#FDBA46"/>
                            <stop offset="0.1424" style="stop-color:#FFC244"/>
                            <stop offset="0.3183" style="stop-color:#FFC444"/>
                            <stop offset="0.4849" style="stop-color:#FDB946"/>
                            <stop offset="0.7754" style="stop-color:#F99C4D"/>
                            <stop offset="0.8658" style="stop-color:#F8924F"/>
                            <stop offset="1" style="stop-color:#F8924F"/>
                        </linearGradient>
                        <path style="opacity:0.3;fill:url(#SVGID_00000148627095200784337380000013125359713707578756_);" d="M2965.3,1484.3     c7.8-77.1,78.7-109.7,69.4-180.7c-5.7-43.7-38.8-80.5-75.8-109.3c-112.1,11.8-198.8,104.6-198.8,226     c0,138.6,112.6,254.8,247,259.3c13,0.4,25.8-0.2,38.2-1.9C2991.9,1624.7,2958.6,1550.6,2965.3,1484.3z"/>
                    </g>
                    <g>

                        <linearGradient id="SVGID_00000014603380326547713610000015371265997080734083_" gradientUnits="userSpaceOnUse" x1="4311.3535" y1="1258.7701" x2="4333.208" y2="1386.1981" gradientTransform="matrix(-1 0 0 1 5255.3359 0)">
                            <stop offset="0" style="stop-color:#FFC444"/>
                            <stop offset="0.9964" style="stop-color:#F36F56"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000014603380326547713610000015371265997080734083_);" d="M982.4,1309.4     c-7.3-5.9-17-15.5-22.5-29.7c-5.9-15.3-1.8-22.1-9.2-31.6c-9.5-12.1-28.8-17.3-42.1-11.4c-2.8,1.2-6.2,3-8.4,6.6     c-5.9,10,7.2,27.2,17.7,36.4c7.9,6.9,11.1,6.4,19.5,12.3c8.1,5.7,18.4,15.7,26.6,33.8L982.4,1309.4z"/>

                        <linearGradient id="SVGID_00000155131728446830258010000004383124603359043493_" gradientUnits="userSpaceOnUse" x1="-3088.7637" y1="2745.2217" x2="-3066.9082" y2="2872.6558" gradientTransform="matrix(0.9207 0.3902 -0.3902 0.9207 4514.7969 -128.1326)">
                            <stop offset="0" style="stop-color:#FFC444"/>
                            <stop offset="0.9964" style="stop-color:#F36F56"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000155131728446830258010000004383124603359043493_);" d="M544.7,1225.8c9-2.6,21.7-7.6,32.3-18.6     c11.4-11.7,10.2-19.6,20.8-25.5c13.4-7.5,33.3-4.7,43.2,5.9c2.1,2.2,4.5,5.2,5.1,9.3c1.5,11.5-17.3,22.3-30.5,26.6     c-9.9,3.3-12.7,1.6-22.7,3.7c-9.7,2.1-23,7.2-37.7,20.7L544.7,1225.8z"/>

                        <linearGradient id="SVGID_00000147185748982867609880000000270242073398573726_" gradientUnits="userSpaceOnUse" x1="-3554.0337" y1="2517.77" x2="-3382.3748" y2="3518.6707" gradientTransform="matrix(0.9612 0.2758 -0.2758 0.9612 4648.4087 -70.8026)">
                            <stop offset="0" style="stop-color:#FF9085"/>
                            <stop offset="1" style="stop-color:#FB6FBB"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000147185748982867609880000000270242073398573726_);" d="M586.5,1240     c5.8,27.7-24.1,52.3-45.7,76.5c-43.3,48.5-88.6,135-72,209.3c9.1,40.6,38.2,84.4,79.4,105.2c44.3,22.4,70.8,2,116.9,28.6     c3.4,2,61.7,36.5,63.3,83.1c2.1,57.5-82.4,118.7-154.8,123.3c-132.3,8.6-291.8-167.4-284.4-342.1     c8.1-190.1,212.4-341,271.1-315.4C569.6,1212.5,583.2,1224.4,586.5,1240z"/>

                        <linearGradient id="SVGID_00000070100652962457206630000012192858673154272134_" gradientUnits="userSpaceOnUse" x1="-4765.3149" y1="3496.3108" x2="-4765.3149" y2="3025.7146" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#FFC444"/>
                            <stop offset="0.9964" style="stop-color:#F36F56"/>
                        </linearGradient>
                        <polygon style="fill:url(#SVGID_00000070100652962457206630000012192858673154272134_);" points="645.4,3208.6 650.1,3256.8      627.7,3252.7 612.6,3207.5    "/>

                        <linearGradient id="SVGID_00000111893776139760538190000003766653429197733295_" gradientUnits="userSpaceOnUse" x1="-4809.2437" y1="2592.1462" x2="-4847.5454" y2="3453.9307" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#311944"/>
                            <stop offset="1" style="stop-color:#893976"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000111893776139760538190000003766653429197733295_);" d="M508.7,2318.6     c2.3,85.5,13,158.7,25.6,218.5c13.6,64.3,21.5,75.4,25.8,119.8c9.2,96.7-21.9,110.6-27.7,219.9c-6.3,120.7,25.8,216.7,38.4,253.3     c11,32,22.6,57.8,31.3,75.8c11.1,9.7,28,5.9,45.8,2.3c6.6-109.5,14.8-212.5,21.3-322c21.2-164.7,42.4-329.4,63.6-494.2     C658.1,2367.5,583.4,2343.1,508.7,2318.6z"/>

                        <linearGradient id="SVGID_00000183208635767870566460000010827560156472253878_" gradientUnits="userSpaceOnUse" x1="-4809.2437" y1="2592.1462" x2="-4847.5454" y2="3453.9302" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#311944"/>
                            <stop offset="1" style="stop-color:#893976"/>
                        </linearGradient>
                        <path style="opacity:0.3;fill:url(#SVGID_00000183208635767870566460000010827560156472253878_);" d="M647.9,3208.2     c6.6-109.5,14.8-212.5,21.3-322c21.2-164.7,42.4-329.4,63.6-494.2c-74.7-24.5-149.4-48.9-224.2-73.4c0.2,5.7,0.4,11.1,0.7,16.7     c104.8,91,125.4,163.2,124.3,212.4c-1.2,59.7-33.9,89.2-27.5,175.7c4.6,61.9,23.2,72.8,23.1,128.6c0,71.9-30.9,112.3-45.9,153.8     c-14.5,40.1-19.7,97,8.4,177.9c3.7,8.4,7.2,15.8,10.3,22.2C613.2,3215.6,630.1,3211.9,647.9,3208.2z"/>

                        <linearGradient id="SVGID_00000128450693620400226500000014322369683210591107_" gradientUnits="userSpaceOnUse" x1="-4726.4111" y1="3498.74" x2="-4805.1436" y2="3239.1355" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#444B8C"/>
                            <stop offset="0.9964" style="stop-color:#26264F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000128450693620400226500000014322369683210591107_);" d="M637,3273.2     c-10.6-13.2-20.4-12.2-22.1-21.1c-1.4-7,3.1-15.5,9.6-18.6c9.2-4.4,20,3,22.4,4.7c16.6,11.3,11.7,28.3,27.4,36.1     c3.2,1.6,8.2,3.3,13.4,8.4c2.2,2.2,7.7,7.6,6.3,11.2c-1.6,4.2-11.6,3.8-21.1,3.5c-11.4-0.4-17.1-0.6-22.6-4.2     C642.8,3288.2,645.2,3283.4,637,3273.2z"/>

                        <linearGradient id="SVGID_00000090286407278346864350000013320405906919381168_" gradientUnits="userSpaceOnUse" x1="-534.0153" y1="5009.5713" x2="-534.0153" y2="4592.4839" gradientTransform="matrix(0.6521 0.7581 -0.7581 0.6521 4720.7378 47.4656)">
                            <stop offset="0" style="stop-color:#FFC444"/>
                            <stop offset="0.9964" style="stop-color:#F36F56"/>
                        </linearGradient>
                        <polygon style="fill:url(#SVGID_00000090286407278346864350000013320405906919381168_);" points="659.5,2861.2 617.6,2877.6      605.3,2858.3 638.1,2836.3    "/>

                        <linearGradient id="SVGID_00000075878053701357496100000017120945868263766171_" gradientUnits="userSpaceOnUse" x1="-505.0182" y1="5025.3408" x2="-583.7544" y2="4765.7231" gradientTransform="matrix(0.6521 0.7581 -0.7581 0.6521 4720.7378 47.4656)">
                            <stop offset="0" style="stop-color:#444B8C"/>
                            <stop offset="0.9964" style="stop-color:#26264F"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000075878053701357496100000017120945868263766171_);" d="M595.5,2887.8     c2.5-16.7-4.9-23.2,0.5-30.6c4.2-5.8,13.5-8.3,20.2-5.6c9.4,3.8,11.4,16.7,11.8,19.6c3,19.9-12.9,27.8-8,44.6     c1,3.4,3.2,8.2,3,15.6c-0.1,3.1-0.3,10.8-3.9,12.2c-4.2,1.6-10.7-6-16.9-13.2c-7.5-8.7-11.2-13-12.2-19.4     C588.4,2902.2,593.6,2900.7,595.5,2887.8z"/>

                        <linearGradient id="SVGID_00000108303701465333904740000010934303875494534558_" gradientUnits="userSpaceOnUse" x1="4959.4795" y1="2581.7996" x2="4156.2188" y2="2545.2871" gradientTransform="matrix(-1 0 0 1 5255.3359 0)">
                            <stop offset="0" style="stop-color:#311944"/>
                            <stop offset="1" style="stop-color:#893976"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000108303701465333904740000010934303875494534558_);" d="M841,2242.6     c78.2,159.4,104.7,292.2,114.7,379c6.5,55.8,5.8,90.3-10.2,125c-57.5,124.1-258.4,132.3-288.9,133.2     c-10-20.6-20.1-41.1-30.1-61.7c18.5-34.3,50.7-81.8,105.9-116.6c42.5-26.7,59.1-21,69.7-38.9c42.5-72-187-227.9-152.8-331.7     C661.2,2295,706.9,2258.6,841,2242.6z"/>

                        <linearGradient id="SVGID_00000116916126438235376060000013730152988119531934_" gradientUnits="userSpaceOnUse" x1="4640.3154" y1="1319.3354" x2="4840.0664" y2="2484.0342" gradientTransform="matrix(-1 0 0 1 5255.3359 0)">
                            <stop offset="0" style="stop-color:#FF9085"/>
                            <stop offset="1" style="stop-color:#FB6FBB"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000116916126438235376060000013730152988119531934_);" d="M671.7,1669.7     c84.5,14.5,148.7,29.6,177.5,73.8c30.3,46.7-17.9,81.9-31,184.4c-20.1,156.9,70.2,215.6,44.2,373.6     c-4.2,25.8-10.7,48.7-17.6,68.3c-12.2,34.5-35.8,63.5-66.7,82.9c-23.2,14.6-51.4,29.3-84.5,40.8c-85.6,30-127.9,12.5-243.1,19.1     c-188.5,10.8-216.7,65.4-301.8,31.8c-86.1-34-148.3-125.8-130.1-165c10.9-23.5,45.4-8.8,94.9-37.7c63.7-37.2,53-87.9,104.7-131.4     c74.3-62.5,145.7,0.6,209.2-53.7c64.3-55,71.9-188.7,44.6-268.3c-17.8-52-18.2-108.5-31.4-161.9c-1.1-4.4-2-11.5,0.8-19.5     c10.5-30.7,66.6-36.5,109-40.6C615.1,1660.4,664.7,1668.5,671.7,1669.7z"/>

                        <linearGradient id="SVGID_00000027593303415736450030000016778730943301182372_" gradientUnits="userSpaceOnUse" x1="7129.3867" y1="2968.748" x2="7518.311" y2="3768.5093" gradientTransform="matrix(-0.9781 -0.2085 -0.2085 0.9781 8522.2227 362.0485)">
                            <stop offset="0" style="stop-color:#FF9085"/>
                            <stop offset="1" style="stop-color:#FB6FBB"/>
                        </linearGradient>
                        <path style="opacity:0.3;fill:url(#SVGID_00000027593303415736450030000016778730943301182372_);" d="M158.5,2485.1     c26.1-17.4,12-66.7,50.6-92.8c35.9-24.3,63.8,7.5,116.7-8.7c67.8-20.8,64.3-86.1,129.2-106.9c46.7-15,60.8,14.8,128.2,16.1     c67.3,1.3,155.5-26.5,211.3-97.8c23.7-30.3,37-62.6,44.2-92.5c18,58.1,37.5,114.3,23.6,199.1c-5.6,34.3-15.2,63.6-24.6,86.7     c-8.8,21.5-23.6,40-42.6,53.2c-26,18.1-59.9,37.6-101.6,52.2c-85.6,30-127.9,12.5-243.1,19.1c-188.5,10.8-216.7,65.4-301.8,31.8     c-55-21.7-100.2-67-120.9-107.1C102.2,2491.6,139.6,2497.7,158.5,2485.1z"/>

                        <linearGradient id="SVGID_00000028311294722541872960000006873672016937962413_" gradientUnits="userSpaceOnUse" x1="-4715.8999" y1="1762.5199" x2="-4805.7207" y2="1907.8182" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#FFC444"/>
                            <stop offset="0.9964" style="stop-color:#F36F56"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000028311294722541872960000006873672016937962413_);" d="M720.5,1523.6c0,0,23.3,43.7,24.7,74.3     c1.5,30.7-33.1,28.4-33.1,28.4l1.3,19.3c1.1,16.5,11.8,30.8,27.4,36.5l13.7,5c0,0-89.1,19.1-137.8-15.3l14-1.4     c19.9-1.9,35.6-17.6,37.6-37.5l0.8-8.3C669.1,1624.8,653.7,1529.3,720.5,1523.6z"/>

                        <linearGradient id="SVGID_00000029741357208577357250000000121740599776027271_" gradientUnits="userSpaceOnUse" x1="4304.311" y1="1455.605" x2="4475.9673" y2="2456.4907" gradientTransform="matrix(-1 0 0 1 5255.3359 0)">
                            <stop offset="0" style="stop-color:#FF9085"/>
                            <stop offset="1" style="stop-color:#FB6FBB"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000029741357208577357250000000121740599776027271_);" d="M939.9,1318.1     c-13.2,25,8.7,56.9,22.8,86.1c28.2,58.6,47.9,154.2,11.5,221c-19.9,36.5-60,70.6-105.3,79.3c-48.7,9.3-68.6-17.6-120.2-4.7     c-3.8,0.9-69.3,18.1-83.8,62.4c-17.9,54.7,46.5,136.8,114.8,161.3c124.8,44.7,326.7-80.5,367.7-250.4     c44.7-185-110.1-386.4-173.6-378C963.7,1296.4,947.3,1304,939.9,1318.1z"/>

                        <linearGradient id="SVGID_00000068654103975767602620000000315777066282058371_" gradientUnits="userSpaceOnUse" x1="-5214.7622" y1="2371.1052" x2="-4851.6362" y2="1595.1948" gradientTransform="matrix(0.9994 3.520000e-02 -3.520000e-02 0.9994 5513.9448 -10.3728)">
                            <stop offset="0" style="stop-color:#311944"/>
                            <stop offset="1" style="stop-color:#6B3976"/>
                        </linearGradient>
                        <path style="fill:url(#SVGID_00000068654103975767602620000000315777066282058371_);" d="M706.5,1567c-4.6-0.4-8.4-6.2-11.6-4.5     c-3.3,1.8-2.9,10.3-0.1,16.3c2.4,4.9,6.2,7.7,8.3,9c-3.6,4.9-8.1,12.6-10,22.6c-4.2,22.1,7.6,40,12.5,50.4     c22.1,47-12.3,121.3-49.9,158.8c-30.6,30.5-44.9,18.2-63.2,43.1c-35.6,48.5,13.5,101.8-4.9,167c-28,99.2-184.6,128.7-191.1,129.9     c-2.6,0.5-4.3,0.7-6.9,1.2c-70.3,11.2-176.8,28.1-251.8-29.6c-56.1-43.2-81.9-118.3-77.6-184.4c1.1-17.4,6.4-83.5,60.2-137.4     c8.5-8.6,59.1-59.1,127.5-59.7c36.2-0.3,43.5,12.4,71.2,4.5c37.9-10.8,61.3-45.3,75.7-66.6c26.6-39.3,15.8-47.7,35-67.1     c37.6-37.9,81.6-8.1,121.8-41.6c39.5-33,15.7-77.7,53.9-106.2c39.4-29.4,114.7-19.2,130.8,15.9     C750.1,1518.7,720.7,1568.2,706.5,1567z"/>
                    </g>
                </g>
            </g>
</svg>
        <h1 style="font-weight: 600;" class="text-center">
            You don't have any taxes.
        </h1>

        <a class="btn btn-primary btn-rounded" href="javascript:mw_admin_edit_tax_item_popup(0)"><?php _e('Add new tax'); ?></a>


    </div>

<?php endif; ?>

<?php if (!empty($defined_taxes)) : ?>
    <!--<span class="text-muted"><?php _e('Example tax for 1000.00 is'); ?><?php print ' ' . mw()->tax_manager->calculate(1000) ?></span>-->
<?php endif; ?>
