<?php

if(!isset($data['id'])){
return;	
}

use Omnipay\Omnipay;

$api_key = get_option('mollie_api_key', 'payments');


$gateway = Omnipay::create('Mollie');
$gateway->setApiKey($api_key);
 

$response = $gateway->completePurchase(
	array(
	
		'transactionReference'   => $data['id'],
		 
	)
)->send();

if ($response->isSuccessful()){
	$update_order['transaction_id'] = $response->getTransactionReference(); // a reference generated by the payment gateway


    $update_order['is_paid'] = 1;
    $update_order['order_completed'] = 1;
    
    $update_order['success'] = 'Your payment was successful! ' . $response->getMessage();


    $response = $gateway->fetchTransaction(
        array(

            'transactionReference' => $update_order['transaction_id'],

        )
    )->send();
    if ($response->isSuccessful()) {
        $data = $response->getData();
        $update_order['is_paid'] = 0;

        if (isset($data['status'])) {

            if (isset($data['amount']) and is_array($data['amount'])) {
                $data['payment_amount'] = $data['amount']['value'];
                $data['payment_currency'] = $data['amount']['currency'];

            }
            $data['payment_status'] = $data['status'];
            if (isset($data['status']) and $data['status'] == 'paid') {
                $update_order['is_paid'] = 1;


            } else {
                $update_order['is_paid'] = 0;

            }
            if (isset($data['profileId'])) {
                $update_order['payer_id'] = $data['profileId'];
            }
            $update_order['payment_data'] = $data;

        }

    }

    
    
    

}
 