// @ts-check
const { withMod } = require("@expo/config-plugins");

/** @import { ExportedConfig, Mod } from "@expo/config-plugins"; */

/**
 * Provides the `ReactNativeHost` file for modification.
 * @param {ExportedConfig} config Exported config
 * @param {Mod} action Method to run on the mod when the config is compiled
 * @returns {ExportedConfig} Modified config
 */
function withReactNativeHost(config, action) {
  return withMod(config, {
    platform: "ios",
    mod: "reactNativeHost",
    action,
  });
}

/**
 * Provides the `SceneDelegate` file for modification.
 * @param {ExportedConfig} config Exported config
 * @param {Mod} action Method to run on the mod when the config is compiled
 * @returns {ExportedConfig} Modified config
 */
function withSceneDelegate(config, action) {
  return withMod(config, {
    platform: "ios",
    mod: "sceneDelegate",
    action,
  });
}

exports.macos = require("./macos");
exports.withReactNativeHost = withReactNativeHost;
exports.withSceneDelegate = withSceneDelegate;
