# 推荐做法

管理一个或多个集群并非易事。 在大多数情况下，管理员应具有丰富的OpenPAI系统知识。 在这里，我们推荐一些实践经验，供管理员参考。

## 团队合作与资源分配

OpenPAI中主要有两种资源，即虚拟集群资源和存储资源，它们由用户组进行管理。所有用户都在`default`组中。因此，每个人都应有权访问`default`虚拟集群以及为`default`组设置的一个或多个存储。除了`default`组外，您可以为不同的用户设置不同的组。 **我们建议您为每个团队分配一个用户组。**

例如，如果您有两个团队：团队A在项目A上工作，团队B在项目B上工作； 那么您可以分别把团队A和B设置A组和B组，每个团队都可以在组内共享计算和存储资源。 如果有新的用户加入团队，只需将其添加到相应的组中即可。

默认情况下，OpenPAI使用基本认证模式。 在此模式下，虚拟集群完全绑定到用户组。在AAD模式下，组和虚拟群集是不同的概念。 有关详细信息，请参考[如何设置虚拟集群](./how-to-set-up-virtual-clusters.md)。

## 新用户创建

在基本认证模式下，PAI管理员应在后端手动创建新用户，并向用户通知一些说明和准则。 在我们的实践中，我们会向新用户发送电子邮件。 除了帐户信息外，我们还在电子邮件中包含以下内容：

  - 让用户阅读[用户手册](../cluster-user/)，以了解如何提交任务，调试任务以及使用客户端工具。
  - 让用户知道其Completed状态的任务可能在30天后被删除。
  - 让用户知道他/她不应该总是执行低效率的工作（例如，在容器中sleep数天）。 否则，管理员可能会终止该任务。
  - 让用户知道如何在发现任何问题或有任何疑问时与管理员联系。
  
## DRI实践

DRI是指定负责人（Designated Responsible Individual）的简称。 我们并没有一位专门负责运维PAI集群的管理员，但我们会每周分配一个或两个DRI。 他/她将在本周成为集群管理的指定负责人。 分配规则基于轮换，因此团队中的每个人都有平等的机会成为DRI。

DRI的职责包括：

- 解决内部部署的问题，这些问题来自报警和人工报告。
- 升级PAI服务。

DRI应该意识问题具备不同的严重性：

  - 严重性0：影响整个产品集群，并且完全不可用。
  - 严重性1：影响重要功能，例如无法提交新任务，API完全失败或Webportal无法访问。
  - 严重级别2：某些任务始终失败，或者某些用户经常遇到问题。
  - 严重级别3：随机任务有可能失败。

另外，如果存在多个集群，则他/她还应该了解不同集群的不同优先级。

根据严重性和优先级，我们可以为集群管理制定SLA。 以下是一个例子：

|     严重程度    |     集群               |     确认    |     更新频率    |     监控时间    |
|-----------------|---------------------------|--------------------|-------------------------|-------------------------|
|     0, 1        |     生产集群    |     30 分钟     |     2 小时              |     工作时间       |
|     2           |     生产集群    |     2 小时        |     24 小时            |     工作时间       |
|     3           |     全部                   |     4 小时        |     24 小时            |     工作时间       |


如果出现问题，DRI应该按照以下步骤解决：

1. 主动确认问题，并更新问题状态。
2. 如果问题是由集群报警引起的，那么DRI应确认该报警。 由于存在许多重复的报警，不需要对每个报警进行确认。
3. 除了确认问题外，如果问题有更新或已被解决，DRI还应答复问题/通知/报警。 更进一步，DRI所有者应考虑该事件的发生原因，并思考下一次如何避免。 如果有需要的话，要在Github上创建issue。