/**
 * A message sent from the editor (embeddee, the iframe) to the host (embedder, e.g. VS Code).
 * Must be the first message sent by the editor.
 *
 * When the editor sends this message again, the host should reset the state of the editor.
 */
export type EditorMessage = InitializedEditorMessage | ContentChangedEditorMessage | OptionsChangedEditorMessage;
/**
 * The client has to send this message to the host after it has been initialized.
 */
export interface InitializedEditorMessage {
    method: "initialized";
    version: "web-editor/0.9";
    contentType?: "text" | "json";
    capabilities?: {
        supportsTextEdits?: boolean;
    };
}
export interface ContentChangedEditorMessage {
    method: "contentChanged";
    content: JsonValue;
}
/** Is only allowed if the server sets the corresponding flag */
export interface OptionsChangedEditorMessage {
    method: "optionsChanged";
    options: JsonValue;
}
/**
 * A message sent from the host (embedder, e.g. VS Code) to the editor (embedee, the iframe).
 */
export type HostMessage = InitializedResponseHostMessage | UpdateHostMessage;
/**
 * The host sends this message as response to the editor initialization message.
 * The host may send an update message before this message.
 */
export interface InitializedResponseHostMessage {
    method: "initialized";
    version: "web-editor-host/0.9";
    capabilities?: {
        supportsOptions?: boolean;
        supportsTextEdits?: boolean;
    };
}
export interface UpdateHostMessage {
    method: "update";
    /**
     * If set, describes the new content.
     * The initial content value is the empty string.
     */
    content?: JsonValue;
    /**
     * If set, describes the new settings.
     * The initial settings value is `undefined`.
     */
    options?: JsonValue;
    /**
     * If set, describes if the document is read only.
     * The initial readonly value is `false`.
     */
    readOnly?: boolean;
    /**
     * If set, describes all edits since the last update message.
     * Is only set if the client supports text edits.
     */
    edits?: TextEdit[];
}
export interface TextEdit {
    offset: number;
    length: number;
    newText: string;
}
export type JsonValue = unknown;
