import { IDisposable } from './disposable';
export type IEvent<T = void> = (listener: (eventArgs: T) => void) => IDisposable;
export declare class EventEmitter<T = void> {
    private readonly _listeners;
    readonly event: IEvent<T>;
    private readonly _onDidChangeHasListeners;
    constructor(options?: {
        /**
         * This event is guaranteed to be only fired when the first listener is added and when the last listener is removed.
        */
        onDidChangeHasListeners?: (hasListeners: boolean) => void;
    });
    fire(data: T): void;
}
