import { IDisposable } from "./utils/disposable";
export interface IConnection<TIncomingMessage = unknown, TOutgoingMessage = unknown> extends IDisposable {
    setMessageHandler(handler: ((message: TIncomingMessage) => void)): void;
    sendMessage(message: TOutgoingMessage): void;
}
declare interface Window {
    addEventListener: any;
    removeEventListener: any;
    postMessage: any;
    parent: any;
}
export declare class WindowConnection implements IConnection {
    private readonly _ourWindow;
    private readonly _theirWindow;
    static toParent(): IConnection | undefined;
    private _lastDisposable;
    constructor(_ourWindow: Window, _theirWindow: Window);
    setMessageHandler(handler: (message: unknown) => void): void;
    sendMessage(message: unknown): void;
    dispose(): void;
}
export declare function castConnection<TIncomingMessage, TOutgoingMessage>(connection: IConnection<unknown, unknown>): IConnection<TIncomingMessage, TOutgoingMessage>;
export {};
