// <auto-generated />
//
// To parse this JSON data, add NuGet 'System.Text.Json' then do:
//
//    using Microsoft.ComponentDetection.Detectors.Rust.Contracts;
//
//    var cargoMetadata = CargoMetadata.FromJson(jsonString);
#nullable enable
#pragma warning disable CS8618
#pragma warning disable CS8601
#pragma warning disable CS8603

namespace Microsoft.ComponentDetection.Detectors.Rust.Contracts;

using System;
using System.Collections.Generic;

using System.Text.Json;
using System.Text.Json.Serialization;
using System.Globalization;

public partial class CargoMetadata
{
    [JsonPropertyName("packages")]
    public Package[] Packages { get; set; }

    [JsonPropertyName("workspace_members")]
    public string[] WorkspaceMembers { get; set; }

    [JsonPropertyName("resolve")]
    public Resolve Resolve { get; set; }

    [JsonPropertyName("target_directory")]
    public string TargetDirectory { get; set; }

    [JsonPropertyName("version")]
    public long Version { get; set; }

    [JsonPropertyName("workspace_root")]
    public string WorkspaceRoot { get; set; }

    [JsonPropertyName("metadata")]
    public object Metadata { get; set; }
}

public partial class Package
{
    [JsonPropertyName("name")]
    public string Name { get; set; }

    [JsonPropertyName("version")]
    public string Version { get; set; }

    [JsonPropertyName("id")]
    public string Id { get; set; }

    [JsonPropertyName("license")]
    public string License { get; set; }

    [JsonPropertyName("license_file")]
    public object LicenseFile { get; set; }

    [JsonPropertyName("description")]
    public string Description { get; set; }

    [JsonPropertyName("source")]
    public string? Source { get; set; }

    [JsonPropertyName("dependencies")]
    public Dependency[] Dependencies { get; set; }

    [JsonPropertyName("targets")]
    public Target[] Targets { get; set; }

    [JsonPropertyName("features")]
    public Dictionary<string, string[]> Features { get; set; }

    [JsonPropertyName("manifest_path")]
    public string ManifestPath { get; set; }

    [JsonPropertyName("metadata")]
    public Metadata Metadata { get; set; }

    [JsonPropertyName("publish")]
    public object Publish { get; set; }

    [JsonPropertyName("authors")]
    public string[] Authors { get; set; }

    [JsonPropertyName("categories")]
    public string[] Categories { get; set; }

    [JsonPropertyName("keywords")]
    public string[] Keywords { get; set; }

    [JsonPropertyName("readme")]
    // Manually change this to a string.
    public string? Readme { get; set; }

    [JsonPropertyName("repository")]
    public Uri Repository { get; set; }

    [JsonPropertyName("homepage")]
    public Uri Homepage { get; set; }

    [JsonPropertyName("documentation")]
    public Uri Documentation { get; set; }

    [JsonPropertyName("edition")]
    [JsonConverter(typeof(ParseStringConverter))]
    public long Edition { get; set; }

    [JsonPropertyName("links")]
    public object Links { get; set; }

    [JsonPropertyName("default_run")]
    public object DefaultRun { get; set; }

    [JsonPropertyName("rust_version")]
    public string RustVersion { get; set; }
}

public partial class Dependency
{
    [JsonPropertyName("name")]
    public string Name { get; set; }

    [JsonPropertyName("source")]
    public string Source { get; set; }

    [JsonPropertyName("req")]
    public string Req { get; set; }

    [JsonPropertyName("kind")]
    public Kind? Kind { get; set; }

    [JsonPropertyName("rename")]
    public string? Rename { get; set; }

    [JsonPropertyName("optional")]
    public bool Optional { get; set; }

    [JsonPropertyName("uses_default_features")]
    public bool UsesDefaultFeatures { get; set; }

    [JsonPropertyName("features")]
    public string[] Features { get; set; }

    [JsonPropertyName("target")]
    public string Target { get; set; }

    [JsonPropertyName("registry")]
    public object Registry { get; set; }
}

public partial class Metadata
{
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("docs")]
    public Docs Docs { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("release")]
    public Release Release { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("playground")]
    public Playground Playground { get; set; }
}

public partial class Docs
{
    [JsonPropertyName("rs")]
    public Rs Rs { get; set; }
}

public partial class Rs
{
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("rustdoc-args")]
    public string[] RustdocArgs { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("all-features")]
    public bool? AllFeatures { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("features")]
    public string[] Features { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("default-target")]
    public string? DefaultTarget { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("cargo-args")]
    public string[] CargoArgs { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("targets")]
    public string[] Targets { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("rustc-args")]
    public string[] RustcArgs { get; set; }
}

public partial class Playground
{
    [JsonPropertyName("features")]
    public string[] Features { get; set; }
}

public partial class Release
{
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("no-dev-version")]
    public bool? NoDevVersion { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("pre-release-commit-message")]
    public string PreReleaseCommitMessage { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("tag-message")]
    public string TagMessage { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("pre-release-replacements")]
    public PreReleaseReplacement[] PreReleaseReplacements { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("tag-name")]
    public string TagName { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("tag-prefix")]
    public string TagPrefix { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("push")]
    public bool? Push { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("tag")]
    public bool? Tag { get; set; }
}

public partial class PreReleaseReplacement
{
    [JsonPropertyName("file")]
    public string File { get; set; }

    [JsonPropertyName("replace")]
    public string Replace { get; set; }

    [JsonPropertyName("search")]
    public string Search { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("exactly")]
    public long? Exactly { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("min")]
    public long? Min { get; set; }
}

public partial class Target
{
    [JsonPropertyName("kind")]
    public CrateType[] Kind { get; set; }

    [JsonPropertyName("crate_types")]
    public CrateType[] CrateTypes { get; set; }

    [JsonPropertyName("name")]
    public string Name { get; set; }

    [JsonPropertyName("src_path")]
    public string SrcPath { get; set; }

    [JsonPropertyName("edition")]
    [JsonConverter(typeof(ParseStringConverter))]
    public long Edition { get; set; }

    [JsonPropertyName("doc")]
    public bool Doc { get; set; }

    [JsonPropertyName("doctest")]
    public bool Doctest { get; set; }

    [JsonPropertyName("test")]
    public bool Test { get; set; }

    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    [JsonPropertyName("required-features")]
    public string[] RequiredFeatures { get; set; }
}

public partial class Resolve
{
    [JsonPropertyName("nodes")]
    public Node[] Nodes { get; set; }

    [JsonPropertyName("root")]
    public string Root { get; set; }
}

public partial class Node
{
    [JsonPropertyName("id")]
    public string Id { get; set; }

    [JsonPropertyName("dependencies")]
    public string[] Dependencies { get; set; }

    [JsonPropertyName("deps")]
    public Dep[] Deps { get; set; }

    [JsonPropertyName("features")]
    public string[] Features { get; set; }
}

public partial class Dep
{
    [JsonPropertyName("name")]
    public string Name { get; set; }

    [JsonPropertyName("pkg")]
    public string Pkg { get; set; }

    [JsonPropertyName("dep_kinds")]
    public DepKind[] DepKinds { get; set; }
}

public partial class DepKind
{
    [JsonPropertyName("kind")]
    public Kind? Kind { get; set; }

    [JsonPropertyName("target")]
    public string Target { get; set; }
}

public enum Kind { Build, Dev };

public enum CrateType { Bench, Bin, CustomBuild, Example, Lib, ProcMacro, Test, RLib, DyLib, CdyLib, StaticLib };

public partial class CargoMetadata
{
    public static CargoMetadata FromJson(string json) => JsonSerializer.Deserialize<CargoMetadata>(json, Microsoft.ComponentDetection.Detectors.Rust.Contracts.Converter.Settings);
}

public static class Serialize
{
    public static string ToJson(this CargoMetadata self) => JsonSerializer.Serialize(self, Microsoft.ComponentDetection.Detectors.Rust.Contracts.Converter.Settings);
}

internal static class Converter
{
    public static readonly JsonSerializerOptions Settings = new(JsonSerializerDefaults.General)
    {
        Converters =
        {
            KindConverter.Singleton,
            CrateTypeConverter.Singleton,
            new DateOnlyConverter(),
            new TimeOnlyConverter(),
            IsoDateTimeOffsetConverter.Singleton
        },
    };
}

internal class KindConverter : JsonConverter<Kind>
{
    public override bool CanConvert(Type t) => t == typeof(Kind);

    public override Kind Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        var value = reader.GetString();
        switch (value)
        {
            case "build":
                return Kind.Build;
            case "dev":
                return Kind.Dev;
        }
        throw new Exception("Cannot unmarshal type Kind");
    }

    public override void Write(Utf8JsonWriter writer, Kind value, JsonSerializerOptions options)
    {
        switch (value)
        {
            case Kind.Build:
                JsonSerializer.Serialize(writer, "build", options);
                return;
            case Kind.Dev:
                JsonSerializer.Serialize(writer, "dev", options);
                return;
        }
        throw new Exception("Cannot marshal type Kind");
    }

    public static readonly KindConverter Singleton = new KindConverter();
}

internal class ParseStringConverter : JsonConverter<long>
{
    public override bool CanConvert(Type t) => t == typeof(long);

    public override long Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        var value = reader.GetString();
        long l;
        if (Int64.TryParse(value, out l))
        {
            return l;
        }
        throw new Exception("Cannot unmarshal type long");
    }

    public override void Write(Utf8JsonWriter writer, long value, JsonSerializerOptions options)
    {
        JsonSerializer.Serialize(writer, value.ToString(), options);
        return;
    }

    public static readonly ParseStringConverter Singleton = new ParseStringConverter();
}

internal class CrateTypeConverter : JsonConverter<CrateType>
{
    public override bool CanConvert(Type t) => t == typeof(CrateType);

    public override CrateType Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        var value = reader.GetString();
        switch (value)
        {
            case "bench":
                return CrateType.Bench;
            case "bin":
                return CrateType.Bin;
            case "custom-build":
                return CrateType.CustomBuild;
            case "example":
                return CrateType.Example;
            case "lib":
                return CrateType.Lib;
            case "proc-macro":
                return CrateType.ProcMacro;
            case "test":
                return CrateType.Test;
            case "rlib":
                return CrateType.RLib;
            case "dylib":
                return CrateType.DyLib;
            case "cdylib":
                return CrateType.CdyLib;
            case "staticlib": 
                return CrateType.StaticLib;
        }
        throw new Exception($"Cannot unmarshal type CrateType - {value}");
    }

    public override void Write(Utf8JsonWriter writer, CrateType value, JsonSerializerOptions options)
    {
        switch (value)
        {
            case CrateType.Bench:
                JsonSerializer.Serialize(writer, "bench", options);
                return;
            case CrateType.Bin:
                JsonSerializer.Serialize(writer, "bin", options);
                return;
            case CrateType.CustomBuild:
                JsonSerializer.Serialize(writer, "custom-build", options);
                return;
            case CrateType.Example:
                JsonSerializer.Serialize(writer, "example", options);
                return;
            case CrateType.Lib:
                JsonSerializer.Serialize(writer, "lib", options);
                return;
            case CrateType.ProcMacro:
                JsonSerializer.Serialize(writer, "proc-macro", options);
                return;
            case CrateType.Test:
                JsonSerializer.Serialize(writer, "test", options);
                return;
        }
        throw new Exception("Cannot marshal type CrateType");
    }

    public static readonly CrateTypeConverter Singleton = new CrateTypeConverter();
}

public class DateOnlyConverter : JsonConverter<DateOnly>
{
    private readonly string serializationFormat;
    public DateOnlyConverter() : this(null) { }

    public DateOnlyConverter(string? serializationFormat)
    {
        this.serializationFormat = serializationFormat ?? "yyyy-MM-dd";
    }

    public override DateOnly Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        var value = reader.GetString();
        return DateOnly.Parse(value!);
    }

    public override void Write(Utf8JsonWriter writer, DateOnly value, JsonSerializerOptions options)
        => writer.WriteStringValue(value.ToString(serializationFormat));
}

public class TimeOnlyConverter : JsonConverter<TimeOnly>
{
    private readonly string serializationFormat;

    public TimeOnlyConverter() : this(null) { }

    public TimeOnlyConverter(string? serializationFormat)
    {
        this.serializationFormat = serializationFormat ?? "HH:mm:ss.fff";
    }

    public override TimeOnly Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        var value = reader.GetString();
        return TimeOnly.Parse(value!);
    }

    public override void Write(Utf8JsonWriter writer, TimeOnly value, JsonSerializerOptions options)
        => writer.WriteStringValue(value.ToString(serializationFormat));
}

internal class IsoDateTimeOffsetConverter : JsonConverter<DateTimeOffset>
{
    public override bool CanConvert(Type t) => t == typeof(DateTimeOffset);

    private const string DefaultDateTimeFormat = "yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK";

    private DateTimeStyles _dateTimeStyles = DateTimeStyles.RoundtripKind;
    private string? _dateTimeFormat;
    private CultureInfo? _culture;

    public DateTimeStyles DateTimeStyles
    {
        get => _dateTimeStyles;
        set => _dateTimeStyles = value;
    }

    public string? DateTimeFormat
    {
        get => _dateTimeFormat ?? string.Empty;
        set => _dateTimeFormat = (string.IsNullOrEmpty(value)) ? null : value;
    }

    public CultureInfo Culture
    {
        get => _culture ?? CultureInfo.CurrentCulture;
        set => _culture = value;
    }

    public override void Write(Utf8JsonWriter writer, DateTimeOffset value, JsonSerializerOptions options)
    {
        string text;


        if ((_dateTimeStyles & DateTimeStyles.AdjustToUniversal) == DateTimeStyles.AdjustToUniversal
            || (_dateTimeStyles & DateTimeStyles.AssumeUniversal) == DateTimeStyles.AssumeUniversal)
        {
            value = value.ToUniversalTime();
        }

        text = value.ToString(_dateTimeFormat ?? DefaultDateTimeFormat, Culture);

        writer.WriteStringValue(text);
    }

    public override DateTimeOffset Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
    {
        string? dateText = reader.GetString();

        if (string.IsNullOrEmpty(dateText) == false)
        {
            if (!string.IsNullOrEmpty(_dateTimeFormat))
            {
                return DateTimeOffset.ParseExact(dateText, _dateTimeFormat, Culture, _dateTimeStyles);
            }
            else
            {
                return DateTimeOffset.Parse(dateText, Culture, _dateTimeStyles);
            }
        }
        else
        {
            return default(DateTimeOffset);
        }
    }


    public static readonly IsoDateTimeOffsetConverter Singleton = new IsoDateTimeOffsetConverter();
}
#pragma warning restore CS8618
#pragma warning restore CS8601
#pragma warning restore CS8603
