namespace Microsoft.ComponentDetection.Detectors.NuGet;

using static global::NuGet.Frameworks.FrameworkConstants.CommonFrameworks;

/// <summary>
/// Framework packages for .NETCoreApp,Version=v3.0.
/// </summary>
internal partial class FrameworkPackages
{
    internal static class NETCoreApp30
    {
        internal static FrameworkPackages Instance { get; } = new(NetCoreApp30, FrameworkNames.NetCoreApp, NETCoreApp21.Instance)
        {
            { "Microsoft.CSharp", "4.6.0" },
            { "Microsoft.Win32.Registry", "4.6.0" },
            { "System.Buffers", "4.5.1" },
            { "System.Collections.Immutable", "1.6.0" },
            { "System.ComponentModel.Annotations", "4.6.0" },
            { "System.Data.DataSetExtensions", "4.5.0" },
            { "System.Diagnostics.DiagnosticSource", "4.6.0" },
            { "System.IO.FileSystem.AccessControl", "4.6.0" },
            { "System.IO.Pipes.AccessControl", "4.6.0" },
            { "System.Reflection.DispatchProxy", "4.6.0" },
            { "System.Reflection.Metadata", "1.7.0" },
            { "System.Runtime.CompilerServices.Unsafe", "4.6.0" },
            { "System.Runtime.WindowsRuntime", "4.6.0" },
            { "System.Runtime.WindowsRuntime.UI.Xaml", "4.6.0" },
            { "System.Security.AccessControl", "4.6.0" },
            { "System.Security.Cryptography.Cng", "4.6.0" },
            { "System.Security.Cryptography.OpenSsl", "4.6.0" },
            { "System.Security.Cryptography.Xml", "4.4.0" },
            { "System.Security.Principal.Windows", "4.6.0" },
            { "System.Text.Encoding.CodePages", "4.6.0" },
            { "System.Text.Encodings.Web", "4.6.0" },
            { "System.Text.Json", "4.6.0" },
            { "System.Threading.Channels", "4.6.0" },
            { "System.Threading.Tasks.Dataflow", "4.10.0" },
        };

        internal static FrameworkPackages AspNetCore { get; } = new(NetCoreApp30, FrameworkNames.AspNetCoreApp)
        {
            { "Microsoft.AspNetCore", "3.0.0" },
            { "Microsoft.AspNetCore.Antiforgery", "3.0.0" },
            { "Microsoft.AspNetCore.Authentication", "3.0.0" },
            { "Microsoft.AspNetCore.Authentication.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Authentication.Cookies", "3.0.0" },
            { "Microsoft.AspNetCore.Authentication.Core", "3.0.0" },
            { "Microsoft.AspNetCore.Authentication.OAuth", "3.0.0" },
            { "Microsoft.AspNetCore.Authorization", "3.0.0" },
            { "Microsoft.AspNetCore.Authorization.Policy", "3.0.0" },
            { "Microsoft.AspNetCore.Components", "3.0.0" },
            { "Microsoft.AspNetCore.Components.Authorization", "3.0.0" },
            { "Microsoft.AspNetCore.Components.Forms", "3.0.0" },
            { "Microsoft.AspNetCore.Components.Server", "3.0.0" },
            { "Microsoft.AspNetCore.Components.Web", "3.0.0" },
            { "Microsoft.AspNetCore.Connections.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.CookiePolicy", "3.0.0" },
            { "Microsoft.AspNetCore.Cors", "3.0.0" },
            { "Microsoft.AspNetCore.Cryptography.Internal", "3.0.0" },
            { "Microsoft.AspNetCore.Cryptography.KeyDerivation", "3.0.0" },
            { "Microsoft.AspNetCore.DataProtection", "3.0.0" },
            { "Microsoft.AspNetCore.DataProtection.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.DataProtection.Extensions", "3.0.0" },
            { "Microsoft.AspNetCore.Diagnostics", "3.0.0" },
            { "Microsoft.AspNetCore.Diagnostics.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Diagnostics.HealthChecks", "3.0.0" },
            { "Microsoft.AspNetCore.HostFiltering", "3.0.0" },
            { "Microsoft.AspNetCore.Hosting", "3.0.0" },
            { "Microsoft.AspNetCore.Hosting.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Hosting.Server.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Html.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Http", "3.0.0" },
            { "Microsoft.AspNetCore.Http.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Http.Connections", "3.0.0" },
            { "Microsoft.AspNetCore.Http.Connections.Common", "3.0.0" },
            { "Microsoft.AspNetCore.Http.Extensions", "3.0.0" },
            { "Microsoft.AspNetCore.Http.Features", "3.0.0" },
            { "Microsoft.AspNetCore.HttpOverrides", "3.0.0" },
            { "Microsoft.AspNetCore.HttpsPolicy", "3.0.0" },
            { "Microsoft.AspNetCore.Identity", "3.0.0" },
            { "Microsoft.AspNetCore.Localization", "3.0.0" },
            { "Microsoft.AspNetCore.Localization.Routing", "3.0.0" },
            { "Microsoft.AspNetCore.Metadata", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.ApiExplorer", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Core", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Cors", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.DataAnnotations", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Formatters.Json", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Formatters.Xml", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Localization", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.Razor", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.RazorPages", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.TagHelpers", "3.0.0" },
            { "Microsoft.AspNetCore.Mvc.ViewFeatures", "3.0.0" },
            { "Microsoft.AspNetCore.Razor", "3.0.0" },
            { "Microsoft.AspNetCore.Razor.Runtime", "3.0.0" },
            { "Microsoft.AspNetCore.ResponseCaching", "3.0.0" },
            { "Microsoft.AspNetCore.ResponseCaching.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.ResponseCompression", "3.0.0" },
            { "Microsoft.AspNetCore.Rewrite", "3.0.0" },
            { "Microsoft.AspNetCore.Routing", "3.0.0" },
            { "Microsoft.AspNetCore.Routing.Abstractions", "3.0.0" },
            { "Microsoft.AspNetCore.Server.HttpSys", "3.0.0" },
            { "Microsoft.AspNetCore.Server.IIS", "3.0.0" },
            { "Microsoft.AspNetCore.Server.IISIntegration", "3.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel", "3.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel.Core", "3.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets", "3.0.0" },
            { "Microsoft.AspNetCore.Session", "3.0.0" },
            { "Microsoft.AspNetCore.SignalR", "3.0.0" },
            { "Microsoft.AspNetCore.SignalR.Common", "3.0.0" },
            { "Microsoft.AspNetCore.SignalR.Core", "3.0.0" },
            { "Microsoft.AspNetCore.SignalR.Protocols.Json", "3.0.0" },
            { "Microsoft.AspNetCore.StaticFiles", "3.0.0" },
            { "Microsoft.AspNetCore.WebSockets", "3.0.0" },
            { "Microsoft.AspNetCore.WebUtilities", "3.0.0" },
            { "Microsoft.Extensions.Caching.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Caching.Memory", "3.0.0" },
            { "Microsoft.Extensions.Configuration", "3.0.0" },
            { "Microsoft.Extensions.Configuration.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Configuration.Binder", "3.0.0" },
            { "Microsoft.Extensions.Configuration.CommandLine", "3.0.0" },
            { "Microsoft.Extensions.Configuration.EnvironmentVariables", "3.0.0" },
            { "Microsoft.Extensions.Configuration.FileExtensions", "3.0.0" },
            { "Microsoft.Extensions.Configuration.Ini", "3.0.0" },
            { "Microsoft.Extensions.Configuration.Json", "3.0.0" },
            { "Microsoft.Extensions.Configuration.KeyPerFile", "3.0.0" },
            { "Microsoft.Extensions.Configuration.UserSecrets", "3.0.0" },
            { "Microsoft.Extensions.Configuration.Xml", "3.0.0" },
            { "Microsoft.Extensions.DependencyInjection", "3.0.0" },
            { "Microsoft.Extensions.DependencyInjection.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Diagnostics.HealthChecks", "3.0.0" },
            { "Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.FileProviders.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.FileProviders.Composite", "3.0.0" },
            { "Microsoft.Extensions.FileProviders.Embedded", "3.0.0" },
            { "Microsoft.Extensions.FileProviders.Physical", "3.0.0" },
            { "Microsoft.Extensions.FileSystemGlobbing", "3.0.0" },
            { "Microsoft.Extensions.Hosting", "3.0.0" },
            { "Microsoft.Extensions.Hosting.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Http", "3.0.0" },
            { "Microsoft.Extensions.Identity.Core", "3.0.0" },
            { "Microsoft.Extensions.Identity.Stores", "3.0.0" },
            { "Microsoft.Extensions.Localization", "3.0.0" },
            { "Microsoft.Extensions.Localization.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Logging", "3.0.0" },
            { "Microsoft.Extensions.Logging.Abstractions", "3.0.0" },
            { "Microsoft.Extensions.Logging.Configuration", "3.0.0" },
            { "Microsoft.Extensions.Logging.Console", "3.0.0" },
            { "Microsoft.Extensions.Logging.Debug", "3.0.0" },
            { "Microsoft.Extensions.Logging.EventLog", "3.0.0" },
            { "Microsoft.Extensions.Logging.EventSource", "3.0.0" },
            { "Microsoft.Extensions.Logging.TraceSource", "3.0.0" },
            { "Microsoft.Extensions.ObjectPool", "3.0.0" },
            { "Microsoft.Extensions.Options", "3.0.0" },
            { "Microsoft.Extensions.Options.ConfigurationExtensions", "3.0.0" },
            { "Microsoft.Extensions.Options.DataAnnotations", "3.0.0" },
            { "Microsoft.Extensions.Primitives", "3.0.0" },
            { "Microsoft.Extensions.WebEncoders", "3.0.0" },
            { "Microsoft.JSInterop", "3.0.0" },
            { "Microsoft.Net.Http.Headers", "3.0.0" },
            { "Microsoft.Win32.Registry", "4.6.0" },
            { "System.Diagnostics.EventLog", "4.6.0" },
            { "System.IO.Pipelines", "4.6.0" },
            { "System.Security.AccessControl", "4.6.0" },
            { "System.Security.Cryptography.Cng", "4.6.0" },
            { "System.Security.Cryptography.Xml", "4.6.0" },
            { "System.Security.Permissions", "4.6.0" },
            { "System.Security.Principal.Windows", "4.6.0" },
            { "System.Windows.Extensions", "4.6.0" },
        };

        internal static FrameworkPackages WindowsDesktop { get; } = new(NetCoreApp30, FrameworkNames.WindowsDesktopApp)
        {
            { "Microsoft.Win32.Registry.AccessControl", "4.6.0" },
            { "Microsoft.Win32.SystemEvents", "4.6.0" },
            { "System.CodeDom", "4.6.0" },
            { "System.Configuration.ConfigurationManager", "4.6.0" },
            { "System.Diagnostics.EventLog", "4.6.0" },
            { "System.Diagnostics.PerformanceCounter", "4.5.0" },
            { "System.DirectoryServices", "4.6.0" },
            { "System.Drawing.Common", "4.7.3" },
            { "System.IO.Packaging", "4.6.0" },
            { "System.Resources.Extensions", "4.6.0" },
            { "System.Security.Cryptography.Pkcs", "4.6.0" },
            { "System.Security.Cryptography.ProtectedData", "4.6.0" },
            { "System.Security.Cryptography.Xml", "4.6.0" },
            { "System.Security.Permissions", "4.6.0" },
            { "System.Threading.AccessControl", "4.6.0" },
            { "System.Windows.Extensions", "4.6.0" },
        };

        internal static void Register() => FrameworkPackages.Register(Instance, AspNetCore, WindowsDesktop);
    }
}
