namespace Microsoft.ComponentDetection.Detectors.NuGet;

using static global::NuGet.Frameworks.FrameworkConstants.CommonFrameworks;

/// <summary>
/// Framework packages for net5.0.
/// </summary>
internal partial class FrameworkPackages
{
    internal static class NETCoreApp50
    {
        internal static FrameworkPackages Instance { get; } = new(Net50, FrameworkNames.NetCoreApp, NETCoreApp31.Instance)
        {
            { "Microsoft.Win32.Registry", "5.0.0" },
            { "System.Collections.Immutable", "5.0.0" },
            { "System.ComponentModel.Annotations", "5.0.0" },
            { "System.Diagnostics.DiagnosticSource", "5.0.0" },
            { "System.Formats.Asn1", "5.0.0" },
            { "System.IO.FileSystem.AccessControl", "5.0.0" },
            { "System.Net.Http.Json", "5.0.0" },
            { "System.Reflection.DispatchProxy", "4.7.1" },
            { "System.Reflection.Metadata", "5.0.0" },
            { "System.Runtime.CompilerServices.Unsafe", "5.0.0" },
            { "System.Security.AccessControl", "5.0.0" },
            { "System.Security.Cryptography.OpenSsl", "5.0.0" },
            { "System.Security.Principal.Windows", "5.0.0" },
            { "System.Text.Encoding.CodePages", "5.0.0" },
            { "System.Text.Encodings.Web", "5.0.0" },
            { "System.Text.Json", "5.0.0" },
            { "System.Threading.Channels", "5.0.0" },
            { "System.Threading.Tasks.Dataflow", "5.0.0" },
        };

        internal static FrameworkPackages AspNetCore { get; } = new(Net50, FrameworkNames.AspNetCoreApp, NETCoreApp31.AspNetCore)
        {
            { "Microsoft.AspNetCore", "5.0.0" },
            { "Microsoft.AspNetCore.Antiforgery", "5.0.0" },
            { "Microsoft.AspNetCore.Authentication", "5.0.0" },
            { "Microsoft.AspNetCore.Authentication.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Authentication.Cookies", "5.0.0" },
            { "Microsoft.AspNetCore.Authentication.Core", "5.0.0" },
            { "Microsoft.AspNetCore.Authentication.OAuth", "5.0.0" },
            { "Microsoft.AspNetCore.Authorization", "5.0.0" },
            { "Microsoft.AspNetCore.Authorization.Policy", "5.0.0" },
            { "Microsoft.AspNetCore.Components", "5.0.0" },
            { "Microsoft.AspNetCore.Components.Authorization", "5.0.0" },
            { "Microsoft.AspNetCore.Components.Forms", "5.0.0" },
            { "Microsoft.AspNetCore.Components.Server", "5.0.0" },
            { "Microsoft.AspNetCore.Components.Web", "5.0.0" },
            { "Microsoft.AspNetCore.Connections.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.CookiePolicy", "5.0.0" },
            { "Microsoft.AspNetCore.Cors", "5.0.0" },
            { "Microsoft.AspNetCore.Cryptography.Internal", "5.0.0" },
            { "Microsoft.AspNetCore.Cryptography.KeyDerivation", "5.0.0" },
            { "Microsoft.AspNetCore.DataProtection", "5.0.0" },
            { "Microsoft.AspNetCore.DataProtection.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.DataProtection.Extensions", "5.0.0" },
            { "Microsoft.AspNetCore.Diagnostics", "5.0.0" },
            { "Microsoft.AspNetCore.Diagnostics.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Diagnostics.HealthChecks", "5.0.0" },
            { "Microsoft.AspNetCore.HostFiltering", "5.0.0" },
            { "Microsoft.AspNetCore.Hosting", "5.0.0" },
            { "Microsoft.AspNetCore.Hosting.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Hosting.Server.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Html.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Http", "5.0.0" },
            { "Microsoft.AspNetCore.Http.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Http.Connections", "5.0.0" },
            { "Microsoft.AspNetCore.Http.Connections.Common", "5.0.0" },
            { "Microsoft.AspNetCore.Http.Extensions", "5.0.0" },
            { "Microsoft.AspNetCore.Http.Features", "5.0.0" },
            { "Microsoft.AspNetCore.HttpOverrides", "5.0.0" },
            { "Microsoft.AspNetCore.HttpsPolicy", "5.0.0" },
            { "Microsoft.AspNetCore.Identity", "5.0.0" },
            { "Microsoft.AspNetCore.Localization", "5.0.0" },
            { "Microsoft.AspNetCore.Localization.Routing", "5.0.0" },
            { "Microsoft.AspNetCore.Metadata", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.ApiExplorer", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Core", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Cors", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.DataAnnotations", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Formatters.Json", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Formatters.Xml", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Localization", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.Razor", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.RazorPages", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.TagHelpers", "5.0.0" },
            { "Microsoft.AspNetCore.Mvc.ViewFeatures", "5.0.0" },
            { "Microsoft.AspNetCore.Razor", "5.0.0" },
            { "Microsoft.AspNetCore.Razor.Runtime", "5.0.0" },
            { "Microsoft.AspNetCore.ResponseCaching", "5.0.0" },
            { "Microsoft.AspNetCore.ResponseCaching.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.ResponseCompression", "5.0.0" },
            { "Microsoft.AspNetCore.Rewrite", "5.0.0" },
            { "Microsoft.AspNetCore.Routing", "5.0.0" },
            { "Microsoft.AspNetCore.Routing.Abstractions", "5.0.0" },
            { "Microsoft.AspNetCore.Server.HttpSys", "5.0.0" },
            { "Microsoft.AspNetCore.Server.IIS", "5.0.0" },
            { "Microsoft.AspNetCore.Server.IISIntegration", "5.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel", "5.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel.Core", "5.0.0" },
            { "Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets", "5.0.0" },
            { "Microsoft.AspNetCore.Session", "5.0.0" },
            { "Microsoft.AspNetCore.SignalR", "5.0.0" },
            { "Microsoft.AspNetCore.SignalR.Common", "5.0.0" },
            { "Microsoft.AspNetCore.SignalR.Core", "5.0.0" },
            { "Microsoft.AspNetCore.SignalR.Protocols.Json", "5.0.0" },
            { "Microsoft.AspNetCore.StaticFiles", "5.0.0" },
            { "Microsoft.AspNetCore.WebSockets", "5.0.0" },
            { "Microsoft.AspNetCore.WebUtilities", "5.0.0" },
            { "Microsoft.Extensions.Caching.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Caching.Memory", "5.0.0" },
            { "Microsoft.Extensions.Configuration", "5.0.0" },
            { "Microsoft.Extensions.Configuration.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Configuration.Binder", "5.0.0" },
            { "Microsoft.Extensions.Configuration.CommandLine", "5.0.0" },
            { "Microsoft.Extensions.Configuration.EnvironmentVariables", "5.0.0" },
            { "Microsoft.Extensions.Configuration.FileExtensions", "5.0.0" },
            { "Microsoft.Extensions.Configuration.Ini", "5.0.0" },
            { "Microsoft.Extensions.Configuration.Json", "5.0.0" },
            { "Microsoft.Extensions.Configuration.KeyPerFile", "5.0.0" },
            { "Microsoft.Extensions.Configuration.UserSecrets", "5.0.0" },
            { "Microsoft.Extensions.Configuration.Xml", "5.0.0" },
            { "Microsoft.Extensions.DependencyInjection", "5.0.0" },
            { "Microsoft.Extensions.DependencyInjection.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Diagnostics.HealthChecks", "5.0.0" },
            { "Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.FileProviders.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.FileProviders.Composite", "5.0.0" },
            { "Microsoft.Extensions.FileProviders.Embedded", "5.0.0" },
            { "Microsoft.Extensions.FileProviders.Physical", "5.0.0" },
            { "Microsoft.Extensions.FileSystemGlobbing", "5.0.0" },
            { "Microsoft.Extensions.Hosting", "5.0.0" },
            { "Microsoft.Extensions.Hosting.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Http", "5.0.0" },
            { "Microsoft.Extensions.Identity.Core", "5.0.0" },
            { "Microsoft.Extensions.Identity.Stores", "5.0.0" },
            { "Microsoft.Extensions.Localization", "5.0.0" },
            { "Microsoft.Extensions.Localization.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Logging", "5.0.0" },
            { "Microsoft.Extensions.Logging.Abstractions", "5.0.0" },
            { "Microsoft.Extensions.Logging.Configuration", "5.0.0" },
            { "Microsoft.Extensions.Logging.Console", "5.0.0" },
            { "Microsoft.Extensions.Logging.Debug", "5.0.0" },
            { "Microsoft.Extensions.Logging.EventLog", "5.0.0" },
            { "Microsoft.Extensions.Logging.EventSource", "5.0.0" },
            { "Microsoft.Extensions.Logging.TraceSource", "5.0.0" },
            { "Microsoft.Extensions.ObjectPool", "5.0.0" },
            { "Microsoft.Extensions.Options", "5.0.0" },
            { "Microsoft.Extensions.Options.ConfigurationExtensions", "5.0.0" },
            { "Microsoft.Extensions.Options.DataAnnotations", "5.0.0" },
            { "Microsoft.Extensions.Primitives", "5.0.0" },
            { "Microsoft.Extensions.WebEncoders", "5.0.0" },
            { "Microsoft.JSInterop", "5.0.0" },
            { "Microsoft.Net.Http.Headers", "5.0.0" },
            { "Microsoft.Win32.Registry", "5.0.0" },
            { "Microsoft.Win32.SystemEvents", "5.0.0" },
            { "System.Diagnostics.EventLog", "5.0.0" },
            { "System.Drawing.Common", "5.0.0" },
            { "System.IO.Pipelines", "5.0.0" },
            { "System.Security.AccessControl", "5.0.0" },
            { "System.Security.Cryptography.Cng", "5.0.0" },
            { "System.Security.Cryptography.Pkcs", "5.0.0" },
            { "System.Security.Cryptography.Xml", "5.0.0" },
            { "System.Security.Permissions", "5.0.0" },
            { "System.Security.Principal.Windows", "5.0.0" },
            { "System.Windows.Extensions", "5.0.0" },
        };

        internal static FrameworkPackages WindowsDesktop { get; } = new(Net50, FrameworkNames.WindowsDesktopApp, NETCoreApp31.WindowsDesktop)
        {
            { "Microsoft.VisualBasic", "10.3.0" },
            { "Microsoft.Win32.Registry", "5.0.0" },
            { "Microsoft.Win32.Registry.AccessControl", "5.0.0" },
            { "Microsoft.Win32.SystemEvents", "5.0.0" },
            { "System.CodeDom", "5.0.0" },
            { "System.Configuration.ConfigurationManager", "5.0.0" },
            { "System.Diagnostics.EventLog", "5.0.0" },
            { "System.Diagnostics.PerformanceCounter", "5.0.0" },
            { "System.Drawing.Common", "5.0.0" },
            { "System.Formats.Asn1", "5.0.0" },
            { "System.IO.FileSystem.AccessControl", "5.0.0" },
            { "System.IO.Packaging", "5.0.0" },
            { "System.IO.Pipes.AccessControl", "5.0.0" },
            { "System.Resources.Extensions", "5.0.0" },
            { "System.Security.AccessControl", "5.0.0" },
            { "System.Security.Cryptography.Cng", "5.0.0" },
            { "System.Security.Cryptography.Pkcs", "5.0.0" },
            { "System.Security.Cryptography.ProtectedData", "5.0.0" },
            { "System.Security.Cryptography.Xml", "5.0.0" },
            { "System.Security.Permissions", "5.0.0" },
            { "System.Security.Principal.Windows", "5.0.0" },
            { "System.Threading.AccessControl", "5.0.0" },
            { "System.Windows.Extensions", "5.0.0" },
        };

        internal static void Register() => FrameworkPackages.Register(Instance, AspNetCore, WindowsDesktop);
    }
}
