// Take schema from https://github.com/anchore/syft/tree/main/schema/json.
// Match version to tag used i.e. https://github.com/anchore/syft/blob/v0.16.1/internal/constants.go#L9
// Can convert JSON Schema to C# using quicktype.io.
// (change name of top Coordinate class to SyftOutput)
// <auto-generated />

namespace Microsoft.ComponentDetection.Detectors.Linux.Contracts;

using System;
using System.Collections.Generic;

public partial class SyftOutput
{
    public ArtifactRelationshipElement[] ArtifactRelationships { get; set; }
    public ArtifactElement[] Artifacts { get; set; }
    public Descriptor Descriptor { get; set; }
    public Distro Distro { get; set; }
    public FileElement[] Files { get; set; }
    public Schema Schema { get; set; }
    public SourceClass Source { get; set; }
}

public partial class ArtifactRelationshipElement
{
    public string Child { get; set; }
    public object Metadata { get; set; }
    public string Parent { get; set; }
    public string Type { get; set; }
}

public partial class ArtifactElement
{
    public string[] Cpes { get; set; }
    public string FoundBy { get; set; }
    public string Id { get; set; }
    public string Language { get; set; }
    public ArtifactLicense[] Licenses { get; set; }
    public LocationElement[] Locations { get; set; }
    public MetadataClass Metadata { get; set; }
    public string MetadataType { get; set; }
    public string Name { get; set; }
    public string Purl { get; set; }
    public string Type { get; set; }
    public string Version { get; set; }
}

public partial class ArtifactLicense
{
    public LocationElement[] Locations { get; set; }
    public string SpdxExpression { get; set; }
    public string Type { get; set; }
    public string[] Urls { get; set; }
    public string Value { get; set; }
}

public partial class LocationElement
{
    public string AccessPath { get; set; }
    public Dictionary<string, string> Annotations { get; set; }
    public string LayerId { get; set; }
    public string Path { get; set; }
}

public partial class MetadataClass
{
    public string Architecture { get; set; }
    public BackupElement[] Backup { get; set; }
    public string Basepackage { get; set; }
    public string Description { get; set; }
    public File[] Files { get; set; }
    public string Package { get; set; }
    public string Packager { get; set; }
    public long? Reason { get; set; }
    public long? Size { get; set; }
    public License? Url { get; set; }
    public string Validation { get; set; }
    public string Version { get; set; }
    public string GitCommitOfApkPort { get; set; }
    public long? InstalledSize { get; set; }
    public string Maintainer { get; set; }
    public string OriginPackage { get; set; }
    public string[] Provides { get; set; }
    public string PullChecksum { get; set; }
    public string[] PullDependencies { get; set; }
    public MatchElement[] Matches { get; set; }
    public string Ref { get; set; }
    public string PackageId { get; set; }
    public string[] BuildRequires { get; set; }
    public string Context { get; set; }
    public Dictionary<string, string> Options { get; set; }
    public string Path { get; set; }
    public string Prev { get; set; }
    public string[] PyRequires { get; set; }
    public string[] Requires { get; set; }
    public string Checksum { get; set; }
    public string HostedUrl { get; set; }
    public string Name { get; set; }
    public string VcsUrl { get; set; }
    public string HashPath { get; set; }
    public string Sha512 { get; set; }
    public string AssemblyVersion { get; set; }
    public string Comments { get; set; }
    public string CompanyName { get; set; }
    public string InternalName { get; set; }
    public string LegalCopyright { get; set; }
    public string ProductName { get; set; }
    public string ProductVersion { get; set; }
    public string[] Depends { get; set; }
    public string[] PreDepends { get; set; }
    public SourceUnion? Source { get; set; }
    public string SourceVersion { get; set; }
    public string PkgHash { get; set; }
    public string PkgHashExt { get; set; }
    public Dictionary<string, string> GoBuildSettings { get; set; }
    public string GoCompiledVersion { get; set; }
    public string[] GoCryptoSettings { get; set; }
    public string H1Digest { get; set; }
    public string MainModule { get; set; }
    public string SnapshotUrl { get; set; }
    public DigestElement[] Digest { get; set; }
    public Manifest Manifest { get; set; }
    public PomProject PomProject { get; set; }
    public PomProperties PomProperties { get; set; }
    public string VirtualPath { get; set; }
    public string Author { get; set; }
    public string Homepage { get; set; }
    public bool? Private { get; set; }
    public string Integrity { get; set; }
    public string Resolved { get; set; }
    public string BuildTime { get; set; }
    public string ExtendedVersion { get; set; }
    public string Format { get; set; }
    public long? RootDevice { get; set; }
    public bool? RwRootFs { get; set; }
    public long? SwapDevice { get; set; }
    public string VideoMode { get; set; }
    public string KernelVersion { get; set; }
    public License? License { get; set; }
    public Dictionary<string, ParameterValue> Parameters { get; set; }
    public string VersionMagic { get; set; }
    public string Kb { get; set; }
    public string ProductId { get; set; }
    public string Output { get; set; }
    public string OutputHash { get; set; }
    public Author[] Authors { get; set; }
    public string[] Bin { get; set; }
    public Dist Dist { get; set; }
    public string[] Keywords { get; set; }
    public string NotificationUrl { get; set; }
    public Dictionary<string, string> Provide { get; set; }
    public Dictionary<string, string> Require { get; set; }
    public Dictionary<string, string> RequireDev { get; set; }
    public Dictionary<string, string> Suggest { get; set; }
    public string Time { get; set; }
    public string Type { get; set; }
    public string AuthorEmail { get; set; }
    public DirectUrlOrigin DirectUrlOrigin { get; set; }
    public string Platform { get; set; }
    public string SitePackagesRootPath { get; set; }
    public string[] TopLevelPackages { get; set; }
    public string[] Extras { get; set; }
    public string Markers { get; set; }
    public string VersionConstraint { get; set; }
    public string[] Hashes { get; set; }
    public string Index { get; set; }
    public string Built { get; set; }
    public string[] Imports { get; set; }
    public bool? NeedsCompilation { get; set; }
    public string Repository { get; set; }
    public string[] Suggests { get; set; }
    public string Title { get; set; }
    public long? Epoch { get; set; }
    public string ModularityLabel { get; set; }
    public string Release { get; set; }
    public string SourceRpm { get; set; }
    public string Vendor { get; set; }
    public string[] Dependencies { get; set; }
    public string Revision { get; set; }
}

public partial class AuthorClass
{
    public string Email { get; set; }
    public string Homepage { get; set; }
    public string Name { get; set; }
}

public partial class BackupElement
{
    public DigestElement[] Digest { get; set; }
    public string Gid { get; set; }
    public string Link { get; set; }
    public string Path { get; set; }
    public string Size { get; set; }
    public DateTimeOffset? Time { get; set; }
    public string Type { get; set; }
    public string Uid { get; set; }
}

public partial class DigestElement
{
    public string Algorithm { get; set; }
    public string Value { get; set; }
}

public partial class DirectUrlOrigin
{
    public string CommitId { get; set; }
    public string Url { get; set; }
    public string Vcs { get; set; }
}

public partial class Dist
{
    public string Reference { get; set; }
    public string Shasum { get; set; }
    public string Type { get; set; }
    public string Url { get; set; }
}

public partial class FileFile
{
    public Digest? Digest { get; set; }
    public string Gid { get; set; }
    public string Link { get; set; }
    public string Path { get; set; }
    public Size? Size { get; set; }
    public DateTimeOffset? Time { get; set; }
    public string Type { get; set; }
    public string Uid { get; set; }
    public string OwnerGid { get; set; }
    public string OwnerUid { get; set; }
    public string Permissions { get; set; }
    public bool? IsConfigFile { get; set; }
    public string Flags { get; set; }
    public string GroupName { get; set; }
    public long? Mode { get; set; }
    public string UserName { get; set; }
}

public partial class PurpleSyftOutpu
{
    public string Algorithm { get; set; }
    public string Value { get; set; }
}

public partial class Manifest
{
    public Dictionary<string, string> Main { get; set; }
    public Dictionary<string, Dictionary<string, string>> NamedSections { get; set; }
}

public partial class MatchElement
{
    public string Classifier { get; set; }
    public LocationElement Location { get; set; }
}

public partial class ParameterValue
{
    public string Description { get; set; }
    public string Type { get; set; }
}

public partial class PomProject
{
    public string ArtifactId { get; set; }
    public string Description { get; set; }
    public string GroupId { get; set; }
    public string Name { get; set; }
    public Parent Parent { get; set; }
    public string Path { get; set; }
    public string Url { get; set; }
    public string Version { get; set; }
}

public partial class Parent
{
    public string ArtifactId { get; set; }
    public string GroupId { get; set; }
    public string Version { get; set; }
}

public partial class PomProperties
{
    public string ArtifactId { get; set; }
    public Dictionary<string, string> ExtraFields { get; set; }
    public string GroupId { get; set; }
    public string Name { get; set; }
    public string Path { get; set; }
    public string Scope { get; set; }
    public string Version { get; set; }
}

public partial class Descriptor
{
    public object Configuration { get; set; }
    public string Name { get; set; }
    public string Version { get; set; }
}

public partial class Distro
{
    public string BugReportUrl { get; set; }
    public string BuildId { get; set; }
    public string CpeName { get; set; }
    public string HomeUrl { get; set; }
    public string Id { get; set; }
    public string[] IdLike { get; set; }
    public string ImageId { get; set; }
    public string ImageVersion { get; set; }
    public string Name { get; set; }
    public string PrettyName { get; set; }
    public string PrivacyPolicyUrl { get; set; }
    public string SupportEnd { get; set; }
    public string SupportUrl { get; set; }
    public string Variant { get; set; }
    public string VariantId { get; set; }
    public string Version { get; set; }
    public string VersionCodename { get; set; }
    public string VersionId { get; set; }
}

public partial class FileElement
{
    public string Contents { get; set; }
    public DigestElement[] Digests { get; set; }
    public string Id { get; set; }
    public FileLicense[] Licenses { get; set; }
    public Location Location { get; set; }
    public Metadata Metadata { get; set; }
}

public partial class FileLicense
{
    public Evidence Evidence { get; set; }
    public string SpdxExpression { get; set; }
    public string Type { get; set; }
    public string Value { get; set; }
}

public partial class Evidence
{
    public long Confidence { get; set; }
    public long Extent { get; set; }
    public long Offset { get; set; }
}

public partial class Location
{
    public string LayerId { get; set; }
    public string Path { get; set; }
}

public partial class Metadata
{
    public long GroupId { get; set; }
    public string LinkDestination { get; set; }
    public string MimeType { get; set; }
    public long Mode { get; set; }
    public long Size { get; set; }
    public string Type { get; set; }
    public long UserId { get; set; }
}

public partial class Schema
{
    public string Url { get; set; }
    public string Version { get; set; }
}

public partial class SourceClass
{
    public string Id { get; set; }
    public object Metadata { get; set; }
    public string Name { get; set; }
    public string Type { get; set; }
    public string Version { get; set; }
}

public partial struct Author
{
    public AuthorClass AuthorClass;
    public string String;

    public static implicit operator Author(AuthorClass AuthorClass) => new Author { AuthorClass = AuthorClass };
    public static implicit operator Author(string String) => new Author { String = String };
}

public partial struct Digest
{
    public DigestElement[] DigestElementArray;
    public PurpleSyftOutpu PurpleSyftOutpu;

    public static implicit operator Digest(DigestElement[] DigestElementArray) => new Digest { DigestElementArray = DigestElementArray };
    public static implicit operator Digest(PurpleSyftOutpu PurpleSyftOutpu) => new Digest { PurpleSyftOutpu = PurpleSyftOutpu };
}

public partial struct Size
{
    public long? Integer;
    public string String;

    public static implicit operator Size(long Integer) => new Size { Integer = Integer };
    public static implicit operator Size(string String) => new Size { String = String };
}

public partial struct File
{
    public FileFile FileFile;
    public string String;

    public static implicit operator File(FileFile FileFile) => new File { FileFile = FileFile };
    public static implicit operator File(string String) => new File { String = String };
}

public partial struct License
{
    public string String;
    public string[] StringArray;

    public static implicit operator License(string String) => new License { String = String };
    public static implicit operator License(string[] StringArray) => new License { StringArray = StringArray };
}

public partial struct SourceUnion
{
    public Dist Dist;
    public string String;

    public static implicit operator SourceUnion(Dist Dist) => new SourceUnion { Dist = Dist };
    public static implicit operator SourceUnion(string String) => new SourceUnion { String = String };
}
