# Welcome!

The measurements kata covers the following topics:
- single-qubit measurements
- quantum state discrimination for both orthogonal and non-orthogonal states

Variations of quantum state discrimination tasks are covered in the paper ["Quantum State Discrimination"](https://arxiv.org/pdf/quant-ph/0010114.pdf).
* Task 2.1 is an example of hypothesis testing for two pure states.
* Task 2.2 is an example of unambiguous state discrimination. See also the paper ["Unambiguous quantum measurement of nonorthogonal states"](https://www.researchgate.net/publication/13375059_Unambiguous_quantum_measurement_of_nonorthogonal_states)
  for further information and hints about how to implement the unambiguous measurements required for this task. 
* Task 2.3 is the so-called Wootters/Peres game. See the following three references for more information and in particular
  the book [3, p. 287] for a nice description of the optimal POVM. 

  [1] A. Holevo, "Information-theoretical aspects of quantum measurement," Problems of Information Transmission, vol. 9, no. 2, pp. 110-118 (1973)

  [2] A. Peres and W. K. Wootters, "Optimal detection of quantum information," Phys. Rev. Lett., vol. 66, pp. 1119-1122, Mar. 1991.

  [3] A. Peres, "Quantum Theory: Concepts and Methods," Kluwer Academic Publishers, 2002.
