# Welcome!

The Grover's Algorithm kata covers Grover's search algorithm, which is one of the fundamental quantum computing algorithms.
It solves the problem of finding an input to a black box (oracle) that produces a particular output.

#### Theory
* The tasks follow the explanation from *Quantum Computation and Quantum Information* by Nielsen and Chuang.
  In the 10th anniversary edition, this is section 6.1.2 on pages 248-251.
* [This Microsoft Learn module](https://docs.microsoft.com/learn/modules/solve-graph-coloring-problems-grovers-search/) offers a different, visual explanation of Grover's algorithm.
* A different explanation of Grover's algorithm can be found in 
  [this Wikipedia article](https://en.wikipedia.org/wiki/Grover%27s_algorithm).
* [An Introduction to Quantum Algorithms](https://strubell.github.io/assets/pdf/quantum_tutorial.pdf) by Emma Strubell, pages 20-24.
* [Lecture 4: Grover's Algorithm](https://www.cs.cmu.edu/~odonnell/quantum15/lecture04.pdf) by John Wright.
* Lectures [12](https://cs.uwaterloo.ca/~watrous/QC-notes/QC-notes.12.pdf) and [13](https://cs.uwaterloo.ca/~watrous/QC-notes/QC-notes.13.pdf) by John Watrous.
* Here is an [animated demonstration of Grover's algorithm](http://davidbkemp.github.io/animated-qubits/grover.html) for a simple case.

#### Q# materials

* Q# Samples repository has an [implementation of Grover's search](https://github.com/microsoft/Quantum/tree/main/samples/algorithms/database-search).
