# Welcome!

This kata covers the concept of a quantum oracle and Deutsch-Jozsa and Bernstein-Vazirani algorithms. 

#### Quantum oracles

A good introduction to quantum oracles can be found in [the Q# documentation](https://docs.microsoft.com/azure/quantum/concepts-oracles).

#### Deutsch-Jozsa algorithm

This algorithm has no practical use, but it is famous for being one of the first examples of a quantum algorithm that is exponentially faster than any deterministic classical algorithm.

* A good place to start is [Wikipedia](https://en.wikipedia.org/wiki/Deutsch%E2%80%93Jozsa_algorithm).
* Nielsen, M. A. & Chuang, I. L. (2010). Quantum Computation and Quantum Information. pp. 34-36
* [Lecture 5: A simple searching algorithm; the Deutsch-Jozsa algorithm](https://cs.uwaterloo.ca/~watrous/QC-notes/QC-notes.05.pdf)

#### Bernstein-Vazirani algorithm

* Bernstein, E. & Vazirani, U. (1997). Quantum complexity theory. SIAM J. Comput. 26, 5, pp. 1411-1473.
* ["Quantum Algorithm Implementations for Beginners"](https://arxiv.org/pdf/1804.03719.pdf), section III.
* ["A Generalization of Bernstein-Vazirani Algorithm to Qudit Systems"](https://arxiv.org/pdf/1609.03185.pdf).
 
