# Welcome!

This kata covers the CHSH game, one of the most famous examples of a nonlocal
(entanglement) game. 

In a nonlocal game, several cooperating players play a game against a referee answering the referee's questions. The players are free to share information
(and even qubits!) before the game starts, but are forbidden from communicating
with each other afterwards. Nonlocal games show that quantum entanglement can be
used to increase the players' chance of winning beyond what would be possible with a
purely classical strategy.

#### Theory

* [Lecture 20](https://cs.uwaterloo.ca/~watrous/QC-notes/QC-notes.20.pdf) by
  John Watrous.

#### Q# Materials

* Q# Samples repository has [an implementation of the CHSH
  game](https://github.com/microsoft/Quantum/tree/main/samples/algorithms/chsh-game)
  that includes an explanation of the history and theory behind the game.