﻿/**** Git Credential Manager for Windows ****
 *
 * Copyright (c) Microsoft Corporation
 * All rights reserved.
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the """"Software""""), to deal
 * in the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED *AS IS*, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE."
**/

using System;

namespace Microsoft.Alm.Authentication.Git
{
    [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames")]
    [Flags]
    public enum ConfigurationLevel
    {
        None = 0,

        /// <summary>
        /// Git portable configuration (only applies to Git for Windows).
        /// </summary>
        Portable = 1 << 0,

        /// <summary>
        /// Git system, or per installation, configuration.
        /// </summary>
        System = 1 << 1,

        /// <summary>
        /// Git XDG, or X Windows specific, configuration.
        /// </summary>
        Xdg = 1 << 2,

        /// <summary>
        /// Git global, or per user, configuration.
        /// </summary>
        Global = 1 << 3,

        /// <summary>
        /// Git local, or per repository, configuration.
        /// </summary>
        Local = 1 << 4,

        All = Portable
            | System
            | Xdg
            | Global
            | Local,

        NoLocal = All & ~Local,
        NoSystem = All & ~(Portable | System),
        UserOnly = All & ~(Portable | System | Local)
    }
}
