[Adaptive Cards Javascript SDK](../README.md) / schema

# Module: schema

## Table of contents

### Interfaces

- [IAction](../interfaces/schema.iaction.md)
- [IAdaptiveCard](../interfaces/schema.iadaptivecard.md)
- [IBackgroundImage](../interfaces/schema.ibackgroundimage.md)
- [ICardElement](../interfaces/schema.icardelement.md)
- [IChoice](../interfaces/schema.ichoice.md)
- [IChoiceSetInput](../interfaces/schema.ichoicesetinput.md)
- [IColumn](../interfaces/schema.icolumn.md)
- [IColumnSet](../interfaces/schema.icolumnset.md)
- [IContainer](../interfaces/schema.icontainer.md)
- [IDateInput](../interfaces/schema.idateinput.md)
- [IFact](../interfaces/schema.ifact.md)
- [IFactSet](../interfaces/schema.ifactset.md)
- [IImage](../interfaces/schema.iimage.md)
- [IImageSet](../interfaces/schema.iimageset.md)
- [IInput](../interfaces/schema.iinput.md)
- [INumberInput](../interfaces/schema.inumberinput.md)
- [IOpenUrlAction](../interfaces/schema.iopenurlaction.md)
- [IShowCardAction](../interfaces/schema.ishowcardaction.md)
- [ISubmitAction](../interfaces/schema.isubmitaction.md)
- [ITextBlock](../interfaces/schema.itextblock.md)
- [ITextInput](../interfaces/schema.itextinput.md)
- [ITimeInput](../interfaces/schema.itimeinput.md)
- [IToggleInput](../interfaces/schema.itoggleinput.md)
- [IVersion](../interfaces/schema.iversion.md)

### Type aliases

- [ContainerStyle](schema.md#containerstyle)
- [HorizontalAlignment](schema.md#horizontalalignment)
- [ImageStyle](schema.md#imagestyle)
- [Size](schema.md#size)
- [Spacing](schema.md#spacing)
- [TextColor](schema.md#textcolor)
- [TextSize](schema.md#textsize)
- [TextWeight](schema.md#textweight)
- [VerticalAlignment](schema.md#verticalalignment)

## Type aliases

### ContainerStyle

Ƭ **ContainerStyle**: *default* \| *emphasis*

Defined in: [schema.ts:10](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L10)

___

### HorizontalAlignment

Ƭ **HorizontalAlignment**: *left* \| *center* \| *right*

Defined in: [schema.ts:5](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L5)

___

### ImageStyle

Ƭ **ImageStyle**: *default* \| *person*

Defined in: [schema.ts:11](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L11)

___

### Size

Ƭ **Size**: *auto* \| *stretch* \| *small* \| *medium* \| *large*

Defined in: [schema.ts:3](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L3)

___

### Spacing

Ƭ **Spacing**: *none* \| *small* \| *default* \| *medium* \| *large* \| *extraLarge* \| *padding*

Defined in: [schema.ts:7](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L7)

___

### TextColor

Ƭ **TextColor**: *default* \| *dark* \| *light* \| *accent* \| *good* \| *warning* \| *attention*

Defined in: [schema.ts:9](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L9)

___

### TextSize

Ƭ **TextSize**: *small* \| *default* \| *medium* \| *large* \| *extraLarge*

Defined in: [schema.ts:4](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L4)

___

### TextWeight

Ƭ **TextWeight**: *lighter* \| *default* \| *bolder*

Defined in: [schema.ts:8](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L8)

___

### VerticalAlignment

Ƭ **VerticalAlignment**: *top* \| *center* \| *bottom*

Defined in: [schema.ts:6](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/schema.ts#L6)
