[Adaptive Cards Javascript SDK](../README.md) / adaptivecards

# Module: adaptivecards

## Table of contents

### References

- [IAdaptiveCard](adaptivecards.md#iadaptivecard)
- [ICardElement](adaptivecards.md#icardelement)

### Enumerations

- [ActionAlignment](../enums/adaptivecards.actionalignment.md)
- [ActionIconPlacement](../enums/adaptivecards.actioniconplacement.md)
- [ContainerFitStatus](../enums/adaptivecards.containerfitstatus.md)
- [FillMode](../enums/adaptivecards.fillmode.md)
- [FontType](../enums/adaptivecards.fonttype.md)
- [HorizontalAlignment](../enums/adaptivecards.horizontalalignment.md)
- [ImageSize](../enums/adaptivecards.imagesize.md)
- [ImageStyle](../enums/adaptivecards.imagestyle.md)
- [InputTextStyle](../enums/adaptivecards.inputtextstyle.md)
- [Orientation](../enums/adaptivecards.orientation.md)
- [ShowCardActionMode](../enums/adaptivecards.showcardactionmode.md)
- [Size](../enums/adaptivecards.size.md)
- [SizeUnit](../enums/adaptivecards.sizeunit.md)
- [Spacing](../enums/adaptivecards.spacing.md)
- [TextColor](../enums/adaptivecards.textcolor.md)
- [TextSize](../enums/adaptivecards.textsize.md)
- [TextWeight](../enums/adaptivecards.textweight.md)
- [ValidationEvent](../enums/adaptivecards.validationevent.md)
- [ValidationPhase](../enums/adaptivecards.validationphase.md)
- [VerticalAlignment](../enums/adaptivecards.verticalalignment.md)

### Classes

- [Action](../classes/adaptivecards.action.md)
- [ActionProperty](../classes/adaptivecards.actionproperty.md)
- [ActionSet](../classes/adaptivecards.actionset.md)
- [ActionStyle](../classes/adaptivecards.actionstyle.md)
- [ActionsConfig](../classes/adaptivecards.actionsconfig.md)
- [AdaptiveCard](../classes/adaptivecards.adaptivecard.md)
- [AdaptiveCardConfig](../classes/adaptivecards.adaptivecardconfig.md)
- [BackgroundImage](../classes/adaptivecards.backgroundimage.md)
- [BaseSerializationContext](../classes/adaptivecards.baseserializationcontext.md)
- [BaseTextBlock](../classes/adaptivecards.basetextblock.md)
- [BaseTextDefinition](../classes/adaptivecards.basetextdefinition.md)
- [BoolProperty](../classes/adaptivecards.boolproperty.md)
- [CardElement](../classes/adaptivecards.cardelement.md)
- [CardElementContainer](../classes/adaptivecards.cardelementcontainer.md)
- [CardObject](../classes/adaptivecards.cardobject.md)
- [CardObjectRegistry](../classes/adaptivecards.cardobjectregistry.md)
- [Choice](../classes/adaptivecards.choice.md)
- [ChoiceSetInput](../classes/adaptivecards.choicesetinput.md)
- [ColorDefinition](../classes/adaptivecards.colordefinition.md)
- [ColorSetDefinition](../classes/adaptivecards.colorsetdefinition.md)
- [Column](../classes/adaptivecards.column.md)
- [ColumnSet](../classes/adaptivecards.columnset.md)
- [Container](../classes/adaptivecards.container.md)
- [ContainerStyle](../classes/adaptivecards.containerstyle.md)
- [ContainerStyleDefinition](../classes/adaptivecards.containerstyledefinition.md)
- [ContainerStyleSet](../classes/adaptivecards.containerstyleset.md)
- [ContainerWithActions](../classes/adaptivecards.containerwithactions.md)
- [CustomProperty](../classes/adaptivecards.customproperty.md)
- [DateInput](../classes/adaptivecards.dateinput.md)
- [EnumProperty](../classes/adaptivecards.enumproperty.md)
- [Fact](../classes/adaptivecards.fact.md)
- [FactSet](../classes/adaptivecards.factset.md)
- [FactSetConfig](../classes/adaptivecards.factsetconfig.md)
- [FactTextDefinition](../classes/adaptivecards.facttextdefinition.md)
- [FactTitleDefinition](../classes/adaptivecards.facttitledefinition.md)
- [FontTypeDefinition](../classes/adaptivecards.fonttypedefinition.md)
- [FontTypeSet](../classes/adaptivecards.fonttypeset.md)
- [GlobalRegistry](../classes/adaptivecards.globalregistry.md)
- [GlobalSettings](../classes/adaptivecards.globalsettings.md)
- [HostConfig](../classes/adaptivecards.hostconfig.md)
- [HttpAction](../classes/adaptivecards.httpaction.md)
- [HttpHeader](../classes/adaptivecards.httpheader.md)
- [Image](../classes/adaptivecards.image.md)
- [ImageSet](../classes/adaptivecards.imageset.md)
- [ImageSetConfig](../classes/adaptivecards.imagesetconfig.md)
- [Input](../classes/adaptivecards.input.md)
- [InputConfig](../classes/adaptivecards.inputconfig.md)
- [InputLabelConfig](../classes/adaptivecards.inputlabelconfig.md)
- [Media](../classes/adaptivecards.media.md)
- [MediaConfig](../classes/adaptivecards.mediaconfig.md)
- [MediaSource](../classes/adaptivecards.mediasource.md)
- [NumProperty](../classes/adaptivecards.numproperty.md)
- [NumberInput](../classes/adaptivecards.numberinput.md)
- [OpenUrlAction](../classes/adaptivecards.openurlaction.md)
- [PaddingDefinition](../classes/adaptivecards.paddingdefinition.md)
- [PixelSizeProperty](../classes/adaptivecards.pixelsizeproperty.md)
- [PropertyDefinition](../classes/adaptivecards.propertydefinition.md)
- [RequiredInputLabelTextDefinition](../classes/adaptivecards.requiredinputlabeltextdefinition.md)
- [RichTextBlock](../classes/adaptivecards.richtextblock.md)
- [SerializableObject](../classes/adaptivecards.serializableobject.md)
- [SerializableObjectCollectionProperty](../classes/adaptivecards.serializableobjectcollectionproperty.md)
- [SerializableObjectProperty](../classes/adaptivecards.serializableobjectproperty.md)
- [SerializableObjectSchema](../classes/adaptivecards.serializableobjectschema.md)
- [SerializationContext](../classes/adaptivecards.serializationcontext.md)
- [ShowCardAction](../classes/adaptivecards.showcardaction.md)
- [ShowCardActionConfig](../classes/adaptivecards.showcardactionconfig.md)
- [SizeAndUnit](../classes/adaptivecards.sizeandunit.md)
- [SpacingDefinition](../classes/adaptivecards.spacingdefinition.md)
- [StringProperty](../classes/adaptivecards.stringproperty.md)
- [StringWithSubstitutions](../classes/adaptivecards.stringwithsubstitutions.md)
- [Strings](../classes/adaptivecards.strings.md)
- [StylableCardElementContainer](../classes/adaptivecards.stylablecardelementcontainer.md)
- [SubmitAction](../classes/adaptivecards.submitaction.md)
- [TextBlock](../classes/adaptivecards.textblock.md)
- [TextColorDefinition](../classes/adaptivecards.textcolordefinition.md)
- [TextInput](../classes/adaptivecards.textinput.md)
- [TextRun](../classes/adaptivecards.textrun.md)
- [TimeInput](../classes/adaptivecards.timeinput.md)
- [TimeProperty](../classes/adaptivecards.timeproperty.md)
- [ToggleInput](../classes/adaptivecards.toggleinput.md)
- [ToggleVisibilityAction](../classes/adaptivecards.togglevisibilityaction.md)
- [UUID](../classes/adaptivecards.uuid.md)
- [ValidationResults](../classes/adaptivecards.validationresults.md)
- [ValueSetProperty](../classes/adaptivecards.valuesetproperty.md)
- [Version](../classes/adaptivecards.version.md)
- [Versions](../classes/adaptivecards.versions.md)

### Interfaces

- [IFontSizeDefinitions](../interfaces/adaptivecards.ifontsizedefinitions.md)
- [IFontWeightDefinitions](../interfaces/adaptivecards.ifontweightdefinitions.md)
- [IInput](../interfaces/adaptivecards.iinput.md)
- [ILineHeightDefinitions](../interfaces/adaptivecards.ilineheightdefinitions.md)
- [IMarkdownProcessingResult](../interfaces/adaptivecards.imarkdownprocessingresult.md)
- [IResourceInformation](../interfaces/adaptivecards.iresourceinformation.md)
- [ISeparationDefinition](../interfaces/adaptivecards.iseparationdefinition.md)
- [ITypeRegistration](../interfaces/adaptivecards.ityperegistration.md)
- [IValidationEvent](../interfaces/adaptivecards.ivalidationevent.md)
- [IVersionedValue](../interfaces/adaptivecards.iversionedvalue.md)

### Type aliases

- [ActionType](adaptivecards.md#actiontype)
- [CardElementHeight](adaptivecards.md#cardelementheight)
- [CardObjectType](adaptivecards.md#cardobjecttype)
- [ColumnWidth](adaptivecards.md#columnwidth)
- [Dictionary](adaptivecards.md#dictionary)
- [PropertyBag](adaptivecards.md#propertybag)
- [SerializableObjectType](adaptivecards.md#serializableobjecttype)
- [TargetVersion](adaptivecards.md#targetversion)

### Variables

- [ContentTypes](adaptivecards.md#contenttypes)
- [defaultHostConfig](adaptivecards.md#defaulthostconfig)

### Functions

- [appendChild](adaptivecards.md#appendchild)
- [generateUniqueId](adaptivecards.md#generateuniqueid)
- [getEnumValueByName](adaptivecards.md#getenumvaluebyname)
- [getFitStatus](adaptivecards.md#getfitstatus)
- [isInternetExplorer](adaptivecards.md#isinternetexplorer)
- [isMobileOS](adaptivecards.md#ismobileos)
- [isVersionLessOrEqual](adaptivecards.md#isversionlessorequal)
- [parseBool](adaptivecards.md#parsebool)
- [parseEnum](adaptivecards.md#parseenum)
- [parseNumber](adaptivecards.md#parsenumber)
- [parseString](adaptivecards.md#parsestring)
- [property](adaptivecards.md#property)
- [renderSeparation](adaptivecards.md#renderseparation)
- [stringToCssColor](adaptivecards.md#stringtocsscolor)
- [truncate](adaptivecards.md#truncate)

## References

### IAdaptiveCard

Re-exports: [IAdaptiveCard](../interfaces/schema.iadaptivecard.md)

___

### ICardElement

Re-exports: [ICardElement](../interfaces/schema.icardelement.md)

## Type aliases

### ActionType

Ƭ **ActionType**: *object*

#### Type declaration:

Defined in: [card-elements.ts:3715](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L3715)

___

### CardElementHeight

Ƭ **CardElementHeight**: *auto* \| *stretch*

Defined in: [card-elements.ts:16](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L16)

___

### CardObjectType

Ƭ **CardObjectType**: *object*

#### Type declaration:

Defined in: [card-object.ts:27](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L27)

___

### ColumnWidth

Ƭ **ColumnWidth**: [*SizeAndUnit*](../classes/shared.sizeandunit.md) \| *auto* \| *stretch*

Defined in: [card-elements.ts:5714](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5714)

___

### Dictionary

Ƭ **Dictionary**<T\>: *object*

#### Type parameters:

Name |
:------ |
`T` |

#### Type declaration:

Defined in: [shared.ts:36](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/shared.ts#L36)

___

### PropertyBag

Ƭ **PropertyBag**: *object*

#### Type declaration:

Defined in: [serialization.ts:771](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L771)

___

### SerializableObjectType

Ƭ **SerializableObjectType**: *object*

#### Type declaration:

Defined in: [serialization.ts:605](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L605)

___

### TargetVersion

Ƭ **TargetVersion**: [*Version*](../classes/serialization.version.md) \| ***

Defined in: [serialization.ts:103](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L103)

## Variables

### ContentTypes

• `Const` **ContentTypes**: *object*

#### Type declaration:

Name | Type |
:------ | :------ |
`applicationJson` | *string* |
`applicationXWwwFormUrlencoded` | *string* |

Defined in: [shared.ts:19](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/shared.ts#L19)

___

### defaultHostConfig

• `Const` **defaultHostConfig**: [*HostConfig*](../classes/host_config.hostconfig.md)

Defined in: [host-config.ts:717](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/host-config.ts#L717)

## Functions

### appendChild

▸ **appendChild**(`node`: Node, `child`: Node \| *undefined*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`node` | Node |
`child` | Node \| *undefined* |

**Returns:** *void*

Defined in: [utils.ts:33](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L33)

___

### generateUniqueId

▸ **generateUniqueId**(): *string*

Generate a UUID prepended with "__ac-"

**Returns:** *string*

Defined in: [utils.ts:29](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L29)

___

### getEnumValueByName

▸ **getEnumValueByName**(`enumType`: { [s: number]: *string*;  }, `name`: *string*): *number* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`enumType` | *object* |
`name` | *string* |

**Returns:** *number* \| *undefined*

Defined in: [utils.ts:65](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L65)

___

### getFitStatus

▸ **getFitStatus**(`element`: HTMLElement, `containerEnd`: *number*): [*ContainerFitStatus*](../enums/enums.containerfitstatus.md)

#### Parameters:

Name | Type |
:------ | :------ |
`element` | HTMLElement |
`containerEnd` | *number* |

**Returns:** [*ContainerFitStatus*](../enums/enums.containerfitstatus.md)

Defined in: [utils.ts:233](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L233)

___

### isInternetExplorer

▸ **isInternetExplorer**(): *boolean*

**Returns:** *boolean*

Defined in: [utils.ts:15](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L15)

___

### isMobileOS

▸ **isMobileOS**(): *boolean*

**Returns:** *boolean*

Defined in: [utils.ts:20](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L20)

___

### isVersionLessOrEqual

▸ **isVersionLessOrEqual**(`version`: [*TargetVersion*](serialization.md#targetversion), `targetVersion`: [*TargetVersion*](serialization.md#targetversion)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`version` | [*TargetVersion*](serialization.md#targetversion) |
`targetVersion` | [*TargetVersion*](serialization.md#targetversion) |

**Returns:** *boolean*

Defined in: [serialization.ts:113](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L113)

___

### parseBool

▸ **parseBool**(`value`: *any*, `defaultValue?`: *boolean*): *boolean* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *any* |
`defaultValue?` | *boolean* |

**Returns:** *boolean* \| *undefined*

Defined in: [utils.ts:47](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L47)

___

### parseEnum

▸ **parseEnum**(`enumType`: { [s: number]: *string*;  }, `name`: *string*, `defaultValue?`: *number*): *number* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`enumType` | *object* |
`name` | *string* |
`defaultValue?` | *number* |

**Returns:** *number* \| *undefined*

Defined in: [utils.ts:81](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L81)

___

### parseNumber

▸ **parseNumber**(`obj`: *any*, `defaultValue?`: *number*): *number* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`obj` | *any* |
`defaultValue?` | *number* |

**Returns:** *number* \| *undefined*

Defined in: [utils.ts:43](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L43)

___

### parseString

▸ **parseString**(`obj`: *any*, `defaultValue?`: *string*): *string* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`obj` | *any* |
`defaultValue?` | *string* |

**Returns:** *string* \| *undefined*

Defined in: [utils.ts:39](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L39)

___

### property

▸ **property**(`property`: [*PropertyDefinition*](../classes/serialization.propertydefinition.md)): (`target`: *any*, `propertyKey`: *string*) => *void*

#### Parameters:

Name | Type |
:------ | :------ |
`property` | [*PropertyDefinition*](../classes/serialization.propertydefinition.md) |

**Returns:** *function*

Defined in: [serialization.ts:758](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L758)

___

### renderSeparation

▸ **renderSeparation**(`hostConfig`: [*HostConfig*](../classes/host_config.hostconfig.md), `separationDefinition`: [*ISeparationDefinition*](../interfaces/shared.iseparationdefinition.md), `orientation`: [*Orientation*](../enums/enums.orientation.md)): HTMLElement \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`hostConfig` | [*HostConfig*](../classes/host_config.hostconfig.md) |
`separationDefinition` | [*ISeparationDefinition*](../interfaces/shared.iseparationdefinition.md) |
`orientation` | [*Orientation*](../enums/enums.orientation.md) |

**Returns:** HTMLElement \| *undefined*

Defined in: [utils.ts:91](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L91)

___

### stringToCssColor

▸ **stringToCssColor**(`color`: *string* \| *undefined*): *string* \| *undefined*

#### Parameters:

Name | Type |
:------ | :------ |
`color` | *string* \| *undefined* |

**Returns:** *string* \| *undefined*

Defined in: [utils.ts:130](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L130)

___

### truncate

▸ **truncate**(`element`: HTMLElement, `maxHeight`: *number*, `lineHeight?`: *number*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | HTMLElement |
`maxHeight` | *number* |
`lineHeight?` | *number* |

**Returns:** *void*

Defined in: [utils.ts:148](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/utils.ts#L148)
