[Adaptive Cards Javascript SDK](../README.md) / [adaptivecards](../modules/adaptivecards.md) / AdaptiveCard

# Class: AdaptiveCard

[adaptivecards](../modules/adaptivecards.md).AdaptiveCard

## Hierarchy

* [*ContainerWithActions*](card_elements.containerwithactions.md)

  ↳ **AdaptiveCard**

## Table of contents

### Constructors

- [constructor](adaptivecards.adaptivecard.md#constructor)

### Properties

- [\_parent](adaptivecards.adaptivecard.md#_parent)
- [\_renderedElement](adaptivecards.adaptivecard.md#_renderedelement)
- [\_selectAction](adaptivecards.adaptivecard.md#_selectaction)
- [allowVerticalOverflow](adaptivecards.adaptivecard.md#allowverticaloverflow)
- [customCssSelector](adaptivecards.adaptivecard.md#customcssselector)
- [designMode](adaptivecards.adaptivecard.md#designmode)
- [fallbackText](adaptivecards.adaptivecard.md#fallbacktext)
- [height](adaptivecards.adaptivecard.md#height)
- [horizontalAlignment](adaptivecards.adaptivecard.md#horizontalalignment)
- [id](adaptivecards.adaptivecard.md#id)
- [maxVersion](adaptivecards.adaptivecard.md#maxversion)
- [minPixelHeight](adaptivecards.adaptivecard.md#minpixelheight)
- [onAnchorClicked](adaptivecards.adaptivecard.md#onanchorclicked)
- [onElementVisibilityChanged](adaptivecards.adaptivecard.md#onelementvisibilitychanged)
- [onExecuteAction](adaptivecards.adaptivecard.md#onexecuteaction)
- [onImageLoaded](adaptivecards.adaptivecard.md#onimageloaded)
- [onInlineCardExpanded](adaptivecards.adaptivecard.md#oninlinecardexpanded)
- [onInputValueChanged](adaptivecards.adaptivecard.md#oninputvaluechanged)
- [onPreProcessPropertyValue](adaptivecards.adaptivecard.md#onpreprocesspropertyvalue)
- [rtl](adaptivecards.adaptivecard.md#rtl)
- [separator](adaptivecards.adaptivecard.md#separator)
- [spacing](adaptivecards.adaptivecard.md#spacing)
- [speak](adaptivecards.adaptivecard.md#speak)
- [version](adaptivecards.adaptivecard.md#version)
- [verticalContentAlignment](adaptivecards.adaptivecard.md#verticalcontentalignment)
- [$schemaProperty](adaptivecards.adaptivecard.md#$schemaproperty)
- [backgroundImageProperty](adaptivecards.adaptivecard.md#backgroundimageproperty)
- [bleedProperty](adaptivecards.adaptivecard.md#bleedproperty)
- [defaultMaxVersion](adaptivecards.adaptivecard.md#defaultmaxversion)
- [fallbackTextProperty](adaptivecards.adaptivecard.md#fallbacktextproperty)
- [heightProperty](adaptivecards.adaptivecard.md#heightproperty)
- [horizontalAlignmentProperty](adaptivecards.adaptivecard.md#horizontalalignmentproperty)
- [idProperty](adaptivecards.adaptivecard.md#idproperty)
- [isVisibleProperty](adaptivecards.adaptivecard.md#isvisibleproperty)
- [langProperty](adaptivecards.adaptivecard.md#langproperty)
- [minHeightProperty](adaptivecards.adaptivecard.md#minheightproperty)
- [onAnchorClicked](adaptivecards.adaptivecard.md#onanchorclicked)
- [onElementVisibilityChanged](adaptivecards.adaptivecard.md#onelementvisibilitychanged)
- [onExecuteAction](adaptivecards.adaptivecard.md#onexecuteaction)
- [onImageLoaded](adaptivecards.adaptivecard.md#onimageloaded)
- [onInlineCardExpanded](adaptivecards.adaptivecard.md#oninlinecardexpanded)
- [onInputValueChanged](adaptivecards.adaptivecard.md#oninputvaluechanged)
- [onProcessMarkdown](adaptivecards.adaptivecard.md#onprocessmarkdown)
- [onRegisterCustomProperties](adaptivecards.adaptivecard.md#onregistercustomproperties)
- [requiresProperty](adaptivecards.adaptivecard.md#requiresproperty)
- [rtlProperty](adaptivecards.adaptivecard.md#rtlproperty)
- [schemaUrl](adaptivecards.adaptivecard.md#schemaurl)
- [selectActionProperty](adaptivecards.adaptivecard.md#selectactionproperty)
- [separatorProperty](adaptivecards.adaptivecard.md#separatorproperty)
- [spacingProperty](adaptivecards.adaptivecard.md#spacingproperty)
- [speakProperty](adaptivecards.adaptivecard.md#speakproperty)
- [styleProperty](adaptivecards.adaptivecard.md#styleproperty)
- [typeNameProperty](adaptivecards.adaptivecard.md#typenameproperty)
- [versionProperty](adaptivecards.adaptivecard.md#versionproperty)
- [verticalContentAlignmentProperty](adaptivecards.adaptivecard.md#verticalcontentalignmentproperty)

### Accessors

- [allowCustomPadding](adaptivecards.adaptivecard.md#allowcustompadding)
- [allowCustomStyle](adaptivecards.adaptivecard.md#allowcustomstyle)
- [backgroundImage](adaptivecards.adaptivecard.md#backgroundimage)
- [bleed](adaptivecards.adaptivecard.md#bleed)
- [bypassVersionCheck](adaptivecards.adaptivecard.md#bypassversioncheck)
- [defaultStyle](adaptivecards.adaptivecard.md#defaultstyle)
- [hasBackground](adaptivecards.adaptivecard.md#hasbackground)
- [hasExplicitStyle](adaptivecards.adaptivecard.md#hasexplicitstyle)
- [hasVisibleSeparator](adaptivecards.adaptivecard.md#hasvisibleseparator)
- [hostConfig](adaptivecards.adaptivecard.md#hostconfig)
- [index](adaptivecards.adaptivecard.md#index)
- [isInline](adaptivecards.adaptivecard.md#isinline)
- [isInteractive](adaptivecards.adaptivecard.md#isinteractive)
- [isSelectable](adaptivecards.adaptivecard.md#isselectable)
- [isStandalone](adaptivecards.adaptivecard.md#isstandalone)
- [isVisible](adaptivecards.adaptivecard.md#isvisible)
- [lang](adaptivecards.adaptivecard.md#lang)
- [padding](adaptivecards.adaptivecard.md#padding)
- [parent](adaptivecards.adaptivecard.md#parent)
- [renderIfEmpty](adaptivecards.adaptivecard.md#renderifempty)
- [renderedActionCount](adaptivecards.adaptivecard.md#renderedactioncount)
- [renderedElement](adaptivecards.adaptivecard.md#renderedelement)
- [requires](adaptivecards.adaptivecard.md#requires)
- [selectAction](adaptivecards.adaptivecard.md#selectaction)
- [separatorElement](adaptivecards.adaptivecard.md#separatorelement)
- [separatorOrientation](adaptivecards.adaptivecard.md#separatororientation)
- [style](adaptivecards.adaptivecard.md#style)
- [useDefaultSizing](adaptivecards.adaptivecard.md#usedefaultsizing)
- [processMarkdown](adaptivecards.adaptivecard.md#processmarkdown)

### Methods

- [addAction](adaptivecards.adaptivecard.md#addaction)
- [addItem](adaptivecards.adaptivecard.md#additem)
- [adjustRenderedElementSize](adaptivecards.adaptivecard.md#adjustrenderedelementsize)
- [applyBackground](adaptivecards.adaptivecard.md#applybackground)
- [applyPadding](adaptivecards.adaptivecard.md#applypadding)
- [asString](adaptivecards.adaptivecard.md#asstring)
- [clear](adaptivecards.adaptivecard.md#clear)
- [createPlaceholderElement](adaptivecards.adaptivecard.md#createplaceholderelement)
- [getActionAt](adaptivecards.adaptivecard.md#getactionat)
- [getActionById](adaptivecards.adaptivecard.md#getactionbyid)
- [getActionCount](adaptivecards.adaptivecard.md#getactioncount)
- [getAllInputs](adaptivecards.adaptivecard.md#getallinputs)
- [getBleed](adaptivecards.adaptivecard.md#getbleed)
- [getCustomProperty](adaptivecards.adaptivecard.md#getcustomproperty)
- [getDefaultPadding](adaptivecards.adaptivecard.md#getdefaultpadding)
- [getDefaultSerializationContext](adaptivecards.adaptivecard.md#getdefaultserializationcontext)
- [getEffectivePadding](adaptivecards.adaptivecard.md#geteffectivepadding)
- [getEffectiveStyle](adaptivecards.adaptivecard.md#geteffectivestyle)
- [getEffectiveStyleDefinition](adaptivecards.adaptivecard.md#geteffectivestyledefinition)
- [getElementById](adaptivecards.adaptivecard.md#getelementbyid)
- [getFirstVisibleRenderedItem](adaptivecards.adaptivecard.md#getfirstvisiblerendereditem)
- [getForbiddenActionTypes](adaptivecards.adaptivecard.md#getforbiddenactiontypes)
- [getHasBackground](adaptivecards.adaptivecard.md#gethasbackground)
- [getHasExpandedAction](adaptivecards.adaptivecard.md#gethasexpandedaction)
- [getImmediateSurroundingPadding](adaptivecards.adaptivecard.md#getimmediatesurroundingpadding)
- [getItemAt](adaptivecards.adaptivecard.md#getitemat)
- [getItemCount](adaptivecards.adaptivecard.md#getitemcount)
- [getItemsCollectionPropertyName](adaptivecards.adaptivecard.md#getitemscollectionpropertyname)
- [getJsonTypeName](adaptivecards.adaptivecard.md#getjsontypename)
- [getLastVisibleRenderedItem](adaptivecards.adaptivecard.md#getlastvisiblerendereditem)
- [getPadding](adaptivecards.adaptivecard.md#getpadding)
- [getParentContainer](adaptivecards.adaptivecard.md#getparentcontainer)
- [getResourceInformation](adaptivecards.adaptivecard.md#getresourceinformation)
- [getRootElement](adaptivecards.adaptivecard.md#getrootelement)
- [getRootObject](adaptivecards.adaptivecard.md#getrootobject)
- [getSchema](adaptivecards.adaptivecard.md#getschema)
- [getSchemaKey](adaptivecards.adaptivecard.md#getschemakey)
- [getValue](adaptivecards.adaptivecard.md#getvalue)
- [hasAllDefaultValues](adaptivecards.adaptivecard.md#hasalldefaultvalues)
- [hasDefaultValue](adaptivecards.adaptivecard.md#hasdefaultvalue)
- [indexOf](adaptivecards.adaptivecard.md#indexof)
- [insertItemAfter](adaptivecards.adaptivecard.md#insertitemafter)
- [insertItemBefore](adaptivecards.adaptivecard.md#insertitembefore)
- [internalParse](adaptivecards.adaptivecard.md#internalparse)
- [internalRender](adaptivecards.adaptivecard.md#internalrender)
- [internalToJSON](adaptivecards.adaptivecard.md#internaltojson)
- [internalValidateProperties](adaptivecards.adaptivecard.md#internalvalidateproperties)
- [isAtTheVeryBottom](adaptivecards.adaptivecard.md#isattheverybottom)
- [isAtTheVeryLeft](adaptivecards.adaptivecard.md#isattheveryleft)
- [isAtTheVeryRight](adaptivecards.adaptivecard.md#isattheveryright)
- [isAtTheVeryTop](adaptivecards.adaptivecard.md#isattheverytop)
- [isBleeding](adaptivecards.adaptivecard.md#isbleeding)
- [isBleedingAtBottom](adaptivecards.adaptivecard.md#isbleedingatbottom)
- [isBleedingAtTop](adaptivecards.adaptivecard.md#isbleedingattop)
- [isBottomElement](adaptivecards.adaptivecard.md#isbottomelement)
- [isDesignMode](adaptivecards.adaptivecard.md#isdesignmode)
- [isDisplayed](adaptivecards.adaptivecard.md#isdisplayed)
- [isElementAllowed](adaptivecards.adaptivecard.md#iselementallowed)
- [isFirstElement](adaptivecards.adaptivecard.md#isfirstelement)
- [isHiddenDueToOverflow](adaptivecards.adaptivecard.md#ishiddenduetooverflow)
- [isLastElement](adaptivecards.adaptivecard.md#islastelement)
- [isLeftMostElement](adaptivecards.adaptivecard.md#isleftmostelement)
- [isRightMostElement](adaptivecards.adaptivecard.md#isrightmostelement)
- [isRtl](adaptivecards.adaptivecard.md#isrtl)
- [isTopElement](adaptivecards.adaptivecard.md#istopelement)
- [overrideInternalRender](adaptivecards.adaptivecard.md#overrideinternalrender)
- [parse](adaptivecards.adaptivecard.md#parse)
- [populateSchema](adaptivecards.adaptivecard.md#populateschema)
- [preProcessPropertyValue](adaptivecards.adaptivecard.md#preprocesspropertyvalue)
- [remove](adaptivecards.adaptivecard.md#remove)
- [removeItem](adaptivecards.adaptivecard.md#removeitem)
- [render](adaptivecards.adaptivecard.md#render)
- [resetDefaultValues](adaptivecards.adaptivecard.md#resetdefaultvalues)
- [setBleed](adaptivecards.adaptivecard.md#setbleed)
- [setCustomProperty](adaptivecards.adaptivecard.md#setcustomproperty)
- [setPadding](adaptivecards.adaptivecard.md#setpadding)
- [setParent](adaptivecards.adaptivecard.md#setparent)
- [setShouldFallback](adaptivecards.adaptivecard.md#setshouldfallback)
- [setValue](adaptivecards.adaptivecard.md#setvalue)
- [shouldFallback](adaptivecards.adaptivecard.md#shouldfallback)
- [shouldSerialize](adaptivecards.adaptivecard.md#shouldserialize)
- [supportsExcplitiHeight](adaptivecards.adaptivecard.md#supportsexcplitiheight)
- [toJSON](adaptivecards.adaptivecard.md#tojson)
- [truncateOverflow](adaptivecards.adaptivecard.md#truncateoverflow)
- [undoOverflowTruncation](adaptivecards.adaptivecard.md#undooverflowtruncation)
- [updateLayout](adaptivecards.adaptivecard.md#updatelayout)
- [validateProperties](adaptivecards.adaptivecard.md#validateproperties)
- [applyMarkdown](adaptivecards.adaptivecard.md#applymarkdown)

## Constructors

### constructor

\+ **new AdaptiveCard**(): [*AdaptiveCard*](card_elements.adaptivecard.md)

**Returns:** [*AdaptiveCard*](card_elements.adaptivecard.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6284](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6284)

## Properties

### \_parent

• `Protected` `Optional` **\_parent**: *undefined* \| [*CardObject*](card_object.cardobject.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[_parent](card_elements.containerwithactions.md#_parent)

Defined in: [card-object.ts:64](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L64)

___

### \_renderedElement

• `Protected` `Optional` **\_renderedElement**: *undefined* \| HTMLElement

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[_renderedElement](card_elements.containerwithactions.md#_renderedelement)

Defined in: [card-object.ts:65](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L65)

___

### \_selectAction

• `Protected` `Optional` **\_selectAction**: *undefined* \| [*Action*](card_elements.action.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[_selectAction](card_elements.containerwithactions.md#_selectaction)

Defined in: [card-elements.ts:1851](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1851)

___

### allowVerticalOverflow

• **allowVerticalOverflow**: *boolean*= false

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[allowVerticalOverflow](card_elements.containerwithactions.md#allowverticaloverflow)

Defined in: [card-elements.ts:1891](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1891)

___

### customCssSelector

• `Optional` **customCssSelector**: *undefined* \| *string*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[customCssSelector](card_elements.containerwithactions.md#customcssselector)

Defined in: [card-elements.ts:327](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L327)

___

### designMode

• **designMode**: *boolean*= false

Defined in: [card-elements.ts:6557](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6557)

___

### fallbackText

• `Optional` **fallbackText**: *undefined* \| *string*

Defined in: [card-elements.ts:6417](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6417)

___

### height

• **height**: [*CardElementHeight*](../modules/card_elements.md#cardelementheight)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[height](card_elements.containerwithactions.md#height)

Defined in: [card-elements.ts:53](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L53)

___

### horizontalAlignment

• **horizontalAlignment**: [*HorizontalAlignment*](../enums/enums.horizontalalignment.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[horizontalAlignment](card_elements.containerwithactions.md#horizontalalignment)

Defined in: [card-elements.ts:44](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L44)

___

### id

• `Optional` **id**: *undefined* \| *string*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[id](card_elements.containerwithactions.md#id)

Defined in: [card-object.ts:53](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L53)

___

### maxVersion

• **maxVersion**: [*Version*](serialization.version.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[maxVersion](card_elements.containerwithactions.md#maxversion)

Defined in: [serialization.ts:898](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L898)

___

### minPixelHeight

• `Optional` **minPixelHeight**: *undefined* \| *number*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[minPixelHeight](card_elements.containerwithactions.md#minpixelheight)

Defined in: [card-elements.ts:5068](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5068)

___

### onAnchorClicked

• `Optional` **onAnchorClicked**: *undefined* \| (`element`: [*CardElement*](card_elements.cardelement.md), `anchor`: HTMLAnchorElement) => *boolean*

Defined in: [card-elements.ts:6550](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6550)

___

### onElementVisibilityChanged

• `Optional` **onElementVisibilityChanged**: *undefined* \| (`element`: [*CardElement*](card_elements.cardelement.md)) => *void*

Defined in: [card-elements.ts:6552](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6552)

___

### onExecuteAction

• `Optional` **onExecuteAction**: *undefined* \| (`action`: [*Action*](card_elements.action.md)) => *void*

Defined in: [card-elements.ts:6551](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6551)

___

### onImageLoaded

• `Optional` **onImageLoaded**: *undefined* \| (`image`: [*Image*](card_elements.image.md)) => *void*

Defined in: [card-elements.ts:6553](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6553)

___

### onInlineCardExpanded

• `Optional` **onInlineCardExpanded**: *undefined* \| (`action`: [*ShowCardAction*](card_elements.showcardaction.md), `isExpanded`: *boolean*) => *void*

Defined in: [card-elements.ts:6554](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6554)

___

### onInputValueChanged

• `Optional` **onInputValueChanged**: *undefined* \| (`input`: [*Input*](card_elements.input.md)) => *void*

Defined in: [card-elements.ts:6555](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6555)

___

### onPreProcessPropertyValue

• `Optional` **onPreProcessPropertyValue**: *undefined* \| (`sender`: [*CardObject*](card_object.cardobject.md), `property`: [*PropertyDefinition*](serialization.propertydefinition.md), `value`: *any*) => *any*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[onPreProcessPropertyValue](card_elements.containerwithactions.md#onpreprocesspropertyvalue)

Defined in: [card-object.ts:67](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L67)

___

### rtl

• `Optional` **rtl**: *undefined* \| *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[rtl](card_elements.containerwithactions.md#rtl)

Defined in: [card-elements.ts:5334](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5334)

___

### separator

• **separator**: *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[separator](card_elements.containerwithactions.md#separator)

Defined in: [card-elements.ts:50](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L50)

___

### spacing

• **spacing**: [*Spacing*](../enums/enums.spacing.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[spacing](card_elements.containerwithactions.md#spacing)

Defined in: [card-elements.ts:47](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L47)

___

### speak

• `Optional` **speak**: *undefined* \| *string*

Defined in: [card-elements.ts:6420](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6420)

___

### version

• **version**: [*Version*](serialization.version.md)

Defined in: [card-elements.ts:6414](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6414)

___

### verticalContentAlignment

• **verticalContentAlignment**: [*VerticalAlignment*](../enums/enums.verticalalignment.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[verticalContentAlignment](card_elements.containerwithactions.md#verticalcontentalignment)

Defined in: [card-elements.ts:5331](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5331)

___

### $schemaProperty

▪ `Protected` `Readonly` `Static` **$schemaProperty**: [*CustomProperty*](serialization.customproperty.md)<string\>

Defined in: [card-elements.ts:6377](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6377)

___

### backgroundImageProperty

▪ `Readonly` `Static` **backgroundImageProperty**: [*SerializableObjectProperty*](serialization.serializableobjectproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[backgroundImageProperty](card_elements.containerwithactions.md#backgroundimageproperty)

Defined in: [card-elements.ts:5318](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5318)

___

### bleedProperty

▪ `Readonly` `Static` **bleedProperty**: [*BoolProperty*](serialization.boolproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[bleedProperty](card_elements.containerwithactions.md#bleedproperty)

Defined in: [card-elements.ts:5044](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5044)

___

### defaultMaxVersion

▪ `Static` **defaultMaxVersion**: [*Version*](serialization.version.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[defaultMaxVersion](card_elements.containerwithactions.md#defaultmaxversion)

Defined in: [serialization.ts:775](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L775)

___

### fallbackTextProperty

▪ `Readonly` `Static` **fallbackTextProperty**: [*StringProperty*](serialization.stringproperty.md)

Defined in: [card-elements.ts:6410](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6410)

___

### heightProperty

▪ `Readonly` `Static` **heightProperty**: [*ValueSetProperty*](serialization.valuesetproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[heightProperty](card_elements.containerwithactions.md#heightproperty)

Defined in: [card-elements.ts:24](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L24)

___

### horizontalAlignmentProperty

▪ `Readonly` `Static` **horizontalAlignmentProperty**: [*EnumProperty*](serialization.enumproperty.md)<*typeof* [*HorizontalAlignment*](../enums/enums.horizontalalignment.md)\>

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[horizontalAlignmentProperty](card_elements.containerwithactions.md#horizontalalignmentproperty)

Defined in: [card-elements.ts:32](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L32)

___

### idProperty

▪ `Readonly` `Static` **idProperty**: [*StringProperty*](serialization.stringproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[idProperty](card_elements.containerwithactions.md#idproperty)

Defined in: [card-object.ts:41](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L41)

___

### isVisibleProperty

▪ `Readonly` `Static` **isVisibleProperty**: [*BoolProperty*](serialization.boolproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[isVisibleProperty](card_elements.containerwithactions.md#isvisibleproperty)

Defined in: [card-elements.ts:22](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L22)

___

### langProperty

▪ `Readonly` `Static` **langProperty**: [*StringProperty*](serialization.stringproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[langProperty](card_elements.containerwithactions.md#langproperty)

Defined in: [card-elements.ts:21](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L21)

___

### minHeightProperty

▪ `Readonly` `Static` **minHeightProperty**: [*PixelSizeProperty*](serialization.pixelsizeproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[minHeightProperty](card_elements.containerwithactions.md#minheightproperty)

Defined in: [card-elements.ts:5045](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5045)

___

### onAnchorClicked

▪ `Optional` `Static` **onAnchorClicked**: *undefined* \| (`element`: [*CardElement*](card_elements.cardelement.md), `anchor`: HTMLAnchorElement) => *boolean*

Defined in: [card-elements.ts:6424](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6424)

___

### onElementVisibilityChanged

▪ `Optional` `Static` **onElementVisibilityChanged**: *undefined* \| (`element`: [*CardElement*](card_elements.cardelement.md)) => *void*

Defined in: [card-elements.ts:6426](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6426)

___

### onExecuteAction

▪ `Optional` `Static` **onExecuteAction**: *undefined* \| (`action`: [*Action*](card_elements.action.md)) => *void*

Defined in: [card-elements.ts:6425](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6425)

___

### onImageLoaded

▪ `Optional` `Static` **onImageLoaded**: *undefined* \| (`image`: [*Image*](card_elements.image.md)) => *void*

Defined in: [card-elements.ts:6427](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6427)

___

### onInlineCardExpanded

▪ `Optional` `Static` **onInlineCardExpanded**: *undefined* \| (`action`: [*ShowCardAction*](card_elements.showcardaction.md), `isExpanded`: *boolean*) => *void*

Defined in: [card-elements.ts:6428](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6428)

___

### onInputValueChanged

▪ `Optional` `Static` **onInputValueChanged**: *undefined* \| (`input`: [*Input*](card_elements.input.md)) => *void*

Defined in: [card-elements.ts:6429](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6429)

___

### onProcessMarkdown

▪ `Optional` `Static` **onProcessMarkdown**: *undefined* \| (`text`: *string*, `result`: [*IMarkdownProcessingResult*](../interfaces/card_elements.imarkdownprocessingresult.md)) => *void*

Defined in: [card-elements.ts:6430](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6430)

___

### onRegisterCustomProperties

▪ `Optional` `Static` **onRegisterCustomProperties**: *undefined* \| (`sender`: [*SerializableObject*](serialization.serializableobject.md), `schema`: [*SerializableObjectSchema*](serialization.serializableobjectschema.md)) => *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[onRegisterCustomProperties](card_elements.containerwithactions.md#onregistercustomproperties)

Defined in: [serialization.ts:774](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L774)

___

### requiresProperty

▪ `Readonly` `Static` **requiresProperty**: [*SerializableObjectProperty*](serialization.serializableobjectproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[requiresProperty](card_elements.containerwithactions.md#requiresproperty)

Defined in: [card-object.ts:42](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L42)

___

### rtlProperty

▪ `Readonly` `Static` **rtlProperty**: [*BoolProperty*](serialization.boolproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[rtlProperty](card_elements.containerwithactions.md#rtlproperty)

Defined in: [card-elements.ts:5323](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5323)

___

### schemaUrl

▪ `Readonly` `Static` **schemaUrl**: *http://adaptivecards.io/schemas/adaptive-card.json*= "http://adaptivecards.io/schemas/adaptive-card.json"

Defined in: [card-elements.ts:6373](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6373)

___

### selectActionProperty

▪ `Readonly` `Static` **selectActionProperty**: [*ActionProperty*](card_elements.actionproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[selectActionProperty](card_elements.containerwithactions.md#selectactionproperty)

Defined in: [card-elements.ts:1840](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1840)

___

### separatorProperty

▪ `Readonly` `Static` **separatorProperty**: [*BoolProperty*](serialization.boolproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[separatorProperty](card_elements.containerwithactions.md#separatorproperty)

Defined in: [card-elements.ts:23](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L23)

___

### spacingProperty

▪ `Readonly` `Static` **spacingProperty**: [*EnumProperty*](serialization.enumproperty.md)<*typeof* [*Spacing*](../enums/enums.spacing.md)\>

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[spacingProperty](card_elements.containerwithactions.md#spacingproperty)

Defined in: [card-elements.ts:37](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L37)

___

### speakProperty

▪ `Readonly` `Static` **speakProperty**: [*StringProperty*](serialization.stringproperty.md)

Defined in: [card-elements.ts:6411](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6411)

___

### styleProperty

▪ `Readonly` `Static` **styleProperty**: [*ValueSetProperty*](serialization.valuesetproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[styleProperty](card_elements.containerwithactions.md#styleproperty)

Defined in: [card-elements.ts:5033](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5033)

___

### typeNameProperty

▪ `Readonly` `Static` **typeNameProperty**: [*StringProperty*](serialization.stringproperty.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[typeNameProperty](card_elements.containerwithactions.md#typenameproperty)

Defined in: [card-object.ts:32](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L32)

___

### versionProperty

▪ `Readonly` `Static` **versionProperty**: [*CustomProperty*](serialization.customproperty.md)<undefined \| [*Version*](serialization.version.md)\>

Defined in: [card-elements.ts:6387](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6387)

___

### verticalContentAlignmentProperty

▪ `Readonly` `Static` **verticalContentAlignmentProperty**: [*EnumProperty*](serialization.enumproperty.md)<*typeof* [*VerticalAlignment*](../enums/enums.verticalalignment.md)\>

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md).[verticalContentAlignmentProperty](card_elements.containerwithactions.md#verticalcontentalignmentproperty)

Defined in: [card-elements.ts:5322](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5322)

## Accessors

### allowCustomPadding

• `Protected`get **allowCustomPadding**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:315](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L315)

___

### allowCustomStyle

• `Protected`get **allowCustomStyle**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6542](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6542)

___

### backgroundImage

• get **backgroundImage**(): [*BackgroundImage*](card_elements.backgroundimage.md)

**Returns:** [*BackgroundImage*](card_elements.backgroundimage.md)

Defined in: [card-elements.ts:5326](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5326)

___

### bleed

• get **bleed**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:5705](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5705)

• set **bleed**(`value`: *boolean*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *boolean* |

**Returns:** *void*

Defined in: [card-elements.ts:5709](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5709)

___

### bypassVersionCheck

• `Protected`get **bypassVersionCheck**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6538](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6538)

___

### defaultStyle

• `Protected`get **defaultStyle**(): *string*

**Returns:** *string*

Defined in: [card-elements.ts:323](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L323)

___

### hasBackground

• `Protected`get **hasBackground**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6546](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6546)

___

### hasExplicitStyle

• `Protected`get **hasExplicitStyle**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:5187](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5187)

___

### hasVisibleSeparator

• get **hasVisibleSeparator**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6639](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6639)

___

### hostConfig

• get **hostConfig**(): [*HostConfig*](host_config.hostconfig.md)

**Returns:** [*HostConfig*](host_config.hostconfig.md)

Defined in: [card-elements.ts:557](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L557)

• set **hostConfig**(`value`: [*HostConfig*](host_config.hostconfig.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | [*HostConfig*](host_config.hostconfig.md) |

**Returns:** *void*

Defined in: [card-elements.ts:571](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L571)

___

### index

• get **index**(): *number*

**Returns:** *number*

Defined in: [card-elements.ts:575](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L575)

___

### isInline

• get **isInline**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:592](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L592)

___

### isInteractive

• get **isInteractive**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:584](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L584)

___

### isSelectable

• `Protected`get **isSelectable**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:5528](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5528)

___

### isStandalone

• get **isStandalone**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6361](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6361)

___

### isVisible

• get **isVisible**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:77](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L77)

• set **isVisible**(`value`: *boolean*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *boolean* |

**Returns:** *void*

Defined in: [card-elements.ts:81](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L81)

___

### lang

• get **lang**(): *undefined* \| *string*

**Returns:** *undefined* \| *string*

Defined in: [card-elements.ts:56](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L56)

• set **lang**(`value`: *undefined* \| *string*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| *string* |

**Returns:** *void*

Defined in: [card-elements.ts:72](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L72)

___

### padding

• get **padding**(): *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)

**Returns:** *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)

Defined in: [card-elements.ts:5689](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5689)

• set **padding**(`value`: *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md) |

**Returns:** *void*

Defined in: [card-elements.ts:5693](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5693)

___

### parent

• get **parent**(): *undefined* \| [*CardElement*](card_elements.cardelement.md)

**Returns:** *undefined* \| [*CardElement*](card_elements.cardelement.md)

Defined in: [card-elements.ts:609](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L609)

___

### renderIfEmpty

• `Protected`get **renderIfEmpty**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:6534](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6534)

___

### renderedActionCount

• `Protected`get **renderedActionCount**(): *number*

**Returns:** *number*

Defined in: [card-elements.ts:6278](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6278)

___

### renderedElement

• get **renderedElement**(): *undefined* \| HTMLElement

**Returns:** *undefined* \| HTMLElement

Defined in: [card-object.ts:143](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L143)

___

### requires

• get **requires**(): [*HostCapabilities*](host_capabilities.hostcapabilities.md)

**Returns:** [*HostCapabilities*](host_capabilities.hostcapabilities.md)

Defined in: [card-object.ts:56](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L56)

___

### selectAction

• get **selectAction**(): *undefined* \| [*Action*](card_elements.action.md)

**Returns:** *undefined* \| [*Action*](card_elements.action.md)

Defined in: [card-elements.ts:5697](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5697)

• set **selectAction**(`value`: *undefined* \| [*Action*](card_elements.action.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| [*Action*](card_elements.action.md) |

**Returns:** *void*

Defined in: [card-elements.ts:5701](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5701)

___

### separatorElement

• get **separatorElement**(): *undefined* \| HTMLElement

**Returns:** *undefined* \| HTMLElement

Defined in: [card-elements.ts:605](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L605)

___

### separatorOrientation

• `Protected`get **separatorOrientation**(): [*Orientation*](../enums/enums.orientation.md)

**Returns:** [*Orientation*](../enums/enums.orientation.md)

Defined in: [card-elements.ts:319](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L319)

___

### style

• get **style**(): *undefined* \| *string*

**Returns:** *undefined* \| *string*

Defined in: [card-elements.ts:5048](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5048)

• set **style**(`value`: *undefined* \| *string*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| *string* |

**Returns:** *void*

Defined in: [card-elements.ts:5060](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5060)

___

### useDefaultSizing

• `Protected`get **useDefaultSizing**(): *boolean*

**Returns:** *boolean*

Defined in: [card-elements.ts:311](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L311)

___

### processMarkdown

• `Static`get **processMarkdown**(): (`text`: *string*) => *string*

**Returns:** *function*

Defined in: [card-elements.ts:6432](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6432)

• `Static`set **processMarkdown**(`value`: (`text`: *string*) => *string*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | (`text`: *string*) => *string* |

**Returns:** *void*

Defined in: [card-elements.ts:6436](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6436)

## Methods

### addAction

▸ **addAction**(`action`: [*Action*](card_elements.action.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`action` | [*Action*](card_elements.action.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6323](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6323)

___

### addItem

▸ **addItem**(`item`: [*CardElement*](card_elements.cardelement.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`item` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5619](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5619)

___

### adjustRenderedElementSize

▸ `Protected`**adjustRenderedElementSize**(`renderedElement`: HTMLElement): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`renderedElement` | HTMLElement |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5072](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5072)

___

### applyBackground

▸ `Protected`**applyBackground**(): *void*

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5373](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5373)

___

### applyPadding

▸ `Protected`**applyPadding**(): *void*

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5092](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5092)

___

### asString

▸ **asString**(): *undefined* \| *string*

**Returns:** *undefined* \| *string*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:333](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L333)

___

### clear

▸ **clear**(): *void*

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6327](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6327)

___

### createPlaceholderElement

▸ `Protected`**createPlaceholderElement**(): HTMLElement

**Returns:** HTMLElement

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:221](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L221)

___

### getActionAt

▸ **getActionAt**(`index`: *number*): *undefined* \| [*Action*](card_elements.action.md)

#### Parameters:

Name | Type |
:------ | :------ |
`index` | *number* |

**Returns:** *undefined* \| [*Action*](card_elements.action.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6296](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6296)

___

### getActionById

▸ **getActionById**(`id`: *string*): *undefined* \| [*Action*](card_elements.action.md)

#### Parameters:

Name | Type |
:------ | :------ |
`id` | *string* |

**Returns:** *undefined* \| [*Action*](card_elements.action.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6305](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6305)

___

### getActionCount

▸ **getActionCount**(): *number*

**Returns:** *number*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6292](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6292)

___

### getAllInputs

▸ **getAllInputs**(`processActions?`: *boolean*): [*Input*](card_elements.input.md)[]

#### Parameters:

Name | Type | Default value |
:------ | :------ | :------ |
`processActions` | *boolean* | true |

**Returns:** [*Input*](card_elements.input.md)[]

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6333](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6333)

___

### getBleed

▸ `Protected`**getBleed**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5175](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5175)

___

### getCustomProperty

▸ **getCustomProperty**(`name`: *string*): *any*

#### Parameters:

Name | Type |
:------ | :------ |
`name` | *string* |

**Returns:** *any*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:985](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L985)

___

### getDefaultPadding

▸ `Protected`**getDefaultPadding**(): [*PaddingDefinition*](shared.paddingdefinition.md)

**Returns:** [*PaddingDefinition*](shared.paddingdefinition.md)

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6522](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6522)

___

### getDefaultSerializationContext

▸ `Protected`**getDefaultSerializationContext**(): [*BaseSerializationContext*](serialization.baseserializationcontext.md)

**Returns:** [*BaseSerializationContext*](serialization.baseserializationcontext.md)

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6478](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6478)

___

### getEffectivePadding

▸ **getEffectivePadding**(): [*PaddingDefinition*](shared.paddingdefinition.md)

**Returns:** [*PaddingDefinition*](shared.paddingdefinition.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:551](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L551)

___

### getEffectiveStyle

▸ **getEffectiveStyle**(): *string*

**Returns:** *string*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5226](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5226)

___

### getEffectiveStyleDefinition

▸ **getEffectiveStyleDefinition**(): [*ContainerStyleDefinition*](host_config.containerstyledefinition.md)

**Returns:** [*ContainerStyleDefinition*](host_config.containerstyledefinition.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:349](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L349)

___

### getElementById

▸ **getElementById**(`id`: *string*): *undefined* \| [*CardElement*](card_elements.cardelement.md)

#### Parameters:

Name | Type |
:------ | :------ |
`id` | *string* |

**Returns:** *undefined* \| [*CardElement*](card_elements.cardelement.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:1996](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1996)

___

### getFirstVisibleRenderedItem

▸ **getFirstVisibleRenderedItem**(): *undefined* \| [*CardElement*](card_elements.cardelement.md)

**Returns:** *undefined* \| [*CardElement*](card_elements.cardelement.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5540](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5540)

___

### getForbiddenActionTypes

▸ **getForbiddenActionTypes**(): [*ActionType*](../modules/card_elements.md#actiontype)[]

**Returns:** [*ActionType*](../modules/card_elements.md#actiontype)[]

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:353](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L353)

___

### getHasBackground

▸ `Protected`**getHasBackground**(): *boolean*

**Returns:** *boolean*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6518](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6518)

___

### getHasExpandedAction

▸ `Protected`**getHasExpandedAction**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6266](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6266)

___

### getImmediateSurroundingPadding

▸ **getImmediateSurroundingPadding**(`result`: [*PaddingDefinition*](shared.paddingdefinition.md), `processTop?`: *boolean*, `processRight?`: *boolean*, `processBottom?`: *boolean*, `processLeft?`: *boolean*): *void*

#### Parameters:

Name | Type | Default value |
:------ | :------ | :------ |
`result` | [*PaddingDefinition*](shared.paddingdefinition.md) | - |
`processTop` | *boolean* | true |
`processRight` | *boolean* | true |
`processBottom` | *boolean* | true |
`processLeft` | *boolean* | true |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:357](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L357)

___

### getItemAt

▸ **getItemAt**(`index`: *number*): [*CardElement*](card_elements.cardelement.md)

#### Parameters:

Name | Type |
:------ | :------ |
`index` | *number* |

**Returns:** [*CardElement*](card_elements.cardelement.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5536](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5536)

___

### getItemCount

▸ **getItemCount**(): *number*

**Returns:** *number*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5532](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5532)

___

### getItemsCollectionPropertyName

▸ `Protected`**getItemsCollectionPropertyName**(): *string*

**Returns:** *string*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6482](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6482)

___

### getJsonTypeName

▸ **getJsonTypeName**(): *string*

**Returns:** *string*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6559](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6559)

___

### getLastVisibleRenderedItem

▸ **getLastVisibleRenderedItem**(): *undefined* \| [*CardElement*](card_elements.cardelement.md)

**Returns:** *undefined* \| [*CardElement*](card_elements.cardelement.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5552](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5552)

___

### getPadding

▸ `Protected`**getPadding**(): *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)

**Returns:** *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:299](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L299)

___

### getParentContainer

▸ **getParentContainer**(): *undefined* \| [*Container*](card_elements.container.md)

**Returns:** *undefined* \| [*Container*](card_elements.container.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:521](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L521)

___

### getResourceInformation

▸ **getResourceInformation**(): [*IResourceInformation*](../interfaces/shared.iresourceinformation.md)[]

**Returns:** [*IResourceInformation*](../interfaces/shared.iresourceinformation.md)[]

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6343](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6343)

___

### getRootElement

▸ **getRootElement**(): [*CardElement*](card_elements.cardelement.md)

**Returns:** [*CardElement*](card_elements.cardelement.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:517](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L517)

___

### getRootObject

▸ **getRootObject**(): [*CardObject*](card_object.cardobject.md)

**Returns:** [*CardObject*](card_object.cardobject.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:103](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L103)

___

### getSchema

▸ **getSchema**(): [*SerializableObjectSchema*](serialization.serializableobjectschema.md)

**Returns:** [*SerializableObjectSchema*](serialization.serializableobjectschema.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:989](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L989)

___

### getSchemaKey

▸ `Protected`**getSchemaKey**(): *string*

**Returns:** *string*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:48](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L48)

___

### getValue

▸ `Protected`**getValue**(`property`: [*PropertyDefinition*](serialization.propertydefinition.md)): *any*

#### Parameters:

Name | Type |
:------ | :------ |
`property` | [*PropertyDefinition*](serialization.propertydefinition.md) |

**Returns:** *any*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:826](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L826)

___

### hasAllDefaultValues

▸ **hasAllDefaultValues**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:950](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L950)

___

### hasDefaultValue

▸ **hasDefaultValue**(`property`: [*PropertyDefinition*](serialization.propertydefinition.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`property` | [*PropertyDefinition*](serialization.propertydefinition.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:946](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L946)

___

### indexOf

▸ **indexOf**(`cardElement`: [*CardElement*](card_elements.cardelement.md)): *number*

#### Parameters:

Name | Type |
:------ | :------ |
`cardElement` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *number*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5615](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5615)

___

### insertItemAfter

▸ **insertItemAfter**(`item`: [*CardElement*](card_elements.cardelement.md), `insertAfter`: [*CardElement*](card_elements.cardelement.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`item` | [*CardElement*](card_elements.cardelement.md) |
`insertAfter` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5627](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5627)

___

### insertItemBefore

▸ **insertItemBefore**(`item`: [*CardElement*](card_elements.cardelement.md), `insertBefore`: [*CardElement*](card_elements.cardelement.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`item` | [*CardElement*](card_elements.cardelement.md) |
`insertBefore` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5623](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5623)

___

### internalParse

▸ `Protected`**internalParse**(`source`: *any*, `context`: [*SerializationContext*](card_elements.serializationcontext.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`source` | *any* |
`context` | [*SerializationContext*](card_elements.serializationcontext.md) |

**Returns:** *void*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6486](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6486)

___

### internalRender

▸ `Protected`**internalRender**(): *undefined* \| HTMLElement

**Returns:** *undefined* \| HTMLElement

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6505](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6505)

___

### internalToJSON

▸ `Protected`**internalToJSON**(`target`: [*PropertyBag*](../modules/serialization.md#propertybag), `context`: [*SerializationContext*](card_elements.serializationcontext.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`target` | [*PropertyBag*](../modules/serialization.md#propertybag) |
`context` | [*SerializationContext*](card_elements.serializationcontext.md) |

**Returns:** *void*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6499](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6499)

___

### internalValidateProperties

▸ **internalValidateProperties**(`context`: [*ValidationResults*](card_object.validationresults.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`context` | [*ValidationResults*](card_object.validationresults.md) |

**Returns:** *void*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6563](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6563)

___

### isAtTheVeryBottom

▸ **isAtTheVeryBottom**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:485](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L485)

___

### isAtTheVeryLeft

▸ **isAtTheVeryLeft**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:473](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L473)

___

### isAtTheVeryRight

▸ **isAtTheVeryRight**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:477](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L477)

___

### isAtTheVeryTop

▸ **isAtTheVeryTop**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:481](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L481)

___

### isBleeding

▸ **isBleeding**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5195](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5195)

___

### isBleedingAtBottom

▸ **isBleedingAtBottom**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6347](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6347)

___

### isBleedingAtTop

▸ **isBleedingAtTop**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5603](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5603)

___

### isBottomElement

▸ **isBottomElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:509](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L509)

___

### isDesignMode

▸ **isDesignMode**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:459](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L459)

___

### isDisplayed

▸ `Protected`**isDisplayed**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:245](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L245)

___

### isElementAllowed

▸ `Protected`**isElementAllowed**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:1855](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1855)

___

### isFirstElement

▸ **isFirstElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5568](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5568)

___

### isHiddenDueToOverflow

▸ **isHiddenDueToOverflow**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:513](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L513)

___

### isLastElement

▸ **isLastElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6319](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6319)

___

### isLeftMostElement

▸ **isLeftMostElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:497](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L497)

___

### isRightMostElement

▸ **isRightMostElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:501](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L501)

___

### isRtl

▸ **isRtl**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5592](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5592)

___

### isTopElement

▸ **isTopElement**(`element`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`element` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:505](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L505)

___

### overrideInternalRender

▸ `Protected`**overrideInternalRender**(): *undefined* \| HTMLElement

**Returns:** *undefined* \| HTMLElement

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:251](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L251)

___

### parse

▸ **parse**(`source`: *any*, `context?`: [*SerializationContext*](card_elements.serializationcontext.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`source` | *any* |
`context?` | [*SerializationContext*](card_elements.serializationcontext.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:329](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L329)

___

### populateSchema

▸ `Protected`**populateSchema**(`schema`: [*SerializableObjectSchema*](serialization.serializableobjectschema.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`schema` | [*SerializableObjectSchema*](serialization.serializableobjectschema.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:1842](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L1842)

___

### preProcessPropertyValue

▸ **preProcessPropertyValue**(`property`: [*PropertyDefinition*](serialization.propertydefinition.md), `propertyValue?`: *any*): *any*

#### Parameters:

Name | Type |
:------ | :------ |
`property` | [*PropertyDefinition*](serialization.propertydefinition.md) |
`propertyValue?` | *any* |

**Returns:** *any*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:73](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L73)

___

### remove

▸ **remove**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:416](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L416)

___

### removeItem

▸ **removeItem**(`item`: [*CardElement*](card_elements.cardelement.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`item` | [*CardElement*](card_elements.cardelement.md) |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5631](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5631)

___

### render

▸ **render**(`target?`: HTMLElement): *undefined* \| HTMLElement

#### Parameters:

Name | Type |
:------ | :------ |
`target?` | HTMLElement |

**Returns:** *undefined* \| HTMLElement

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6587](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6587)

___

### resetDefaultValues

▸ **resetDefaultValues**(): *void*

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:964](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L964)

___

### setBleed

▸ `Protected`**setBleed**(`value`: *boolean*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *boolean* |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5179](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5179)

___

### setCustomProperty

▸ **setCustomProperty**(`name`: *string*, `value`: *any*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`name` | *string* |
`value` | *any* |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:974](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L974)

___

### setPadding

▸ `Protected`**setPadding**(`value`: *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| [*PaddingDefinition*](shared.paddingdefinition.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:303](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L303)

___

### setParent

▸ **setParent**(`value`: *undefined* \| [*CardObject*](card_object.cardobject.md)): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *undefined* \| [*CardObject*](card_object.cardobject.md) |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:91](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L91)

___

### setShouldFallback

▸ **setShouldFallback**(`value`: *boolean*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`value` | *boolean* |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:95](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L95)

___

### setValue

▸ `Protected`**setValue**(`property`: [*PropertyDefinition*](serialization.propertydefinition.md), `value`: *any*): *void*

#### Parameters:

Name | Type |
:------ | :------ |
`property` | [*PropertyDefinition*](serialization.propertydefinition.md) |
`value` | *any* |

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:830](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L830)

___

### shouldFallback

▸ **shouldFallback**(): *boolean*

**Returns:** *boolean*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6635](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6635)

___

### shouldSerialize

▸ `Protected`**shouldSerialize**(`context`: [*SerializationContext*](card_elements.serializationcontext.md)): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`context` | [*SerializationContext*](card_elements.serializationcontext.md) |

**Returns:** *boolean*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6530](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6530)

___

### supportsExcplitiHeight

▸ `Protected`**supportsExcplitiHeight**(): *boolean*

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5365](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5365)

___

### toJSON

▸ **toJSON**(`context?`: [*BaseSerializationContext*](serialization.baseserializationcontext.md)): *undefined* \| [*PropertyBag*](../modules/serialization.md#propertybag)

#### Parameters:

Name | Type |
:------ | :------ |
`context?` | [*BaseSerializationContext*](serialization.baseserializationcontext.md) |

**Returns:** *undefined* \| [*PropertyBag*](../modules/serialization.md#propertybag)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [serialization.ts:916](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/serialization.ts#L916)

___

### truncateOverflow

▸ `Protected`**truncateOverflow**(`maxHeight`: *number*): *boolean*

#### Parameters:

Name | Type |
:------ | :------ |
`maxHeight` | *number* |

**Returns:** *boolean*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5454](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5454)

___

### undoOverflowTruncation

▸ `Protected`**undoOverflowTruncation**(): *void*

**Returns:** *void*

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:5493](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L5493)

___

### updateLayout

▸ **updateLayout**(`processChildren?`: *boolean*): *void*

#### Parameters:

Name | Type | Default value |
:------ | :------ | :------ |
`processChildren` | *boolean* | true |

**Returns:** *void*

Overrides: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-elements.ts:6625](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6625)

___

### validateProperties

▸ **validateProperties**(): [*ValidationResults*](card_object.validationresults.md)

**Returns:** [*ValidationResults*](card_object.validationresults.md)

Inherited from: [ContainerWithActions](card_elements.containerwithactions.md)

Defined in: [card-object.ts:131](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-object.ts#L131)

___

### applyMarkdown

▸ `Static`**applyMarkdown**(`text`: *string*): [*IMarkdownProcessingResult*](../interfaces/card_elements.imarkdownprocessingresult.md)

#### Parameters:

Name | Type |
:------ | :------ |
`text` | *string* |

**Returns:** [*IMarkdownProcessingResult*](../interfaces/card_elements.imarkdownprocessingresult.md)

Defined in: [card-elements.ts:6440](https://github.com/microsoft/AdaptiveCards/blob/0938a1f10/source/nodejs/adaptivecards/src/card-elements.ts#L6440)
