[Adaptive Cards Javascript SDK](README.md)

# Adaptive Cards Javascript SDK

## Index

### Enumerations

* [ActionAlignment](enums/actionalignment.md)
* [ActionButtonState](enums/actionbuttonstate.md)
* [ActionIconPlacement](enums/actioniconplacement.md)
* [ActivityInvocationTrigger](enums/activityinvocationtrigger.md)
* [ActivityStatus](enums/activitystatus.md)
* [ContainerFitStatus](enums/containerfitstatus.md)
* [FillMode](enums/fillmode.md)
* [FontType](enums/fonttype.md)
* [HorizontalAlignment](enums/horizontalalignment.md)
* [ImageSize](enums/imagesize.md)
* [ImageStyle](enums/imagestyle.md)
* [InputTextStyle](enums/inputtextstyle.md)
* [LogLevel](enums/loglevel.md)
* [Orientation](enums/orientation.md)
* [RefreshMode](enums/refreshmode.md)
* [ShowCardActionMode](enums/showcardactionmode.md)
* [Size](enums/size.md)
* [SizeUnit](enums/sizeunit.md)
* [Spacing](enums/spacing.md)
* [TextColor](enums/textcolor.md)
* [TextSize](enums/textsize.md)
* [TextWeight](enums/textweight.md)
* [TypeErrorType](enums/typeerrortype.md)
* [ValidationEvent](enums/validationevent.md)
* [ValidationPhase](enums/validationphase.md)
* [VerticalAlignment](enums/verticalalignment.md)

### Classes

* [AbstractTextFormatter](classes/abstracttextformatter.md)
* [Action](classes/action.md)
* [ActionButton](classes/actionbutton.md)
* [ActionCollection](classes/actioncollection.md)
* [ActionProperty](classes/actionproperty.md)
* [ActionSet](classes/actionset.md)
* [ActionStyle](classes/actionstyle.md)
* [ActionsConfig](classes/actionsconfig.md)
* [AdaptiveApplet](classes/adaptiveapplet.md)
* [AdaptiveAppletCard](classes/adaptiveappletcard.md)
* [AdaptiveCard](classes/adaptivecard.md)
* [AdaptiveCardConfig](classes/adaptivecardconfig.md)
* [BackgroundImage](classes/backgroundimage.md)
* [BaseSerializationContext](classes/baseserializationcontext.md)
* [BaseTextBlock](classes/basetextblock.md)
* [BaseTextDefinition](classes/basetextdefinition.md)
* [BoolProperty](classes/boolproperty.md)
* [BuiltInContainerStyleDefinition](classes/builtincontainerstyledefinition.md)
* [CardElement](classes/cardelement.md)
* [CardElementContainer](classes/cardelementcontainer.md)
* [CardObject](classes/cardobject.md)
* [CardObjectRegistry](classes/cardobjectregistry.md)
* [ChannelAdapter](classes/channeladapter.md)
* [Choice](classes/choice.md)
* [ChoiceSetInput](classes/choicesetinput.md)
* [ColorDefinition](classes/colordefinition.md)
* [ColorSetDefinition](classes/colorsetdefinition.md)
* [Column](classes/column.md)
* [ColumnSet](classes/columnset.md)
* [Container](classes/container.md)
* [ContainerStyle](classes/containerstyle.md)
* [ContainerStyleDefinition](classes/containerstyledefinition.md)
* [ContainerStyleSet](classes/containerstyleset.md)
* [ContainerWithActions](classes/containerwithactions.md)
* [CustomProperty](classes/customproperty.md)
* [DateFormatter](classes/dateformatter.md)
* [DateInput](classes/dateinput.md)
* [EnumProperty](classes/enumproperty.md)
* [ExecuteAction](classes/executeaction.md)
* [Fact](classes/fact.md)
* [FactSet](classes/factset.md)
* [FactSetConfig](classes/factsetconfig.md)
* [FactTextDefinition](classes/facttextdefinition.md)
* [FactTitleDefinition](classes/facttitledefinition.md)
* [FontTypeDefinition](classes/fonttypedefinition.md)
* [FontTypeSet](classes/fonttypeset.md)
* [GlobalRegistry](classes/globalregistry.md)
* [GlobalSettings](classes/globalsettings.md)
* [HostCapabilities](classes/hostcapabilities.md)
* [HostConfig](classes/hostconfig.md)
* [HttpAction](classes/httpaction.md)
* [HttpChannelAdapter](classes/httpchanneladapter.md)
* [HttpHeader](classes/httpheader.md)
* [Image](classes/image.md)
* [ImageDimensionProperty](classes/imagedimensionproperty.md)
* [ImageSet](classes/imageset.md)
* [ImageSetConfig](classes/imagesetconfig.md)
* [InlineAdaptiveCard](classes/inlineadaptivecard.md)
* [Input](classes/input.md)
* [InputConfig](classes/inputconfig.md)
* [InputLabelConfig](classes/inputlabelconfig.md)
* [Media](classes/media.md)
* [MediaConfig](classes/mediaconfig.md)
* [MediaSource](classes/mediasource.md)
* [NumProperty](classes/numproperty.md)
* [NumberInput](classes/numberinput.md)
* [OpenUrlAction](classes/openurlaction.md)
* [PaddingDefinition](classes/paddingdefinition.md)
* [PixelSizeProperty](classes/pixelsizeproperty.md)
* [PropertyDefinition](classes/propertydefinition.md)
* [RefreshActionProperty](classes/refreshactionproperty.md)
* [RefreshDefinition](classes/refreshdefinition.md)
* [RequiredInputLabelTextDefinition](classes/requiredinputlabeltextdefinition.md)
* [RichTextBlock](classes/richtextblock.md)
* [SerializableObject](classes/serializableobject.md)
* [SerializableObjectCollectionProperty](classes/serializableobjectcollectionproperty.md)
* [SerializableObjectProperty](classes/serializableobjectproperty.md)
* [SerializableObjectSchema](classes/serializableobjectschema.md)
* [SerializationContext](classes/serializationcontext.md)
* [ShowCardAction](classes/showcardaction.md)
* [ShowCardActionConfig](classes/showcardactionconfig.md)
* [SimpleSerializationContext](classes/simpleserializationcontext.md)
* [SizeAndUnit](classes/sizeandunit.md)
* [SpacingDefinition](classes/spacingdefinition.md)
* [StringArrayProperty](classes/stringarrayproperty.md)
* [StringProperty](classes/stringproperty.md)
* [StringWithSubstitutionProperty](classes/stringwithsubstitutionproperty.md)
* [StringWithSubstitutions](classes/stringwithsubstitutions.md)
* [Strings](classes/strings.md)
* [StylableCardElementContainer](classes/stylablecardelementcontainer.md)
* [SubmitAction](classes/submitaction.md)
* [TextBlock](classes/textblock.md)
* [TextColorDefinition](classes/textcolordefinition.md)
* [TextInput](classes/textinput.md)
* [TextRun](classes/textrun.md)
* [TimeFormatter](classes/timeformatter.md)
* [TimeInput](classes/timeinput.md)
* [TimeProperty](classes/timeproperty.md)
* [ToggleInput](classes/toggleinput.md)
* [ToggleVisibilityAction](classes/togglevisibilityaction.md)
* [UUID](classes/uuid.md)
* [ValidationResults](classes/validationresults.md)
* [ValueSetProperty](classes/valuesetproperty.md)
* [Version](classes/version.md)
* [Versions](classes/versions.md)

### Interfaces

* [ActivityRequest](interfaces/activityrequest.md)
* [ActivityResponse](interfaces/activityresponse.md)
* [IAction](interfaces/iaction.md)
* [IAdaptiveCard](interfaces/iadaptivecard.md)
* [IBackgroundImage](interfaces/ibackgroundimage.md)
* [ICardElement](interfaces/icardelement.md)
* [IChoice](interfaces/ichoice.md)
* [IChoiceSetInput](interfaces/ichoicesetinput.md)
* [IColumn](interfaces/icolumn.md)
* [IColumnSet](interfaces/icolumnset.md)
* [IContainer](interfaces/icontainer.md)
* [IDateInput](interfaces/idateinput.md)
* [IFact](interfaces/ifact.md)
* [IFactSet](interfaces/ifactset.md)
* [IFontSizeDefinitions](interfaces/ifontsizedefinitions.md)
* [IFontWeightDefinitions](interfaces/ifontweightdefinitions.md)
* [IImage](interfaces/iimage.md)
* [IImageSet](interfaces/iimageset.md)
* [IInput](interfaces/iinput.md)
* [ILineHeightDefinitions](interfaces/ilineheightdefinitions.md)
* [IMarkdownProcessingResult](interfaces/imarkdownprocessingresult.md)
* [INumberInput](interfaces/inumberinput.md)
* [IOpenUrlAction](interfaces/iopenurlaction.md)
* [IResourceInformation](interfaces/iresourceinformation.md)
* [ISeparationDefinition](interfaces/iseparationdefinition.md)
* [IShowCardAction](interfaces/ishowcardaction.md)
* [ISubmitAction](interfaces/isubmitaction.md)
* [ITextBlock](interfaces/itextblock.md)
* [ITextInput](interfaces/itextinput.md)
* [ITimeInput](interfaces/itimeinput.md)
* [IToggleInput](interfaces/itoggleinput.md)
* [ITypeRegistration](interfaces/ityperegistration.md)
* [IValidationEvent](interfaces/ivalidationevent.md)
* [IVersion](interfaces/iversion.md)
* [IVersionedValue](interfaces/iversionedvalue.md)
* [InvokeActivity](interfaces/invokeactivity.md)

### Type aliases

* [ActionType](README.md#actiontype)
* [AppletsSettings](README.md#appletssettings)
* [CardElementHeight](README.md#cardelementheight)
* [CardObjectType](README.md#cardobjecttype)
* [ColumnWidth](README.md#columnwidth)
* [Dictionary](README.md#dictionary)
* [PropertyBag](README.md#propertybag)
* [Refresh](README.md#refresh)
* [SerializableObjectType](README.md#serializableobjecttype)
* [TargetVersion](README.md#targetversion)

### Variables

* [defaultHostConfig](README.md#const-defaulthostconfig)
* [emoji_message](README.md#const-emoji_message)

### Functions

* [appendChild](README.md#appendchild)
* [findBreakableIndices](README.md#findbreakableindices)
* [findNextCharacter](README.md#findnextcharacter)
* [formatText](README.md#formattext)
* [generateUniqueId](README.md#generateuniqueid)
* [getEnumValueByName](README.md#getenumvaluebyname)
* [getFitStatus](README.md#getfitstatus)
* [isMobileOS](README.md#ismobileos)
* [isVersionLessOrEqual](README.md#isversionlessorequal)
* [parseBool](README.md#parsebool)
* [parseEnum](README.md#parseenum)
* [parseHostConfigEnum](README.md#parsehostconfigenum)
* [parseNumber](README.md#parsenumber)
* [parseString](README.md#parsestring)
* [property](README.md#property)
* [raiseAnchorClickedEvent](README.md#raiseanchorclickedevent)
* [raiseElementVisibilityChangedEvent](README.md#raiseelementvisibilitychangedevent)
* [raiseExecuteActionEvent](README.md#raiseexecuteactionevent)
* [raiseImageLoadedEvent](README.md#raiseimageloadedevent)
* [raiseInlineCardExpandedEvent](README.md#raiseinlinecardexpandedevent)
* [raiseInputValueChangedEvent](README.md#raiseinputvaluechangedevent)
* [renderSeparation](README.md#renderseparation)
* [stringToCssColor](README.md#stringtocsscolor)
* [truncate](README.md#truncate)

### Object literals

* [ContentTypes](README.md#const-contenttypes)
* [simple_test_card](README.md#const-simple_test_card)

## Type aliases

###  ActionType

Ƭ **ActionType**: *object*

#### Type declaration:

* **new __type**(): *[Action](classes/action.md)*

___

###  AppletsSettings

Ƭ **AppletsSettings**: *object*

#### Type declaration:

* **authPromptHeight**: *number*

* **authPromptWidth**: *number*

* **defaultTimeBetweenRetryAttempts**: *number*

* **logEnabled**: *boolean*

* **logLevel**: *[LogLevel](enums/loglevel.md)*

* **maximumRetryAttempts**: *number*

* **onLogEvent**? : *undefined | function*

* **refresh**: *[Refresh](README.md#refresh)*

___

###  CardElementHeight

Ƭ **CardElementHeight**: *"auto" | "stretch"*

___

###  CardObjectType

Ƭ **CardObjectType**: *object*

#### Type declaration:

* **new __type**(): *[CardObject](classes/cardobject.md)*

___

###  ColumnWidth

Ƭ **ColumnWidth**: *[SizeAndUnit](classes/sizeandunit.md) | "auto" | "stretch"*

___

###  Dictionary

Ƭ **Dictionary**: *object*

#### Type declaration:

* \[ **key**: *string*\]: T

___

###  PropertyBag

Ƭ **PropertyBag**: *object*

#### Type declaration:

* \[ **propertyName**: *string*\]: any

___

###  Refresh

Ƭ **Refresh**: *object*

#### Type declaration:

* **maximumConsecutiveRefreshes**: *number*

* **mode**: *[RefreshMode](enums/refreshmode.md)*

* **timeBetweenAutomaticRefreshes**: *number*

___

###  SerializableObjectType

Ƭ **SerializableObjectType**: *object*

#### Type declaration:

* **new __type**(): *[SerializableObject](classes/serializableobject.md)*

___

###  TargetVersion

Ƭ **TargetVersion**: *[Version](classes/version.md) | "*"*

## Variables

### `Const` defaultHostConfig

• **defaultHostConfig**: *[HostConfig](classes/hostconfig.md)* = new HostConfig(
    {
        supportsInteractivity: true,
        spacing: {
            small: 10,
            default: 20,
            medium: 30,
            large: 40,
            extraLarge: 50,
            padding: 20
        },
        separator: {
            lineThickness: 1,
            lineColor: "#EEEEEE"
        },
        fontTypes: {
            default: {
                fontFamily: "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",
                fontSizes: {
                    small: 12,
                    default: 14,
                    medium: 17,
                    large: 21,
                    extraLarge: 26
                },
                fontWeights: {
                    lighter: 200,
                    default: 400,
                    bolder: 600
                }
            },
            monospace: {
                fontFamily: "'Courier New', Courier, monospace",
                fontSizes: {
                    small: 12,
                    default: 14,
                    medium: 17,
                    large: 21,
                    extraLarge: 26
                },
                fontWeights: {
                    lighter: 200,
                    default: 400,
                    bolder: 600
                }
            }
        },
        imageSizes: {
            small: 40,
            medium: 80,
            large: 160
        },
        containerStyles: {
            default: {
                backgroundColor: "#FFFFFF",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            },
            emphasis: {
                backgroundColor: "#08000000",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            },
            accent: {
                backgroundColor: "#C7DEF9",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            },
            good: {
                backgroundColor: "#CCFFCC",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            },
            attention: {
                backgroundColor: "#FFC5B2",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            },
            warning: {
                backgroundColor: "#FFE2B2",
                foregroundColors: {
                    default: {
                        default: "#333333",
                        subtle: "#EE333333"
                    },
                    dark: {
                        default: "#000000",
                        subtle: "#66000000"
                    },
                    light: {
                        default: "#FFFFFF",
                        subtle: "#33000000"
                    },
                    accent: {
                        default: "#2E89FC",
                        subtle: "#882E89FC"
                    },
                    attention: {
                        default: "#cc3300",
                        subtle: "#DDcc3300"
                    },
                    good: {
                        default: "#028A02",
                        subtle: "#DD027502"
                    },
                    warning: {
                        default: "#e69500",
                        subtle: "#DDe69500"
                    }
                }
            }
        },
        inputs: {
            label: {
                requiredInputs: {
                    color: Enums.TextColor.Accent,
                    size: Enums.TextSize.ExtraLarge,
                    weight: Enums.TextWeight.Bolder,
                    isSubtle: true,
                    suffix: " (required)",
                    suffixColor: Enums.TextColor.Good
                },
                optionalInputs: {
                    color: Enums.TextColor.Warning,
                    size: Enums.TextSize.Medium,
                    weight: Enums.TextWeight.Lighter,
                    isSubtle: false
                }
            },
            errorMessage: {
                color: Enums.TextColor.Accent,
                size: Enums.TextSize.Small,
                weight: Enums.TextWeight.Bolder
            }
        },
        actions: {
            maxActions: 5,
            spacing: Enums.Spacing.Default,
            buttonSpacing: 10,
            showCard: {
                actionMode: Enums.ShowCardActionMode.Inline,
                inlineTopMargin: 16
            },
            actionsOrientation: Enums.Orientation.Horizontal,
            actionAlignment: Enums.ActionAlignment.Left
        },
        adaptiveCard: {
            allowCustomStyle: false
        },
        imageSet: {
            imageSize: Enums.Size.Medium,
            maxImageHeight: 100
        },
        factSet: {
            title: {
                color: Enums.TextColor.Default,
                size: Enums.TextSize.Default,
                isSubtle: false,
                weight: Enums.TextWeight.Bolder,
                wrap: true,
                maxWidth: 150,
            },
            value: {
                color: Enums.TextColor.Default,
                size: Enums.TextSize.Default,
                isSubtle: false,
                weight: Enums.TextWeight.Default,
                wrap: true,
            },
            spacing: 10
        }
    })

___

### `Const` emoji_message

• **emoji_message**: *"Mix 🗣 emoji inside 🙌 text"* = "Mix 🗣 emoji inside 🙌 text"

## Functions

###  appendChild

▸ **appendChild**(`node`: Node, `child`: Node | undefined): *void*

**Parameters:**

Name | Type |
------ | ------ |
`node` | Node |
`child` | Node &#124; undefined |

**Returns:** *void*

___

###  findBreakableIndices

▸ **findBreakableIndices**(`html`: string): *number[]*

**Parameters:**

Name | Type |
------ | ------ |
`html` | string |

**Returns:** *number[]*

___

###  findNextCharacter

▸ **findNextCharacter**(`html`: string, `currIdx`: number): *number*

**Parameters:**

Name | Type |
------ | ------ |
`html` | string |
`currIdx` | number |

**Returns:** *number*

___

###  formatText

▸ **formatText**(`lang`: string | undefined, `text`: string | undefined): *string | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`lang` | string &#124; undefined |
`text` | string &#124; undefined |

**Returns:** *string | undefined*

___

###  generateUniqueId

▸ **generateUniqueId**(): *string*

Generate a UUID prepended with "__ac-"

**Returns:** *string*

___

###  getEnumValueByName

▸ **getEnumValueByName**(`enumType`: object, `name`: string): *number | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`enumType` | object |
`name` | string |

**Returns:** *number | undefined*

___

###  getFitStatus

▸ **getFitStatus**(`element`: HTMLElement, `containerEnd`: number): *[ContainerFitStatus](enums/containerfitstatus.md)*

**Parameters:**

Name | Type |
------ | ------ |
`element` | HTMLElement |
`containerEnd` | number |

**Returns:** *[ContainerFitStatus](enums/containerfitstatus.md)*

___

###  isMobileOS

▸ **isMobileOS**(): *boolean*

**Returns:** *boolean*

___

###  isVersionLessOrEqual

▸ **isVersionLessOrEqual**(`version`: [TargetVersion](README.md#targetversion), `targetVersion`: [TargetVersion](README.md#targetversion)): *boolean*

**Parameters:**

Name | Type |
------ | ------ |
`version` | [TargetVersion](README.md#targetversion) |
`targetVersion` | [TargetVersion](README.md#targetversion) |

**Returns:** *boolean*

___

###  parseBool

▸ **parseBool**(`value`: any, `defaultValue?`: undefined | false | true): *boolean | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`value` | any |
`defaultValue?` | undefined &#124; false &#124; true |

**Returns:** *boolean | undefined*

___

###  parseEnum

▸ **parseEnum**(`enumType`: object, `name`: string, `defaultValue?`: undefined | number): *number | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`enumType` | object |
`name` | string |
`defaultValue?` | undefined &#124; number |

**Returns:** *number | undefined*

___

###  parseHostConfigEnum

▸ **parseHostConfigEnum**(`targetEnum`: object, `value`: string | number, `defaultValue`: number): *number*

**Parameters:**

Name | Type |
------ | ------ |
`targetEnum` | object |
`value` | string &#124; number |
`defaultValue` | number |

**Returns:** *number*

___

###  parseNumber

▸ **parseNumber**(`obj`: any, `defaultValue?`: undefined | number): *number | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`obj` | any |
`defaultValue?` | undefined &#124; number |

**Returns:** *number | undefined*

___

###  parseString

▸ **parseString**(`obj`: any, `defaultValue?`: undefined | string): *string | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`obj` | any |
`defaultValue?` | undefined &#124; string |

**Returns:** *string | undefined*

___

###  property

▸ **property**(`property`: [PropertyDefinition](classes/propertydefinition.md)): *(Anonymous function)*

**Parameters:**

Name | Type |
------ | ------ |
`property` | [PropertyDefinition](classes/propertydefinition.md) |

**Returns:** *(Anonymous function)*

___

###  raiseAnchorClickedEvent

▸ **raiseAnchorClickedEvent**(`element`: [CardElement](classes/cardelement.md), `anchor`: HTMLAnchorElement): *boolean*

**Parameters:**

Name | Type |
------ | ------ |
`element` | [CardElement](classes/cardelement.md) |
`anchor` | HTMLAnchorElement |

**Returns:** *boolean*

___

###  raiseElementVisibilityChangedEvent

▸ **raiseElementVisibilityChangedEvent**(`element`: [CardElement](classes/cardelement.md), `shouldUpdateLayout`: boolean): *void*

**Parameters:**

Name | Type | Default |
------ | ------ | ------ |
`element` | [CardElement](classes/cardelement.md) | - |
`shouldUpdateLayout` | boolean | true |

**Returns:** *void*

___

###  raiseExecuteActionEvent

▸ **raiseExecuteActionEvent**(`action`: [Action](classes/action.md)): *void*

**Parameters:**

Name | Type |
------ | ------ |
`action` | [Action](classes/action.md) |

**Returns:** *void*

___

###  raiseImageLoadedEvent

▸ **raiseImageLoadedEvent**(`image`: [Image](classes/image.md)): *void*

**Parameters:**

Name | Type |
------ | ------ |
`image` | [Image](classes/image.md) |

**Returns:** *void*

___

###  raiseInlineCardExpandedEvent

▸ **raiseInlineCardExpandedEvent**(`action`: [ShowCardAction](classes/showcardaction.md), `isExpanded`: boolean): *void*

**Parameters:**

Name | Type |
------ | ------ |
`action` | [ShowCardAction](classes/showcardaction.md) |
`isExpanded` | boolean |

**Returns:** *void*

___

###  raiseInputValueChangedEvent

▸ **raiseInputValueChangedEvent**(`input`: [Input](classes/input.md)): *void*

**Parameters:**

Name | Type |
------ | ------ |
`input` | [Input](classes/input.md) |

**Returns:** *void*

___

###  renderSeparation

▸ **renderSeparation**(`hostConfig`: [HostConfig](classes/hostconfig.md), `separationDefinition`: [ISeparationDefinition](interfaces/iseparationdefinition.md), `orientation`: [Orientation](enums/orientation.md)): *HTMLElement | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`hostConfig` | [HostConfig](classes/hostconfig.md) |
`separationDefinition` | [ISeparationDefinition](interfaces/iseparationdefinition.md) |
`orientation` | [Orientation](enums/orientation.md) |

**Returns:** *HTMLElement | undefined*

___

###  stringToCssColor

▸ **stringToCssColor**(`color`: string | undefined): *string | undefined*

**Parameters:**

Name | Type |
------ | ------ |
`color` | string &#124; undefined |

**Returns:** *string | undefined*

___

###  truncate

▸ **truncate**(`element`: HTMLElement, `maxHeight`: number, `lineHeight?`: undefined | number): *void*

**Parameters:**

Name | Type |
------ | ------ |
`element` | HTMLElement |
`maxHeight` | number |
`lineHeight?` | undefined &#124; number |

**Returns:** *void*

## Object literals

### `Const` ContentTypes

### ▪ **ContentTypes**: *object*

###  applicationJson

• **applicationJson**: *string* = "application/json"

###  applicationXWwwFormUrlencoded

• **applicationXWwwFormUrlencoded**: *string* = "application/x-www-form-urlencoded"

___

### `Const` simple_test_card

### ▪ **simple_test_card**: *object*

###  $schema

• **$schema**: *string* = "http://adaptivecards.io/schemas/adaptive-card.json"

###  body

• **body**: *object[]* = [{
        "type": "TextBlock",
        "text": emoji_message
    }]

###  type

• **type**: *string* = "AdaptiveCard"

###  version

• **version**: *string* = "1.0"
