---
title: 📣 Community Call - September, 2022
subtitle: Updates on Accessibility Features in Adaptive Cards
date: 2022-09-08
featured_image: https://user-images.githubusercontent.com/33772802/196286823-4b03da2d-75f7-44ae-b6ac-60c43321a0d2.jpg
github_username: JeanRoca
twitter: jpthepm
---

In this month’s community call, updates on **Accessibility features in Adaptive Cards** (tools include - speech, altText, tooltip, label, and CaptionSource (Preview)), **New video sources for Media Element** (the latest release of Media Element (in v1.6) will include out-of-box support for – YouTube, Vimeo, and Dailymotion. Brief demo of Media Element), and 15-minute **Q&A** covering a host of topics. Expect another v1.6 beta release the week of September 12th. Resources included in blog post. This call was hosted by [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm. Recorded on September 8, 2022.

### Watch the call here

<iframe width="680" height="383" src="https://www.youtube.com/embed/uFVUXJwnOTw" title="Community Call September 2022 video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Agenda:
- Accessibility Features in Adaptive Cards – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [00:29](https://youtu.be/uFVUXJwnOTw?t=29)
- New Video Sources for Media Element – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [02:48](https://youtu.be/uFVUXJwnOTw?t=168)
- Q&A – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [09:32](https://youtu.be/uFVUXJwnOTw?t=572)

### Topic summaries:
- **Accessibility Features in Adaptive Cards** – why is accessibility important? What are the accessibility tools in Adaptive Cards? Tools covered in this session - speech, altText, tooltip, label, and CaptionSource. CaptionSource (Preview) defines closed captions available for a video (UWP and JS).
- **New Video Sources for Media Element** – the latest release of Media Element (in v1.6) will include out-of-box support for – YouTube, Vimeo, and Dailymotion. Media Element is a card element that displays a video in an Adaptive Card. Demo of Media Element. Also, CaptionSource is included in this release.
- **Q&A** – on a range of topics – cards that create a dynamic URL based on an active directory attribute, how to get specific items from an array in a data template, Power Automate connector that listens for Adaptive Card responses and dynamically updates card, and more.

### Referenced in this call:
* Demo - [How to add animated SVG's to Adaptive Cards](https://youtu.be/Yt4QcHjNr6A?t=2048) – [Kristine Kolodziejski](https://twitter.com/kristinekk94) (Computacenter) \| @kristinekk94 
* Blog post – [Microsoft 365 & Power Platform Development Community call - 1st of September, 2022](https://pnp.github.io/blog/microsoft-365-developer-community-call/2022-09-01/) 
* Schema Explorer – [CaptionSource (Preview Feature)](https://adaptivecardsci.z5.web.core.windows.net/explorer/CaptionSource.html)
* Samples - [Adaptive Card Design samples for Viva Connections](https://github.com/pnp/AdaptiveCards-Templates)
* Sample (draft) - [Rendering array in data template](https://github.com/microsoft/AdaptiveCards/issues/7569#issuecomment-1167927785)
* Session - [Adaptive Cards community call – May 2022](https://www.youtube.com/watch?v=3nZRgt-WUv0)

### Resources in General: 
- Let us know the features you need    https://aka.ms/ACRoadmap
- Schema Explorer - https://adaptivecards.io/explorer/Action.Execute.html
- Designer - https://adaptivecards.io/designer/ 
- Get started with Templating - https://aka.ms/ACTemplating
- Browse the Adaptive Cards Code - https://aka.ms/ACRepo
- Find tools, sample cards, and more - https://www.madewithcards.io
- Contribution Guidelines – https://aka.ms/ACRepo 

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2nd Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.