---
title: 📣 Community Call - October, 2022
subtitle: Building Windows 11 Widgets with Adaptive Cards
date: 2022-10-14
featured_image: https://user-images.githubusercontent.com/33772802/196287201-9cbe1293-13f6-4910-a3e0-955742a5f12e.png
github_username: JeanRoca
twitter: jpthepm
---

The focus in this month’s community call is **Building Windows 11 Widgets with Adaptive Cards** and post demo related **Q&A.** This call was hosted by [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm. Recorded on October 13, 2022. The 3rd party Widgets Platform allows developers to create a widget for their Win32 or Progressive Web Apps also known as PWA’s. PWA support will be coming later this year. Users will then be able to see and interact with this widget on the widgets board. 3rd party widgets are not meant to be a replacement for your app, but instead provide users with another way to engage with your app in a glanceable and focused way. The first preview of this platform that allows developers to start creating Widgets for their app has shipped as part of the Windows App SDK 1.2 preview 2 release. 

As part of this preview release, developers are able to locally test their 3P widgets as long as they meet the prerequisites outlined in [Implement a widget provider in a win32 app](https://learn.microsoft.com/windows/apps/develop/widgets/implement-widget-provider-win32). 3P widgets will be available in official releases of Windows 11 in a future date. This documentation provides developers with everything they need to get started building 3P widgets using Adaptive Cards. For any problems you are experiencing, please file an issue in the [Windows App SDK repository](https://github.com/microsoft/WindowsAppSDK).

### Watch the call here

<iframe width="680" height="383" src="https://www.youtube.com/embed/Uk1p6OaXaNI" title="Community Call October 2022 video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Agenda:
- Building Windows 11 Widgets with Adaptive Cards – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm
    * Presentation – [0:24](https://youtu.be/Uk1p6OaXaNI?t=24)
    * Demo – [6:14](https://youtu.be/Uk1p6OaXaNI?t=374)
    * Q&A – [25:53](https://youtu.be/Uk1p6OaXaNI?t=1553)

### Topic summaries:
- **Building Windows 11 Widgets with Adaptive Cards** – what are widgets, 3rd party widget platform, development environment prerequisites and 3 steps for creating your Win32 Widget. 1) design widget (using Adaptive Cards), 2) implement IWidgetProvider interface (methods for handling communications between widgets board and your app), and 3) register widget (changes to APPX Manifest). Deploy widget.

### Referenced in this call:
* Documentation - [Widgets overview](https://learn.microsoft.com/windows/apps/design/widgets/) \| aka.ms/widgetdocs
* Documentation - [Widget providers](https://learn.microsoft.com/windows/apps/develop/widgets/widget-providers) \| aka.ms/widgetdevdocs
* Documentation - [Implement a widget provider in a win32 app](https://learn.microsoft.com/windows/apps/develop/widgets/implement-widget-provider-win32)
* Repo - [Implement a widget provider in a win32 app](https://github.com/MicrosoftDocs/windows-dev-docs/blob/docs/hub/apps/develop/widgets/implement-widget-provider-win32.md)
* Repo – [Windows App SDK 1.2 Preview 2](https://github.com/microsoft/WindowsAppSDK/releases/tag/v1.2.0-preview2)
* Tool – [Adaptive Cards Designer](https://adaptivecards.io/designer/)
* Documentation – [Widget provider package manifest XML format](https://learn.microsoft.com/windows/apps/develop/widgets/widget-provider-manifest)
* Feedback – [Want to contribute to Microsoft Adaptive Cards?](https://github.com/microsoft/AdaptiveCards/issues)

### Resources in General: 
- Let us know the features you need    https://aka.ms/ACRoadmap
- Schema Explorer - https://adaptivecards.io/explorer/Action.Execute.html
- Designer - https://adaptivecards.io/designer/ 
- Get started with Templating - https://aka.ms/ACTemplating
- Browse the Adaptive Cards Code - https://aka.ms/ACRepo
- Find tools, sample cards, and more - https://www.madewithcards.io
- Contribution Guidelines – https://aka.ms/ACRepo 

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2nd Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.