---
title: 📣 Community Call - May, 2022
subtitle: Handling multi-user responses for Adaptive Cards in Teams
date: 2022-05-12
featured_image: https://pnp.github.io/blog/adaptive-cards-community-call/adaptive-cards-community-call-may-2022/images/recording-adaptive-cards-may-call_hufbf3f7faf2b2edabb62d15f9085c8218_282942_700x0_resize_q100_h2_box_3.webp
github_username: JeanRoca
twitter: jpthepm
---

In this month’s community call. Featured demo - Handling multi-user responses for Adaptive Cards in Teams (posting a card with Power Automate in a Teams meeting chat that can handle multiple responses to it) - [Josh Friedman](https://www.linkedin.com/in/josh-friedman-2a812254) (Microsoft). As well, there are prompts to register for Microsoft Build 2022 and to respond to a 2-question survey. Finally, a deep dive Q&A into today’s demo topic that also yielded a sneak peek at 2 new capabilities from Josh’s team – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft), [Josh Friedman](https://www.linkedin.com/in/josh-friedman-2a812254) (Microsoft) and [Tomasz Poszytek](http://twitter.com/TomaszPoszytek). This call was hosted by [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm. Recorded on May 12, 2022.

### Watch the call here

<iframe width="680" height="383" src="https://www.youtube.com/embed/3nZRgt-WUv0" title="Community Call May 2022 video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Agenda:
- Handling multi-user responses for Adaptive Cards in Microsoft Teams - [Josh Friedman](https://www.linkedin.com/in/josh-friedman-2a812254) (Microsoft) – [00:33](https://youtu.be/3nZRgt-WUv0?t=33)
- Microsoft Build 2022 - [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [15:07](https://youtu.be/3nZRgt-WUv0?t=907)
- Call to Action - [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [15:42](https://youtu.be/3nZRgt-WUv0?t=942)
- Q&A - [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm, [Josh Friedman](https://www.linkedin.com/in/josh-friedman-2a812254) (Microsoft) and [Tomasz Poszytek](http://twitter.com/TomaszPoszytek) \| @TomaszPoszytek – [16:29](https://youtu.be/3nZRgt-WUv0?t=989)

### Demo:
-  **Handling multi-user responses for Adaptive Cards in Microsoft Teams** – posting a card (requesting information from meeting attendees) with Power Automate in a Teams meeting chat. The card can handle multiple responses to it (evidenced in multiple responses in meeting chat). Every time a person responds to the card (trigger), a Planner task is created. The solution requires 2 flows - Trigger (Response Handling Flow) and Action (Card Posting Flow). Available in Preview today.

In the post demo Q&A with Josh, he gave viewers a first look at 2 more features to be released soon:

-   **Update an Adaptive Card in a chat or channel** - build an instant cloud flow from compose Box v2 and add a message extension trigger – Button that updates an Adaptive Card dynamically in chat. Makes the flow synchronous.
-   **Respond in Teams Task Module with Messaging Triggers** - Using the V2 for a selected message or V2 from the compose box trigger you will *soon* be able to use a new action, Respond in Teams Task Module action which takes an adaptive card as an input and will synchronously run the flow and then show this card in the same task module. This allows for immediate feedback upon completion of the flow in the same context that it was triggered.

### Referenced in this call:
*  **Handling multi-user responses for Adaptive Cards in Microsoft Teams** - 
    * Article – [Microsoft Power Automate: Post Adaptive cards to a Microsoft Teams for an Approval](https://powerusers.microsoft.com/t5/Power-Automate-Community-Blog/Microsoft-Power-Automate-Post-Adaptive-cards-to-a-Microsoft/ba-p/658693)


### Resources in General: 
- Let us know the features you need    https://aka.ms/ACRoadmap
- Schema Explorer - https://adaptivecards.io/explorer/Action.Execute.html
- Designer - https://adaptivecards.io/designer/ 
- Get started with Templating - https://aka.ms/ACTemplating
- Browse the Adaptive Cards Code - https://aka.ms/ACRepo
- Find tools, sample cards, and more - https://www.madewithcards.io
- Contribution Guidelines – https://aka.ms/ACRepo 

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2nd Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.