---
title: 📣 Community Call - March, 2022
subtitle: Adaptive Cards Host Control in Microsoft PnP Library
date: 2022-03-10
featured_image: https://techcommunity.microsoft.com/t5/image/serverpage/image-id/356326i03254E96BDFD72C2/image-size/large?v=v2&px=999
github_username: JeanRoca
twitter: jpthepm
---

The following topics are covered in this month’s community call. Demo: **Adaptive Cards Host Control in Microsoft PnP Library** (use an Adaptive Card in an SPFx solution that allows UI changes at runtime) – [Fabio Franzini](http://twitter.com/franzinifabio) (Apvee Solutions), **Designer Device Emulator** (quick way to see Adaptive Card layout at various selected screen resolutions) – Will Shown (Microsoft), and 15 minute live **Q&A** – host and demo presenters answer questions about their demos and on **building Teams apps with React; which React library to use - React Northstar, React Teams or Fluent UI?** This call was hosted by [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) | @jpthepm. Recorded on March 10, 2022.

### Watch the call here

<iframe width="680" height="383" src="https://www.youtube.com/embed/k5kNBgevDBM" title="Community Call March 2022 video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Agenda:
- Adaptive Cards Host Control in Microsoft PnP Library – [Fabio Franzini](http://twitter.com/franzinifabio) (Apvee Solutions) | @franzinifabio – [00:38](https://youtu.be/k5kNBgevDBM?t=38)
- Designer Device Emulator – Will Shown (Microsoft) – [20:20](https://youtu.be/k5kNBgevDBM?t=1220)
- Q&A – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) | @jpthepm & demo presenters – [23:49](https://youtu.be/k5kNBgevDBM?t=1429)

### Demo:
**Demo 1: Adaptive Cards Host Control in Microsoft PnP Library –** customers want same functionality, different UI. Needed a way to change UI at runtime (no recompiling required). This SPFx solution contains a web part that hosts an AdaptiveCardhost control. Same web part can be used in a SharePoint page, Teams tab and Teams personal app. Hear the rationale behind this React control, why use the Adaptive Cards SDK, Fluent UI, and how control is implemented.

**Demo 2: Designer Device Emulator** - created by the Teams Platform group, this emulator shows Adaptive Card layouts for selected screen widths/resolutions. Desktop (unconstrained), small mobile (320px), large mobile (414px), small tablet (768px), large tablet (1024px). If you host your own Designer, then you can add additional resolution options. Great for mobile projects. Emulator will show up on AdaptiveCards.io shortly.

### Referenced in this call:
- **D1**:  SPFx Controls - [Adaptive Card Host](https://pnp.github.io/sp-dev-fx-controls-react/controls/AdaptiveCardHost/) 
- **D1**:  SPFx Samples - [SharePoint Framework Client-Side Web Part Samples](https://pnp.github.io/sp-dev-fx-webparts/) (Demo will be posted here when complete) 
- **D2**:  [Nightly build for Adaptive Cards Designer with Device Emulator](https://adaptivecardsci.z5.web.core.windows.net/designer) 
- Power Automate for Desktop Announcement - [https://powerautomate.microsoft.com/en-us/blog/power-automate-for-desktop-february-2022-update/](https://powerautomate.microsoft.com/en-us/blog/power-automate-for-desktop-february-2022-update/)
- The latest Fluent React v9 here - [fluentui/packages/react-components at master · microsoft/fluentui (github.com)](https://github.com/microsoft/fluentui/tree/master/packages/react-components#readme)

Next month's call will be held on **Thursday, April 14, 2022 at 9:00am PST.** We look forward to talking to you then! Download a recurring calendar invite here at <https://aka.ms/adaptivecardscommunitycall>.

Check out the previous month's call recording on our [Office Development YouTube Channel](https://www.youtube.com/channel/UCV_6HOhwxYLXAGd-JOqKPoQ)

### Resources in General: 
- Let us know the features you need    https://aka.ms/ACRoadmap
- Schema Explorer - https://adaptivecards.io/explorer/Action.Execute.html
- Designer - https://adaptivecards.io/designer/ 
- Get started with Templating - https://aka.ms/ACTemplating
- Browse the Adaptive Cards Code - https://aka.ms/ACRepo
- Find tools, sample cards and more - https://www.madewithcards.io
- Contribution Guidelines – https://aka.ms/ACRepo 

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2nd Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.