---
title: 📣 Community Call - August, 2022
subtitle: Overview of the React Native Adaptive Cards Renderer by BigThinkCode
date: 2022-08-11
featured_image: https://pnp.github.io/blog/adaptive-cards-community-call/adaptive-cards-community-call-august-2022/images/recording-adaptive-cards-august-call_hu29a577d313165ec630d79518bb1a376e_280808_700x0_resize_q100_h2_box_3.webp
github_username: JeanRoca
twitter: jpthepm
---

In this month’s community call, get an overview of the React Native Adaptive Cards Renderer and on the usage of the React Native Adaptive Cards SDK in a Microsoft Viva Connections mobile app and in a LUIS chatbot app delivered by CEO & Founder – [Vasanthakumar Sarpasayanam](https://in.linkedin.com/in/vasanthakumar-sarpasayanam) and his team at BigThinkCode. The community-supported React Native renderer for Adaptive Cards is maintained by BigThinkCode. There was a 10-minute Q&A covering a host of topics. This call was hosted by [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm. Recorded on August 11, 2022.

### Watch the call here

<iframe width="680" height="383" src="https://www.youtube.com/embed/9x9YMNvdH3A" title="Community Call August 2022 video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Agenda:
- React Native Adaptive Cards Renderer – [Vasanthakumar Sarpasayanam](https://in.linkedin.com/in/vasanthakumar-sarpasayanam) (BigThinkCode) – [00:34](https://youtu.be/9x9YMNvdH3A?t=34)
- Using the React Native Adaptive Cards Renderer in a Microsoft Viva Connections Mobile App – [Vasanthakumar Sarpasayanam](https://in.linkedin.com/in/vasanthakumar-sarpasayanam) (BigThinkCode) – [20:01](https://youtu.be/9x9YMNvdH3A?t=1201)
- Q&A – [J.P. Roca](http://twitter.com/jpthepm) (Microsoft) \| @jpthepm – [30:50](https://youtu.be/9x9YMNvdH3A?t=1850)

### Topic summaries:
- **React Native Adaptive Cards Renderer** - Adaptive Cards overview, React Native (RN) Adaptive Cards deep dive with implementation details.  How to integrate RN adaptive card with your app?  How can you extend RN adaptive card component in RN way?  Development roadmap, contributing to RN Adaptive Cards open-source software OSS, Q&A.  
- **Using the React Native Adaptive Cards Renderer in a Microsoft Viva Connections Mobile App** -
Showcasing the use of the React Native Adaptive Cards SDK in a Microsoft Viva Connections app and an E-commerce Microsoft LUIS based chatbot for purposes of reducing customer care queries and chat-based shopping experience.

## BigThinkCode presenters
* Vasanthakumar S \| [vasanth-s](https://github.com/vasanth-s)
* Balaji Rajendran \| [BalajiR](https://github.com/BalajiR)
* Vivek Kozhisseri \| [vivekvijayakrishnan](https://github.com/vivekvijayakrishnan)
* Ibrahim Sulaiman \| [ibrahimsulai](https://github.com/ibrahimsulai)
* Pragadeesh Kanagavel \| [pragadeeshk](https://github.com/pragadeeshk)

### Referenced in this call:
* **Tool**
    * Tool npm - [adaptivecards-reactnative](https://www.npmjs.com/package/adaptivecards-reactnative)
    * Repo - [BigThinkcode/AdaptiveCards](https://github.com/Bigthinkcode/AdaptiveCards/tree/main)
    * Documentation - [ReactNative Renderer](https://docs.microsoft.com/adaptive-cards/sdk/rendering-cards/react-native/getting-started)
* **Contributor**
    * Issues - [submit bugs](https://github.com/BigThinkcode/AdaptiveCards/issues/)
    * Review - [source code changes](https://github.com/BigThinkcode/AdaptiveCards/pulls)
    * Contribute - [bug fixes](https://github.com/BigThinkcode/AdaptiveCards/blob/main/.github/CONTRIBUTING.md)
    * Guideline - [Microsoft Open Source - Code of Conduct](https://opensource.microsoft.com/codeofconduct/)
* **Pic2Card**
    * Repo - [Pic2Card](https://github.com/BigThinkcode/AdaptiveCards/tree/fork-main/source/pic2card)
    * Article - [Pic2Card Service Now available on Adaptive Card Designer](https://adaptivecards.io/blog/2020/Community-Call-November/)
* **Viva Connections**
    * Video – [Demo of Viva Connections](https://www.microsoft.com/videoplayer/embed/RE4Ukqm?autoplay=true)
    * Website - [Microsoft Viva Connections](https://www.microsoft.com/microsoft-viva/connections)
    * Documentation - [Overview of Viva Connections Extensibility](https://docs.microsoft.com/sharepoint/dev/spfx/viva/overview-viva-connections)
    * Extensions - [Adaptive Card Extension Design Gallery](https://appsource.microsoft.com/product/office/WA200003929)

### Resources in General: 
- Let us know the features you need    https://aka.ms/ACRoadmap
- Schema Explorer - https://adaptivecards.io/explorer/Action.Execute.html
- Designer - https://adaptivecards.io/designer/ 
- Get started with Templating - https://aka.ms/ACTemplating
- Browse the Adaptive Cards Code - https://aka.ms/ACRepo
- Find tools, sample cards, and more - https://www.madewithcards.io
- Contribution Guidelines – https://aka.ms/ACRepo 

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2nd Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.