---
title: 📣 Community Call - June, 2020 
subtitle: Build 2020 recap and a new SharePoint web part
date: 2020-06-11
featured_image: https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2020/06/2-2-767x431.png
github_username: matthidinger
twitter: matthidinger
---

Welcome to our Adaptive Cards community call series for 2020, the 2nd Thursday of each month. We are excited to provide you with a monthly opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.

Agenda for this month's call, hosted by Matt Hidinger, included:

Build 2020 and a look at the Roadmap
------------------------------------

Build 2020 was all-virtual this year, and we had the opportunity to share the latest and greatest coming to Adaptive Cards on the [YouTube session](https://aka.ms/m365sk134). The session focused on four areas, outlined below.

### Adaptive Card Templating and Designer Updates

Templating helps you save time by easily populating reusable card templates with data. [Release Candidate SDKs](https://docs.microsoft.com/en-us/adaptive-cards/templating/sdk) are now available for .NET and JavaScript, and we plan to make them Generally Available in the coming weeks. We also added rich data-binding support in the [Adaptive Card Designer](https://adaptivecards.io/designer) to make it even faster to design new cards based on your data payloads.

[Get started with templating](https://aka.ms/ACTemplating)

### Adaptive Cards v2: Universal Actions

Next we officially unveiled Adaptive Cards v2, which adds a new "universal action model" to Adaptive Cards, making it possible to create actionable cards that can communicate with a backend server in a standard way, whether those cards are in Microsoft Teams, Outlook, Cortana Skills, or anywhere else.

Stay tuned to this space, as we'll have plenty more to share on this topic throughout the year.

### Card Author Services

Lastly, we discussed a recent additional to the Adaptive Cards family: the "[Adaptive Cards CMS](https://adaptivecards.io/blog/2020/Community-Call-April/)" or "Card Author Services".

![A screenshot of ACMS dashboard.](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2020/06/1-1.png)

This product offers a centralized place to create, manage, share, and use card templates for your own apps or the entire organization. It includes a user-friendly card management portal, configurable storage and authentication, and a REST API for accessing your cards. We're still working on the final name and release plan, but the good news is this project is still in development and we hope to have a preview that is available this summer. We also welcome community support and contributions if this is something that interests you.

### Putting it all together

Here's a look at each of our major investment areas and what to expect for the rest of 2020 and throughout 2021.

![Adaptive cards roadmap, visit https://aka.ms/ACRoadmap for details](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2020/06/2-2.png)

SharePoint web part for Adaptive Cards
--------------------------------------

Also, this month we were joined by Office Dev MVP Hugo Bernier, who showcased an impressive and user-friendly SharePoint web part for hosting Adaptive Cards --<wbr> with full templating support! Take a look at the video for full details and a behind-the-scenes look at the code.

![Adaptive card animation](https://developer.microsoft.com/en-us/office/blogs/wp-content/uploads/2020/06/adaptive-card-demo.gif)

-   Find Hugo on Twitter [**@bernierh**](https://twitter.com/bernierh)
-   Adaptive Card Host Web Part: [**https://github.com/pnp/sp-dev-fx-webparts/tree/master/samples/react-adaptivecards**](https://github.com/pnp/sp-dev-fx-webparts/tree/master/samples/react-adaptivecards)
-   Adaptive Card Host Web Part with React Hooks: [**https://github.com/pnp/sp-dev-fx-webparts/tree/master/samples/react-adaptivecards-hooks**](https://github.com/pnp/sp-dev-fx-webparts/tree/master/samples/react-adaptivecards-hooks)
-   PnP Team: [**https://aka.ms/m365pnp**](https://aka.ms/m365pnp)
-   Citizen Developer User Group: [**https://www.meetup.com/TorontoCDUG/**](https://www.meetup.com/TorontoCDUG/)
-   Web Parts Samples Gallery: [**https://ms/spfx-webparts**](https://aka.ms/spfx-webparts)
-   PnP Reusable Controls: [**https://sharepoint.github.io/sp-dev-fx-controls-react/**](https://sharepoint.github.io/sp-dev-fx-controls-react/)

Watch the call here

<iframe width="560" title="Adaptive Cards Community Call" height="315" src="https://www.youtube.com/embed/Nelgh4Tvzng" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="allowfullscreen"></iframe>

Resources from this month's call

-   [Watch the latest Adaptive Cards session from Build 2020](https://aka.ms/m365sk134)
-   [Adaptive Cards Roadmap](https://aka.ms/ACRoadmap)
-   [Adaptive Card Templating Overview](https://docs.microsoft.com/en-us/adaptive-cards/templating/)
-   [Adaptive Card Template Service](https://docs.microsoft.com/en-us/adaptive-cards/templating/service)
-   <https://aka.ms/ACFeatures> -- Let us know what features you need

Next month's call will be held on **Thursday, July 9, 2020 at 9:00am PST.** We look forward to talking to you then! Download a recurring calendar invite here at <https://aka.ms/adaptivecardscommunitycall>.

Check out the previous month's call recording on our [Microsoft 365 Development YouTube Channel](https://www.youtube.com/channel/UCV_6HOhwxYLXAGd-JOqKPoQ)

### Adaptive Cards feedback channels

-   [Issues and feature requests](https://github.com/Microsoft/AdaptiveCards/issues)
-   [Technical questions](https://stackoverflow.com/questions/tagged/adaptive-cards)

The Adaptive Cards developer community call is on the 2^nd^ Thursday of each month. We will provide you with the opportunity to learn about Adaptive Cards in general, how they could be a great tool in your applications and contribute to the evolution of the format and SDKs. Each month, we'll discuss new features we are bringing to the platform, our roadmap, and listen to your feedback and suggestions.